/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.flatui;

import java.text.BreakIterator;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

public class LinkLabel
extends Canvas {
    private String fText = "";
    int fTextMarginWidth = 5;
    int fTextMarginHeight = 5;
    private boolean fUnderlined = true;
    protected boolean fHasFocus;

    public LinkLabel(Composite parent, int style) {
        super(parent, style);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                LinkLabel.this.paint(e);
            }
        });
        this.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    LinkLabel.this.notifyListeners(14);
                }
            }
        });
        this.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (e.detail != 4) {
                    e.doit = true;
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (!LinkLabel.this.fHasFocus) {
                    LinkLabel.this.fHasFocus = true;
                    LinkLabel.this.notifyListeners(13);
                    LinkLabel.this.redraw();
                }
            }

            public void focusLost(FocusEvent e) {
                if (LinkLabel.this.fHasFocus) {
                    LinkLabel.this.fHasFocus = false;
                    LinkLabel.this.notifyListeners(13);
                    LinkLabel.this.redraw();
                }
            }
        });
        this.fTextMarginWidth = 1;
        this.fTextMarginHeight = 1;
        this.initAccessible();
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            return;
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            return;
        }
        this.removeListener(13, (SWTEventListener)listener);
        this.removeListener(14, (SWTEventListener)listener);
    }

    public boolean getSelection() {
        return this.fHasFocus;
    }

    public String getText() {
        return this.fText;
    }

    public void setText(String text) {
        this.fText = text != null ? text : "";
    }

    public void setUnderlined(boolean underlined) {
        this.fUnderlined = underlined;
    }

    public boolean isUnderlined() {
        return this.fUnderlined;
    }

    protected final void notifyListeners(int eventType) {
        Event event = new Event();
        event.type = eventType;
        event.widget = this;
        this.notifyListeners(eventType, event);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int innerWidth = wHint;
        if (innerWidth != -1) {
            innerWidth -= this.fTextMarginWidth * 2;
        }
        Point textSize = this.computeTextSize(innerWidth, hHint);
        int textWidth = textSize.x + 2 * this.fTextMarginWidth;
        int textHeight = textSize.y + 2 * this.fTextMarginHeight;
        return new Point(textWidth, textHeight);
    }

    public static int computeWrapHeight(GC gc, String text, int width) {
        BreakIterator wb = BreakIterator.getWordInstance();
        wb.setText(text);
        FontMetrics fm = gc.getFontMetrics();
        int lineHeight = fm.getHeight();
        int saved = 0;
        int last = 0;
        int height = lineHeight;
        int loc = wb.first();
        while (loc != -1) {
            String word = text.substring(saved, loc);
            Point extent = gc.textExtent(word);
            if (extent.x > width) {
                saved = last;
                height += extent.y;
            }
            last = loc;
            loc = wb.next();
        }
        return height;
    }

    private Point computeTextSize(int wHint, int hHint) {
        Point extent;
        GC gc = new GC((Drawable)this);
        gc.setFont(this.getFont());
        if ((this.getStyle() & 0x40) != 0 && wHint != -1) {
            int height = LinkLabel.computeWrapHeight(gc, this.fText, wHint);
            extent = new Point(wHint, height);
        } else {
            extent = gc.textExtent(this.getText());
        }
        gc.dispose();
        return extent;
    }

    public static void paintWrapText(GC gc, Point size, String text, int marginWidth, int marginHeight) {
        LinkLabel.paintWrapText(gc, size, text, marginWidth, marginHeight, false);
    }

    public static void paintWrapText(GC gc, Point size, String text, int marginWidth, int marginHeight, boolean underline) {
        BreakIterator wb = BreakIterator.getWordInstance();
        wb.setText(text);
        FontMetrics fm = gc.getFontMetrics();
        int lineHeight = fm.getHeight();
        int descent = fm.getDescent();
        int saved = 0;
        int last = 0;
        int y = marginHeight;
        int width = size.x - marginWidth * 2;
        int loc = wb.first();
        while (loc != -1) {
            String line = text.substring(saved, loc);
            Point extent = gc.textExtent(line);
            if (extent.x > width) {
                String prevLine = text.substring(saved, last);
                gc.drawString(prevLine, marginWidth, y, true);
                if (underline) {
                    Point prevExtent = gc.textExtent(prevLine);
                    int lineY = y + lineHeight - descent + 1;
                    gc.drawLine(marginWidth, lineY, prevExtent.x, lineY);
                }
                saved = last;
                y += lineHeight;
            }
            last = loc;
            loc = wb.next();
        }
        String lastLine = text.substring(saved, last);
        gc.drawString(lastLine, marginWidth, y, true);
        if (underline) {
            int lineY = y + lineHeight - descent + 1;
            Point lastExtent = gc.textExtent(lastLine);
            gc.drawLine(marginWidth, lineY, marginWidth + lastExtent.x, lineY);
        }
    }

    protected void paint(PaintEvent e) {
        GC gc = e.gc;
        Point size = this.getSize();
        gc.setFont(this.getFont());
        gc.setForeground(this.getForeground());
        if ((this.getStyle() & 0x40) != 0) {
            LinkLabel.paintWrapText(gc, size, this.fText, this.fTextMarginWidth, this.fTextMarginHeight, this.fUnderlined);
        } else {
            gc.drawText(this.getText(), this.fTextMarginWidth, this.fTextMarginHeight, true);
            if (this.fUnderlined) {
                FontMetrics fm = gc.getFontMetrics();
                int descent = fm.getDescent();
                int lineY = size.y - this.fTextMarginHeight - descent + 1;
                gc.drawLine(this.fTextMarginWidth, lineY, size.x - this.fTextMarginWidth, lineY);
            }
        }
    }

    private void initAccessible() {
        this.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = LinkLabel.this.getText();
            }

            public void getDescription(AccessibleEvent e) {
                e.result = "A link to:  " + LinkLabel.this.getText();
            }
        });
        this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = LinkLabel.this.getBounds();
                Point pt = LinkLabel.this.toDisplay(new Point(location.x, location.y));
                e.x = pt.x;
                e.y = pt.y;
                e.width = location.width;
                e.height = location.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 43;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0;
            }
        });
    }
}

