/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.flatui;

import com.ibm.etools.webtools.flatui.IFlatEditor;
import com.ibm.etools.webtools.flatui.IFlatPage;
import com.ibm.etools.webtools.flatui.WidgetFactory;
import java.util.Vector;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.part.MultiPageEditorPart;

public abstract class FlatEditor
extends MultiPageEditorPart
implements IFlatEditor {
    protected WidgetFactory fWf;
    protected Vector fPages;
    protected boolean fReadOnly = false;
    private static Class COMPOSITE_CLASS = Composite.class;
    private static Class CCOMBO_CLASS = CCombo.class;
    private static Class TABLE_CLASS = Table.class;

    protected void addPage(IFlatPage fp) {
        int i = this.addPage((Control)fp.getPageControl());
        this.setPageText(i, fp.getTabText());
        fp.setPageIndex(i);
        this.registerPage(fp);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.fWf != null) {
            this.fWf.dispose();
        }
        if (this.fPages != null && this.fPages.size() != 0) {
            for (IFlatPage page : this.fPages) {
                page.dispose();
            }
        }
    }

    protected void initializeWidgetFactory() {
        this.fWf = new WidgetFactory();
    }

    private void registerPage(IFlatPage page) {
        if (this.fPages == null) {
            this.fPages = new Vector();
        }
        if (!this.fPages.contains(page)) {
            this.fPages.add(page);
        }
    }

    @Override
    public void setPage(int i) {
        this.setActivePage(i);
        this.setFocus();
    }

    @Override
    public void setReadOnly(boolean boo) {
        this.fReadOnly = boo;
        this.setReadOnly(boo, this.getContainer());
        for (IFlatPage page : this.fPages) {
            page.setReadOnly(boo);
        }
    }

    protected void setReadOnly(boolean aBoolean, Composite composite) {
        Control[] children = composite.getChildren();
        int size = children.length;
        Control control = null;
        int i = 0;
        while (i < size) {
            control = children[i];
            if (CCOMBO_CLASS.isInstance(control)) {
                this.setReadOnly(aBoolean, control);
            } else if (TABLE_CLASS.isInstance(control)) {
                this.setReadOnly(aBoolean, control);
            } else if (COMPOSITE_CLASS.isInstance(control)) {
                this.setReadOnly(aBoolean, (Composite)control);
            } else {
                this.setReadOnly(aBoolean, control);
            }
            ++i;
        }
    }

    protected void setReadOnly(boolean aBoolean, Control control) {
        control.setEnabled(!aBoolean);
    }

    @Override
    public boolean isReadOnly() {
        return this.fReadOnly;
    }

    protected void createPages() {
    }

    protected void setActivePage(int pageIndex) {
        if (this.fPages.size() > pageIndex && this.fPages.get(pageIndex) instanceof IFlatPage) {
            IFlatPage activePage = (IFlatPage)this.fPages.get(pageIndex);
            activePage.setActivated(true);
            super.setActivePage(pageIndex);
        } else {
            super.setActivePage(pageIndex);
        }
        IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
        if (contributor != null && contributor instanceof MultiPageEditorActionBarContributor) {
            ((MultiPageEditorActionBarContributor)contributor).setActivePage(this.getEditor(pageIndex));
        }
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void gotoMarker(IMarker marker) {
    }

    protected abstract int getCurrentPage();

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected void pageChange(int newPageIndex) {
        int oldPage = this.getCurrentPage();
        if (this.fPages.size() > newPageIndex && this.fPages.get(newPageIndex) instanceof IFlatPage) {
            ((IFlatPage)this.fPages.get(newPageIndex)).setActivated(true);
        }
        if (this.fPages.size() > oldPage && this.fPages.get(oldPage) instanceof IFlatPage) {
            ((IFlatPage)this.fPages.get(oldPage)).setActivated(false);
        }
        super.pageChange(newPageIndex);
    }
}

