/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.slickui.internal.demo;

import com.ibm.etools.slickui.SlickControlDescriptor;
import com.ibm.etools.slickui.SlickControlList;
import com.ibm.etools.slickui.SlickControlProvider;
import com.ibm.etools.slickui.internal.demo.DataModel;
import com.ibm.etools.slickui.internal.demo.DemoContentProvider;
import com.ibm.etools.slickui.internal.util.StatusUtil;
import com.ibm.etools.slickui.validation.IValidationStateChangedListener;
import com.ibm.etools.slickui.validation.ValidationEvent;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SlickUIDemoDialog
extends TitleAreaDialog
implements ISelectionChangedListener,
IValidationStateChangedListener {
    private DataModel dataModel;
    private SlickControlDescriptor selectedControl;
    private SlickControlList controlList;
    private IStructuredContentProvider controlProvider;
    private boolean initialCloseState;

    public SlickUIDemoDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(65584);
        this.dataModel = new DataModel(true);
    }

    protected void configureShell(Shell newShell) {
        String dialogTitle = "Slick UI Demo Dialog";
        newShell.setText(dialogTitle);
        super.configureShell(newShell);
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.setCloseEnabled(this.initialCloseState);
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite baseComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        baseComposite.setLayout((Layout)layout);
        baseComposite.setLayoutData((Object)new GridData(1808));
        this.controlList = new SlickControlList(baseComposite, null);
        this.controlList.addSelectionChangedListener(this);
        this.controlList.addValidationStateChangedListener(this);
        this.controlProvider = new DemoContentProvider();
        this.controlList.setContentProvider(this.controlProvider);
        this.controlList.setInput(this.dataModel);
        return baseComposite;
    }

    protected void okPressed() {
        this.controlList.dispose();
        super.okPressed();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSource().equals(this.controlList)) {
            this.selectedControl = (SlickControlDescriptor)((IStructuredSelection)event.getSelection()).getFirstElement();
            this.setTitle(this.selectedControl.getTitle());
            this.setMessage(this.selectedControl.getDescription());
            this.validateSelection();
        }
    }

    private void setCloseEnabled(boolean enabled) {
        Button closeButton = this.getButton(0);
        if (closeButton != null) {
            closeButton.setEnabled(enabled);
        } else {
            this.initialCloseState = enabled;
        }
    }

    private void setStatus(IStatus status) {
        if (!status.isOK()) {
            int severity = 0;
            severity = status.getSeverity() == 4 ? 3 : (status.getSeverity() == 1 ? 1 : 2);
            String message = StatusUtil.getMostSevereMessage(status);
            if (severity > 2) {
                this.setErrorMessage(message);
            } else {
                this.setMessage(message, severity);
            }
        } else {
            this.setErrorMessage(null);
            this.setMessage(this.selectedControl.getDescription());
        }
    }

    private void validateSelection() {
        if (this.selectedControl != null) {
            SlickControlProvider provider = this.selectedControl.getControlProvider();
            IStatus status = provider.getValidationState();
            this.setStatus(status);
        }
    }

    @Override
    public void validateStateChanged(ValidationEvent event) {
        this.validateSelection();
        this.setCloseEnabled(event.getStatus().isOK());
    }
}

