/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.javaee.model.internal;

import com.ibm.etools.j2ee.J2EEProjectUtilities;
import com.ibm.etools.javaee.annotations.base.EMF2AnnotationModelBaseProvider;
import com.ibm.etools.javaee.core.JavaEEPlugin;
import com.ibm.etools.javaee.core.WebFragmentResourceImpl;
import com.ibm.etools.javaee.merge.MergeUtil;
import com.ibm.etools.javaee.merge.WebFragmentMergedModelAdapter;
import com.ibm.etools.javaee.model.internal.IJEE5ModelProvider;
import com.ibm.etools.javaee.model.internal.JEE5ModelProvider;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collections;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.IModelProviderEvent;
import org.eclipse.jst.javaee.core.DisplayName;
import org.eclipse.jst.javaee.core.JavaeeFactory;
import org.eclipse.jst.javaee.web.WebAppVersionType;
import org.eclipse.jst.javaee.web.WebFactory;
import org.eclipse.jst.javaee.web.WebFragment;
import org.eclipse.jst.javaee.web.internal.impl.WebFragmentImpl;
import org.eclipse.jst.javaee.webfragment.WebAppDeploymentDescriptor;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class WebFragmentModelProvider
extends JEE5ModelProvider {
    private static final String WEBFRAGMENT_CONTENT_TYPE = "org.eclipse.jst.jee.ee6webfragmentDD";
    private static boolean debug = false;
    protected Reference<EObject> cachedAnnotationsModelRef = null;
    private Reference<WebFragment> cachedMergeModelRef = null;

    static {
        try {
            String debugS = System.getProperty("com.ibm.etools.javaee.merge.DEBUG");
            if (debugS != null) {
                debug = true;
            }
        }
        catch (Throwable throwable) {}
    }

    public WebFragmentModelProvider(IProject proj) {
        int j2eeDDProjectVersion;
        this.proj = proj;
        String ddVersion = J2EEProjectUtilities.getJ2EEDDProjectVersion(proj);
        if (ddVersion != null && (j2eeDDProjectVersion = J2EEVersionUtil.convertVersionStringToInt((String)J2EEProjectUtilities.getJ2EEDDProjectVersion(proj))) < 25) {
            this.useLegacy = true;
        }
        this.setDefaultResourcePath(IJEE5ModelProvider.WEB_FRAGMENT_DD_MODEL_MERGED);
    }

    public Object getAnnotationsModel() {
        EObject result = null;
        if (this.cachedAnnotationsModelRef != null) {
            result = this.cachedAnnotationsModelRef.get();
        }
        if (result == null) {
            result = EMF2AnnotationModelBaseProvider.getInstance().getTopLevelAnnotationObject(this.proj, IJEE5ModelProvider.WEBFRAGMENT_DD_MODEL_XML_NODEVICE);
            this.cachedAnnotationsModelRef = new SoftReference<EObject>(result);
        }
        return result;
    }

    @Override
    public Object getModelObject(IPath modelPath) {
        IPath modelPathNoDevice = modelPath.setDevice(null);
        if (this.useLegacy) {
            return this.getLegacyDDArtifactEdit().getModelObject(modelPathNoDevice);
        }
        if (this.getWritableResource() != null) {
            return this.getXMLModel(modelPath);
        }
        String device = modelPath.getDevice();
        if (device == null || "xmlonly:".equals(device) && IJEE5ModelProvider.WEBFRAGMENT_DD_MODEL_XML_NODEVICE.equals((Object)modelPathNoDevice)) {
            return this.getXMLModel(modelPath);
        }
        if ("annotated:".equals(device) && IJEE5ModelProvider.WEBFRAGMENT_DD_MODEL_XML_NODEVICE.equals((Object)modelPathNoDevice)) {
            return this.getAnnotationsModel();
        }
        if ("merged:".equals(device) && IJEE5ModelProvider.WEBFRAGMENT_DD_MODEL_XML_NODEVICE.equals((Object)modelPathNoDevice)) {
            WebFragment result = null;
            if (this.cachedMergeModelRef != null) {
                result = this.cachedMergeModelRef.get();
            }
            if (result == null) {
                WebFragment annotationsRoot = (WebFragment)this.getModelObject(IJEE5ModelProvider.WEB_FRAGMENT_DD_MODEL_ANNOTATIONS);
                WebFragment xmlRoot = (WebFragment)this.getModelObject(IJEE5ModelProvider.WEBFRAGMENT_DD_MODEL_XML_NODEVICE);
                if (xmlRoot == null) {
                    result = annotationsRoot;
                } else if (annotationsRoot == null) {
                    result = xmlRoot;
                } else {
                    result = MergeUtil.compose(xmlRoot, annotationsRoot);
                    if (debug) {
                        TestAdapter tA = new TestAdapter();
                        ((EObject)result).eAdapters().add((Object)tA);
                    }
                }
                this.cachedMergeModelRef = new SoftReference<WebFragment>(result);
            }
            return result;
        }
        return null;
    }

    public Object getXMLModel(IPath modelPath) {
        WebFragmentResourceImpl webRes = (WebFragmentResourceImpl)this.getModelResource(modelPath);
        if (webRes != null && webRes.getContents().size() > 0) {
            if (webRes.getRootObject() instanceof WebAppDeploymentDescriptor) {
                return ((WebAppDeploymentDescriptor)webRes.getRootObject()).getWebFragment();
            }
            return webRes.getRootObject();
        }
        return null;
    }

    @Override
    protected String getContentTypeDescriber() {
        return WEBFRAGMENT_CONTENT_TYPE;
    }

    @Override
    public void populateRoot(XMLResourceImpl res, String name) {
        WebFragment webFragment = WebFactory.eINSTANCE.createWebFragment();
        webFragment.setVersion(WebAppVersionType._30_LITERAL);
        DisplayName dn = JavaeeFactory.eINSTANCE.createDisplayName();
        dn.setValue(name);
        webFragment.getDisplayNames().add(dn);
        res.getContents().add((Object)((EObject)webFragment));
    }

    @Override
    public void populateRoot(XMLResourceImpl res, String name, String version) {
        WebFragment webFragment = WebFactory.eINSTANCE.createWebFragment();
        if (version.equals("3.0")) {
            webFragment.setVersion(WebAppVersionType._30_LITERAL);
        } else if (version.equals("3.1")) {
            webFragment.setVersion(WebAppVersionType._31);
        } else if (version.equals("4.0")) {
            webFragment.setVersion(WebAppVersionType._40);
        }
        DisplayName dn = JavaeeFactory.eINSTANCE.createDisplayName();
        dn.setValue(name);
        webFragment.getDisplayNames().add(dn);
        res.getContents().add((Object)((EObject)webFragment));
    }

    @Override
    public void modelsChanged(IModelProviderEvent anEvent) {
        int code = anEvent.getEventCode();
        switch (code) {
            case 4: 
            case 64: {
                if (!this.hasResourceReference(anEvent.getChangedResources())) break;
                this.clearMergedCaches();
            }
        }
        super.modelsChanged(anEvent);
    }

    private void clearMergedCaches() {
        this.cachedMergeModelRef = null;
        this.cachedAnnotationsModelRef = null;
    }

    @Override
    public void modify(Runnable runnable, IPath modelPath) {
        if (this.useLegacy) {
            this.getLegacyDDArtifactEdit().modify(runnable, modelPath);
        } else {
            try {
                try {
                    final WebFragmentResourceImpl res = (WebFragmentResourceImpl)this.getModelResource(IJEE5ModelProvider.WEB_FRAGMENT_DD_MODEL_XML);
                    if (res != null) {
                        this.setWritableResource((XMLResourceImpl)res);
                    }
                    runnable.run();
                    final WebFragmentResourceImpl newRes = (WebFragmentResourceImpl)this.getModelResource(IJEE5ModelProvider.WEB_FRAGMENT_DD_MODEL_XML);
                    try {
                        if (res != null) {
                            if (modelPath != null && modelPath.equals((Object)IModelProvider.FORCESAVE)) {
                                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                                workspace.run(new IWorkspaceRunnable(){

                                    public void run(IProgressMonitor monitor) throws CoreException {
                                        try {
                                            if (res.getResourceSet() == null) {
                                                newRes.save(Collections.EMPTY_MAP, true);
                                            } else {
                                                res.save(Collections.EMPTY_MAP, true);
                                            }
                                        }
                                        catch (IOException e) {
                                            JavaEEPlugin.logError(e);
                                        }
                                    }
                                }, (IProgressMonitor)new NullProgressMonitor());
                            } else if (res.getResourceSet() == null) {
                                newRes.save(Collections.EMPTY_MAP);
                            } else {
                                res.save(Collections.EMPTY_MAP);
                            }
                        }
                    }
                    catch (IOException e) {
                        JavaEEPlugin.logError(e);
                    }
                }
                catch (Exception ex) {
                    JavaEEPlugin.logError(ex);
                    this.setWritableResource(null);
                }
            }
            finally {
                this.setWritableResource(null);
            }
        }
    }

    @Override
    protected XMLResourceImpl getModelResource(IPath modelPath) {
        IPath modelPathNoDevice = modelPath.setDevice(null);
        return super.getModelResource(modelPathNoDevice);
    }

    @Override
    public void projectClosed() {
        WebFragmentMergedModelAdapter adapter;
        WebFragment mergedModel;
        if (this.cachedMergeModelRef != null && (mergedModel = this.cachedMergeModelRef.get()) != null && (adapter = MergeUtil.getWebFragmentMMAdapterFromEObject((EObject)mergedModel)) != null) {
            adapter.dispose();
        }
        this.clearMergedCaches();
        super.projectClosed();
    }

    @Override
    protected String getVersionString() {
        IProjectFacetVersion facetVersion = WebFragmentModelProvider.getDefaultFacet(this.proj);
        return facetVersion.getVersionString();
    }

    class TestAdapter
    extends AdapterImpl {
        String id = Integer.toHexString(System.identityHashCode((Object)this));

        TestAdapter() {
            System.out.println("New TestAdapter: " + this.id);
        }

        public void notifyChanged(Notification notification) {
            System.out.println("=== TestAdapter " + this.id + " : ");
            System.out.println("\tType " + notification.getEventType());
            System.out.println("\tfrom " + notification.getNotifier());
            System.out.println("\tfeature " + notification.getFeature());
            System.out.println("\toldValue " + notification.getOldValue());
            System.out.println("\tnewValue " + notification.getNewValue());
            if (notification.getEventType() == 8) {
                System.out.println("====== TA - REMOVING_ADAPTER event: ");
                if (notification.getNotifier() instanceof WebFragmentImpl) {
                    System.out.println("======== !! removing adapter from WebFragmentImpl");
                }
            }
        }
    }
}

