/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.javaee.model.internal;

import com.ibm.etools.javaee.core.JavaEEPlugin;
import com.ibm.etools.javaee.core.JavaEEResourceImpl;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.jem.util.emf.workbench.FlexibleProjectResourceSet;
import org.eclipse.jem.util.emf.workbench.ISynchronizerExtender;
import org.eclipse.jem.util.emf.workbench.ProjectResourceSet;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.jst.j2ee.componentcore.EnterpriseArtifactEdit;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.IModelProviderEvent;
import org.eclipse.jst.j2ee.model.IModelProviderListener;
import org.eclipse.jst.j2ee.model.ModelProviderEvent;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.impl.ModuleURIUtil;
import org.eclipse.wst.common.componentcore.internal.impl.WTPResourceFactoryRegistry;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.ResourceStateInputProvider;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.ResourceStateValidator;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.ResourceStateValidatorImpl;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.ResourceStateValidatorPresenter;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class JEE5ModelProvider
implements IModelProvider,
ResourceStateInputProvider,
ResourceStateValidator,
IModelProviderListener,
ISynchronizerExtender,
IResourceChangeListener,
IResourceDeltaVisitor {
    protected XMLResourceImpl writableResource;
    protected IProject proj;
    protected IPath defaultResourcePath;
    protected EnterpriseArtifactEdit legacyDDArtifactEdit;
    protected ResourceStateValidator stateValidator;
    protected ResourceAdapter resourceAdapter = new ResourceAdapter();
    protected final ListenerList listeners = new ListenerList();
    protected boolean useLegacy = false;
    private Set modelResources = new HashSet();

    public JEE5ModelProvider() {
        this.initListeningIfNecessary();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    protected ProjectResourceSet getResourceSet(IProject proj2) {
        return (ProjectResourceSet)WorkbenchResourceHelperBase.getResourceSet((IProject)this.proj);
    }

    public XMLResourceImpl getWritableResource() {
        return this.writableResource;
    }

    public void setWritableResource(XMLResourceImpl writableResource) {
        this.writableResource = writableResource;
    }

    protected void resourceChanged(Resource aResource) {
    }

    protected void resourceIsLoadedChanged(Resource aResource, boolean oldValue, boolean newValue) {
        if (this.hasListeners()) {
            int eventCode = newValue ? 32 : 64;
            ModelProviderEvent evt = new ModelProviderEvent(eventCode, (IModelProvider)this, this.proj);
            evt.addResource((Object)aResource);
            this.notifyListeners((IModelProviderEvent)evt);
        }
    }

    public boolean hasListeners() {
        return !this.listeners.isEmpty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected XMLResourceImpl getModelResource(IPath modelPath) {
        ProjectResourceSet resSet;
        if (this.writableResource != null) {
            this.addManagedResource(this.writableResource);
            return this.writableResource;
        }
        if (modelPath == null || modelPath.equals((Object)IModelProvider.FORCESAVE)) {
            modelPath = this.getDefaultResourcePath();
        }
        if ((resSet = this.getResourceSet(this.proj)) == null) {
            return null;
        }
        resSet.getSynchronizer().addExtender((ISynchronizerExtender)this);
        IVirtualFolder container = ComponentCore.createComponent((IProject)this.proj).getRootFolder();
        String modelPathURI = modelPath.toString();
        URI uri = URI.createURI((String)modelPathURI);
        Path projURIPath = new Path("");
        projURIPath = projURIPath.append(container.getProjectRelativePath());
        projURIPath = projURIPath.addTrailingSeparator();
        projURIPath = projURIPath.append(modelPath);
        URI projURI = URI.createURI((String)projURIPath.toString());
        XMLResourceImpl res = null;
        try {
            if (!this.proj.getFile(projURI.toString()).exists()) {
                XMLResourceImpl newRes = this.createModelResource(modelPath, resSet, projURI, this.getVersionString());
                if (newRes == null) return newRes;
                this.addManagedResource(newRes);
                return newRes;
            }
            res = (XMLResourceImpl)resSet.getResource(this.getModuleURI(uri), true);
            if (res == null) {
                return null;
            }
            this.addManagedResource(res);
            return res;
        }
        catch (WrappedException ex) {
            if (!(ex.getCause() instanceof FileNotFoundException)) throw ex;
            return null;
        }
    }

    protected String getVersionString() {
        return null;
    }

    protected static IProjectFacetVersion getDefaultFacet(IProject proj) {
        String type = J2EEProjectUtilities.getJ2EEProjectType((IProject)proj);
        IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)type);
        IFacetedProject fp = null;
        try {
            fp = ProjectFacetsManager.create((IProject)proj);
        }
        catch (CoreException e) {
            J2EEPlugin.logError((CoreException)e);
        }
        if (fp != null && facet != null) {
            return fp.getInstalledVersion(facet);
        }
        return null;
    }

    private void initListeningIfNecessary() {
        this.addListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addManagedResource(XMLResourceImpl res) {
        Set set = this.modelResources;
        synchronized (set) {
            this.modelResources.add(res);
        }
        if (!res.eAdapters().contains((Object)this.resourceAdapter)) {
            res.eAdapters().add((Object)this.resourceAdapter);
        }
    }

    protected URI getModuleURI(URI uri) {
        URI moduleuri = ModuleURIUtil.fullyQualifyURI((IProject)this.proj, (String)this.getContentTypeDescriber());
        IPath requestPath = new Path(moduleuri.path()).append((IPath)new Path(uri.path()));
        URI resourceURI = URI.createURI((String)("module:" + requestPath.toString()));
        return resourceURI;
    }

    protected XMLResourceImpl createModelResource(IPath modelPath, ProjectResourceSet resourceSet, URI uri) {
        XMLResourceImpl res = (XMLResourceImpl)resourceSet.getResource(this.getModuleURI(uri), false);
        if (!(res != null && res.isLoaded() || (res = (XMLResourceImpl)((FlexibleProjectResourceSet)resourceSet).createResource(this.getModuleURI(uri), WTPResourceFactoryRegistry.INSTANCE.getFactory(uri, this.getContentType(this.getContentTypeDescriber())))) == null)) {
            this.populateRoot(res, resourceSet.getProject().getName());
        }
        return res;
    }

    protected XMLResourceImpl createModelResource(IPath modelPath, ProjectResourceSet resourceSet, URI uri, String version) {
        XMLResourceImpl res = (XMLResourceImpl)resourceSet.getResource(this.getModuleURI(uri), false);
        if (!(res != null && res.isLoaded() || (res = (XMLResourceImpl)((FlexibleProjectResourceSet)resourceSet).createResource(this.getModuleURI(uri), WTPResourceFactoryRegistry.INSTANCE.getFactory(uri, this.getContentType(this.getContentTypeDescriber())))) == null)) {
            this.populateRoot(res, resourceSet.getProject().getName(), version);
        }
        return res;
    }

    public void populateRoot(XMLResourceImpl res, String string) {
    }

    public void populateRoot(XMLResourceImpl res, String string, String version) {
    }

    private IContentDescription getContentType(String contentTypeDescriber) {
        if (contentTypeDescriber != null) {
            return Platform.getContentTypeManager().getContentType(contentTypeDescriber).getDefaultDescription();
        }
        return null;
    }

    public IPath getDefaultResourcePath() {
        return this.defaultResourcePath;
    }

    public void setDefaultResourcePath(IPath defaultResourcePath) {
        this.defaultResourcePath = defaultResourcePath;
    }

    public Object getModelObject() {
        try {
            if (this.useLegacy) {
                ProjectResourceSet resSet = this.getResourceSet(this.proj);
                if (resSet != null) {
                    resSet.getSynchronizer().addExtender((ISynchronizerExtender)this);
                }
                return this.getLegacyDDArtifactEdit().getModelObject();
            }
            return this.getModelObject(this.getDefaultResourcePath());
        }
        catch (RuntimeException ex) {
            JavaEEPlugin.logError(ex);
            return null;
        }
    }

    public Object getModelObject(IPath modelPath) {
        return null;
    }

    protected String getContentTypeDescriber() {
        return null;
    }

    public IStatus validateEdit(IPath modelPath, Object context) {
        if (this.useLegacy) {
            return this.getLegacyDDArtifactEdit().validateEdit(modelPath, context);
        }
        if (modelPath == null) {
            modelPath = this.getDefaultResourcePath();
        }
        IWorkspace work = ResourcesPlugin.getWorkspace();
        IFile file = WorkbenchResourceHelper.getFile((Resource)this.getModelResource(modelPath));
        if (file != null) {
            IFile[] files = new IFile[]{file};
            if (context == null) {
                context = IWorkspace.VALIDATE_PROMPT;
            }
            return work.validateEdit(files, context);
        }
        return Status.OK_STATUS;
    }

    public void modify(Runnable runnable, IPath modelPath) {
        if (this.useLegacy) {
            this.getLegacyDDArtifactEdit().modify(runnable, modelPath);
        } else {
            try {
                try {
                    final JavaEEResourceImpl res = (JavaEEResourceImpl)this.getModelResource(modelPath);
                    if (res != null) {
                        this.setWritableResource((XMLResourceImpl)res);
                    }
                    runnable.run();
                    final JavaEEResourceImpl newRes = (JavaEEResourceImpl)this.getModelResource(modelPath);
                    try {
                        if (res != null) {
                            if (modelPath != null && modelPath.equals((Object)IModelProvider.FORCESAVE)) {
                                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                                workspace.run(new IWorkspaceRunnable(){

                                    public void run(IProgressMonitor monitor) throws CoreException {
                                        try {
                                            if (res.getResourceSet() == null) {
                                                newRes.save(Collections.EMPTY_MAP, true);
                                            } else {
                                                res.save(Collections.EMPTY_MAP, true);
                                            }
                                        }
                                        catch (IOException e) {
                                            JavaEEPlugin.logError(e);
                                        }
                                    }
                                }, (IProgressMonitor)new NullProgressMonitor());
                            } else if (res.getResourceSet() == null) {
                                newRes.save(Collections.EMPTY_MAP);
                            } else {
                                res.save(Collections.EMPTY_MAP);
                            }
                        }
                    }
                    catch (IOException e) {
                        JavaEEPlugin.logError(e);
                    }
                }
                catch (Exception ex) {
                    JavaEEPlugin.logError(ex);
                    this.setWritableResource(null);
                }
            }
            finally {
                this.setWritableResource(null);
            }
        }
    }

    public void addListener(IModelProviderListener listener) {
        EnterpriseArtifactEdit legacyDDArtifactEdit = null;
        if (this.useLegacy) {
            legacyDDArtifactEdit = this.getLegacyDDArtifactEdit();
        }
        if (legacyDDArtifactEdit != null) {
            legacyDDArtifactEdit.addListener(listener);
        } else {
            this.listeners.add((Object)listener);
        }
    }

    public void removeListener(IModelProviderListener listener) {
        if (this.useLegacy) {
            EnterpriseArtifactEdit edit = this.getLegacyDDArtifactEdit();
            if (edit != null) {
                edit.removeListener(listener);
            }
        } else {
            this.listeners.remove((Object)listener);
        }
    }

    public void modelsChanged(IModelProviderEvent anEvent) {
        int code = anEvent.getEventCode();
        switch (code) {
            case 4: 
            case 64: {
                if (this.hasResourceReference(anEvent.getChangedResources())) {
                    this.removeResources(anEvent.getChangedResources());
                    break;
                }
                return;
            }
        }
    }

    protected void removeResources(List aList) {
        int i = 0;
        while (i < aList.size()) {
            Resource res = (Resource)aList.get(i);
            this.removeResource(res);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeResource(Resource aResource) {
        if (aResource != null) {
            if (this.writableResource == aResource) {
                this.writableResource = null;
            }
            aResource.eAdapters().remove((Object)this.resourceAdapter);
            Set set = this.modelResources;
            synchronized (set) {
                return this.modelResources.remove(aResource);
            }
        }
        return false;
    }

    protected boolean hasResourceReference(List tResources) {
        if (tResources == null) {
            return false;
        }
        int i = 0;
        while (i < tResources.size()) {
            if (this.hasResourceReference((Resource)tResources.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean hasResourceReference(Resource aResource) {
        if (aResource != null) {
            return this.getResources().contains(aResource);
        }
        return false;
    }

    protected void notifyListeners(IModelProviderEvent anEvent) {
        NotifyRunner notifier = new NotifyRunner(anEvent);
        Object[] notifyList = this.listeners.getListeners();
        int i = 0;
        while (i < notifyList.length) {
            notifier.setListener((IModelProviderListener)notifyList[i]);
            SafeRunner.run((ISafeRunnable)notifier);
            ++i;
        }
    }

    protected EnterpriseArtifactEdit getLegacyDDArtifactEdit() {
        if (this.legacyDDArtifactEdit == null) {
            this.legacyDDArtifactEdit = this.createArtifactEdit();
        }
        return this.legacyDDArtifactEdit;
    }

    public ResourceStateValidator getStateValidator() {
        if (this.stateValidator == null) {
            this.stateValidator = this.createStateValidator();
        }
        return this.stateValidator;
    }

    private ResourceStateValidator createStateValidator() {
        return new ResourceStateValidatorImpl((ResourceStateInputProvider)this);
    }

    protected EnterpriseArtifactEdit createArtifactEdit() {
        return null;
    }

    public void checkActivation(ResourceStateValidatorPresenter presenter) throws CoreException {
        this.getStateValidator().checkActivation(presenter);
    }

    public boolean checkReadOnly() {
        return this.getStateValidator().checkReadOnly();
    }

    public boolean checkSave(ResourceStateValidatorPresenter presenter) throws CoreException {
        return this.getStateValidator().checkSave(presenter);
    }

    public void lostActivation(ResourceStateValidatorPresenter presenter) throws CoreException {
        this.getStateValidator().lostActivation(presenter);
    }

    public IStatus validateState(ResourceStateValidatorPresenter presenter) throws CoreException {
        if (presenter == null) {
            return Status.OK_STATUS;
        }
        return this.getStateValidator().validateState(presenter);
    }

    public void cacheNonResourceValidateState(List roNonResourceFiles) {
    }

    public List getNonResourceFiles() {
        return null;
    }

    public List getNonResourceInconsistentFiles() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getResources() {
        Set set = this.modelResources;
        synchronized (set) {
            return new ArrayList(this.modelResources);
        }
    }

    public boolean isDirty() {
        List list = this.getResources();
        int i = 0;
        while (i < list.size()) {
            if (((Resource)list.get(i)).isModified()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void projectChanged(IResourceDelta delta) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void projectClosed() {
        int eventCode = 4;
        ModelProviderEvent evt = new ModelProviderEvent(eventCode, (IModelProvider)this, this.proj);
        NotifyRunner notifier = new NotifyRunner((IModelProviderEvent)evt);
        Object[] notifyList = this.listeners.getListeners();
        int i = 0;
        while (i < notifyList.length) {
            notifier.setListener((IModelProviderListener)notifyList[i]);
            SafeRunner.run((ISafeRunnable)notifier);
            ++i;
        }
        for (Resource res : this.getResources()) {
            res.eAdapters().remove((Object)this.resourceAdapter);
        }
        this.writableResource = null;
        Set set = this.modelResources;
        synchronized (set) {
            this.modelResources.clear();
        }
        this.legacyDDArtifactEdit = null;
    }

    public boolean visit(IResourceDelta delta) {
        if (delta.getFlags() == 131072) {
            return false;
        }
        IResource resource = delta.getResource();
        switch (resource.getType()) {
            case 8: {
                return true;
            }
            case 4: {
                return resource.equals((Object)this.proj);
            }
            case 2: {
                return true;
            }
            case 1: {
                String defaultDeploymentDescriptorPathString;
                IFile compFile;
                IFile manifestFile;
                String name = resource.getName();
                if (name.equals("MANIFEST.MF") && ((manifestFile = J2EEProjectUtilities.getManifestFile((IProject)resource.getProject(), (boolean)false)) == null || resource.equals((Object)manifestFile))) {
                    this.metadataFileChanged(manifestFile);
                }
                if (resource.getProjectRelativePath().toString().equals(StructureEdit.MODULE_META_FILE_NAME) && ((compFile = resource.getProject().getFile(StructureEdit.MODULE_META_FILE_NAME)) == null || resource.equals((Object)compFile))) {
                    this.metadataFileChanged(compFile);
                }
                if (delta.getKind() != 2) break;
                String resourcePathString = resource.getProjectRelativePath().toString();
                IPath defaultResourcePath = this.getDefaultResourcePath();
                if (defaultResourcePath == null || !resourcePathString.endsWith(defaultDeploymentDescriptorPathString = defaultResourcePath.setDevice(null).toString()) || !this.useLegacy) break;
                this.removeListener(this);
                this.useLegacy = false;
                this.legacyDDArtifactEdit = null;
                this.addListener(this);
            }
        }
        return false;
    }

    private void metadataFileChanged(IFile aFile) {
        if (this.hasListeners()) {
            int eventCode = 512;
            ModelProviderEvent evt = new ModelProviderEvent(eventCode, (IModelProvider)this, this.proj);
            evt.addResource((Object)aFile);
            this.notifyListeners((IModelProviderEvent)evt);
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        switch (event.getType()) {
            case 1: {
                try {
                    event.getDelta().accept((IResourceDeltaVisitor)this);
                    break;
                }
                catch (CoreException e) {
                    JavaEEPlugin.logError(e);
                }
            }
        }
    }

    public class NotifyRunner
    implements ISafeRunnable {
        private final IModelProviderEvent event;
        private IModelProviderListener listener;

        public NotifyRunner(IModelProviderEvent event) {
            Assert.isNotNull((Object)event);
            this.event = event;
        }

        public void setListener(IModelProviderListener listener) {
            this.listener = listener;
        }

        public void handleException(Throwable exception) {
            JavaEEPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.ibm.etools.javaee.core", 0, exception.getMessage(), exception));
        }

        public void run() throws Exception {
            if (this.listener != null) {
                this.listener.modelsChanged(this.event);
            }
        }
    }

    protected class ResourceAdapter
    extends AdapterImpl {
        protected ResourceAdapter() {
        }

        public void notifyChanged(Notification notification) {
            if (notification.getEventType() == 1 && notification.getFeatureID(null) == 4) {
                JEE5ModelProvider.this.resourceIsLoadedChanged((Resource)notification.getNotifier(), notification.getOldBooleanValue(), notification.getNewBooleanValue());
            } else if (notification.getFeatureID(null) == 3) {
                JEE5ModelProvider.this.resourceChanged((Resource)notification.getNotifier());
            }
        }
    }
}

