/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.javaee.model.internal;

import com.ibm.etools.j2ee.J2EEProjectUtilities;
import com.ibm.etools.javaee.annotations.ejb.converter.EMF2AnnotationModelProvider;
import com.ibm.etools.javaee.core.JavaEEPlugin;
import com.ibm.etools.javaee.core.JavaEEResourceImpl;
import com.ibm.etools.javaee.merge.MergeUtil;
import com.ibm.etools.javaee.merge.MergedModelAdapter2;
import com.ibm.etools.javaee.model.internal.IJEE5ModelProvider;
import com.ibm.etools.javaee.model.internal.JEE5ModelProvider;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.jst.j2ee.componentcore.EnterpriseArtifactEdit;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.IModelProviderEvent;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.project.WebUtilities;
import org.eclipse.jst.javaee.core.DisplayName;
import org.eclipse.jst.javaee.core.JavaeeFactory;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.jst.javaee.ejb.EJBJarDeploymentDescriptor;
import org.eclipse.jst.javaee.ejb.EjbFactory;
import org.eclipse.jst.javaee.ejb.internal.impl.EJBJarImpl;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class Ejb3ModelProvider
extends JEE5ModelProvider {
    protected IPath defaultXMLResourcePath = IJEE5ModelProvider.EJB_DD_MODEL_XML_NODEVICE;
    protected IPath defaultAnnotationResourcePath = IJEE5ModelProvider.EJB_DD_MODEL_ANNOTATIONS;
    private Object lockObject = new Object();
    private static final String EJB3_CONTENT_TYPE = "org.eclipse.jst.jee.ee5ejbDD";
    private static boolean debug = false;
    protected Reference<EObject> cachedAnnotationsModelRef = null;
    private Reference<EJBJar> cachedMergeModelRef = null;

    static {
        try {
            String debugS = System.getProperty("com.ibm.etools.javaee.merge.DEBUG");
            if (debugS != null) {
                debug = true;
            }
        }
        catch (Throwable throwable) {}
    }

    public Ejb3ModelProvider(IProject proj) {
        int j2eeDDProjectVersion;
        this.proj = proj;
        String ddVersion = this.getJ2EEDDProjectVersion();
        if (ddVersion != null && (j2eeDDProjectVersion = J2EEVersionUtil.convertVersionStringToInt((String)J2EEProjectUtilities.getJ2EEDDProjectVersion(proj))) < 30) {
            this.useLegacy = true;
        }
        this.setDefaultResourcePath(IJEE5ModelProvider.EJB_DD_MODEL_MERGED);
    }

    protected Object getAnnotationsModel() {
        EObject result = null;
        if (this.cachedAnnotationsModelRef != null) {
            result = this.cachedAnnotationsModelRef.get();
        }
        if (result == null) {
            result = EMF2AnnotationModelProvider.getInstance().getTopLevelAnnotationObject(this.proj);
            this.cachedAnnotationsModelRef = new SoftReference<EObject>(result);
        }
        return result;
    }

    @Override
    protected EnterpriseArtifactEdit createArtifactEdit() {
        return EJBArtifactEdit.getEJBArtifactEditForRead((IProject)this.proj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getModelObject(IPath modelPath) {
        IPath modelPathNoDevice = modelPath.setDevice(null);
        if (this.useLegacy) {
            return this.getLegacyDDArtifactEdit().getModelObject(modelPathNoDevice);
        }
        if (this.getWritableResource() != null) {
            return this.getXMLModel(modelPath);
        }
        String device = modelPath.getDevice();
        if (device == null || "xmlonly:".equals(device) && this.getDefaultXMLResourcePath().equals((Object)modelPathNoDevice)) {
            return this.getXMLModel(modelPath);
        }
        if ("annotated:".equals(device) && this.getDefaultXMLResourcePath().equals((Object)modelPathNoDevice)) {
            return this.getAnnotationsModel();
        }
        if ("merged:".equals(device) && this.getDefaultXMLResourcePath().equals((Object)modelPathNoDevice)) {
            EJBJar result = null;
            Object object = this.lockObject;
            synchronized (object) {
                if (this.cachedMergeModelRef != null) {
                    result = this.cachedMergeModelRef.get();
                }
                if (result == null) {
                    EJBJar annotationsRoot = (EJBJar)this.getModelObject(this.getDefaultAnnotationResourcePath());
                    EJBJar xmlRoot = (EJBJar)this.getModelObject(this.getDefaultXMLResourcePath());
                    if (xmlRoot == null) {
                        result = annotationsRoot;
                    } else if (annotationsRoot == null) {
                        result = xmlRoot;
                    } else {
                        MergeUtil.removeStaleAdapters((EObject)annotationsRoot);
                        result = MergeUtil.compose(xmlRoot, annotationsRoot);
                        List<IVirtualComponent> ejbLibs = MergeUtil.getEJBLibModules(WebUtilities.getLibModules((IProject)WorkbenchResourceHelper.getProject((Resource)((EObject)xmlRoot).eResource())));
                        for (IVirtualComponent ejbLib : ejbLibs) {
                            if (ejbLib.isBinary()) continue;
                            Ejb3ModelProvider ejbModelProvider = (Ejb3ModelProvider)ModelProviderManager.getModelProvider((IProject)ejbLib.getProject());
                            EObject mappedEJBAnnoModel = (EObject)ejbModelProvider.getModelObject(IJEE5ModelProvider.EJB_DD_MODEL_ANNOTATIONS);
                            MergeUtil.getAdapterFromEObject((EObject)result).addEJBAnnoFragObject(mappedEJBAnnoModel);
                            MergeUtil.mergeMappedEJBModule((EObject)result, mappedEJBAnnoModel, MergeUtil.getAdapterFromEObject((EObject)result), false, true);
                        }
                        if (debug) {
                            TestAdapter tA = new TestAdapter();
                            ((EObject)result).eAdapters().add((Object)tA);
                        }
                    }
                    this.cachedMergeModelRef = new SoftReference<EJBJar>(result);
                }
            }
            return result;
        }
        return null;
    }

    protected Object getXMLModel(IPath modelPath) {
        JavaEEResourceImpl ejbRes = (JavaEEResourceImpl)this.getModelResource(modelPath);
        if (ejbRes != null && ejbRes.getContents().size() > 0) {
            if (ejbRes.getRootObject() instanceof EJBJarDeploymentDescriptor) {
                return ((EJBJarDeploymentDescriptor)ejbRes.getRootObject()).getEjbJar();
            }
            return ejbRes.getRootObject();
        }
        return null;
    }

    @Override
    protected String getContentTypeDescriber() {
        return EJB3_CONTENT_TYPE;
    }

    @Override
    public void populateRoot(XMLResourceImpl res, String name) {
        if (res == null) {
            return;
        }
        EJBJar jar = EjbFactory.eINSTANCE.createEJBJar();
        DisplayName dn = JavaeeFactory.eINSTANCE.createDisplayName();
        dn.setValue(name);
        jar.getDisplayNames().add(dn);
        res.getContents().add((Object)((EObject)jar));
    }

    @Override
    public void populateRoot(XMLResourceImpl res, String name, String version) {
        if (res == null) {
            return;
        }
        EJBJar jar = EjbFactory.eINSTANCE.createEJBJar();
        jar.setVersion(version);
        DisplayName dn = JavaeeFactory.eINSTANCE.createDisplayName();
        dn.setValue(name);
        jar.getDisplayNames().add(dn);
        res.getContents().add((Object)((EObject)jar));
    }

    @Override
    public void modelsChanged(IModelProviderEvent anEvent) {
        int code = anEvent.getEventCode();
        switch (code) {
            case 4: 
            case 64: {
                if (!this.hasResourceReference(anEvent.getChangedResources())) break;
                this.clearMergedCaches();
            }
        }
        super.modelsChanged(anEvent);
    }

    private void clearMergedCaches() {
        this.cachedMergeModelRef = null;
        this.cachedAnnotationsModelRef = null;
    }

    @Override
    public void modify(Runnable runnable, IPath modelPath) {
        if (this.useLegacy) {
            this.getLegacyDDArtifactEdit().modify(runnable, modelPath);
        } else {
            try {
                try {
                    final JavaEEResourceImpl res = (JavaEEResourceImpl)this.getModelResource(this.getDefaultXMLResourcePath().setDevice("xmlonly:"));
                    if (res != null) {
                        this.setWritableResource((XMLResourceImpl)res);
                    }
                    runnable.run();
                    try {
                        if (res != null) {
                            if (modelPath != null && modelPath.equals((Object)IModelProvider.FORCESAVE)) {
                                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                                workspace.run(new IWorkspaceRunnable(){

                                    public void run(IProgressMonitor monitor) throws CoreException {
                                        try {
                                            res.save(Collections.EMPTY_MAP, true);
                                        }
                                        catch (IOException e) {
                                            JavaEEPlugin.logError(e);
                                        }
                                    }
                                }, (IProgressMonitor)new NullProgressMonitor());
                            } else {
                                res.save(Collections.EMPTY_MAP);
                            }
                        }
                    }
                    catch (IOException e) {
                        JavaEEPlugin.logError(e);
                    }
                }
                catch (Exception ex) {
                    JavaEEPlugin.logError(ex);
                    this.setWritableResource(null);
                }
            }
            finally {
                this.setWritableResource(null);
            }
        }
    }

    @Override
    protected XMLResourceImpl getModelResource(IPath modelPath) {
        IPath modelPathNoDevice = modelPath.setDevice(null);
        return super.getModelResource(modelPathNoDevice);
    }

    @Override
    public void projectClosed() {
        MergedModelAdapter2 adapter;
        EJBJar mergedModel;
        if (this.cachedMergeModelRef != null && (mergedModel = this.cachedMergeModelRef.get()) != null && (adapter = MergeUtil.getAdapterFromEObject((EObject)mergedModel)) != null) {
            adapter.dispose();
        }
        this.clearMergedCaches();
        super.projectClosed();
    }

    @Override
    protected String getVersionString() {
        IProjectFacetVersion facetVersion = Ejb3ModelProvider.getDefaultFacet(this.proj);
        return facetVersion.getVersionString();
    }

    protected String getJ2EEDDProjectVersion() {
        return JavaEEProjectUtilities.getJ2EEDDProjectVersion((IProject)this.proj);
    }

    protected IPath getDefaultXMLResourcePath() {
        return this.defaultXMLResourcePath;
    }

    protected void setDefaultXMLResourcePath(IPath defaultXMLResourcePath) {
        this.defaultXMLResourcePath = defaultXMLResourcePath;
    }

    protected IPath getDefaultAnnotationResourcePath() {
        return this.defaultAnnotationResourcePath;
    }

    protected void setDefaultAnnotationResourcePath(IPath defaultAnnotationResourcePath) {
        this.defaultAnnotationResourcePath = defaultAnnotationResourcePath;
    }

    class TestAdapter
    extends AdapterImpl {
        String id = Integer.toHexString(System.identityHashCode((Object)this));

        TestAdapter() {
            System.out.println("New TestAdapter: " + this.id);
        }

        public void notifyChanged(Notification notification) {
            System.out.println("=== TestAdapter " + this.id + " : ");
            System.out.println("\tType " + notification.getEventType());
            System.out.println("\tfrom " + notification.getNotifier());
            System.out.println("\tfeature " + notification.getFeature());
            System.out.println("\toldValue " + notification.getOldValue());
            System.out.println("\tnewValue " + notification.getNewValue());
            if (notification.getEventType() == 8) {
                System.out.println("====== TA - REMOVING_ADAPTER event: ");
                if (notification.getNotifier() instanceof EJBJarImpl) {
                    System.out.println("======== !! removing adapter from EJBJarImpl");
                }
            }
        }
    }
}

