/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.javaee.annotations.ejb.converter;

import com.ibm.etools.annotations.core.data.AnnotationInfo;
import com.ibm.etools.javaee.annotations.ejb.converter.EJBCustomMapper;
import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.emf.ecore.EObject;

public class CustomAnnotationMapper {
    protected EJBCustomMapper ejbMapper = new EJBCustomMapper();
    protected static String MESSAGE_DRIVEN = "javax.ejb.MessageDriven";
    protected static String STATELESS = "javax.ejb.Stateless";
    protected static String STATEFUL = "javax.ejb.Stateful";
    protected static String SINGLETON = "javax.ejb.Singleton";
    protected static String EJB = "javax.ejb.EJB";
    protected static String LOCAL = "javax.ejb.Local";
    protected static String REMOTE = "javax.ejb.Remote";
    protected static String TRANSACTION_ATTRIBUTE = "javax.ejb.TransactionAttribute";
    protected static String TRANSACTION_MANAGEMENT = "javax.ejb.TransactionManagement";
    protected static String DECLARE_ROLES = "javax.annotation.security.DeclareRoles";
    protected static String PERMIT_ALL = "javax.annotation.security.PermitAll";
    protected static String DENY_ALL = "javax.annotation.security.DenyAll";
    protected static String ROLES_ALLOWED = "javax.annotation.security.RolesAllowed";
    protected static String INTERCEPTORS = "javax.interceptor.Interceptors";
    protected static String AROUNDINVOKE = "javax.interceptor.AroundInvoke";
    protected static String RESOURCE = "javax.annotation.Resource";
    protected static String DATASOURCEDEFINITION = "javax.annotation.sql.DataSourceDefinition";
    private static final String[] customAnns = new String[]{EJB, DECLARE_ROLES, PERMIT_ALL, ROLES_ALLOWED, DENY_ALL, TRANSACTION_MANAGEMENT, TRANSACTION_ATTRIBUTE, INTERCEPTORS, LOCAL, REMOTE};
    private static final String[] partiallyCustom = new String[]{MESSAGE_DRIVEN, STATELESS, STATEFUL, AROUNDINVOKE, RESOURCE, SINGLETON, DATASOURCEDEFINITION};

    public static boolean isFullyCustomAnnotationHandling(AnnotationInfo info) {
        String sAnName = info.getFullyQualifiedName();
        int i = 0;
        while (i < customAnns.length) {
            if (customAnns[i].equals(sAnName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isPartiallyCustomAnnotationHandling(AnnotationInfo info) {
        String sAnName = info.getFullyQualifiedName();
        int i = 0;
        while (i < partiallyCustom.length) {
            if (partiallyCustom[i].equals(sAnName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected Hashtable<String, ArrayList<String>> getDependencyMap() {
        return this.ejbMapper.getDependencyMap();
    }

    public EObject handleFullyCustomAnnotation(AnnotationInfo info, EObject parentEObject, boolean adaptNeeded) {
        this.ejbMapper.setAdaptationNeeded(adaptNeeded);
        if (info.getFullyQualifiedName().equals(EJB)) {
            this.ejbMapper.mapEJBAnnotation(info, parentEObject);
        } else if (info.getFullyQualifiedName().equals(DECLARE_ROLES)) {
            this.ejbMapper.mapDeclareRoles(info, parentEObject);
        } else if (info.getFullyQualifiedName().equals(PERMIT_ALL) || info.getFullyQualifiedName().equals(ROLES_ALLOWED) || info.getFullyQualifiedName().equals(DENY_ALL)) {
            this.ejbMapper.mapSecurityPermision(info, parentEObject);
        } else if (info.getFullyQualifiedName().equals(TRANSACTION_MANAGEMENT)) {
            this.ejbMapper.mapTransactionType(info, parentEObject);
        } else if (info.getFullyQualifiedName().equals(TRANSACTION_ATTRIBUTE)) {
            this.ejbMapper.mapTransactionAttribute(info, parentEObject);
        } else if (info.getFullyQualifiedName().equals(INTERCEPTORS)) {
            this.ejbMapper.mapInterceptor(info, parentEObject);
        } else if (!info.getFullyQualifiedName().equals(LOCAL)) {
            info.getFullyQualifiedName().equals(REMOTE);
        }
        return parentEObject;
    }

    public EObject handlePartiallyCustomAnnotation(AnnotationInfo info, EObject annotationObject, EObject oldObject) {
        if (info.getFullyQualifiedName().equals(MESSAGE_DRIVEN)) {
            this.ejbMapper.partiallyMapMDBAnnotation(info, annotationObject);
        } else if (info.getFullyQualifiedName().equals(STATELESS)) {
            this.ejbMapper.partiallyMapSessionBeanAnnotation(info, annotationObject);
        } else if (info.getFullyQualifiedName().equals(STATEFUL)) {
            this.ejbMapper.partiallyMapSessionBeanAnnotation(info, annotationObject);
        } else if (info.getFullyQualifiedName().equals(SINGLETON)) {
            this.ejbMapper.partiallyMapSessionBeanAnnotation(info, annotationObject);
        } else {
            if (info.getFullyQualifiedName().equals(AROUNDINVOKE)) {
                return this.ejbMapper.partiallyAroundInvokeAnnotation(info, oldObject);
            }
            if (info.getFullyQualifiedName().equals(RESOURCE)) {
                return this.ejbMapper.partiallyMapResourceAnnotation(info, annotationObject);
            }
            if (info.getFullyQualifiedName().equals(DATASOURCEDEFINITION)) {
                return this.ejbMapper.partiallyMapDataSourceDefinitionAnnotation(info, annotationObject);
            }
        }
        return annotationObject;
    }
}

