/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.javaee.annotations.ejb.converter;

import com.ibm.etools.annotations.core.data.AnnotatedProjectInfo;
import com.ibm.etools.annotations.core.data.AnnotationInfo;
import com.ibm.etools.annotations.core.model.IAnnotationAttributeProperty;
import com.ibm.etools.annotations.core.properties.ArrayAnnotationArgumentProperty;
import com.ibm.etools.annotations.core.properties.SingleAnnotationArgumentProperty;
import com.ibm.etools.javaee.annotations.ejb.converter.CustomAnnotationMapper;
import com.ibm.etools.javaee.annotations.ejb.converter.EMF2AnnotationAdapterFactory;
import com.ibm.etools.javaee.annotations.ejb.utils.CodeUtils;
import com.ibm.etools.javaee.annotations.ejb.utils.EMFUtils;
import com.ibm.etools.javaee.annotations.ejb.utils.ReflectionUtils;
import com.ibm.etools.javaee.annotations.ejb.utils.XMLUtils;
import com.ibm.etools.javaee.annotations.ejb.xml.datastructures.AnnotationMapping;
import com.ibm.etools.javaee.annotations.ejb.xml.datastructures.ContextInfo;
import com.ibm.etools.javaee.annotations.ejb.xml.datastructures.EAttributeInfo;
import com.ibm.etools.javaee.annotations.ejb.xml.datastructures.EObjectInfo;
import com.ibm.etools.javaee.annotations.ejb.xml.datastructures.MappingInfo;
import com.ibm.etools.javaee.annotations.ejb.xml.datastructures.TriggerAnnotationInfo;
import com.ibm.etools.javaee.annotations.internal.utils.BaseEMFUtils;
import com.ibm.etools.javaee.core.JavaEEPlugin;
import com.ibm.propertygroup.spi.BaseMultiValuedProperty;
import com.ibm.propertygroup.spi.BaseSingleValuedProperty;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AnnotationToEMFMapper {
    private Document doc;
    private static Hashtable annotationMappingsMap = new Hashtable();
    private ReflectionUtils rUtils;
    private static String[] triggerAnnotations = null;
    private CustomAnnotationMapper customMapper = null;

    public AnnotationToEMFMapper() {
        try {
            if (JavaEEPlugin.getDefault() != null) {
                Bundle bundle = JavaEEPlugin.getDefault().getBundle();
                URL starterURL = bundle.getEntry("EJBMappings.xml");
                URL fU = FileLocator.toFileURL((URL)starterURL);
                this.doc = XMLUtils.parseXML(fU.getFile());
                Hashtable<String, String> newH = new Hashtable<String, String>();
                newH.put("EJBPACKAGE", "org.eclipse.jst.javaee.ejb.internal.metadata.EjbPackage");
                newH.put("JAVAEEPACKAGE", "org.eclipse.jst.javaee.core.internal.metadata.JavaeePackage");
                this.rUtils = new ReflectionUtils(newH);
                this.init();
            }
        }
        catch (Exception e) {
            JavaEEPlugin.logError(e);
        }
    }

    public AnnotationToEMFMapper(Document doc) {
        this.doc = doc;
        Hashtable<String, String> newH = new Hashtable<String, String>();
        newH.put("EJBPACKAGE", "org.eclipse.jst.javaee.ejb.internal.metadata.EjbPackage");
        newH.put("JAVAEEPACKAGE", "org.eclipse.jst.javaee.core.internal.metadata.JavaeePackage");
        this.rUtils = new ReflectionUtils(newH);
        this.init();
    }

    private void init() {
        if (!annotationMappingsMap.keys().hasMoreElements()) {
            List<AnnotationMapping> LL = XMLUtils.getAnnotationMappings(this.doc);
            int n = 0;
            while (n < LL.size()) {
                AnnotationMapping am = LL.get(n);
                String sName = am.getFullyQualifiedName();
                ArrayList<AnnotationMapping> aL = (ArrayList<AnnotationMapping>)annotationMappingsMap.get(sName);
                if (aL == null) {
                    aL = new ArrayList<AnnotationMapping>();
                    annotationMappingsMap.put(sName, aL);
                }
                aL.add(am);
                ++n;
            }
        }
        if (triggerAnnotations == null) {
            triggerAnnotations = XMLUtils.getTriggerAnnotationNames(this.doc);
        }
    }

    public EObject createTopEObject() {
        if (this.doc != null) {
            String clN = this.getEClassName();
            EClass topEClass = (EClass)this.rUtils.executeMethod(clN);
            return BaseEMFUtils.createEMFObject(topEClass);
        }
        return null;
    }

    public EObject handleAnnotation(AnnotationInfo info, EObject top, List dependentAnnotations, AnnotatedProjectInfo pai) {
        if (this.customMapper == null) {
            this.customMapper = new CustomAnnotationMapper();
        }
        return this.handleAnnotation(info, null, top, dependentAnnotations, null);
    }

    protected Hashtable<String, ArrayList<String>> getDependencyMap() {
        if (this.customMapper != null) {
            return this.customMapper.getDependencyMap();
        }
        return null;
    }

    protected EObject handleAnnotation(AnnotationInfo info, String trigger, EObject top, List dependentAnnotations, String parentEfetName) {
        return this.handleAnnotation(info, trigger, top, dependentAnnotations, parentEfetName, true);
    }

    protected EObject handleAnnotation(AnnotationInfo info, String trigger, EObject top, List dependentAnnotations, String parentEfetName, boolean adaptNeeded) {
        Object currVal;
        EStructuralFeature sF;
        if (CustomAnnotationMapper.isFullyCustomAnnotationHandling(info)) {
            if (this.customMapper == null) {
                this.customMapper = new CustomAnnotationMapper();
            }
            return this.customMapper.handleFullyCustomAnnotation(info, top, adaptNeeded);
        }
        String sAnName = info.getFullyQualifiedName();
        ArrayList arList = (ArrayList)annotationMappingsMap.get(sAnName);
        if (arList == null || arList.isEmpty()) {
            return top;
        }
        AnnotationMapping aM = null;
        if (trigger == null) {
            aM = (AnnotationMapping)arList.get(0);
        } else {
            if (arList.size() == 1 && this.isTrigerAnnotation(sAnName) && parentEfetName != null) {
                return top;
            }
            int k = 0;
            while (k < arList.size()) {
                AnnotationMapping anM = (AnnotationMapping)arList.get(k);
                ContextInfo[] arContexts = anM.getContexts();
                boolean rightMapping = true;
                TriggerAnnotationInfo[] triggerInfos = anM.getTriggerAnnotations();
                boolean tempB1 = false;
                String contextSensitiveEfeatureName = null;
                int h = 0;
                while (h < triggerInfos.length) {
                    String name = triggerInfos[h].getFullyQualifiedName();
                    if (name != null && name.equals(trigger)) {
                        contextSensitiveEfeatureName = triggerInfos[h].getEFeatureName();
                        tempB1 = true;
                    }
                    ++h;
                }
                if (!tempB1) {
                    rightMapping = false;
                }
                if (rightMapping) {
                    int c = 0;
                    while (c < arContexts.length) {
                        if (arContexts[c].getContextType().equals("Attribute")) {
                            String attrName = arContexts[c].getContextTarget();
                            String val = CodeUtils.getSingleValueAttributeFromAnnotation(info, attrName);
                            if (val != null) {
                                int n;
                                boolean tempB;
                                String[] sVals = arContexts[c].getValidContextValues();
                                if (!arContexts[c].isNotOneOfContextValues()) {
                                    tempB = false;
                                    n = 0;
                                    while (n < sVals.length) {
                                        if (sVals[n].equals(val)) {
                                            tempB = true;
                                        }
                                        ++n;
                                    }
                                    if (!tempB) {
                                        rightMapping = false;
                                        break;
                                    }
                                } else {
                                    tempB = true;
                                    n = 0;
                                    while (n < sVals.length) {
                                        if (sVals[n].equals(val)) {
                                            tempB = false;
                                            break;
                                        }
                                        ++n;
                                    }
                                    if (!tempB) {
                                        rightMapping = false;
                                        break;
                                    }
                                }
                            } else {
                                rightMapping = false;
                            }
                        } else {
                            rightMapping = false;
                        }
                        ++c;
                    }
                    if (rightMapping) {
                        aM = anM;
                        if (contextSensitiveEfeatureName == null || contextSensitiveEfeatureName.trim().length() <= 0) break;
                        aM.setTargetEFeatureName(contextSensitiveEfeatureName);
                        break;
                    }
                }
                ++k;
            }
        }
        if (aM == null) {
            return top;
        }
        EObjectInfo efInf = aM.getEFeatureInfo();
        EObject newTop = top;
        String annEFname = null;
        String sFName = annEFname = aM.getTargetEFeatureName();
        ParentChild parChild = this.createEObjectForEObjectFeature(annEFname, efInf, top, parentEfetName, info, adaptNeeded);
        newTop = parChild.getChild();
        if (annEFname == null || annEFname.trim().length() == 0) {
            annEFname = parentEfetName;
        }
        List listMaps = aM.getListOfMappingInfos();
        int v = 0;
        while (v < listMaps.size()) {
            MappingInfo mi = (MappingInfo)listMaps.get(v);
            this.handleMapping(info, mi, newTop, annEFname, adaptNeeded);
            ++v;
        }
        if (CustomAnnotationMapper.isPartiallyCustomAnnotationHandling(info)) {
            if (this.customMapper == null) {
                this.customMapper = new CustomAnnotationMapper();
            }
            newTop = this.customMapper.handlePartiallyCustomAnnotation(info, newTop, top);
        }
        if (dependentAnnotations != null) {
            int m = 0;
            while (m < dependentAnnotations.size()) {
                AnnotationInfo anInf = (AnnotationInfo)((Object)dependentAnnotations.get(m));
                String annName = anInf.getFullyQualifiedName();
                if (annName.equals("javax.annotation.Resources") || annName.equals("javax.ejb.EJBs") || annName.equals("javax.annotation.sql.DataSourceDefinitions")) {
                    this.handleAttributeAnnotations(anInf, sAnName, newTop, annEFname);
                } else {
                    this.handleAnnotation(anInf, sAnName, newTop, null, annEFname, true);
                }
                ++m;
            }
        }
        if (parChild.getParent() != null && (sF = this.getEStructuralFeature(sFName)) != null && (currVal = parChild.getParent().eGet(sF)) != newTop) {
            EMFUtils.setMOFValue((Notifier)parChild.getParent(), (Object)newTop, sF);
        }
        return newTop;
    }

    protected void handleAttributeAnnotations(AnnotationInfo anInf, String trigger, EObject top, String parentEfetName) {
        List<IAnnotationAttributeProperty> attributes = anInf.getDeclaredAttributes();
        if (attributes != null && attributes.size() > 0) {
            int i = 0;
            while (i < attributes.size()) {
                IAnnotationAttributeProperty attribute = attributes.get(i);
                if (attribute instanceof ArrayAnnotationArgumentProperty) {
                    Object[] values = ((ArrayAnnotationArgumentProperty)attribute).getValues();
                    int j = 0;
                    while (j < values.length) {
                        this.handleAnnotation((AnnotationInfo)((Object)values[j]), trigger, top, null, parentEfetName, true);
                        ++j;
                    }
                } else if (attribute instanceof SingleAnnotationArgumentProperty && ((SingleAnnotationArgumentProperty)attribute).getValue() != null) {
                    this.handleAnnotation((AnnotationInfo)((Object)((SingleAnnotationArgumentProperty)attribute).getValue()), trigger, top, null, parentEfetName, true);
                }
                ++i;
            }
        }
    }

    public String[] getTriggerAnnotationNames() {
        return triggerAnnotations;
    }

    private boolean isTrigerAnnotation(String sAnName) {
        String[] names = this.getTriggerAnnotationNames();
        int i = 0;
        while (i < names.length) {
            String s1 = names[i];
            if (s1.equals(sAnName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getEClassName() {
        String res = null;
        NodeList nl = this.doc.getElementsByTagName("eClass");
        Node trA = nl.item(0);
        Element el = (Element)trA;
        res = el.getAttribute("name");
        return res;
    }

    private EObject createUpperObjects(EObjectInfo inf, EObject top, AnnotationInfo ai, boolean adaptNeeded) {
        EObject currentObject = top;
        if (inf != null) {
            EObjectInfo iterOb = inf;
            while (iterOb != null) {
                currentObject = this.getEObjectForEObjectFeature(iterOb.getName(), currentObject, ai, adaptNeeded, true);
                iterOb = iterOb.getChild();
            }
        }
        return currentObject;
    }

    private ParentChild createEObjectForEObjectFeature(String featureName, EObjectInfo info, EObject top, String sEFName, AnnotationInfo ai, boolean adaptNeeded) {
        EObjectInfo newInfo = info;
        if (newInfo != null && sEFName != null && newInfo.getName().equals(sEFName)) {
            newInfo = newInfo.getChild();
        }
        ParentChild parChild = new ParentChild();
        parChild.setParent(this.createUpperObjects(newInfo, top, ai, adaptNeeded));
        parChild.setChild(this.getEObjectForEObjectFeature(featureName, parChild.getParent(), ai, adaptNeeded, false));
        return parChild;
    }

    private EStructuralFeature getEStructuralFeature(String featureName) {
        String fName = featureName;
        Object o1 = this.rUtils.executeMethod(fName);
        EStructuralFeature feature = o1 instanceof EStructuralFeature ? (EStructuralFeature)o1 : null;
        return feature;
    }

    private EObject getEObjectForEObjectFeature(String featureName, EObject top, AnnotationInfo ai, boolean adaptNeeded, boolean setFeatureIfNew) {
        EObject res = top;
        String fName = featureName;
        EStructuralFeature feature = this.getEStructuralFeature(fName);
        if (feature != null) {
            Object obj = EMFUtils.getMOFValue(top, feature);
            if (obj == null || obj instanceof EMap || obj instanceof EList) {
                if (top != null) {
                    res = setFeatureIfNew ? EMFUtils.createAndSet((Notifier)top, feature) : EMFUtils.createEMFObject(feature);
                    if (adaptNeeded) {
                        EMF2AnnotationAdapterFactory.getInstance().adapt((Notifier)res, (Object)ai);
                    }
                }
            } else if (obj instanceof EObject) {
                res = (EObject)obj;
                if (adaptNeeded) {
                    EMF2AnnotationAdapterFactory.getInstance().adapt((Notifier)res, (Object)ai);
                }
            }
        }
        return res;
    }

    private void handleAttribute(AnnotationInfo info, String sAnnotFeatureName, EObject annotTopObject, EAttributeInfo attrMapping, boolean adaptNeeded) {
        String sAttrName = attrMapping.getTargetName();
        IAnnotationAttributeProperty aP = info.getAttribute(sAttrName);
        if (aP != null) {
            String v;
            Object attrValue = "";
            if (aP instanceof BaseSingleValuedProperty) {
                attrValue = CodeUtils.getSingleValueAttributeFromAnnotation(info, sAttrName);
            } else if (aP instanceof BaseMultiValuedProperty) {
                attrValue = ((BaseMultiValuedProperty)aP).getValues();
            }
            Hashtable hash = attrMapping.getValidValuesMap();
            if (hash != null && (v = (String)hash.get(attrValue)) != null) {
                attrValue = v;
            }
            this.handleSetValue(sAnnotFeatureName, annotTopObject, attrValue, info, adaptNeeded);
        } else if (sAttrName.equals("name")) {
            IJavaElement sourceElement = info.getAnnotation().getParent();
            this.handleSetValue(sAnnotFeatureName, annotTopObject, sourceElement.getElementName(), info, adaptNeeded);
        }
    }

    private void handleJavaElement(AnnotationInfo info, String sAnnotFeatureName, EObject annotTopObject, EAttributeInfo attrMapping, boolean adaptNeeded) {
        String sJavaElName = attrMapping.getTargetName();
        IAnnotation oA = info.getAnnotation();
        String value = null;
        if (oA != null) {
            IJavaElement parEl = oA.getParent();
            if (sJavaElName.equals("className")) {
                IJavaElement methPar;
                if (parEl instanceof IType) {
                    value = ((IType)parEl).getFullyQualifiedName();
                } else if (parEl instanceof IMethod && (methPar = ((IMethod)parEl).getParent()) instanceof IType) {
                    value = ((IType)methPar).getFullyQualifiedName();
                }
            } else if (parEl instanceof IMethod && sJavaElName.equals("methodName")) {
                value = ((IMethod)parEl).getElementName();
            } else if (parEl instanceof IField && sJavaElName.equals("fieldName")) {
                IField field = (IField)parEl;
                value = field.getElementName();
            } else if (parEl instanceof IMethod && sJavaElName.equals("methodParameters")) {
                IMethod mD = (IMethod)parEl;
                String[] pars = mD.getParameterTypes();
                this.handleSetValue(sAnnotFeatureName, annotTopObject, pars, info, adaptNeeded);
                return;
            }
        }
        if (value != null) {
            this.handleSetValue(sAnnotFeatureName, annotTopObject, value, info, adaptNeeded);
        }
    }

    private void handleANYElement(AnnotationInfo info, String sAnnotFeatureName, EObject annotTopObject, EAttributeInfo attrMapping, boolean adaptNeeded) {
        String value = attrMapping.getTargetName();
        if (value != null) {
            this.handleSetValue(sAnnotFeatureName, annotTopObject, value, info, adaptNeeded);
        }
    }

    private void handleSetValue(String featureName, EObject annotTopObject, Object value, AnnotationInfo ai, boolean adaptNeeded) {
        EStructuralFeature feature = this.getEStructuralFeature(featureName);
        if (feature != null) {
            EMFUtils.handleSetValue(feature, annotTopObject, value, ai, adaptNeeded);
        }
    }

    private void handleMapping(AnnotationInfo info, MappingInfo mi, EObject newTop, String annEFname, boolean adaptNeeded) {
        String targetName;
        String targetType = mi.getTargetType();
        if (targetType != null && targetType.equals("AnnotationAttribute") && (targetName = mi.getTargetName()) != null && info.getAttribute(targetName) == null) {
            return;
        }
        EObjectInfo eoInf = mi.getParentEObjectFeature();
        this.handleEObjectCreation(info, eoInf, newTop, adaptNeeded);
    }

    private void handleEObjectCreation(AnnotationInfo info, EObjectInfo eoInf, EObject top, boolean adaptNeeded) {
        EObjectInfo child;
        String sFName = eoInf.getName();
        EAttributeInfo[] tis = eoInf.getTargetInfos();
        EObject newTop = top;
        boolean newTopObject = false;
        if (sFName != null && sFName.trim().length() != 0) {
            newTop = this.getEObjectForEObjectFeature(sFName, top, info, adaptNeeded, false);
            newTopObject = true;
        }
        if (tis != null) {
            int b = 0;
            while (b < tis.length) {
                EAttributeInfo ti = tis[b];
                String sType = ti.getTargetType();
                String annEFname = ti.getTargetEFeatureName();
                if (sType.equals("AnnotationAttribute")) {
                    this.handleAttribute(info, annEFname, newTop, ti, adaptNeeded);
                } else if (sType.equals("JavaElement")) {
                    this.handleJavaElement(info, annEFname, newTop, ti, adaptNeeded);
                } else if (sType.equals("ANY")) {
                    this.handleANYElement(info, annEFname, newTop, ti, adaptNeeded);
                }
                ++b;
            }
        }
        if ((child = eoInf.getChild()) != null) {
            this.handleEObjectCreation(info, child, newTop, adaptNeeded);
        }
        if (newTopObject && sFName != null && sFName.trim().length() != 0) {
            EStructuralFeature sF = this.getEStructuralFeature(sFName);
            if (sF != null) {
                EMFUtils.setMOFValue((Notifier)top, (Object)newTop, sF);
            } else {
                JavaEEPlugin.logError("Couldn't create structural feature for string '" + sFName + "'.");
            }
        }
    }

    private class ParentChild {
        EObject parent;
        EObject child;

        private ParentChild() {
        }

        public EObject getParent() {
            return this.parent;
        }

        public void setParent(EObject parent) {
            this.parent = parent;
        }

        public EObject getChild() {
            return this.child;
        }

        public void setChild(EObject child) {
            this.child = child;
        }
    }
}

