/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.reference;

import com.ibm.etools.j2ee.J2eePlugin;
import com.ibm.etools.j2ee.common.operations.J2EEModelModifierOperationDataModel;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.internal.project.J2EECreationResourceHandler;
import org.eclipse.jst.javaee.applicationclient.ApplicationClient;
import org.eclipse.jst.javaee.core.EjbLocalRef;
import org.eclipse.jst.javaee.core.EjbRef;
import org.eclipse.jst.javaee.core.ResourceEnvRef;
import org.eclipse.jst.javaee.core.ResourceRef;
import org.eclipse.jst.javaee.core.SecurityRoleRef;
import org.eclipse.jst.javaee.ejb.EntityBean;
import org.eclipse.jst.javaee.ejb.MessageDrivenBean;
import org.eclipse.jst.javaee.ejb.SessionBean;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.javaee.web.WebFragment;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public abstract class EE5ReferenceDataModel
extends J2EEModelModifierOperationDataModel {
    public static final String OWNER = "ReferenceDataModel.OWNER";
    public static final String REF_NAME = "ReferenceDataModel.REF_NAME";
    public static final String DESCRIPTION = "ReferenceDataModel.DESCRIPTION";
    public static final String MODULE_TYPE = "ReferenceDataModel.MODULE_TYPE";
    public static final String J2EE_VERSION = "ReferenceDataModel.J2EE_VERSION";
    public static final int EJB_TYPE = 0;
    public static final int APP_CLIENT_TYPE = 1;
    public static final int WEB_TYPE = 2;
    public static final int WEBFRAGMENT_TYPE = 3;
    protected int ownerType;

    @Override
    protected void init() {
        super.init();
    }

    protected void initializeOwnerNature() {
        IProject ownerProject;
        EObject owner = (EObject)this.getProperty(OWNER);
        if (owner != null && (ownerProject = ProjectUtilities.getProject((EObject)owner)) != null) {
            this.ownerType = owner instanceof ApplicationClient ? 1 : (owner instanceof WebApp ? 2 : (owner instanceof WebFragment ? 3 : 0));
        }
    }

    @Override
    protected void initValidBaseProperties() {
        this.addValidBaseProperty(OWNER);
        this.addValidBaseProperty(REF_NAME);
        this.addValidBaseProperty(DESCRIPTION);
        this.addValidBaseProperty(J2EE_VERSION);
        this.addValidBaseProperty(MODULE_TYPE);
        super.initValidBaseProperties();
    }

    @Override
    protected boolean doSetProperty(String propertyName, Object propertyValue) {
        boolean doSet = super.doSetProperty(propertyName, propertyValue);
        if (OWNER.equals(propertyName)) {
            try {
                this.initializeOwnerNature();
                this.notifyDefaultChange(MODULE_TYPE);
                this.notifyDefaultChange(J2EE_VERSION);
            }
            catch (Exception e) {
                J2eePlugin.logError(e);
            }
        }
        return doSet;
    }

    @Override
    protected Object getDefaultProperty(String propertyName) {
        if (propertyName.equals(MODULE_TYPE)) {
            return this.calculateOwnerModuleType();
        }
        if (propertyName.equals(J2EE_VERSION)) {
            int version = this.calculateJ2EEVersionForOwnerModule();
            return new Integer(version);
        }
        return super.getDefaultProperty(propertyName);
    }

    private Object calculateOwnerModuleType() {
        IProject ownerProject;
        EObject owner = (EObject)this.getProperty(OWNER);
        if (owner != null && (ownerProject = ProjectUtilities.getProject((EObject)owner)) != null) {
            if (owner instanceof ApplicationClient) {
                return "Application-client_ID";
            }
            if (owner instanceof WebApp) {
                return "WebApp_ID";
            }
            if (owner instanceof WebFragment) {
                return "WebFragment_ID";
            }
            return "ejb-jar_ID";
        }
        return null;
    }

    private int calculateJ2EEVersionForOwnerModule() {
        String moduleType = this.getStringProperty(MODULE_TYPE);
        if (moduleType == null) {
            return -1;
        }
        if (moduleType.equals("ejb-jar_ID")) {
            return 30;
        }
        if (moduleType.equals("WebApp_ID")) {
            return 50;
        }
        if (moduleType.equals("Application-client_ID")) {
            return 50;
        }
        if (moduleType.equals("WebFragment_ID")) {
            return 60;
        }
        return -1;
    }

    @Override
    protected IStatus doValidateProperty(String propertyName) {
        if (OWNER.equals(propertyName) && this.getProperty(OWNER) == null) {
            return WTPCommonPlugin.createErrorStatus((String)J2EECreationResourceHandler.ReferenceDataModel_UI_3);
        }
        if (REF_NAME.equals(propertyName)) {
            String nameValue = this.getStringProperty(propertyName);
            if (nameValue == null || nameValue.trim().equals("")) {
                return WTPCommonPlugin.createErrorStatus((String)J2EECreationResourceHandler.ReferenceDataModel_UI_5);
            }
            if (!this.validateReferenceDoesNotExist(nameValue.trim())) {
                return WTPCommonPlugin.createErrorStatus((String)J2EECreationResourceHandler.ReferenceDataModel_UI_6);
            }
        }
        return super.doValidateProperty(propertyName);
    }

    public boolean validateReferenceDoesNotExist(String nameValue) {
        if (this.ownerType == 0) {
            if (this.getProperty(OWNER) instanceof EntityBean) {
                EntityBean eb = (EntityBean)this.getProperty(OWNER);
                if (this.checkResourceRefExists(eb.getResourceRefs(), nameValue)) {
                    return false;
                }
                if (this.checkResourceEnvRefExists(eb.getResourceEnvRefs(), nameValue)) {
                    return false;
                }
                if (this.checkEJBLocalRefExists(eb.getEjbLocalRefs(), nameValue)) {
                    return false;
                }
                if (this.checkEJBRefExists(eb.getEjbRefs(), nameValue)) {
                    return false;
                }
                if (this.checkSecurityRoleRefExists(eb.getSecurityRoleRefs(), nameValue)) {
                    return false;
                }
            }
            if (this.getProperty(OWNER) instanceof MessageDrivenBean) {
                MessageDrivenBean mb = (MessageDrivenBean)this.getProperty(OWNER);
                if (this.checkResourceRefExists(mb.getResourceRefs(), nameValue)) {
                    return false;
                }
                if (this.checkResourceEnvRefExists(mb.getResourceEnvRefs(), nameValue)) {
                    return false;
                }
                if (this.checkEJBLocalRefExists(mb.getEjbLocalRefs(), nameValue)) {
                    return false;
                }
                if (this.checkEJBRefExists(mb.getEjbRefs(), nameValue)) {
                    return false;
                }
            }
            if (this.getProperty(OWNER) instanceof SessionBean) {
                SessionBean sb = (SessionBean)this.getProperty(OWNER);
                if (this.checkResourceRefExists(sb.getResourceRefs(), nameValue)) {
                    return false;
                }
                if (this.checkResourceEnvRefExists(sb.getResourceEnvRefs(), nameValue)) {
                    return false;
                }
                if (this.checkEJBLocalRefExists(sb.getEjbLocalRefs(), nameValue)) {
                    return false;
                }
                if (this.checkEJBRefExists(sb.getEjbRefs(), nameValue)) {
                    return false;
                }
                if (this.checkSecurityRoleRefExists(sb.getSecurityRoleRefs(), nameValue)) {
                    return false;
                }
            }
        }
        return true;
    }

    private boolean checkSecurityRoleRefExists(List list, String refName) {
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                SecurityRoleRef ref = (SecurityRoleRef)list.get(i);
                if (ref.getRoleName() != null && ref.getRoleName().equals(refName)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean checkEJBRefExists(List list, String refName) {
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                EjbRef ref = (EjbRef)list.get(i);
                if (ref.getEjbRefName() != null && ref.getEjbRefName().equals(refName)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean checkEJBLocalRefExists(List list, String refName) {
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                EjbLocalRef ref = (EjbLocalRef)list.get(i);
                if (ref.getEjbRefName() != null && ref.getEjbRefName().equals(refName)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean checkResourceEnvRefExists(List list, String refName) {
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                ResourceEnvRef ref = (ResourceEnvRef)list.get(i);
                if (ref.getResourceEnvRefName() != null && ref.getResourceEnvRefName().equals(refName)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean checkResourceRefExists(List list, String refName) {
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                ResourceRef ref = (ResourceRef)list.get(i);
                if (ref.getResRefName() != null && ref.getResRefName().equals(refName)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

