/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.internal.java.codegen;

import com.ibm.etools.j2ee.internal.java.codegen.IJavaMergeStrategy;
import com.ibm.etools.j2ee.internal.java.codegen.IJavaMerglet;
import com.ibm.etools.j2ee.internal.java.codegen.JavaFieldMerglet;
import com.ibm.etools.j2ee.internal.java.codegen.JavaMemberHistoryDescriptor;
import com.ibm.etools.j2ee.internal.java.codegen.JavaMethodHistoryDescriptor;
import com.ibm.etools.j2ee.internal.java.codegen.JavaMethodMerglet;
import com.ibm.etools.j2ee.internal.java.codegen.JavaTypeMerglet;
import com.ibm.etools.j2ee.internal.java.codegen.MergeException;
import com.ibm.etools.j2ee.internal.java.codegen.MergeResults;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.jdom.IDOMField;
import org.eclipse.jdt.core.jdom.IDOMMember;
import org.eclipse.jdt.core.jdom.IDOMMethod;
import org.eclipse.jdt.core.jdom.IDOMType;

public abstract class JavaMergeStrategy
implements IJavaMergeStrategy {
    private boolean fDefaultPreserveNonCollisionOldMembers = false;
    private boolean fDefaultIncrementalPreserveCollision = false;
    protected static final String DEFAULT_GENERATED_MEMBER_FLAG = "@generated";
    protected static final String DEFAULT_USER_CODE_BEGIN = "// user code begin";
    protected static final String DEFAULT_USER_CODE_BEGIN_TEMPLATE = "// user code begin {%0}";
    protected static final String DEFAULT_USER_CODE_END = "// user code end";

    @Override
    public IJavaMerglet createDefaultFieldMerglet() {
        return new JavaFieldMerglet(this);
    }

    @Override
    public IJavaMerglet createDefaultMethodMerglet() {
        return new JavaMethodMerglet(this);
    }

    @Override
    public IJavaMerglet createDefaultTypeMerglet() {
        return new JavaTypeMerglet(this);
    }

    protected MergeResults createInitialMergeResults(JavaMemberHistoryDescriptor histDesc) {
        MergeResults mr = new MergeResults();
        mr.setDeleteOnly(histDesc.isDeleteOnly());
        mr.setOldMember(histDesc.getOldMember());
        mr.setCollisionMember(histDesc.getCollisionMember());
        return mr;
    }

    @Override
    public String getGeneratedMemberTag() {
        return DEFAULT_GENERATED_MEMBER_FLAG;
    }

    @Override
    public String getUserCodeBegin() {
        return DEFAULT_USER_CODE_BEGIN;
    }

    @Override
    public String getUserCodeBeginTemplate() {
        return DEFAULT_USER_CODE_BEGIN_TEMPLATE;
    }

    @Override
    public String getUserCodeEnd() {
        return DEFAULT_USER_CODE_END;
    }

    @Override
    public boolean isDefaultIncrementalPreserveCollision() {
        return this.fDefaultIncrementalPreserveCollision;
    }

    @Override
    public boolean isDefaultPreserveNonCollisionOldMembers() {
        return this.fDefaultPreserveNonCollisionOldMembers;
    }

    @Override
    public MergeResults merge(JavaMemberHistoryDescriptor histDesc, IDOMField newField) throws MergeException {
        return this.merge(histDesc, (IDOMMember)newField, this.createDefaultFieldMerglet());
    }

    @Override
    public MergeResults merge(JavaMemberHistoryDescriptor histDesc, IDOMMember newMember, IJavaMerglet merglet) throws MergeException {
        MergeResults mr = this.createInitialMergeResults(histDesc);
        if (mr.isDeleteOnly()) {
            this.mergeForDeleteOnly(mr, merglet);
        } else {
            this.mergeForGenerate(mr, newMember, merglet);
        }
        return mr;
    }

    @Override
    public MergeResults merge(JavaMemberHistoryDescriptor histDesc, IDOMType newType) throws MergeException {
        return this.merge(histDesc, (IDOMMember)newType, this.createDefaultTypeMerglet());
    }

    @Override
    public MergeResults merge(JavaMethodHistoryDescriptor histDesc, IDOMMethod newMethod) throws MergeException {
        return this.merge(histDesc, (IDOMMember)newMethod, this.createDefaultMethodMerglet());
    }

    protected void mergeForDeleteOnly(MergeResults mr, IJavaMerglet merglet) throws MergeException {
        if (mr.getOldMember() != null) {
            mr.setGenerate(merglet.validateForDeleteOnly(mr));
        } else {
            mr.setGenerate(false);
        }
    }

    protected void mergeForGenerate(MergeResults mr, IDOMMember newMember, IJavaMerglet merglet) throws MergeException {
        boolean needToGenerate = merglet.validateCollision(mr);
        boolean okayToDeleteOldMember = false;
        if (mr.getOldMember() != null && mr.getOldMember() != mr.getCollisionMember() && !merglet.isPreserveNonCollisionOldMembers()) {
            okayToDeleteOldMember = merglet.validateForDelete(mr);
        }
        if (needToGenerate) {
            needToGenerate = !this.isBatchGeneration() && merglet.isIncrementalPreserveCollision() && mr.getCollisionMember() != null ? false : merglet.merge(mr, newMember);
        }
        if (needToGenerate) {
            if (!okayToDeleteOldMember) {
                mr.setOldMember(null);
            }
        } else if (okayToDeleteOldMember) {
            mr.setDeleteOnly(true);
        } else {
            mr.setGenerate(false);
        }
    }

    @Override
    public void setDefaultIncrementalPreserveCollision(boolean newDefaultIncrementalPreserveCollision) {
        this.fDefaultIncrementalPreserveCollision = newDefaultIncrementalPreserveCollision;
    }

    @Override
    public void setDefaultPreserveNonCollisionOldMembers(boolean newDefaultPreserveNonCollisionOldMembers) {
        this.fDefaultPreserveNonCollisionOldMembers = newDefaultPreserveNonCollisionOldMembers;
    }

    @Override
    public boolean wasGenerated(String source, int endCheckIndex) {
        if (source == null) {
            return true;
        }
        boolean foundGeneratedFlag = false;
        foundGeneratedFlag = endCheckIndex <= 0 ? source.indexOf(this.getGeneratedMemberTag()) >= 0 : source.lastIndexOf(this.getGeneratedMemberTag(), endCheckIndex) >= 0;
        return foundGeneratedFlag;
    }

    @Override
    public boolean wasGenerated(IMember member) throws MergeException {
        if (member == null || !member.exists()) {
            return true;
        }
        boolean foundGeneratedFlag = false;
        try {
            int endCheckIndex = member.getNameRange().getOffset() - member.getSourceRange().getOffset();
            foundGeneratedFlag = this.wasGenerated(member.getSource(), endCheckIndex);
        }
        catch (JavaModelException exc) {
            throw new MergeException((Exception)((Object)exc));
        }
        return foundGeneratedFlag;
    }
}

