/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.annotations.core.utils;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public final class ResourceUtils {
    private static IWorkspaceRoot root_ = null;
    private static IWorkspace workspace_ = null;
    public static String DYNAMIC_WEB = "jst.web";
    public static String EJB = "jst.ejb";
    public static String JCA = "jst.connector";
    public static String ENTERPRISE_APPLICATION = "jst.ear";

    public static IWorkspaceRoot getWorkspaceRoot() {
        if (root_ == null) {
            root_ = ResourcesPlugin.getWorkspace().getRoot();
        }
        return root_;
    }

    public static IWorkspace getWorkspace() {
        if (workspace_ == null) {
            if (root_ == null) {
                root_ = ResourcesPlugin.getWorkspace().getRoot();
            }
            workspace_ = root_.getWorkspace();
        }
        return workspace_;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isJavaComponent(IVirtualComponent comp) {
        IProject project = comp.getProject();
        IJavaModel javaModel = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        try {
            IJavaProject[] projects = javaModel.getJavaProjects();
            int i = 0;
            int length = projects.length;
            while (true) {
                if (i >= length) {
                    return false;
                }
                IJavaProject javaProject = projects[i];
                if (project.equals((Object)javaProject.getProject())) {
                    return true;
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isJavaProject(IProject project) {
        IJavaModel javaModel = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        try {
            IJavaProject[] projects = javaModel.getJavaProjects();
            int i = 0;
            int length = projects.length;
            while (true) {
                if (i >= length) {
                    return false;
                }
                IJavaProject javaProject = projects[i];
                if (project.equals((Object)javaProject.getProject())) {
                    return true;
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }

    public static boolean isTrueJavaProject(IProject project) {
        return ResourceUtils.isJavaProject(project) && !ResourceUtils.isDynamicWebProject(project) && !ResourceUtils.isEJBProject(project) && !ResourceUtils.isJCAProject(project) && !J2EEProjectUtilities.isApplicationClientProject((IProject)project);
    }

    public static boolean isDynamicWebProject(IProject project) {
        return J2EEProjectUtilities.isDynamicWebProject((IProject)project);
    }

    public static boolean isEJBProject(IProject project) {
        return J2EEProjectUtilities.isEJBProject((IProject)project);
    }

    public static boolean isJCAProject(IProject project) {
        return J2EEProjectUtilities.isJCAProject((IProject)project);
    }

    public static boolean isEARProject(IProject project) {
        return J2EEProjectUtilities.isEARProject((IProject)project);
    }

    public static String getJ2EEProjectType(IProject currentProject) {
        return J2EEProjectUtilities.getJ2EEProjectType((IProject)currentProject);
    }
}

