/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.annotations.core.utils;

import com.ibm.etools.annotations.core.utils.AnnotationConstants;

public class AttributeTypeHelper {
    public static String getAnnotationTypeAsString(Object defaultValue, String defaultType) {
        StringBuffer myBuf = new StringBuffer();
        if (defaultValue != null) {
            AnnotationConstants.dump("defType=" + defaultType);
            Class<?> valType = defaultValue.getClass();
            AnnotationConstants.dump("isEnum=" + valType.isEnum());
            AnnotationConstants.dump("isArray=" + valType.isArray());
            AnnotationConstants.dump("isPrimitive=" + valType.isPrimitive());
            AnnotationConstants.dump("simpleName=" + valType.getSimpleName());
            if (defaultType != null && defaultValue != null && defaultType.equals("java.lang.String")) {
                myBuf.append("\"");
                myBuf.append(defaultValue.toString());
                myBuf.append("\"");
            } else if (defaultValue != null && defaultType != null) {
                if (valType.isPrimitive() || valType.isEnum()) {
                    if (valType.isEnum()) {
                        myBuf.append(defaultType);
                        myBuf.append(".");
                        myBuf.append(defaultValue.toString());
                    } else {
                        myBuf.append(defaultValue.toString());
                    }
                } else if (valType.isArray()) {
                    Object result = defaultValue;
                    myBuf.append(AttributeTypeHelper.convertArrayTypeValuesAsString(result));
                    myBuf.append("}");
                } else if (valType.isAnnotation()) {
                    myBuf.append("{");
                    Object result = defaultValue;
                    myBuf.append(AttributeTypeHelper.convertAnnotationTypeValuesAsString(result));
                    myBuf.append("}");
                } else if (valType.isInterface()) {
                    myBuf.append("{");
                    Object result = defaultValue;
                    myBuf.append(AttributeTypeHelper.convertInterfaceTypeValuesAsString(result));
                    myBuf.append("}");
                }
            }
        }
        AnnotationConstants.debug("returned array string=" + myBuf.toString());
        return myBuf.toString();
    }

    public static String convertInterfaceTypeValuesAsString(Object result) {
        return "TODO- handle interface type values";
    }

    public static String convertAnnotationTypeValuesAsString(Object result) {
        return "TODO-handle annotation type values";
    }

    public static String convertArrayTypeValuesAsString(Object result) {
        StringBuffer myBuf = new StringBuffer();
        if (result.getClass().getSimpleName().equals("String[]")) {
            String[] list = (String[])result;
            int k = 0;
            while (k < list.length) {
                myBuf.append("\"");
                myBuf.append(list[k]);
                myBuf.append("\"");
                if (k < list.length - 1) {
                    myBuf.append(",");
                }
                ++k;
            }
        } else if (result.getClass().getSimpleName().equals("boolean[]")) {
            boolean[] list = (boolean[])result;
            int k = 0;
            while (k < list.length) {
                if (list[k]) {
                    myBuf.append("true");
                } else {
                    myBuf.append("false");
                }
                if (k < list.length - 1) {
                    myBuf.append(",");
                }
                ++k;
            }
        } else if (result.getClass().getSimpleName().equals("char[]")) {
            char[] list = (char[])result;
            int k = 0;
            while (k < list.length) {
                myBuf.append("'");
                myBuf.append(list[k]);
                myBuf.append("'");
                if (k < list.length - 1) {
                    myBuf.append(",");
                }
                ++k;
            }
        } else if (result.getClass().getSimpleName().equals("int[]")) {
            int[] list = (int[])result;
            int k = 0;
            while (k < list.length) {
                myBuf.append(list[k]);
                if (k < list.length - 1) {
                    myBuf.append(",");
                }
                ++k;
            }
        } else if (result.getClass().getSimpleName().equals("double[]")) {
            double[] list = (double[])result;
            int k = 0;
            while (k < list.length) {
                myBuf.append(list[k]);
                if (k < list.length - 1) {
                    myBuf.append(",");
                }
                ++k;
            }
        } else {
            AnnotationConstants.debug(result.getClass().getSimpleName());
            Object[] alist = (Object[])result;
            int k = 0;
            while (k < alist.length) {
                AnnotationConstants.debug("defvalue=" + alist[k].toString());
                AnnotationConstants.debug("Name=" + alist[k].getClass().getName());
                AnnotationConstants.debug("SimpleName=" + alist[k].getClass().getSimpleName());
                AnnotationConstants.debug("isAnnotation=" + alist[k].getClass().isAnnotation() + " isEnum=" + alist[k].getClass().isEnum() + " isinterface=" + alist[k].getClass().isInterface());
                myBuf.append(alist[k].getClass().getName());
                myBuf.append(".");
                myBuf.append(alist[k].toString());
                if (k < alist.length - 1) {
                    myBuf.append(",");
                }
                ++k;
            }
        }
        AnnotationConstants.debug(myBuf.toString());
        return myBuf.toString();
    }
}

