/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.annotations.core.utils;

import com.ibm.adapter.j2c.internal.CodegenPlugin;
import com.ibm.etools.annotations.core.AnnotationsCoreConstants;
import com.ibm.etools.annotations.core.data.AnnotatedClassInfo;
import com.ibm.etools.annotations.core.data.AnnotatedProjectInfo;
import com.ibm.etools.annotations.core.data.AnnotatedProjectInfosRepository;
import com.ibm.etools.annotations.core.data.AnnotationInfo;
import com.ibm.etools.annotations.core.data.JavaElementInfo;
import com.ibm.etools.annotations.core.internal.AnnotationConfigImpliedAnnotationInfo;
import com.ibm.etools.annotations.core.internal.AnnotationParser;
import com.ibm.etools.annotations.core.internal.jobs.AnnotationModelUpdateJob;
import com.ibm.etools.annotations.core.internal.messages.AnnotationCoreMessages;
import com.ibm.etools.annotations.core.internal.search.JavaSearchUtils;
import com.ibm.etools.annotations.core.internal.utils.AnnotationAttributePropertyFactory;
import com.ibm.etools.annotations.core.internal.utils.InternalUtils;
import com.ibm.etools.annotations.core.model.IAnnotationAttributeProperty;
import com.ibm.etools.annotations.core.properties.ArrayAnnotationArgumentProperty;
import com.ibm.etools.annotations.core.utils.AnnotationContextHelper;
import com.ibm.propertygroup.IPropertyDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;

public class AnnotationUtils {
    public static boolean isDebug_ = false;
    protected static AnnotationConfigImpliedAnnotationInfo impliedAnnoConfig = new AnnotationConfigImpliedAnnotationInfo();

    public static void debug(Object msg) {
        if (isDebug_) {
            System.out.println(msg);
        }
    }

    public static ArrayList getImpliedAnnotationsFromExtensionPoint(String tagName, IJavaElement je) {
        ArrayList impliedAnnoNameList = impliedAnnoConfig.instance().getImpliedAnnotations(tagName, je);
        return impliedAnnoNameList;
    }

    @Deprecated
    public static AnnotatedClassInfo getAllAnnotationsForCU(ICompilationUnit cu) {
        return AnnotationUtils.getAnnotatedClassInfo((IJavaElement)cu);
    }

    public static AnnotatedClassInfo getAnnotatedClassInfo(IJavaElement cu) {
        AnnotationParser parser = new AnnotationParser();
        AnnotatedClassInfo res = parser.getAnnotatedClassInfo(cu, 0, true);
        return res;
    }

    public static void addAnnotationToCU(ICompilationUnit cu, AnnotationInfo info, IJavaElement el) {
        AnnotationUtils.addAnnotationToCU(cu, info, el, false);
    }

    public static void addAnnotationToCU(ICompilationUnit cu, AnnotationInfo info, IJavaElement el, boolean commit) {
        if (cu == null || info == null || el == null) {
            return;
        }
        InternalUtils.addAnnotationToCU(cu, info.getName(), info.getPackageName(), info.annotToString(), el, commit, false);
    }

    protected ASTNode findNodeFromElement(ASTNode parent, IJavaElement el) {
        if (el instanceof IMethod) {
            MyMethodVisitor vis = new MyMethodVisitor((IMethod)el);
            parent.accept((ASTVisitor)vis);
            MethodDeclaration decl = (MethodDeclaration)vis.getDefinedNode();
            return decl;
        }
        if (el instanceof IField) {
            MyFieldVisitor vis = new MyFieldVisitor((IField)el);
            parent.accept((ASTVisitor)vis);
            return vis.getDefinedNode();
        }
        if (el instanceof IType) {
            MyTypeVisitor vis = new MyTypeVisitor((IType)el);
            parent.accept((ASTVisitor)vis);
            return vis.getDefinedNode();
        }
        MyTypeVisitor vis2 = new MyTypeVisitor(null);
        parent.accept((ASTVisitor)vis2);
        return vis2.getDefinedNode();
    }

    @Deprecated
    public List<AnnotationInfo> parseAllAnnotationsOnClassPath(IJavaProject jProj) {
        return this.parseAllAnnotationsOnClassPath(jProj, null);
    }

    public List<AnnotationInfo> parseAllAnnotationsOnClassPath(IJavaProject jProj, IProgressMonitor monitor) {
        final ArrayList<AnnotationInfo> allAnns = new ArrayList<AnnotationInfo>();
        SearchPattern pattern = SearchPattern.createPattern((String)"java.lang.annotation.Annotation", (int)8, (int)1, (int)8);
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                IType t = (IType)match.getElement();
                IJavaElement ije = t.getParent();
                ((IClassFile)ije).open((IProgressMonitor)new NullProgressMonitor());
                IMethod[] ms = t.getMethods();
                String sPack = t.getPackageFragment().getElementName();
                String name = t.getElementName();
                String[] fullName = AnnotationUtils.resolveFullAnnotationName(name, t);
                if (fullName != null && fullName[1] != null) {
                    name = fullName[1];
                }
                AnnotationInfo anI = new AnnotationInfo(name, 0, null);
                anI.setAllAttributes(AnnotationUtils.getListOfAttributeInfos(ms));
                anI.setDeclaredAttributes(new ArrayList<IAnnotationAttributeProperty>());
                anI.setCategorizationKey(sPack);
                anI.setPackageName(sPack);
                allAnns.add(anI);
            }
        };
        SearchParticipant[] participants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
        try {
            SearchEngine se = new SearchEngine();
            IJavaElement[] els = new IJavaElement[]{jProj};
            se.search(pattern, participants, SearchEngine.createJavaSearchScope((IJavaElement[])els), requestor, monitor);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return allAnns;
    }

    public static String[] resolveFullAnnotationName(String name, IType primType) {
        try {
            String[][] typeNames;
            if (primType != null && name != null && (typeNames = primType.resolveType(name)) != null && typeNames.length > 0 && typeNames[0][0] != null && typeNames[0][1] != null) {
                return typeNames[0];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static List getListOfAttributeInfos(IMethod[] members) {
        ArrayList result = new ArrayList();
        int g = 0;
        while (g < members.length) {
            String typeName = null;
            try {
                typeName = members[g].getReturnType();
                typeName = Signature.toString((String)typeName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++g;
        }
        return result;
    }

    public static AnnotationInfo getResolvedImpliedAnnotations(IJavaProject proj, String tagName, String pkName, IJavaElement je) {
        IType annTypeDef;
        StringBuffer fullName = new StringBuffer(pkName);
        fullName.append(".");
        fullName.append(tagName);
        String fullTagName = fullName.toString();
        if (fullName != null && proj != null && (annTypeDef = InternalUtils.resoveJavaType(fullTagName, proj, true)) != null) {
            try {
                IMethod[] ms = annTypeDef.getMethods();
                String sPack = annTypeDef.getPackageFragment().getElementName();
                AnnotationInfo anI = new AnnotationInfo(annTypeDef.getElementName(), 0, null);
                anI.setReserved(ms);
                anI.setAllAttributes(AnnotationUtils.createListOfAttributeInfos(ms, anI));
                anI.setDeclaredAttributes(new ArrayList<IAnnotationAttributeProperty>());
                anI.setCategorizationKey(sPack);
                anI.setPackageName(pkName);
                return anI;
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
        return null;
    }

    private static List<IAnnotationAttributeProperty> createListOfAttributeInfos(IMethod[] members, AnnotationInfo anI) {
        ArrayList<IAnnotationAttributeProperty> result = new ArrayList<IAnnotationAttributeProperty>();
        int g = 0;
        while (g < members.length) {
            String typeName = null;
            IType defType = null;
            try {
                typeName = members[g].getReturnType();
                defType = members[g].getDeclaringType();
                typeName = Signature.toString((String)typeName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            result.add(AnnotationAttributePropertyFactory.getAnnotationAttributeProperty(anI, members[g], defType, null));
            ++g;
        }
        return result;
    }

    public static String scopeAsString(IJavaElement scope) {
        if (scope == null) {
            return "NULL";
        }
        if (scope.getElementType() == 8) {
            return "FIELD";
        }
        if (scope.getElementType() == 9) {
            return "METHOD";
        }
        if (scope.getElementType() == 7) {
            if (AnnotationContextHelper.isInterface(scope)) {
                return "INTERFACE";
            }
            return "CLASS";
        }
        if (scope.getElementType() == 5) {
            return "CLASS";
        }
        return "NONE";
    }

    public static String turnIMemberValuePairValueToString(IMemberValuePair pair) {
        Object oRes = pair.getValue();
        if (oRes == null) {
            return null;
        }
        if (pair.getValueKind() == 11) {
            if (oRes instanceof String) {
                return (String)oRes;
            }
            return ((Class)oRes).getCanonicalName();
        }
        if (pair.getValueKind() == 9) {
            return (String)oRes;
        }
        if (pair.getValueKind() == 12) {
            if (oRes instanceof String) {
                String sRes = (String)oRes;
                int iInd = sRes.lastIndexOf(".");
                if (iInd > 0) {
                    sRes = sRes.substring(iInd + 1, sRes.length());
                }
                return sRes;
            }
            Enum en = (Enum)oRes;
            return en.toString();
        }
        if (pair.getValueKind() == 13) {
            if (oRes instanceof String) {
                return (String)oRes;
            }
            if (oRes instanceof Enum) {
                Enum en = (Enum)oRes;
                return en.toString();
            }
            return oRes.toString();
        }
        if (pair.getValueKind() == 10) {
            if (oRes instanceof String) {
                return (String)oRes;
            }
            return new StringBuffer("@").append(((IAnnotation)oRes).getElementName()).toString();
        }
        if (pair.getValueKind() == 14) {
            return null;
        }
        return oRes.toString();
    }

    public static String turnDOMBindingToString(Object value) {
        if (value != null) {
            if (value instanceof IVariableBinding) {
                return ((IVariableBinding)value).getName();
            }
            if (value instanceof IAnnotationBinding) {
                return "@" + ((IAnnotationBinding)value).getName();
            }
            if (value instanceof String) {
                return (String)value;
            }
            if (value instanceof ITypeBinding) {
                return ((ITypeBinding)value).getQualifiedName();
            }
            return value.toString();
        }
        return null;
    }

    public static String turnObjectToString(Object oRes, IMemberValuePair pair) {
        if (oRes == null) {
            return null;
        }
        if (pair.getValueKind() == 11) {
            if (oRes instanceof String) {
                return (String)oRes;
            }
            return ((Class)oRes).getCanonicalName();
        }
        if (pair.getValueKind() == 9) {
            return (String)oRes;
        }
        if (pair.getValueKind() == 12) {
            if (oRes instanceof String) {
                return (String)oRes;
            }
            if (oRes instanceof Enum) {
                Enum en = (Enum)oRes;
                return en.toString();
            }
            return oRes.toString();
        }
        if (pair.getValueKind() == 14) {
            return null;
        }
        if (pair.getValueKind() == 10) {
            if (oRes instanceof String) {
                return (String)oRes;
            }
            return new StringBuffer("@").append(((IAnnotation)oRes).getElementName()).toString();
        }
        return oRes.toString();
    }

    public static String turnObjectToString(Object value) {
        if (value != null) {
            Class<?> tB = value.getClass();
            String sTName = tB.getCanonicalName();
            if (sTName.equals("java.lang.String")) {
                return (String)value;
            }
            if (tB.isEnum()) {
                String st = ((Enum)value).name();
                return st;
            }
            if (value instanceof Class) {
                String st0 = sTName;
                return String.valueOf(st0) + ".class";
            }
            if (tB.isPrimitive()) {
                return value.toString();
            }
            value.toString();
        }
        return null;
    }

    public static String turnObjectToString2(Object oRes) {
        if (oRes == null) {
            return null;
        }
        if (oRes instanceof Class) {
            return ((Class)oRes).getCanonicalName();
        }
        if (oRes instanceof String) {
            return (String)oRes;
        }
        if (oRes instanceof IVariableBinding) {
            return ((IVariableBinding)oRes).getName();
        }
        if (oRes instanceof IAnnotationBinding) {
            return ((IAnnotationBinding)oRes).getName();
        }
        return oRes.toString();
    }

    public static String getNameOfParentJavaElement(AnnotationInfo info) {
        String value = null;
        JavaElementInfo jei = info.getParentJavaElementInfo();
        if (jei != null) {
            return jei.getName();
        }
        return value;
    }

    public static String getFullyQaulifiedAnnotationName(AnnotationInfo ai) {
        if (ai == null) {
            return null;
        }
        String tagName = null;
        String packageName = ai.getCategorizationKey();
        if (packageName != null && packageName.length() > 0) {
            StringBuffer tbuf = new StringBuffer(packageName);
            tbuf.append("." + ai.getName());
            tagName = tbuf.toString();
        }
        return tagName;
    }

    public static String getAnnoPackageNameFromLongName(String fullAnnotationName) {
        int index = fullAnnotationName.lastIndexOf(".");
        return fullAnnotationName.substring(0, index);
    }

    public static String getAnnoNameFromLongName(String fullAnnotationName) {
        int index = fullAnnotationName.lastIndexOf(".");
        return fullAnnotationName.substring(index + 1);
    }

    public static String scopeAsStringForView(IJavaElement scope) {
        if (scope == null) {
            return "NULL";
        }
        if (scope.getElementType() == 8) {
            return "FIELD";
        }
        if (scope.getElementType() == 9) {
            return "METHOD";
        }
        if (scope.getElementType() == 7) {
            return "TYPE";
        }
        if (scope.getElementType() == 5) {
            return "TYPE";
        }
        return "NONE";
    }

    @Deprecated
    public static List getAllAnnotationInfosUtilMethod(AnnotatedClassInfo aci) {
        return AnnotationUtils.getAnnotationInfosForJavaElementInfo(aci, false);
    }

    public static List<AnnotationInfo> getAnnotationInfosForJavaElementInfo(AnnotatedClassInfo aci, boolean includeChildrenOnly) {
        if (aci == null) {
            return new ArrayList<AnnotationInfo>(0);
        }
        return aci.getAnnotationInfos(includeChildrenOnly);
    }

    public static List<AnnotationInfo> getAnnotationInfosFromJavaElementInfo(JavaElementInfo jeInf) {
        ArrayList<AnnotationInfo> lst = new ArrayList<AnnotationInfo>();
        IPropertyDescriptor[] descrs = jeInf.getAnnotationInfoPG().getProperties();
        int v = 0;
        while (v < descrs.length) {
            lst.add((AnnotationInfo)descrs[v]);
            ++v;
        }
        IPropertyDescriptor[] childs = jeInf.getJavaElementInfoPG().getProperties();
        int m = 0;
        while (m < childs.length) {
            IPropertyDescriptor prop = childs[m];
            if (prop instanceof JavaElementInfo) {
                lst.addAll(AnnotationUtils.getAnnotationInfosFromJavaElementInfo((JavaElementInfo)prop));
            }
            ++m;
        }
        return lst;
    }

    public static List<JavaElementInfo> getJavaElementInfosForJavaElementInfo(AnnotatedClassInfo aci, boolean includeChildrenOnly) {
        ArrayList<JavaElementInfo> res = new ArrayList<JavaElementInfo>();
        if (aci == null) {
            return res;
        }
        if (!includeChildrenOnly) {
            IPropertyDescriptor[] descrs = aci.getJavaElementInfoPG().getProperties();
            int v = 0;
            while (v < descrs.length) {
                res.add((JavaElementInfo)descrs[v]);
                ++v;
            }
        }
        IPropertyDescriptor[] childs = aci.getJavaElementInfoPG().getProperties();
        int m = 0;
        while (m < childs.length) {
            IPropertyDescriptor prop = childs[m];
            if (prop instanceof JavaElementInfo) {
                res.addAll(AnnotationUtils.getJavaElementsFromJavaElementInfo((JavaElementInfo)prop));
            }
            ++m;
        }
        return res;
    }

    public static List<JavaElementInfo> getJavaElementsFromJavaElementInfo(JavaElementInfo jeInf) {
        ArrayList<JavaElementInfo> lst = new ArrayList<JavaElementInfo>();
        lst.add(jeInf);
        IPropertyDescriptor[] childs = jeInf.getJavaElementInfoPG().getProperties();
        int m = 0;
        while (m < childs.length) {
            IPropertyDescriptor prop = childs[m];
            if (prop instanceof JavaElementInfo) {
                lst.addAll(AnnotationUtils.getJavaElementsFromJavaElementInfo((JavaElementInfo)prop));
            }
            ++m;
        }
        return lst;
    }

    public static String getFullyQualifiedNameForAnnotatedClass(AnnotatedClassInfo clInfo) {
        IJavaElement icu = clInfo.getJavaElementForThisClass();
        return new StringBuffer(icu.getJavaProject().getElementName()).append(".").append(icu.getParent().getElementName()).append(".").append(icu.getElementName()).toString();
    }

    public static String getFullyQualifiedNameForPrimaryType(AnnotatedClassInfo clInfo) {
        IJavaElement icu = clInfo.getJavaElementForThisClass();
        String sNa = icu.getElementName();
        if (sNa.endsWith(".java")) {
            sNa = sNa.substring(0, sNa.length() - 5);
        }
        return new StringBuffer(icu.getParent().getElementName()).append(".").append(sNa).toString();
    }

    public static AnnotatedClassInfo getAnnotatedClassFromAnnotationInfo(AnnotationInfo inf) {
        Object parent;
        JavaElementInfo jei = inf.getParentJavaElementInfo();
        if (jei == null && (parent = inf.getParentElementInfo()) != null && parent instanceof IAnnotationAttributeProperty) {
            jei = AnnotationUtils.getAnnotatedClassFromAnnotationInfo(((IAnnotationAttributeProperty)parent).getParentAnnotation());
        }
        return AnnotationUtils.getAnnotatedClassFromJEI(jei);
    }

    private static AnnotatedClassInfo getAnnotatedClassFromJEI(JavaElementInfo je) {
        if (je == null) {
            return null;
        }
        if (je instanceof AnnotatedClassInfo) {
            return (AnnotatedClassInfo)je;
        }
        return AnnotationUtils.getAnnotatedClassFromJEI(je.getParentJavaElementInfo());
    }

    public static IType findTypeDeclaration(String typeName, IJavaElement el) {
        return JavaSearchUtils.getInstance().findTypeDeclaration(typeName, el, null);
    }

    public static AnnotatedClassInfo getAnnotatedClassInfoForTypeName(AnnotatedProjectInfo api, String fullyQTypeName) {
        AnnotatedClassInfo[] clIs = api.getAnnotatedClassInfos();
        int i = 0;
        while (i < clIs.length) {
            String sFullName;
            AnnotatedClassInfo clI = clIs[i];
            String sName = clI.getJavaElementForThisClass().getElementName();
            if (sName.endsWith(".java")) {
                sName = sName.substring(0, sName.length() - 5);
            }
            String sPackName = "";
            try {
                IJavaElement jEl = clI.getJavaElementForThisClass();
                IPackageDeclaration[] ipd = null;
                if (jEl instanceof ICompilationUnit) {
                    ipd = ((ICompilationUnit)jEl).getPackageDeclarations();
                    if (ipd != null && ipd.length > 0) {
                        sPackName = ipd[0].getElementName();
                    }
                } else if (jEl instanceof IClassFile) {
                    sPackName = ((IClassFile)jEl).getType().getPackageFragment().getElementName();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if ((sFullName = String.valueOf(sPackName) + "." + sName).equals(fullyQTypeName)) {
                return clI;
            }
            ++i;
        }
        return null;
    }

    @Deprecated
    public static AnnotatedClassInfo[] getAnnotatedClassInfoFromJavaElement(IJavaElement je, String[] annotationList) {
        return AnnotationUtils.getAnnotatedClassInfoFromJavaElement(je, annotationList, null);
    }

    public static AnnotatedClassInfo[] getAnnotatedClassInfoFromJavaElement(IJavaElement je, String[] annotationList, IProgressMonitor monitor) {
        List<Object> list = Collections.emptyList();
        int type = je.getElementType();
        if (type == 3 || type == 6 || type == 5 || type == 4) {
            list = JavaSearchUtils.getInstance().findAnnotationDeclarations2(je, annotationList, monitor);
        }
        ArrayList<AnnotatedClassInfo> acis = new ArrayList<AnnotatedClassInfo>();
        for (IJavaElement iJavaElement : list) {
            if (monitor != null && monitor.isCanceled()) {
                for (AnnotatedClassInfo aci : acis) {
                    aci.makeSourceListener(false);
                }
                acis.clear();
                break;
            }
            AnnotatedClassInfo aci2 = AnnotationUtils.getAnnotatedClassInfo(iJavaElement);
            if (aci2 == null || acis.contains((Object)aci2)) continue;
            acis.add(aci2);
            aci2.makeSourceListener();
        }
        return acis.toArray(new AnnotatedClassInfo[acis.size()]);
    }

    @Deprecated
    public static AnnotatedClassInfo[] getAnnotatedClassInfoFromJavaElementForEJBInWeb(IJavaElement je, String[] annotationList) {
        return AnnotationUtils.getAnnotatedClassInfoFromJavaElementForEJBInWeb(je, annotationList, null);
    }

    public static AnnotatedClassInfo[] getAnnotatedClassInfoFromJavaElementForEJBInWeb(IJavaElement je, String[] annotationList, IProgressMonitor monitor) {
        List<Object> list;
        block13: {
            IPackageFragmentRoot[] roots;
            block12: {
                list = Collections.emptyList();
                int type = je.getElementType();
                if (type != 3 && type != 6 && type != 5 && type != 4) break block13;
                IJavaProject jProject = je.getJavaProject();
                roots = null;
                if (jProject == null) break block12;
                try {
                    IClasspathEntry[] entries;
                    IClasspathEntry[] iClasspathEntryArray = entries = jProject.getRawClasspath();
                    int n = entries.length;
                    int n2 = 0;
                    while (n2 < n) {
                        block14: {
                            IClasspathEntry ice;
                            block15: {
                                String sPath;
                                ice = iClasspathEntryArray[n2];
                                if (monitor != null && monitor.isCanceled()) break block12;
                                if (ice.getEntryKind() != 5 || AnnotationsCoreConstants.stopSCanningContainers_ || (sPath = ice.getPath().toOSString()).indexOf("web.container") < 0) break block14;
                                if (AnnotationsCoreConstants.excludedContainers_ == null) break block15;
                                boolean shouldBeIgnored = false;
                                String[] stringArray = AnnotationsCoreConstants.excludedContainers_;
                                int n3 = AnnotationsCoreConstants.excludedContainers_.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    String excludedContainer = stringArray[n4];
                                    if (sPath.indexOf(excludedContainer) != -1) {
                                        shouldBeIgnored = true;
                                        break;
                                    }
                                    ++n4;
                                }
                                if (shouldBeIgnored) break block14;
                            }
                            roots = jProject.findPackageFragmentRoots(ice);
                            break;
                        }
                        ++n2;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (monitor == null || !monitor.isCanceled()) {
                if (roots != null && roots.length > 0) {
                    IJavaElement[] elements = new IJavaElement[roots.length + 1];
                    System.arraycopy(roots, 0, elements, 0, roots.length);
                    elements[roots.length] = je;
                    list = JavaSearchUtils.getInstance().findAnnotationDeclarations2(SearchEngine.createJavaSearchScope((IJavaElement[])elements, (boolean)false), annotationList, monitor);
                } else {
                    list = JavaSearchUtils.getInstance().findAnnotationDeclarations2(je, annotationList, monitor);
                }
            }
        }
        ArrayList<AnnotatedClassInfo> acis = new ArrayList<AnnotatedClassInfo>();
        for (IJavaElement el : list) {
            AnnotatedClassInfo aci2;
            if (monitor != null && monitor.isCanceled()) {
                for (AnnotatedClassInfo aci2 : acis) {
                    aci2.makeSourceListener(false);
                }
                acis.clear();
                break;
            }
            aci2 = AnnotationUtils.getAnnotatedClassInfo(el);
            if (aci2 == null || acis.contains((Object)aci2)) continue;
            acis.add(aci2);
            aci2.makeSourceListener();
        }
        return acis.toArray(new AnnotatedClassInfo[acis.size()]);
    }

    public static Job findAnnotationModelUpdateJob(IJobManager jobManager, IProject project, int projectType) {
        Job[] jobs;
        Job[] jobArray = jobs = jobManager.find(null);
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            Job currJob = jobArray[n2];
            String jobName = currJob.getName();
            AnnotatedProjectInfo api = null;
            if (jobName.startsWith(AnnotationCoreMessages.ANNOTATIONS_CORE_JOB_ANNOTATION_MODEL_UPDATE)) {
                try {
                    api = ((AnnotationModelUpdateJob)currJob).getAnnotatedProjectInfo();
                }
                catch (Exception exception) {}
            }
            if (api != null) {
                if (project == null) {
                    return currJob;
                }
                AnnotatedProjectInfo api1 = AnnotationUtils.getCachedAnnotatedProjectInfo(project, projectType);
                if (api1 != null && api1.getName().equals(api.getName())) {
                    return currJob;
                }
            }
            ++n2;
        }
        return null;
    }

    public static AnnotatedProjectInfo getCachedAnnotatedProjectInfo(IProject project, int projectType) {
        if (projectType == 1) {
            return AnnotatedProjectInfosRepository.getInstance().getCachedAnnotatedProjectInfo(project, "EJB");
        }
        if (projectType == 2) {
            return AnnotatedProjectInfosRepository.getInstance().getCachedAnnotatedProjectInfo(project, "WEB");
        }
        AnnotatedProjectInfo api = AnnotatedProjectInfosRepository.getInstance().getCachedAnnotatedProjectInfo(project, "EJB");
        if (api == null) {
            api = AnnotatedProjectInfosRepository.getInstance().getCachedAnnotatedProjectInfo(project, "WEB");
        }
        return api;
    }

    public static String getFullyQualifiedType(AnnotationInfo aInfo, String value) {
        IType defType = null;
        if (aInfo.getParentJavaElementInfo() == null) {
            if (aInfo.getParentElementInfo() instanceof ArrayAnnotationArgumentProperty) {
                IAnnotationAttributeProperty aap = (IAnnotationAttributeProperty)aInfo.getParentElementInfo();
                JavaElementInfo annoParentJavaEI = aap.getParentAnnotation().getParentJavaElementInfo();
                if (annoParentJavaEI != null) {
                    defType = AnnotationUtils.findTypeDeclaration(value, annoParentJavaEI.getJavaElement());
                } else {
                    CodegenPlugin.logError("AnnotationUtils.getFullyQualifiedType(): annoParentJavaEI is null");
                }
            } else {
                CodegenPlugin.logError("AnnotationUtils.getFullyQualifiedType(): aInfo.getParentJavaElementInfo() is null");
            }
        } else {
            defType = AnnotationUtils.findTypeDeclaration(value, aInfo.getParentJavaElementInfo().getJavaElement());
        }
        if (defType != null) {
            value = defType.getFullyQualifiedName();
            return value;
        }
        return value;
    }

    private class MyFieldVisitor
    extends ASTVisitor {
        IField definedElement;
        ASTNode foundNode = null;

        public MyFieldVisitor(IField element) {
            this.definedElement = element;
        }

        public boolean visit(FieldDeclaration node) {
            String sTypeSig = null;
            try {
                sTypeSig = this.definedElement.getTypeSignature();
            }
            catch (Exception exception) {}
            String sTypeName = Signature.getSignatureSimpleName((String)sTypeSig);
            String sNodeType = InternalUtils.getTypeName(node.getType());
            if (sTypeSig != null && sNodeType != null && sNodeType.equals(sTypeName)) {
                String sElName = this.definedElement.getElementName();
                List lst = node.fragments();
                int k = 0;
                while (k < lst.size()) {
                    VariableDeclarationFragment frag = (VariableDeclarationFragment)lst.get(k);
                    String fName = frag.getName().toString();
                    if (fName.equals(sElName)) {
                        this.foundNode = node;
                        break;
                    }
                    ++k;
                }
            }
            return true;
        }

        public ASTNode getDefinedNode() {
            return this.foundNode;
        }
    }

    private class MyMethodVisitor
    extends ASTVisitor {
        IMethod definedElement;
        ASTNode foundNode = null;

        public MyMethodVisitor(IMethod element) {
            this.definedElement = element;
        }

        public boolean visit(MethodDeclaration node) {
            block8: {
                Type retT;
                String sPack;
                String sRetType;
                block9: {
                    try {
                        String name = this.definedElement.getElementName();
                        if (!name.equals(node.getName().toString())) break block8;
                        this.definedElement.getReturnType();
                        String[] params = this.definedElement.getParameterNames();
                        String sRetTypeRaw = this.definedElement.getReturnType();
                        sRetType = Signature.getSignatureSimpleName((String)sRetTypeRaw);
                        sPack = Signature.getSignatureQualifier((String)sRetTypeRaw);
                        List lParams = node.parameters();
                        if (params.length != lParams.size()) break block8;
                        Hashtable<String, String> temp = new Hashtable<String, String>();
                        boolean b = true;
                        int w = 0;
                        while (w < params.length) {
                            temp.put(params[w], params[w]);
                            ++w;
                        }
                        w = 0;
                        while (w < lParams.size()) {
                            SingleVariableDeclaration svd = (SingleVariableDeclaration)lParams.get(w);
                            String sNa = svd.getName().toString();
                            Object val = temp.get(sNa);
                            if (val == null) {
                                b = false;
                            }
                            ++w;
                        }
                        if (!b || sRetType == null) break block8;
                        retT = node.getReturnType2();
                        if (retT != null) break block9;
                        if (sRetType.equals("void")) {
                            this.foundNode = node;
                            break block8;
                        }
                        return true;
                    }
                    catch (Exception exception) {}
                }
                String sTypeName = InternalUtils.getTypeName(retT);
                if (sRetType != null && sTypeName != null && (sRetType.equals(sTypeName) || (String.valueOf(sPack) + "." + sRetType).equals(sTypeName))) {
                    this.foundNode = node;
                }
            }
            return true;
        }

        public ASTNode getDefinedNode() {
            return this.foundNode;
        }
    }

    private class MyTypeVisitor
    extends ASTVisitor {
        IType definedElement;
        ASTNode foundNode = null;

        public MyTypeVisitor(IType element) {
            this.definedElement = element;
        }

        public boolean visit(TypeDeclaration node) {
            return this.myVisit((AbstractTypeDeclaration)node);
        }

        public boolean visit(EnumDeclaration node) {
            return this.myVisit((AbstractTypeDeclaration)node);
        }

        public boolean visit(AnnotationTypeDeclaration node) {
            return this.myVisit((AbstractTypeDeclaration)node);
        }

        private boolean myVisit(AbstractTypeDeclaration node) {
            String sNodeName = node.getName().toString();
            if (this.definedElement == null) {
                this.foundNode = node;
                return false;
            }
            String sElName = this.definedElement.getElementName();
            if (sNodeName.equals(sElName)) {
                this.foundNode = node;
            }
            return true;
        }

        public ASTNode getDefinedNode() {
            return this.foundNode;
        }
    }
}

