/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.annotations.core.utils;

import com.ibm.etools.annotations.core.data.AnnotationInfo;
import com.ibm.etools.annotations.core.internal.utils.InternalUtils;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;

public class AnnotationContextHelper {
    public static boolean isInterface(IAnnotatable elm) {
        try {
            if (elm instanceof IType) {
                return ((IType)elm).isInterface();
            }
            return false;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return false;
        }
    }

    public static boolean isInterface(IJavaElement elm) {
        try {
            if (elm instanceof IType) {
                return ((IType)elm).isInterface();
            }
            return false;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return false;
        }
    }

    public static ICompilationUnit getCUFromAnnotation(AnnotationInfo ai) {
        IAnnotation an;
        IType type;
        IAnnotation o1 = ai.getAnnotation();
        if (o1 instanceof IAnnotation && (type = InternalUtils.getPrimaryType((an = o1).getParent())) != null) {
            return type.getCompilationUnit();
        }
        return null;
    }

    public static ICompilationUnit getCUFromAnnotation(IAnnotatable ai) {
        IType type;
        if (ai instanceof IJavaElement && (type = InternalUtils.getPrimaryType((IJavaElement)ai)) != null) {
            return type.getCompilationUnit();
        }
        return null;
    }

    public static String processType(IAnnotatable jcontext) {
        if (jcontext instanceof IJavaElement && jcontext != null) {
            return ((IJavaElement)jcontext).getElementName();
        }
        return AnnotationContextHelper.getClassType(jcontext);
    }

    public static String getClassType(IAnnotatable jcontext) {
        if (jcontext == null) {
            return null;
        }
        ICompilationUnit cu = AnnotationContextHelper.getCUFromAnnotation(jcontext);
        try {
            IType[] typeList = cu.getAllTypes();
            if (typeList != null && typeList.length > 0) {
                int i = 0;
                while (i < typeList.length) {
                    IType type = typeList[i];
                    IJavaElement elem = type.getPrimaryElement();
                    if (elem != null && jcontext != null && elem.getElementType() == 7) {
                        return elem.getElementName();
                    }
                    ++i;
                }
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        return null;
    }
}

