/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.annotations.core.properties;

import com.ibm.etools.annotations.core.data.AnnotationInfo;
import com.ibm.etools.annotations.core.internal.AnnotationConfigAttributesInfo;
import com.ibm.etools.annotations.core.internal.utils.InternalUtils;
import com.ibm.etools.annotations.core.model.IAnnotationAttributeProperty;
import com.ibm.etools.annotations.core.properties.AnnotationPropertyType;
import com.ibm.etools.annotations.core.utils.AnnotationUtils;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import com.ibm.propertygroup.spi.BaseSingleValuedProperty;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;

public class SingleValueArgumentProperty
extends BaseSingleValuedProperty
implements IAnnotationAttributeProperty {
    private boolean isString = false;
    private boolean isClass = false;
    private boolean isDeclared = false;
    private boolean isEnum = false;
    private boolean isAnnotation = false;
    private Object originalValueObject;
    private String sTypeName = "";
    private String enumTypeName = "";
    private AnnotationInfo parent;
    private Object impliedValue = null;

    public SingleValueArgumentProperty(String propertyName, String displayName, String propertyDescription, Class type, BasePropertyGroup parentGroup, AnnotationInfo parentAnno, IMemberValuePair pair) throws CoreException {
        super(propertyName, displayName, propertyDescription, type, parentGroup);
        this.parent = parentAnno;
        this.setImpliedValue(this.getImpliedValueFromExtension());
        this.propertyType = new AnnotationPropertyType(this, type);
        if (pair != null) {
            if (pair.getValueKind() == 9) {
                this.isString = true;
            } else if (pair.getValueKind() == 12) {
                this.isEnum = true;
            } else if (pair.getValueKind() == 10) {
                this.isAnnotation = true;
            } else if (pair.getValueKind() == 11) {
                try {
                    this.assignID("com.ibm.etools.annotations.ui.javaClassProperty");
                    this.isClass = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public SingleValueArgumentProperty(String propertyName, String displayName, String propertyDescription, Class type, BasePropertyGroup parentGroup, AnnotationInfo parentAnno, IType resolvedType) throws CoreException {
        super(propertyName, displayName, propertyDescription, type, parentGroup);
        this.parent = parentAnno;
        this.setImpliedValue(this.getImpliedValueFromExtension());
        this.propertyType = new AnnotationPropertyType(this, type);
        if (resolvedType != null) {
            String typeName = resolvedType.getElementName();
            if (resolvedType.isEnum()) {
                String elName;
                this.isEnum = true;
                IField[] fields = resolvedType.getFields();
                this.enumTypeName = resolvedType.getElementName();
                String stQ = resolvedType.getTypeQualifiedName();
                if (stQ.indexOf("$") > 0 && (elName = stQ.replace('$', '.')) != null && elName.length() > 0) {
                    this.enumTypeName = elName;
                }
                ArrayList<String> validValues = new ArrayList<String>();
                IField[] iFieldArray = fields;
                int n = fields.length;
                int n2 = 0;
                while (n2 < n) {
                    IField f = iFieldArray[n2];
                    if (f.isEnumConstant()) {
                        validValues.add(f.getElementName());
                    }
                    ++n2;
                }
                Object[] defVals = new String[validValues.size()];
                validValues.toArray(defVals);
                try {
                    this.setValidValues(defVals);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (resolvedType.isAnnotation()) {
                this.isAnnotation = true;
            } else if (typeName.equals("java.lang.Class") || typeName.equals("Class")) {
                try {
                    this.assignID("com.ibm.etools.annotations.ui.javaClassProperty");
                    this.isClass = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (typeName.equals("java.lang.String") || typeName.equals("String")) {
                this.isString = true;
            }
        }
    }

    public SingleValueArgumentProperty(String propertyName, String displayName, String propertyDescription, Class type, BasePropertyGroup parentGroup, AnnotationInfo parentAnno, Object pairValue) throws CoreException {
        super(propertyName, displayName, propertyDescription, type, parentGroup);
        this.parent = parentAnno;
        this.setImpliedValue(this.getImpliedValueFromExtension());
        this.propertyType = new AnnotationPropertyType(this, type);
        if (pairValue != null) {
            if (pairValue instanceof IVariableBinding) {
                this.isEnum = true;
            } else if (pairValue instanceof IAnnotationBinding) {
                this.isAnnotation = true;
            } else if (pairValue instanceof String) {
                this.isString = true;
            } else if (pairValue instanceof ITypeBinding) {
                this.assignID("com.ibm.etools.annotations.ui.javaClassProperty");
                this.isClass = true;
            }
        }
    }

    public Object getImpliedValueFromExtension() {
        String tagName = AnnotationUtils.getFullyQaulifiedAnnotationName(this.parent);
        if (tagName != null && tagName.length() > 0) {
            IAnnotation iAn = this.parent.getAnnotation();
            IJavaElement je = null;
            if (iAn != null) {
                je = iAn.getParent();
            }
            AnnotationConfigAttributesInfo annoConfig = new AnnotationConfigAttributesInfo();
            if (je == null && (je = this.parent.getJavaElem()) == null && this.parent.getParentJavaElementInfo() != null) {
                je = this.parent.getParentJavaElementInfo().getJavaElement();
            }
            Object impliedValue = null;
            if (je != null && je instanceof IAnnotatable) {
                impliedValue = annoConfig.instance().getImpliedAttributeValue(tagName, this.getDisplayName(), (IAnnotatable)je);
            }
            return impliedValue;
        }
        return null;
    }

    @Override
    public boolean isDeclared() {
        return this.isDeclared;
    }

    @Override
    public void setDeclared(boolean b) {
        this.isDeclared = b;
    }

    @Override
    public String toCUString() {
        String res = this.getValueAsString();
        if (res == null) {
            if (this.isString) {
                return "\"\"";
            }
            return "";
        }
        if (this.isString) {
            return "\"" + InternalUtils.escapeCharacters(res) + "\"";
        }
        if (this.isEnum) {
            int indx = res.indexOf(".");
            if (indx < 0) {
                res = String.valueOf(this.enumTypeName) + "." + res;
            }
            return res;
        }
        if (this.isClass) {
            if (!res.trim().endsWith(".class")) {
                res = String.valueOf(res) + ".class";
            }
            return res;
        }
        return res;
    }

    @Override
    public String getTypeName() {
        return this.sTypeName;
    }

    public boolean isAnnotation() {
        return this.isAnnotation;
    }

    public Object getOriginalValueObject() {
        return this.originalValueObject;
    }

    public void setOriginalValueObject(Object orValue) {
        this.originalValueObject = orValue;
    }

    @Override
    public AnnotationInfo getParentAnnotation() {
        return this.parent;
    }

    public void setImpliedValue(Object value) {
        this.impliedValue = value;
    }

    @Override
    public Object getImpliedValue() {
        return this.impliedValue;
    }

    @Override
    public Object getDefaultValue(boolean isDefault) {
        if (!isDefault) {
            return this.getImpliedValue();
        }
        return this.getPropertyType().getDefaultValue();
    }

    public boolean isClass() {
        return this.isClass;
    }

    public void setValueAsString(String newValue) throws CoreException {
        if (this.isEnabled() && this.isClass && newValue != null && !newValue.isEmpty()) {
            newValue = newValue.trim();
            if ((newValue = InternalUtils.trimDot(newValue)).isEmpty()) {
                newValue = null;
            }
        }
        super.setValueAsString(newValue);
    }
}

