/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.annotations.core.properties;

import com.ibm.etools.annotations.core.data.AnnotationInfo;
import com.ibm.etools.annotations.core.internal.AnnotationConfigAttributesInfo;
import com.ibm.etools.annotations.core.internal.utils.InternalUtils;
import com.ibm.etools.annotations.core.model.IAnnotationAttributeProperty;
import com.ibm.etools.annotations.core.properties.AnnotationPropertyType;
import com.ibm.etools.annotations.core.utils.AnnotationUtils;
import com.ibm.propertygroup.spi.BaseMultiValuedProperty;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IType;

public class ArrayArgumentProperty
extends BaseMultiValuedProperty
implements IAnnotationAttributeProperty {
    private boolean isString = false;
    private boolean isAnnotation = false;
    private boolean isClass = false;
    private Object[] originalValues;
    private boolean isDeclared = false;
    private String componentTypeName = "";
    private AnnotationInfo annotationInfo_;
    private Object impliedValue = null;

    public ArrayArgumentProperty(String propertyName, String displayName, String propertyDescription, Class cl, BasePropertyGroup parentGroup, AnnotationInfo parentAnno, IMemberValuePair pair) throws CoreException {
        super(propertyName, displayName, propertyDescription, cl, parentGroup);
        this.annotationInfo_ = parentAnno;
        this.setImpliedValue(this.getImpliedValueFromExtension());
        this.propertyType = new AnnotationPropertyType(this, cl);
        if (pair != null) {
            if (pair.getValueKind() == 9) {
                this.isString = true;
            } else if (pair.getValueKind() == 10) {
                this.isAnnotation = true;
            } else if (pair.getValueKind() == 11) {
                try {
                    this.assignID("com.ibm.etools.annotations.ui.javaClassProperty2");
                    this.isClass = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public ArrayArgumentProperty(String propertyName, String displayName, String propertyDescription, Class type, BasePropertyGroup parentGroup, AnnotationInfo parentAnno, IType resolvedType) throws CoreException {
        super(propertyName, displayName, propertyDescription, type, parentGroup);
        this.annotationInfo_ = parentAnno;
        this.setImpliedValue(this.getImpliedValueFromExtension());
        this.propertyType = new AnnotationPropertyType(this, type);
        if (resolvedType != null) {
            String typeName = resolvedType.getElementName();
            if (resolvedType.isAnnotation()) {
                this.isAnnotation = true;
            } else if (typeName.equals("java.lang.Class") || typeName.equals("Class")) {
                try {
                    this.assignID("com.ibm.etools.annotations.ui.javaClassProperty2");
                    this.isClass = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (typeName.equals("java.lang.String") || typeName.equals("String")) {
                this.isString = true;
            }
        }
    }

    public void dumpValue(Object impliedValue) {
        if (impliedValue != null) {
            boolean cfr_ignored_0 = impliedValue instanceof String[];
        }
    }

    public Object getImpliedValueFromExtension() {
        String tagName = AnnotationUtils.getFullyQaulifiedAnnotationName(this.annotationInfo_);
        if (tagName != null && tagName.length() > 0) {
            AnnotationConfigAttributesInfo annoConfig = new AnnotationConfigAttributesInfo();
            IJavaElement je = null;
            try {
                if (this.annotationInfo_ != null) {
                    IAnnotation iAn = this.annotationInfo_.getAnnotation();
                    if (iAn != null) {
                        je = iAn.getParent();
                    }
                    if (je == null && (je = this.annotationInfo_.getJavaElem()) == null && this.annotationInfo_.getParentJavaElementInfo() != null) {
                        je = this.annotationInfo_.getParentJavaElementInfo().getJavaElement();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (je == null) {
                return null;
            }
            Object impliedValue = null;
            if (je instanceof IAnnotatable) {
                impliedValue = annoConfig.instance().getImpliedAttributeValue(tagName, this.getDisplayName(), (IAnnotatable)je);
            } else {
                boolean cfr_ignored_0 = je instanceof IAnnotation;
            }
            return impliedValue;
        }
        return null;
    }

    @Override
    public String toCUString() {
        String[] vals = this.getValuesAsStrings();
        if (vals == null) {
            if (this.isString) {
                return "{\"\"}";
            }
            return "";
        }
        StringBuffer res = new StringBuffer("{");
        int j = 0;
        while (j < vals.length) {
            if (this.isString) {
                res.append("\"");
                vals[j] = InternalUtils.escapeCharacters(vals[j]);
            }
            res.append(vals[j]);
            if (this.isClass && !vals[j].trim().endsWith(".class")) {
                res.append(".class");
            }
            if (this.isString) {
                res.append("\"");
            }
            if (j != vals.length - 1) {
                res.append(", ");
            }
            ++j;
        }
        res.append("}");
        return res.toString();
    }

    @Override
    public boolean isDeclared() {
        return this.isDeclared;
    }

    @Override
    public void setDeclared(boolean b) {
        this.isDeclared = b;
    }

    public void setValues(Object[] objs, Class tB) {
        this.componentTypeName = tB.getCanonicalName();
        if (tB.getComponentType().isAnnotation()) {
            this.isAnnotation = true;
            return;
        }
        if (tB.getComponentType().getCanonicalName().equals("java.lang.String")) {
            this.isString = true;
        } else if (tB.getComponentType().getCanonicalName().equals("java.lang.Class")) {
            try {
                this.assignID("com.ibm.etools.annotations.ui.javaClassProperty2");
                this.isClass = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (objs != null) {
            int i = 0;
            while (i < objs.length) {
                Object o = objs[i];
                String sValue = AnnotationUtils.turnObjectToString(o);
                try {
                    if (sValue != null) {
                        this.addValueAsString(sValue);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
    }

    @Override
    public String getTypeName() {
        return String.valueOf(this.componentTypeName) + "[]";
    }

    public Object[] getOriginalValues() {
        return this.originalValues;
    }

    public void setOriginalValues(Object[] obs) {
        this.originalValues = obs;
    }

    public boolean isAnnotation() {
        return this.isAnnotation;
    }

    @Override
    public AnnotationInfo getParentAnnotation() {
        return this.annotationInfo_;
    }

    @Override
    public Object getImpliedValue() {
        return this.impliedValue;
    }

    public void setImpliedValue(Object value) {
        this.impliedValue = value;
    }

    @Override
    public Object getDefaultValue(boolean isDefault) {
        try {
            AnnotationUtils.debug("ArrayArgumentProperty.getDefaultValue() :" + this.parent.getName() + "attr name=" + super.getDisplayName() + " getDefaultValue:" + isDefault);
        }
        catch (Exception exception) {}
        if (!isDefault) {
            return this.getImpliedValue();
        }
        return this.getPropertyType().getDefaultValue();
    }
}

