/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.annotations.core.properties;

import com.ibm.etools.annotations.core.data.AnnotationInfo;
import com.ibm.etools.annotations.core.data.JavaElementInfo;
import com.ibm.etools.annotations.core.internal.utils.InternalUtils;
import com.ibm.etools.annotations.core.properties.ArrayArgumentProperty;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IType;

public class ArrayAnnotationArgumentProperty
extends ArrayArgumentProperty {
    public static final String id_ = "com.ibm.etools.annotations.core.properties.ArrayAnnotationArgumentProperty";

    public ArrayAnnotationArgumentProperty(String propertyName, String displayName, String propertyDescription, BasePropertyGroup parentGroup, AnnotationInfo parentAnno, IMemberValuePair pair) throws CoreException {
        super(propertyName, displayName, propertyDescription, AnnotationInfo.class, parentGroup, parentAnno, pair);
        this.assignID(id_);
    }

    public ArrayAnnotationArgumentProperty(String propertyName, String displayName, String propertyDescription, BasePropertyGroup parentGroup, AnnotationInfo parentAnno, IType resolvedType) throws CoreException {
        super(propertyName, displayName, propertyDescription, AnnotationInfo.class, parentGroup, parentAnno, resolvedType);
        this.assignID(id_);
    }

    public String[] getValuesAsStrings() {
        Object[] currentValues = this.getValues();
        String[] stringValues = new String[currentValues.length];
        int i = currentValues.length;
        while (--i >= 0) {
            if (currentValues[i] == null) continue;
            stringValues[i] = new StringBuffer("@").append(((AnnotationInfo)((Object)currentValues[i])).getName()).toString();
        }
        return stringValues;
    }

    public void addValueAsString(String value) throws CoreException {
        this.addValueAsString(value, this.values.size());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addValueAsString(String value, int index) throws CoreException, IndexOutOfBoundsException {
        if (this.isEnabled() && value != null) {
            try {
                String newValue = value.trim();
                if (value.startsWith("@")) {
                    newValue = value.substring(1);
                }
                JavaElementInfo jeInfo = InternalUtils.getParentJavaElementInfo4Attribute(this);
                IJavaElement je = null;
                if (jeInfo != null) {
                    je = jeInfo.getJavaElement();
                }
                if (je == null) return;
                IType type = InternalUtils.resoveJavaType(newValue, je.getJavaProject(), true);
                IAnnotation anno = type != null ? type.getAnnotation(newValue) : null;
                AnnotationInfo annoInfo = null;
                annoInfo = anno != null ? InternalUtils.createNestedAnnotationInfo(anno, this) : InternalUtils.createNestedAnnotationInfo(newValue, this);
                if (annoInfo == null) return;
                this.addValue((Object)annoInfo, index);
                return;
            }
            catch (Throwable e) {
                Status status = new Status(4, "com.ibm.adapter.j2c.codegen", 4, e.getLocalizedMessage() == null ? "" : e.getLocalizedMessage(), e);
                throw new CoreException((IStatus)status);
            }
        } else {
            super.addValueAsString(value, index);
        }
    }

    public void addValue(Object value, int index) throws CoreException, IndexOutOfBoundsException {
        super.addValue(value, index);
        if (value != null) {
            ((AnnotationInfo)((Object)value)).setParentElementInfo(this);
        }
    }

    public Object removeValue(int index) {
        AnnotationInfo annoInfo = (AnnotationInfo)((Object)super.removeValue(index));
        if (annoInfo != null) {
            annoInfo.setParentElementInfo(null);
        }
        return annoInfo;
    }

    public boolean removeValue(Object value) {
        boolean retValue = super.removeValue(value);
        if (retValue) {
            ((AnnotationInfo)((Object)value)).setParentElementInfo(null);
        }
        return retValue;
    }

    @Override
    public String toCUString() {
        if (!this.values.isEmpty()) {
            StringBuffer newString = new StringBuffer("{");
            Iterator iter = this.values.iterator();
            while (iter.hasNext()) {
                AnnotationInfo annoInfo = (AnnotationInfo)((Object)iter.next());
                newString.append(annoInfo.annotToString());
                if (!iter.hasNext()) continue;
                newString.append(", ");
            }
            newString.append("}");
            return newString.toString();
        }
        return super.toCUString();
    }
}

