/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.annotations.core.internal.search;

import com.ibm.etools.annotations.core.internal.utils.InternalUtils;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.core.search.TypeReferenceMatch;

public class SearchAllAnnotatedClassesForAnnotationsRequestor
extends SearchRequestor {
    private ArrayList<IJavaElement> resList_ = new ArrayList();
    private String[] lookingAnnotations_;
    private int lastElementHashCode_;

    protected SearchAllAnnotatedClassesForAnnotationsRequestor(String[] fqNames) {
        this.lookingAnnotations_ = fqNames;
    }

    public void acceptSearchMatch(SearchMatch match) throws CoreException {
        IJavaElement resEl;
        TypeReferenceMatch refM = (TypeReferenceMatch)match;
        IJavaElement localEl = refM.getLocalElement();
        if (localEl == null) {
            localEl = (IJavaElement)refM.getElement();
        }
        if (localEl != null && (resEl = InternalUtils.getCUorClassFile(localEl)) != null && resEl.hashCode() != this.lastElementHashCode_) {
            this.lastElementHashCode_ = resEl.hashCode();
            if (this.lookingAnnotations_ != null && this.lookingAnnotations_.length > 0 && !this.checkAnnotationForClass(resEl)) {
                return;
            }
            if (!this.resList_.contains(resEl)) {
                this.resList_.add(resEl);
            }
        }
    }

    public ArrayList<IJavaElement> getResults() {
        return this.resList_;
    }

    protected boolean checkAnnotationForClass(IJavaElement je) {
        try {
            IJavaElement[] childs = null;
            if (je instanceof ICompilationUnit) {
                childs = ((ICompilationUnit)je).getChildren();
            } else if (je instanceof IClassFile) {
                childs = ((IClassFile)je).getChildren();
            }
            if (childs != null) {
                return this.checkAnnotationForJE(childs);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    protected ArrayList<String> getAllAnnotationsFromClass(IJavaElement[] jes) {
        ArrayList<String> annoList = new ArrayList<String>();
        try {
            IJavaElement[] iJavaElementArray = jes;
            int n = jes.length;
            int n2 = 0;
            while (n2 < n) {
                IAnnotation[] annotations;
                IJavaElement je = iJavaElementArray[n2];
                if (je instanceof IAnnotatable && (annotations = ((IAnnotatable)je).getAnnotations()) != null && annotations.length > 0) {
                    IAnnotation[] iAnnotationArray = annotations;
                    int n3 = annotations.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IAnnotation annotation = iAnnotationArray[n4];
                        String elementName = annotation.getElementName();
                        if (!annoList.contains(elementName)) {
                            annoList.add(elementName);
                        }
                        ++n4;
                    }
                }
                if (je instanceof IMember) {
                    annoList.addAll(this.getAllAnnotationsFromClass(((IMember)je).getChildren()));
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return annoList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean checkAnnotationForJE(IJavaElement[] jes) {
        try {
            IJavaElement[] iJavaElementArray = jes;
            int n = jes.length;
            int n2 = 0;
            while (n2 < n) {
                boolean status;
                IAnnotation[] annotations;
                IJavaElement je = iJavaElementArray[n2];
                if (je instanceof IAnnotatable && (annotations = ((IAnnotatable)je).getAnnotations()) != null && annotations.length > 0) {
                    IAnnotation[] iAnnotationArray = annotations;
                    int n3 = annotations.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IAnnotation annotation = iAnnotationArray[n4];
                        String elementName = annotation.getElementName();
                        String[] stringArray = this.lookingAnnotations_;
                        int n5 = this.lookingAnnotations_.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            String annotationName = stringArray[n6];
                            if (annotationName.endsWith(elementName)) {
                                return true;
                            }
                            ++n6;
                        }
                        ++n4;
                    }
                }
                if (je instanceof IMember && (status = this.checkAnnotationForJE(((IMember)je).getChildren()))) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }
}

