/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.annotations.core.internal.search;

import com.ibm.etools.annotations.core.data.AnnotatedClassInfo;
import com.ibm.etools.annotations.core.data.AnnotatedProjectInfo;
import com.ibm.etools.annotations.core.internal.search.JavaSearchUtils;
import com.ibm.etools.annotations.core.utils.AnnotationUtils;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;

public class InitializationUtils {
    public static void initializeAnnotatedProjectInfo(AnnotatedProjectInfo inf, IJavaProject ijp) {
        InitializationUtils.initializeAnnotatedProjectInfoForAnnotations(inf, ijp, null, false, null);
    }

    @Deprecated
    public static void initializeAnnotatedProjectInfoForAnnotations(AnnotatedProjectInfo inf, IJavaProject ijp, String[] annotationNames) {
        InitializationUtils.initializeAnnotatedProjectInfoForAnnotations(inf, ijp, annotationNames, false, null);
    }

    public static void initializeAnnotatedProjectInfoForAnnotations(AnnotatedProjectInfo inf, IJavaProject ijp, String[] annotationNames, IProgressMonitor monitor) {
        InitializationUtils.initializeAnnotatedProjectInfoForAnnotations(inf, ijp, annotationNames, false, monitor);
    }

    @Deprecated
    public static void initializeAnnotatedProjectInfoForAnnotations(AnnotatedProjectInfo inf, IJavaProject ijp, String[] annotationNames, boolean removeContent) {
        InitializationUtils.initializeAnnotatedProjectInfoForAnnotations(inf, ijp, annotationNames, removeContent, null);
    }

    public static void initializeAnnotatedProjectInfoForAnnotations(AnnotatedProjectInfo inf, IJavaProject ijp, String[] annotationNames, boolean removeContent, IProgressMonitor monitor) {
        List<IJavaElement> lstt = JavaSearchUtils.getInstance().findAnnotationDeclarations2(ijp, annotationNames, monitor);
        if (removeContent) {
            inf.removeAllAnnotatedClassInfo(monitor);
        }
        for (IJavaElement ell : lstt) {
            if (monitor != null && monitor.isCanceled()) break;
            AnnotatedClassInfo aci = AnnotationUtils.getAnnotatedClassInfo(ell);
            if (aci == null) continue;
            inf.addAnnotatedClassInfo(aci);
            if (annotationNames == null || annotationNames.length <= 0) continue;
            aci.makeSourceListener();
        }
    }

    protected static boolean checkAnnotationForClass(IJavaElement je, String[] annotationNames) {
        try {
            IJavaElement[] childs = null;
            if (je instanceof ICompilationUnit) {
                childs = ((ICompilationUnit)je).getChildren();
            } else if (je instanceof IClassFile) {
                childs = ((IClassFile)je).getChildren();
            }
            if (childs != null) {
                return InitializationUtils.checkAnnotationForJE(childs, annotationNames);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static boolean checkAnnotationForJE(IJavaElement[] jes, String[] annotationNames) {
        try {
            IJavaElement[] iJavaElementArray = jes;
            int n = jes.length;
            int n2 = 0;
            while (n2 < n) {
                boolean status;
                IAnnotation[] annotations;
                IJavaElement je = iJavaElementArray[n2];
                if (je instanceof IAnnotatable && (annotations = ((IAnnotatable)je).getAnnotations()) != null && annotations.length > 0) {
                    IAnnotation[] iAnnotationArray = annotations;
                    int n3 = annotations.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IAnnotation annotation = iAnnotationArray[n4];
                        String elementName = annotation.getElementName();
                        String[] stringArray = annotationNames;
                        int n5 = annotationNames.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            String annotationName = stringArray[n6];
                            if (!annotationName.contains(".") ? elementName.endsWith(annotationName) : annotationName.endsWith(elementName)) {
                                return true;
                            }
                            ++n6;
                        }
                        ++n4;
                    }
                }
                if (je instanceof IMember && (status = InitializationUtils.checkAnnotationForJE(((IMember)je).getChildren(), annotationNames))) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }
}

