/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.annotations.core.internal.listeners;

import com.ibm.etools.annotations.core.internal.listeners.JELInfo;
import com.ibm.etools.annotations.core.internal.utils.InternalUtils;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;

public class InMemoryIndex {
    public static final int ADD_OPERATION = 0;
    public static final int REMOVE_OPERATION = 1;
    public static final int UPDATE_OPERATION = 2;
    private static InMemoryIndex instance;
    private Hashtable<IJavaElement, JELInfo> elements = new Hashtable();

    private InMemoryIndex() {
    }

    public static InMemoryIndex getInstance() {
        if (instance == null) {
            instance = new InMemoryIndex();
        }
        return instance;
    }

    public synchronized void updateInMemoryIndex(IJavaElement el, List<IAnnotation> annList, int operation) {
        List<IJavaElement> lst = InternalUtils.getIJavaElementFullHierachy(el);
        switch (operation) {
            case 0: {
                this.addToInMemoryIndex(lst);
                break;
            }
            case 1: {
                this.removeFromInMemoryIndex(lst, annList);
                break;
            }
            case 2: {
                this.updateMemoryIndex(lst);
            }
        }
    }

    public synchronized void updateInMemoryIndex(List<IAnnotation> annList, int isAdded) {
        for (IAnnotation annotation : annList) {
            ArrayList<IAnnotation> arrL = new ArrayList<IAnnotation>(1);
            arrL.add(annotation);
            this.updateInMemoryIndex(annotation.getParent(), arrL, isAdded);
        }
    }

    private void updateMemoryIndex(List<IJavaElement> elNames) {
        if (elNames.isEmpty() || this.elements.isEmpty()) {
            return;
        }
        Hashtable<IJavaElement, JELInfo> tempEl = this.elements;
        JELInfo inf = null;
        for (IJavaElement jEl : elNames) {
            inf = tempEl.get(jEl);
            if (inf == null) break;
            tempEl = inf.getChildren();
        }
        if (inf != null) {
            this.recurcivelyUpdateAllAnnotations(inf);
        }
    }

    private void addToInMemoryIndex(List<IJavaElement> elNames) {
        if (elNames.isEmpty()) {
            return;
        }
        Hashtable<IJavaElement, JELInfo> tempEl = this.elements;
        JELInfo inf = null;
        JELInfo tempParent = null;
        for (IJavaElement jEl : elNames) {
            inf = tempEl.get(jEl);
            if (inf != null) {
                tempEl = inf.getChildren();
                tempParent = inf;
                continue;
            }
            inf = new JELInfo(jEl);
            if (tempParent != null) {
                tempParent.addChild(jEl, inf);
            } else {
                tempEl.put(jEl, inf);
            }
            tempParent = inf;
            tempEl = inf.getChildren();
        }
        if (inf != null) {
            inf.updateAnnotations();
        }
    }

    private void removeFromInMemoryIndex(List<IJavaElement> elNames, List<IAnnotation> annotations) {
        if (elNames.isEmpty() || this.elements.isEmpty()) {
            return;
        }
        Hashtable<IJavaElement, JELInfo> tempEl = this.elements;
        JELInfo tempParent = null;
        JELInfo inf = null;
        for (IJavaElement jEl : elNames) {
            if (jEl.exists()) {
                tempParent = inf = tempEl.get(jEl);
                if (inf == null) break;
                tempEl = inf.getChildren();
                continue;
            }
            inf = tempEl.get(jEl);
            if (annotations == null) break;
            annotations.clear();
            break;
        }
        if (inf != null) {
            if (annotations == null || annotations.isEmpty()) {
                if (tempParent != null) {
                    tempParent.removeChild(inf.getJavaElement());
                } else {
                    this.elements.remove(inf.getJavaElement());
                }
            } else {
                inf.updateAnnotations();
            }
        }
    }

    public List<IAnnotation> getAnnotationsFromInMemoryIndex(IJavaElement element, boolean unitOnly) {
        ArrayList<IAnnotation> res = new ArrayList<IAnnotation>(0);
        if (this.elements.isEmpty()) {
            return res;
        }
        List<IJavaElement> lst = InternalUtils.getIJavaElementFullHierachy(element);
        if (lst.size() == 0) {
            return res;
        }
        Hashtable<IJavaElement, JELInfo> tempEl = this.elements;
        JELInfo inf = null;
        for (IJavaElement jEl : lst) {
            inf = tempEl.get(jEl);
            if (inf != null) {
                tempEl = inf.getChildren();
            }
            if (unitOnly && (jEl.getElementType() == 5 || jEl.getElementType() == 6)) break;
        }
        if (inf != null) {
            return this.recurcivelyGetAllAnnotations(inf);
        }
        return res;
    }

    private List<IAnnotation> recurcivelyGetAllAnnotations(JELInfo info) {
        ArrayList<IAnnotation> res = new ArrayList<IAnnotation>(info.getAnnotations());
        Hashtable<IJavaElement, JELInfo> tempEl = info.getChildren();
        if (tempEl != null) {
            Enumeration<IJavaElement> keys = tempEl.keys();
            while (keys.hasMoreElements()) {
                IJavaElement key = keys.nextElement();
                JELInfo in = tempEl.get(key);
                res.addAll(this.recurcivelyGetAllAnnotations(in));
            }
        }
        return res;
    }

    private void recurcivelyUpdateAllAnnotations(JELInfo info) {
        info.updateAnnotations();
        Hashtable<IJavaElement, JELInfo> tempEl = info.getChildren();
        if (tempEl != null) {
            Enumeration<IJavaElement> keys = tempEl.keys();
            while (keys.hasMoreElements()) {
                IJavaElement key = keys.nextElement();
                JELInfo in = tempEl.get(key);
                in.updateAnnotations();
            }
        }
    }

    public List getAllAnnotationInstancesFromIndex(List<String> annotationNames) {
        return this.getAnnotationInstances(annotationNames, this.elements);
    }

    private List<IAnnotation> getAnnotationInstances(List<String> annotationNames, Hashtable<IJavaElement, JELInfo> elements2) {
        if (elements2.isEmpty()) {
            return new ArrayList<IAnnotation>(0);
        }
        ArrayList<IAnnotation> res = new ArrayList<IAnnotation>();
        Enumeration<IJavaElement> en = elements2.keys();
        while (en.hasMoreElements()) {
            Hashtable<IJavaElement, JELInfo> childs;
            IJavaElement key = en.nextElement();
            JELInfo info = elements2.get(key);
            if (info == null) continue;
            ArrayList<IAnnotation> anns = info.getAnnotations();
            if (anns != null) {
                for (IAnnotation ann : anns) {
                    String sAnnName = ann.getElementName();
                    if (!annotationNames.contains(sAnnName)) continue;
                    res.add(ann);
                }
            }
            if ((childs = info.getChildren()) == null) continue;
            res.addAll(this.getAnnotationInstances(annotationNames, childs));
        }
        return res;
    }
}

