/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.annotations.core.internal.jobs;

import com.ibm.adapter.j2c.internal.CodegenPlugin;
import com.ibm.etools.annotations.core.internal.jobs.AnnotationJob;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.util.Messages;

public class AnnotationJobManager {
    private CheckJobManagerThread jobManagerThread = null;
    private int sleepTime = Integer.getInteger("annoSleepTime", 2000);
    private static AnnotationJobManager instance = new AnnotationJobManager();

    public static AnnotationJobManager getInstance() {
        return instance;
    }

    public synchronized void startJob(Job job) {
        if (this.jobManagerThread == null || !this.jobManagerThread.isAlive()) {
            this.jobManagerThread = new CheckJobManagerThread();
        }
        if (!this.jobManagerThread.isAlive()) {
            this.jobManagerThread.start();
        }
        this.jobManagerThread.schedule(job);
    }

    private class CheckJobManagerThread
    extends Thread {
        List<Job> delayedJobs = Collections.synchronizedList(new ArrayList());

        public CheckJobManagerThread() {
            this.setName("Annotation JobManager Checker");
            this.setPriority(1);
        }

        protected void schedule(Job job) {
            this.delayedJobs.add(job);
        }

        private Job findJDTIndexingJob(IJobManager jobManager) {
            Job[] jobs = jobManager.find(null);
            CodegenPlugin.debug("CheckJobManagerThread:    ****Looking for Java indexing job");
            Job jdtIndexingJob = null;
            Job[] jobArray = jobs;
            int n = jobs.length;
            int n2 = 0;
            while (n2 < n) {
                Job currJob = jobArray[n2];
                CodegenPlugin.debug("CheckJobManagerThread:jobInfo " + (currJob.getState() == 4 ? "RUNNING " : " ") + currJob);
                String jobName = currJob.getName();
                if (jobName.startsWith(Messages.jobmanager_indexing)) {
                    CodegenPlugin.debug("CheckJobManagerThread:FOUND JAVA INDEXING PROGRESS JOB");
                    jdtIndexingJob = currJob;
                    break;
                }
                ++n2;
            }
            return jdtIndexingJob;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                IJavaProject[] projects = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
                IJavaProject[] iJavaProjectArray = projects;
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaProject project = iJavaProjectArray[n2];
                    project.getPackageFragmentRoots();
                    ++n2;
                }
                JavaCore.initializeAfterLoad(null);
            }
            catch (CoreException e1) {
                CodegenPlugin.log("CheckJobManagerThread: JavaCore.initializeAfterLoad()", (Exception)((Object)e1));
            }
            IJobManager jobManager = Job.getJobManager();
            try {
                CodegenPlugin.debug("CheckJobManagerThread: Sleep for 5 seconds after thread creation");
                CheckJobManagerThread.sleep(5000L);
            }
            catch (InterruptedException e) {
                CodegenPlugin.log("CheckJobManagerThread:", e);
                return;
            }
            while (true) {
                if (this.delayedJobs.size() > 0) {
                    try {
                        CodegenPlugin.debug("CheckJobManagerThread: Sleep for " + AnnotationJobManager.this.sleepTime + "ms");
                        CheckJobManagerThread.sleep(AnnotationJobManager.this.sleepTime);
                    }
                    catch (InterruptedException e) {
                        CodegenPlugin.log("CheckJobManagerThread:", e);
                        return;
                    }
                    Job jdtIndexingJob = this.findJDTIndexingJob(jobManager);
                    while (jdtIndexingJob != null) {
                        CodegenPlugin.debug("CheckJobManagerThread: Joining Java indexing progress job");
                        try {
                            jdtIndexingJob.join();
                        }
                        catch (InterruptedException e) {
                            CodegenPlugin.log("CheckJobManagerThread: Exception attempting to join Java Index Job", e);
                        }
                        try {
                            CodegenPlugin.debug("CheckJobManagerThread: Sleep for " + AnnotationJobManager.this.sleepTime + "ms");
                            CheckJobManagerThread.sleep(AnnotationJobManager.this.sleepTime);
                        }
                        catch (InterruptedException e) {
                            CodegenPlugin.log("CheckJobManagerThread:", e);
                            return;
                        }
                        CodegenPlugin.debug("CheckJobManagerThread:*****finished waiting for index job to finish.  Finished sleeping after the jdt index job we joined is done.  Now trying to locate if another indexing job has sprung up.");
                        jdtIndexingJob = this.findJDTIndexingJob(jobManager);
                    }
                    CodegenPlugin.debug("CheckJobManagerThread:Starting jobs in queue");
                    List<Job> list = this.delayedJobs;
                    synchronized (list) {
                        for (Job currJob : this.delayedJobs) {
                            currJob.schedule();
                        }
                        this.delayedJobs.clear();
                    }
                }
                if (CodegenPlugin.getDefault() == null) break;
                try {
                    CodegenPlugin.debug("CheckJobManagerThread: Sleep for half second");
                    CheckJobManagerThread.sleep(AnnotationJobManager.this.sleepTime);
                }
                catch (InterruptedException e) {
                    CodegenPlugin.log("CheckJobManagerThread:", e);
                    return;
                }
            }
            jobManager.cancel((Object)AnnotationJob.NORMAL_FAMILY);
            CodegenPlugin.debug("CheckJobManagerThread: Thread exiting");
            AnnotationJobManager.this.jobManagerThread = null;
        }
    }
}

