/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.annotations.core.internal;

import com.ibm.etools.annotations.core.api.AnnotationImpliedAnnotationInfo;
import com.ibm.etools.annotations.core.data.AnnotationInfo;
import com.ibm.etools.annotations.core.utils.AnnotationConstants;
import com.ibm.etools.annotations.core.utils.AnnotationUtils;
import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaElement;

public class AnnotationConfigImpliedAnnotationInfo {
    private static Hashtable<String, Hashtable<String, ArrayList<String>>> ImpliedAnnotationsTable_;
    private static Hashtable<String, ArrayList<String>> ImpliedAnnoForScopeList_;
    private static Hashtable<String, ArrayList<String>> ImpliedAnnotationsScopeList_;
    AnnotationConfigImpliedAnnotationInfo ImpliedAnnotationInstance_;
    ArrayList<String> ImpliedScopeList_;
    ArrayList<AnnotationInfo> ImpliedAnnotationsList_;
    private static Hashtable<String, Object> ImpliedannoTagClass_;
    private static Hashtable<String, Object> ImpliedannoClassObjects_;

    public AnnotationConfigImpliedAnnotationInfo instance() {
        if (this.ImpliedAnnotationInstance_ == null) {
            this.ImpliedAnnotationInstance_ = new AnnotationConfigImpliedAnnotationInfo();
            ImpliedAnnotationsTable_ = null;
            ImpliedAnnotationsScopeList_ = null;
            this.ImpliedScopeList_ = null;
            this.ImpliedAnnotationsList_ = null;
            ImpliedAnnoForScopeList_ = null;
        }
        return this.ImpliedAnnotationInstance_;
    }

    private Hashtable getOnceOnlyImpliedAnnotationConfigFromExtensionPointInfo() {
        AnnotationConstants.debug("should invoke this only once :getOnceOnlyImpliedAnnotationConfigFromExtensionPointInfo");
        ImpliedAnnotationsTable_ = new Hashtable();
        ImpliedannoTagClass_ = new Hashtable();
        ImpliedannoClassObjects_ = new Hashtable();
        ImpliedAnnotationsScopeList_ = new Hashtable();
        ImpliedAnnoForScopeList_ = new Hashtable();
        IConfigurationElement[] annoConfigExtensionPoints = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.etools.annotations.core.AnnotationConfigImpliedAnnotationsInfo");
        AnnotationConstants.debug("configlength=" + annoConfigExtensionPoints.length);
        int i = 0;
        while (i < annoConfigExtensionPoints.length) {
            AnnotationConstants.debug("i:" + i + ":" + annoConfigExtensionPoints[i].getName());
            if ("impliedAnnotations".equals(annoConfigExtensionPoints[i].getName())) {
                String aTag = annoConfigExtensionPoints[i].getAttribute("tag");
                String aPackage = annoConfigExtensionPoints[i].getAttribute("package");
                StringBuffer aKey = new StringBuffer(aPackage);
                aKey.append(".");
                aKey.append(aTag);
                String tagKey = aKey.toString();
                AnnotationConstants.debug("tagName=" + tagKey);
                Object classObj = null;
                String aClassName = annoConfigExtensionPoints[i].getAttribute("className");
                if (aClassName != null && aClassName.length() > 0) {
                    try {
                        classObj = annoConfigExtensionPoints[i].createExecutableExtension("className");
                        ImpliedannoTagClass_.put(tagKey, classObj);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    if (classObj != null) {
                        ImpliedannoClassObjects_.put(aClassName, classObj);
                    }
                    if (annoConfigExtensionPoints[i].getChildren() != null) {
                        this.ImpliedScopeList_ = this.getImpliedAnnotationsScope(annoConfigExtensionPoints[i]);
                        if (ImpliedAnnotationsScopeList_.size() > 0) {
                            ImpliedAnnotationsScopeList_.put(tagKey, this.ImpliedScopeList_);
                        }
                    }
                    if (this.ImpliedScopeList_ != null && this.ImpliedScopeList_.size() > 0) {
                        int k = 0;
                        while (k < this.ImpliedScopeList_.size()) {
                            String scope = this.ImpliedScopeList_.get(k);
                            ArrayList impliedannoforThisScopeList = new ArrayList();
                            ImpliedAnnoForScopeList_.put(scope, impliedannoforThisScopeList);
                            ImpliedAnnotationsTable_.put(tagKey, ImpliedAnnoForScopeList_);
                            ++k;
                        }
                    }
                }
            }
            ++i;
        }
        return ImpliedAnnotationsTable_;
    }

    private ArrayList getImpliedAnnotationsScope(IConfigurationElement annoScopeNodes) {
        IConfigurationElement[] scopeElms;
        ArrayList<String> scopes = new ArrayList<String>();
        if (annoScopeNodes.getChildren() != null && (scopeElms = annoScopeNodes.getChildren("scope")) != null && scopeElms.length > 0) {
            int i = 0;
            while (i < scopeElms.length) {
                String aName = scopeElms[i].getAttribute("name");
                if (aName != null) {
                    if (aName.equals("ALL")) {
                        scopes.add("CLASS");
                        scopes.add("INTERFACE");
                        scopes.add("FIELD");
                        scopes.add("METHOD");
                    } else {
                        scopes.add(aName);
                    }
                }
                ++i;
            }
        }
        return scopes;
    }

    public ArrayList getImpliedAnnotations(String tag, IJavaElement jScope) {
        ArrayList<String> validScopes;
        String scopeStr = AnnotationUtils.scopeAsString(jScope);
        AnnotationUtils.debug("API: getImpliedAnnotations: tag=" + tag + " scopeStr=[" + scopeStr + "]");
        if (ImpliedAnnotationsTable_ == null || ImpliedAnnotationsTable_ != null && ImpliedAnnotationsTable_.isEmpty()) {
            AnnotationUtils.debug("getOnceOnlyImpliedAnnotationConfigFromExtensionPointInfo");
            ImpliedAnnotationsTable_ = this.getOnceOnlyImpliedAnnotationConfigFromExtensionPointInfo();
        }
        if (ImpliedAnnotationsScopeList_ != null && (validScopes = ImpliedAnnotationsScopeList_.get(tag)) != null && !validScopes.contains(scopeStr)) {
            return new ArrayList();
        }
        return this.getImpliedAnnotationsForScope(tag, jScope);
    }

    private ArrayList getImpliedAnnotationsForScope(String tag, IJavaElement jScope) {
        try {
            Object classObj;
            if (ImpliedannoTagClass_ != null && ImpliedannoTagClass_.containsKey(tag) && (classObj = ImpliedannoTagClass_.get(tag)) != null) {
                ArrayList<String> aImplied = ((AnnotationImpliedAnnotationInfo)classObj).getImpliedAnnotationsForCurrentJE(tag, jScope);
                if (aImplied != null && aImplied.size() > 0) {
                    return aImplied;
                }
                return new ArrayList();
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        return new ArrayList();
    }
}

