/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.annotations.core.internal;

import com.ibm.etools.annotations.core.internal.AnnotationAttributesElem;
import com.ibm.etools.annotations.core.utils.AnnotationConstants;
import java.util.ArrayList;
import java.util.HashSet;

public class AnnotationConfigElem {
    private String category;
    private String icon;
    private String annotationName = "";
    private String annotationDesc = "";
    private String annoPackage = "";
    private ArrayList<AnnotationAttributesElem> attributesElement;
    private boolean hasDefault = false;
    private ArrayList scopeLists;
    private boolean isExcluded = false;

    public AnnotationConfigElem() {
    }

    public AnnotationConfigElem(String cat, String name, String iconpath, String description, String pName) {
        this.category = cat;
        this.icon = iconpath;
        this.annotationDesc = description;
        this.annotationName = name;
        this.annoPackage = pName;
        this.isExcluded = false;
    }

    public void setScopeList(ArrayList list) {
        this.scopeLists = new ArrayList();
        if (list == null || list.size() == 0) {
            this.scopeLists.add("CLASS");
            this.scopeLists.add("FIELD");
            this.scopeLists.add("METHOD");
            this.scopeLists.add("INTERFACE");
        } else {
            int i = 0;
            while (i < list.size()) {
                this.scopeLists.add(list.get(i));
                ++i;
            }
        }
    }

    public ArrayList getScopeList() {
        return this.scopeLists;
    }

    public String getCateogry() {
        return this.category;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getAnnotationDesc() {
        return this.annotationDesc;
    }

    public String getAnnoPackage() {
        return this.annoPackage;
    }

    public String getAnnotationName() {
        return this.annotationName;
    }

    public boolean hasDefault() {
        return this.hasDefault;
    }

    public String getCategoryString() {
        return "(" + this.getCateogry() + ")";
    }

    public void setHasDefault(boolean flag) {
        this.hasDefault = flag;
    }

    public void setCategory(String cat) {
        this.category = cat;
    }

    public void setIcon(String iconpath) {
        this.icon = iconpath;
    }

    public void setAnnotationDesc(String desc) {
        this.annotationDesc = desc;
    }

    public void setAnnotationName(String name) {
        this.annotationName = name;
    }

    public void setAnnoPackage(String name) {
        this.annotationName = name;
    }

    public void setAnnotationAttributes(ArrayList list) {
        this.attributesElement = list;
    }

    public void setExcluded(boolean value) {
        this.isExcluded = value;
    }

    public boolean getExcludedValue() {
        return this.isExcluded;
    }

    public String getAnnotationWithOutDefaultsDesc() {
        StringBuffer myBuf = new StringBuffer("@");
        myBuf.append(this.annotationName);
        return myBuf.toString();
    }

    public String getAnnotationWithDefaultsDesc() {
        StringBuffer myBuf = new StringBuffer("@");
        myBuf.append(this.annotationName);
        if (this.attributesElement != null && this.attributesElement.size() > 0) {
            AnnotationConstants.dump("getAnnotationWithDefaultsDesc:size=" + this.attributesElement.size());
            myBuf.append("(");
            int i = 0;
            while (i < this.attributesElement.size()) {
                AnnotationAttributesElem elm = this.attributesElement.get(i);
                if (elm != null && elm.getDefaultValueAsString() != null) {
                    AnnotationConstants.dump("defattrname=" + elm.getAttrName());
                    AnnotationConstants.dump("defvalue=" + elm.getDefaultValueAsString());
                    myBuf.append(elm.getAttrName());
                    myBuf.append("=");
                    if (elm.getDefaultValueAsString() != null && elm.getDefaultValueAsString().length() == 0) {
                        myBuf.append("\"\"");
                    } else {
                        myBuf.append(elm.getDefaultValueAsString());
                    }
                    if (i < this.attributesElement.size() - 1) {
                        myBuf.append(", ");
                    }
                }
                ++i;
            }
            myBuf.append(")");
        }
        AnnotationConstants.debug("returned array string=" + myBuf.toString());
        return myBuf.toString();
    }

    public ArrayList getAttributeImports() {
        ArrayList newList = new ArrayList();
        if (this.attributesElement != null && this.attributesElement.size() > 0) {
            int i = 0;
            while (i < this.attributesElement.size()) {
                AnnotationAttributesElem elm = this.attributesElement.get(i);
                if (elm != null && elm.getImports_() != null && !elm.getImports_().isEmpty()) {
                    newList.addAll(elm.getImports_());
                }
                ++i;
            }
        }
        return this.makeUnique(newList);
    }

    public ArrayList makeUnique(ArrayList imports) {
        HashSet<String> seenAlready = new HashSet<String>();
        ArrayList<String> uniqueImports = new ArrayList<String>();
        for (String this_importclass : imports) {
            if (seenAlready.contains(this_importclass)) continue;
            seenAlready.add(this_importclass);
            uniqueImports.add(this_importclass);
        }
        return uniqueImports;
    }

    public void setAnnoAttributes(ArrayList<AnnotationAttributesElem> list) {
        this.attributesElement = list;
    }

    public ArrayList<AnnotationAttributesElem> getAnnoAttributes() {
        return this.attributesElement;
    }

    public String getTagKey() {
        StringBuffer aKey = new StringBuffer(this.category);
        aKey.append(".");
        aKey.append(this.annoPackage);
        aKey.append(".");
        aKey.append(this.annotationName);
        String tagKey = aKey.toString();
        return tagKey;
    }
}

