/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.annotations.core.internal;

import com.ibm.etools.annotations.core.data.AnnotatedClassInfo;
import com.ibm.etools.annotations.core.data.AnnotationInfo;
import com.ibm.etools.annotations.core.data.JavaElementInfo;
import com.ibm.etools.annotations.core.internal.utils.AnnotationAttributePropertyFactory;
import com.ibm.etools.annotations.core.internal.utils.InternalUtils;
import com.ibm.etools.annotations.core.model.IAnnotationAttributeProperty;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;

public class ASTAnnotationParser {
    public static final char NAME_SEPARATOR = '#';
    private ArrayList<AnnotationInfo> allAnnotationsInClass = null;
    private Hashtable<IJavaElement, JavaElementInfo> javaEltpJavaElInfo = new Hashtable();

    public AnnotatedClassInfo getAnnotatedClassInfo(IJavaElement cu, int offset, boolean forceReparse) {
        if (cu == null) {
            return null;
        }
        if (this.allAnnotationsInClass == null || forceReparse) {
            this.javaEltpJavaElInfo.clear();
            this.allAnnotationsInClass = (ArrayList)this.parseAnnotationOnly(cu, offset);
        }
        if (this.allAnnotationsInClass == null || this.allAnnotationsInClass.size() == 0) {
            return null;
        }
        AnnotatedClassInfo re = null;
        try {
            re = new AnnotatedClassInfo(cu);
            this.createJavaElementInfos(cu, re);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        if (re != null) {
            int r = 0;
            while (r < this.allAnnotationsInClass.size()) {
                AnnotationInfo ai = this.allAnnotationsInClass.get(r);
                if (ai != null) {
                    JavaElementInfo jeInfo;
                    IJavaElement jaEls;
                    IAnnotation annotation = ai.getAnnotation();
                    if (annotation != null) {
                        try {
                            ISourceRange isr = annotation.getSourceRange();
                            if (isr != null) {
                                int iStart = isr.getOffset();
                                int length = isr.getLength();
                                if (offset >= iStart && offset <= iStart + length) {
                                    ai.setDefaultInScope(true);
                                } else {
                                    ai.setDefaultInScope(false);
                                }
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if ((jaEls = InternalUtils.getJavaElementForAnnotation(annotation)) != null && (jeInfo = this.javaEltpJavaElInfo.get(jaEls)) != null) {
                        jeInfo.getAnnotationInfoPG().addProperty((IPropertyDescriptor)ai);
                        ai.setJavaElementInfo(jeInfo);
                    }
                    InternalUtils.applyExternalCustomization(ai);
                }
                ++r;
            }
        }
        IJavaProject project = cu.getJavaProject();
        re.calculateAllImpliedAnnotations(project);
        return re;
    }

    public List<AnnotationInfo> parseAnnotationOnly(IJavaElement je, int offSet) {
        ArrayList<AnnotationInfo> result = new ArrayList<AnnotationInfo>();
        try {
            if (je instanceof ICompilationUnit) {
                ICompilationUnit unit = (ICompilationUnit)je;
                this.addAnnotationInfosForCU(result, unit);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private void addAnnotationInfosForCU(List<AnnotationInfo> result, ICompilationUnit unit) {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(unit);
        parser.setResolveBindings(true);
        parser.setFocalPosition(0);
        CompilationUnit compilationUnit = (CompilationUnit)parser.createAST(null);
        class AnnotationVisitor
        extends ASTVisitor {
            List<AnnotationInfo> list;

            public AnnotationVisitor(List<AnnotationInfo> list) {
                this.list = list;
            }

            public boolean visit(MarkerAnnotation node) {
                this.processAnnotation((Annotation)node);
                return true;
            }

            public boolean visit(NormalAnnotation node) {
                this.processAnnotation((Annotation)node);
                return true;
            }

            public boolean visit(SingleMemberAnnotation node) {
                this.processAnnotation((Annotation)node);
                return true;
            }

            private void processAnnotation(Annotation node) {
                AnnotationInfo inf = ASTAnnotationParser.this.buildAnnotationInfo(node);
                if (inf != null) {
                    this.list.add(inf);
                }
            }
        }
        AnnotationVisitor visitor = new AnnotationVisitor(result);
        compilationUnit.accept((ASTVisitor)visitor);
    }

    public AnnotationInfo buildAnnotationInfo(Annotation node) {
        IAnnotation annotation;
        String sAnnName;
        IAnnotationBinding annotationBinding;
        AnnotationInfo anI;
        block5: {
            block4: {
                anI = null;
                annotationBinding = node.resolveAnnotationBinding();
                if (annotationBinding != null) break block4;
                return null;
            }
            sAnnName = annotationBinding.getName();
            annotation = (IAnnotation)annotationBinding.getJavaElement();
            if (annotation != null) break block5;
            return null;
        }
        try {
            String sPack = annotationBinding.getAnnotationType().getPackage().getName();
            anI = new AnnotationInfo(sAnnName, node.getStartPosition(), annotation);
            anI.setCategorizationKey(sPack);
            anI.setPackageName(sPack);
            this.buildAnnotationAttributes(anI, annotationBinding, node);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return anI;
    }

    public void buildAnnotationAttributes(AnnotationInfo annotationInfo, IAnnotationBinding binding, Annotation annotation) {
        ArrayList<IAnnotationAttributeProperty> allAnnotationAttributeInfos = new ArrayList<IAnnotationAttributeProperty>();
        ArrayList<IAnnotationAttributeProperty> allDeclaredAttributeInfos = new ArrayList<IAnnotationAttributeProperty>();
        this.retrieveAnnotationAttributes(annotationInfo, binding, allDeclaredAttributeInfos, allAnnotationAttributeInfos);
        annotationInfo.setDeclaredAttributes(allDeclaredAttributeInfos);
        annotationInfo.setAllAttributes(allAnnotationAttributeInfos);
    }

    public void retrieveAnnotationAttributes(AnnotationInfo parent, IAnnotationBinding binding, List<IAnnotationAttributeProperty> declaredAnnotationAttributes, List<IAnnotationAttributeProperty> allAnnotationAttributes) {
        HashMap<String, IAnnotationAttributeProperty> allPairs = new HashMap<String, IAnnotationAttributeProperty>();
        IMemberValuePairBinding[] declaredMemberValuePairs = binding.getDeclaredMemberValuePairs();
        int g = 0;
        int max = declaredMemberValuePairs.length;
        while (g < max) {
            IMemberValuePairBinding memberValuePairBinding = declaredMemberValuePairs[g];
            IAnnotationAttributeProperty annotationAttributeProperty = AnnotationAttributePropertyFactory.getASTAnnotationAttributeProperty(parent, memberValuePairBinding);
            if (annotationAttributeProperty != null) {
                declaredAnnotationAttributes.add(annotationAttributeProperty);
                allPairs.put(memberValuePairBinding.getName(), annotationAttributeProperty);
            }
            ++g;
        }
        IMemberValuePairBinding[] allMemberValuePairs = binding.getAllMemberValuePairs();
        int i = 0;
        int max2 = allMemberValuePairs.length;
        while (i < max2) {
            IMemberValuePairBinding memberValuePairBinding = allMemberValuePairs[i];
            IAnnotationAttributeProperty annotationAttributeProperty = (IAnnotationAttributeProperty)allPairs.get(memberValuePairBinding.getName());
            if (annotationAttributeProperty != null) {
                allAnnotationAttributes.add(annotationAttributeProperty);
            } else {
                annotationAttributeProperty = AnnotationAttributePropertyFactory.getASTAnnotationAttributeProperty(parent, memberValuePairBinding);
                if (annotationAttributeProperty != null) {
                    allAnnotationAttributes.add(annotationAttributeProperty);
                }
            }
            ++i;
        }
    }

    private void createJavaElementInfos(IJavaElement cu, AnnotatedClassInfo aci) {
        if (cu != null) {
            try {
                IType[] types = null;
                IPackageDeclaration[] packageDecls = null;
                if (cu instanceof ICompilationUnit) {
                    types = ((ICompilationUnit)cu).getTypes();
                    packageDecls = ((ICompilationUnit)cu).getPackageDeclarations();
                } else if (cu instanceof IClassFile) {
                    types = new IType[]{((IClassFile)cu).getType()};
                }
                if (packageDecls != null) {
                    int t = 0;
                    while (t < packageDecls.length) {
                        IPackageDeclaration ipd = packageDecls[t];
                        try {
                            JavaElementInfo childNode = new JavaElementInfo((IJavaElement)ipd, aci.getJavaElementInfoPG());
                            childNode.setParentJavaElementInfo(aci);
                            this.javaEltpJavaElInfo.put((IJavaElement)ipd, childNode);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        ++t;
                    }
                }
                if (types != null) {
                    int i = 0;
                    while (i < types.length) {
                        JavaElementInfo jInf = this.createJavaElementInfos((IJavaElement)types[i], aci.getJavaElementInfoPG());
                        jInf.setParentJavaElementInfo(aci);
                        ++i;
                    }
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
    }

    private JavaElementInfo createJavaElementInfos(IJavaElement je, BasePropertyGroup bpg) {
        JavaElementInfo node = null;
        try {
            IJavaElement[] children;
            node = new JavaElementInfo(je, bpg);
            this.javaEltpJavaElInfo.put(je, node);
            if (je instanceof IMember && (children = ((IMember)je).getChildren()) != null) {
                IJavaElement[] iJavaElementArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElement child = iJavaElementArray[n2];
                    JavaElementInfo childNode = this.createJavaElementInfos(child, node.getJavaElementInfoPG());
                    if (childNode != null) {
                        childNode.setParentJavaElementInfo(node);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception exception) {}
        return node;
    }
}

