/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.annotations.core.data;

import com.ibm.etools.annotations.core.data.AnnotatedClassInfo;
import com.ibm.etools.annotations.core.internal.jobs.AnnotationModelUpdateJobManager;
import com.ibm.etools.annotations.core.internal.utils.InternalUtils;
import com.ibm.propertygroup.IPropertyDescriptor;
import java.util.List;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class JDTListener
implements IElementChangedListener {
    protected AnnotationModelUpdateJobManager updateManager_ = new AnnotationModelUpdateJobManager();
    private IJavaElement cu;
    private AnnotatedClassInfo aci_;

    public JDTListener(AnnotatedClassInfo aci) {
        this.aci_ = aci;
        this.cu = this.aci_.getJavaElement();
    }

    public void elementChanged(ElementChangedEvent event) {
        IJavaElementDelta delta = event.getDelta();
        switch (event.getType()) {
            case 1: {
                IJavaElementDelta cDelta = this.getChangedDelta(delta);
                if (cDelta == null || !this.cu.exists()) break;
                AnnotatedClassInfo annotatedClassInfo = this.aci_;
                ((Object)((Object)annotatedClassInfo)).getClass();
                this.updateManager_.performModelUpdate(new AnnotatedClassInfo.AnnotatedClassInfoUpdateJob(annotatedClassInfo, (IPropertyDescriptor)this.aci_));
                break;
            }
            default: {
                CompilationUnit astUnit = delta.getCompilationUnitAST();
                if (astUnit == null || astUnit.getTypeRoot() == null || !astUnit.getTypeRoot().equals(this.cu)) break;
                this.cu = astUnit.getTypeRoot();
                if (!this.cu.exists()) break;
                AnnotatedClassInfo annotatedClassInfo = this.aci_;
                ((Object)((Object)annotatedClassInfo)).getClass();
                this.updateManager_.performModelUpdate(new AnnotatedClassInfo.AnnotatedClassInfoUpdateJob(annotatedClassInfo, (IPropertyDescriptor)this.aci_));
            }
        }
    }

    protected IJavaElementDelta getChangedDelta(IJavaElementDelta delta) {
        int kind = delta.getKind();
        if (kind == 4) {
            int i;
            int flags = delta.getFlags();
            IJavaElement element = delta.getElement();
            if (element instanceof IJavaModel) {
                if ((flags & 8) == 0) {
                    return null;
                }
            } else if (element instanceof IJavaProject) {
                if (element.equals(this.cu.getJavaProject())) {
                    if (this.evaluateLeafChildreb(delta)) {
                        return delta;
                    }
                    if ((flags & 0x20000) != 0) {
                        return delta;
                    }
                    IResourceDelta[] deltas = delta.getResourceDeltas();
                    if (deltas != null) {
                        i = 0;
                        while (i < deltas.length) {
                            if (deltas[i].getProjectRelativePath().toString().equals(".classpath")) {
                                return delta;
                            }
                            ++i;
                        }
                    }
                }
            } else if (element instanceof ICompilationUnit) {
                ICompilationUnit icu = (ICompilationUnit)element;
                if (icu.equals(this.cu)) {
                    return delta;
                }
                return null;
            }
            IJavaElementDelta[] children = delta.getChangedChildren();
            i = 0;
            while (i < children.length) {
                IJavaElementDelta cDelta = this.getChangedDelta(children[i]);
                if (cDelta != null) {
                    return cDelta;
                }
                ++i;
            }
        }
        return null;
    }

    protected boolean evaluateLeafChildreb(IJavaElementDelta delta) {
        boolean movedTo = false;
        boolean movedFrom = false;
        boolean content = false;
        List<IJavaElementDelta> dds = InternalUtils.getLeafDeltas(delta);
        int c = 0;
        while (c < dds.size()) {
            ICompilationUnit cuNew;
            IJavaElement astUnit;
            IJavaElementDelta del = dds.get(c);
            int flags = del.getFlags();
            if ((flags & 0x20) != 0) {
                movedTo = true;
            }
            if ((flags & 0x10) != 0) {
                movedFrom = true;
            }
            if ((flags & 1) != 0 && (astUnit = del.getElement()) instanceof ICompilationUnit && (cuNew = (ICompilationUnit)astUnit) != null && this.cu.getElementName().equals(cuNew.getElementName())) {
                content = true;
            }
            ++c;
        }
        return movedTo && movedFrom && content;
    }
}

