/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.annotations.core.data;

import com.ibm.adapter.j2c.internal.CodegenPlugin;
import com.ibm.etools.annotations.core.data.AnnotatedProjectInfo;
import com.ibm.etools.annotations.core.internal.utils.InternalUtils;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;

public class AnnotatedProjectInfosRepository
implements IElementChangedListener,
IResourceChangeListener {
    public static final String EJB_LIST = "EJB";
    public static final String WEB_LIST = "WEB";
    public static final String JSF_LIST = "JSF";
    public static final String JCDI_LIST = "JCDI";
    public static final String WEBSOCKET_LIST = "WEB_SOCKET";
    public static final String[] PACKAGE_LEVEL_ANNOTATIONS = new String[]{"javax.servlet.sip.annotation.SipApplication"};
    public static final String PACKAGE_INFO_JAVA = "package-info.java";
    private static final List<String> commonAnnoList = Arrays.asList("javax.annotation.Generated", "javax.annotation.Resource", "javax.annotation.Resources", "javax.annotation.PostConstruct", "javax.annotation.PreDestroy", "javax.annotation.Priority", "javax.annotation.security.RunAs", "javax.annotation.security.RolesAllowed", "javax.annotation.security.PermitAll", "javax.annotation.security.DenyAll", "javax.annotation.security.DeclareRoles", "javax.annotation.sql.DataSourceDefinition", "javax.annotation.sql.DataSourceDefinitions", "javax.annotation.ManagedBean", "javax.interceptor.Interceptor");
    private static final List<String> ejbAnnoList = Arrays.asList("javax.ejb.Stateless", "javax.ejb.Stateful", "javax.ejb.Singleton", "javax.ejb.MessageDriven", "javax.ejb.ApplicationException", "javax.ejb.TransactionAttribute", "javax.interceptor.Interceptors", "javax.interceptor.AroundInvoke", "javax.interceptor.AroundTimeout", "javax.interceptor.AroundConstruct", "javax.ejb.EJB", "javax.ejb.EJBs", "javax.persistence.PersistenceContext", "javax.persistence.PersistenceUnit");
    private static final List<String> webAnnoList = Arrays.asList("javax.ejb.EJB", "javax.ejb.EJBs", "javax.servlet.sip.annotation.SipApplication", "javax.servlet.sip.annotation.SipServlet", "javax.servlet.sip.annotation.SipListener", "javax.servlet.sip.annotation.SipApplicationKey", "javax.servlet.annotation.WebServlet", "javax.servlet.annotation.WebFilter", "javax.servlet.annotation.WebListener", "javax.servlet.annotation.MultipartConfig", "javax.ws.rs.Path");
    private static final List<String> jsfAnnoList = Arrays.asList("javax.faces.component.FacesComponent", "javax.faces.component.behavior.FacesBehavior", "javax.faces.render.FacesBehaviorRenderer", "javax.faces.render.FacesRenderer", "javax.faces.convert.FacesConverter", "javax.faces.validator.FacesValidator", "javax.faces.event.ListenerFor", "javax.faces.event.ListenersFor", "javax.faces.event.NamedEvent", "javax.faces.application.ResourceDependencies", "javax.faces.application.ResourceDependency", "javax.faces.bean.ManagedBean", "javax.faces.bean.ManagedProperty", "javax.faces.bean.ReferencedBean", "javax.faces.bean.RequestScoped", "javax.faces.bean.SessionScoped", "javax.faces.bean.ApplicationScoped", "javax.faces.bean.CustomScoped", "javax.faces.bean.ViewScoped", "javax.faces.bean.NoneScoped", "javax.faces.flow.FlowScoped");
    private static final List<String> jcdiAnnoList = Arrays.asList("javax.inject.Inject", "javax.inject.Named", "javax.inject.Qualifier", "javax.inject.Scope", "javax.inject.Singleton", "javax.enterprise.inject.Alternative", "javax.enterprise.inject.Any", "javax.enterprise.inject.Decorated", "javax.enterprise.inject.Default", "javax.enterprise.inject.Disposes", "javax.enterprise.inject.Intercepted", "javax.enterprise.inject.Model", "javax.enterprise.inject.New", "javax.enterprise.inject.Produces", "javax.enterprise.inject.Specializes", "javax.enterprise.inject.Stereotype", "javax.enterprise.inject.TransientReference", "javax.enterprise.inject.Typed", "javax.enterprise.inject.Vetoed", "javax.enterprise.context.ApplicationScoped", "javax.enterprise.context.ConversationScoped", "javax.enterprise.context.Dependent", "javax.enterprise.context.Destroyed", "javax.enterprise.context.Initialized", "javax.enterprise.context.NormalScoped", "javax.enterprise.context.RequestScoped", "javax.enterprise.context.SessionScoped", "javax.decorator.Decorator", "javax.decorator.Delegate", "javax.enterprise.util.Nonbinding", "javax.enterprise.event.Observes", "javax.enterprise.inject.spi.WithAnnotations");
    private static final List<String> webSocketAnnoList = Arrays.asList("javax.websocket.server.ServerEndpoint", "javax.websocket.ClientEndpoint", "javax.websocket.server.PathParam", "javax.websocket.OnOpen", "javax.websocket.OnClose", "javax.websocket.OnError", "javax.websocket.OnMessage");
    private static final List<String> swaggerAnnoList = Arrays.asList("io.swagger.annotations.Api", "io.swagger.annotations.ApiImplicitParam", "io.swagger.annotations.ApiImplicitParams", "io.swagger.annotations.ApiModel", "io.swagger.annotations.ApiModelProperty", "io.swagger.annotations.ApiOperation", "io.swagger.annotations.ApiParam", "io.swagger.annotations.ApiResponse", "io.swagger.annotations.ApiResponses", "io.swagger.annotations.Authorization", "io.swagger.annotations.AuthorizationScope", "io.swagger.annotations.Contact", "io.swagger.annotations.Extension", "io.swagger.annotations.ExtensionProperty", "io.swagger.annotations.ExternalDocs", "io.swagger.annotations.Info", "io.swagger.annotations.License", "io.swagger.annotations.ResponseHeader", "io.swagger.annotations.SwaggerDefinition", "io.swagger.annotations.Tag", "io.swagger.annotations.Example", "io.swagger.annotations.ExampleProperty");
    private static AnnotatedProjectInfosRepository instance = new AnnotatedProjectInfosRepository();
    private Hashtable<String, SoftReference<AnnotatedProjectInfo>> localCache = new Hashtable();

    private AnnotatedProjectInfosRepository() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 6);
    }

    public static AnnotatedProjectInfosRepository getInstance() {
        return instance;
    }

    public AnnotatedProjectInfo getAnnotatedProjectInfo(IProject project) {
        return this.getAnnotatedProjectInfo(project, true);
    }

    public AnnotatedProjectInfo getAnnotatedProjectInfo(IProject project, boolean runProjectInitInBackgroud) {
        return this.getAnnotatedProjectInfo(project, runProjectInitInBackgroud, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnnotatedProjectInfo getAnnotatedProjectInfo(IProject project, boolean runProjectInitInBackgroud, boolean waitForInit) {
        if (project != null) {
            String sProjectName = project.getName();
            AnnotatedProjectInfo api = null;
            Hashtable<String, SoftReference<AnnotatedProjectInfo>> hashtable = this.localCache;
            synchronized (hashtable) {
                SoftReference<AnnotatedProjectInfo> softApi = this.localCache.get(sProjectName);
                if (softApi != null) {
                    api = softApi.get();
                }
                if (api == null) {
                    try {
                        api = new AnnotatedProjectInfo(project, runProjectInitInBackgroud, null);
                        SoftReference<AnnotatedProjectInfo> softApi1 = new SoftReference<AnnotatedProjectInfo>(api);
                        this.localCache.put(project.getName(), softApi1);
                    }
                    catch (Exception e) {
                        CodegenPlugin.log("Exception creating AnnotatedProjectInfo: ", e);
                    }
                }
            }
            if (api != null && waitForInit) {
                this.waitForInit(api, null);
            }
            return api;
        }
        return null;
    }

    public String[] getJCDIAnnotationList() {
        ArrayList<String> completeList = new ArrayList<String>(jcdiAnnoList);
        completeList.addAll(commonAnnoList);
        return completeList.toArray(new String[0]);
    }

    public String[] getEJBAnnotationList() {
        ArrayList<String> completeList = new ArrayList<String>(ejbAnnoList);
        completeList.addAll(commonAnnoList);
        completeList.addAll(jcdiAnnoList);
        return completeList.toArray(new String[0]);
    }

    public String[] getWebAnnotationList() {
        ArrayList<String> completeList = new ArrayList<String>(webAnnoList);
        completeList.addAll(ejbAnnoList);
        completeList.addAll(commonAnnoList);
        completeList.addAll(jcdiAnnoList);
        completeList.addAll(webSocketAnnoList);
        completeList.addAll(swaggerAnnoList);
        return completeList.toArray(new String[0]);
    }

    public String[] getJSFAnnotationList() {
        ArrayList<String> completeList = new ArrayList<String>(jsfAnnoList);
        completeList.addAll(jcdiAnnoList);
        return completeList.toArray(new String[0]);
    }

    public AnnotatedProjectInfo getAnnotatedProjectInfoForEJB(IProject project, boolean runProjectInitInBackgroud, boolean waitForInit) {
        return this.getAnnotatedProjectInfoForEJB(project, runProjectInitInBackgroud, waitForInit, null);
    }

    public AnnotatedProjectInfo getAnnotatedProjectInfoForEJB(IProject project, boolean runProjectInitInBackgroud, boolean waitForInit, IProgressMonitor monitor) {
        return this.getAnnotatedProjectInfo(project, EJB_LIST, this.getEJBAnnotationList(), runProjectInitInBackgroud, waitForInit, monitor);
    }

    public AnnotatedProjectInfo getAnnotatedProjectInfoForWeb(IProject project, boolean runProjectInitInBackgroud, boolean waitForInit) {
        return this.getAnnotatedProjectInfoForWeb(project, runProjectInitInBackgroud, waitForInit, null);
    }

    public AnnotatedProjectInfo getAnnotatedProjectInfoForWeb(IProject project, boolean runProjectInitInBackgroud, boolean waitForInit, IProgressMonitor monitor) {
        return this.getAnnotatedProjectInfo(project, WEB_LIST, this.getWebAnnotationList(), runProjectInitInBackgroud, waitForInit, monitor);
    }

    public AnnotatedProjectInfo getAnnotatedProjectInfoForJSF(IProject project, boolean runProjectInitInBackgroud, boolean waitForInit) {
        return this.getAnnotatedProjectInfoForJSF(project, runProjectInitInBackgroud, waitForInit, null);
    }

    public AnnotatedProjectInfo getAnnotatedProjectInfoForJSF(IProject project, boolean runProjectInitInBackgroud, boolean waitForInit, IProgressMonitor monitor) {
        return this.getAnnotatedProjectInfo(project, JSF_LIST, this.getJSFAnnotationList(), runProjectInitInBackgroud, waitForInit, monitor);
    }

    public AnnotatedProjectInfo getAnnotatedProjectInfoForJCDI(IProject project, boolean runProjectInitInBackgroud, boolean waitForInit) {
        return this.getAnnotatedProjectInfoForJCDI(project, runProjectInitInBackgroud, waitForInit, null);
    }

    public AnnotatedProjectInfo getAnnotatedProjectInfoForJCDI(IProject project, boolean runProjectInitInBackgroud, boolean waitForInit, IProgressMonitor monitor) {
        return this.getAnnotatedProjectInfo(project, JCDI_LIST, this.getJCDIAnnotationList(), runProjectInitInBackgroud, waitForInit, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AnnotatedProjectInfo getAnnotatedProjectInfo(IProject project, String key, String[] annotationNames, boolean runProjectInitInBackgroud, boolean waitForInit, IProgressMonitor monitor) {
        if (project != null || key == null || key.length() < 1) {
            String newKey = new StringBuffer(key).append("_").append(project.getName()).toString();
            AnnotatedProjectInfo api = null;
            Hashtable<String, SoftReference<AnnotatedProjectInfo>> hashtable = this.localCache;
            synchronized (hashtable) {
                SoftReference<AnnotatedProjectInfo> softApi = this.localCache.get(newKey);
                if (softApi != null) {
                    api = softApi.get();
                }
                if (api == null) {
                    try {
                        api = new AnnotatedProjectInfo(project, annotationNames, runProjectInitInBackgroud, monitor);
                        SoftReference<AnnotatedProjectInfo> softApi1 = new SoftReference<AnnotatedProjectInfo>(api);
                        this.localCache.put(newKey, softApi1);
                    }
                    catch (Exception e) {
                        CodegenPlugin.log("Exception creating AnnotatedProjectInfo: ", e);
                    }
                }
            }
            if (api != null && waitForInit) {
                this.waitForInit(api, monitor);
            }
            return api;
        }
        return null;
    }

    private void waitForInit(AnnotatedProjectInfo api, IProgressMonitor monitor) {
        int preventInfLoopCount = 0;
        while (!api.isInitialized()) {
            if (monitor != null && monitor.isCanceled()) break;
            try {
                Thread.sleep(200L);
                if (preventInfLoopCount > 250) {
                    return;
                }
            }
            catch (InterruptedException interruptedException) {
                break;
            }
            ++preventInfLoopCount;
        }
    }

    public void elementChanged(ElementChangedEvent event) {
        IJavaElementDelta delta;
        if (event.getType() == 1 && (delta = event.getDelta()).getKind() == 4) {
            List<IJavaElementDelta> allLeafDeltas = InternalUtils.getLeafDeltas(delta);
            int cx = 0;
            while (cx < allLeafDeltas.size()) {
                IJavaElementDelta leafDelta = allLeafDeltas.get(cx);
                IJavaElement el = leafDelta.getElement();
                if (el == null || el.getJavaProject() == null) {
                    return;
                }
                String sProjName = el.getJavaProject().getProject().getName();
                SoftReference<AnnotatedProjectInfo> softApi = this.localCache.get(sProjName);
                AnnotatedProjectInfo api = null;
                if (softApi != null) {
                    api = softApi.get();
                }
                if (api != null) {
                    api.elementChanged(event);
                }
                ++cx;
            }
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResource deltaRes = event.getResource();
        if (deltaRes.getType() == 4) {
            String newKey;
            String projectName = deltaRes.getName();
            if (this.localCache.containsKey(projectName)) {
                this.localCache.remove(projectName);
            }
            if (this.localCache.containsKey(newKey = new StringBuffer(EJB_LIST).append("_").append(projectName).toString())) {
                this.localCache.remove(newKey);
            }
            if (this.localCache.containsKey(newKey = new StringBuffer(WEB_LIST).append("_").append(projectName).toString())) {
                this.localCache.remove(newKey);
            }
            if (this.localCache.containsKey(newKey = new StringBuffer(JCDI_LIST).append("_").append(projectName).toString())) {
                this.localCache.remove(newKey);
            }
        }
    }

    public AnnotatedProjectInfo getCachedAnnotatedProjectInfo(IProject project, String type) {
        String newKey;
        SoftReference<AnnotatedProjectInfo> softApi;
        AnnotatedProjectInfo api = null;
        if (type != null && (softApi = this.localCache.get(newKey = new StringBuffer(type).append("_").append(project.getName()).toString())) != null) {
            api = softApi.get();
        }
        return api;
    }
}

