/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.annotations.core.data;

import com.ibm.etools.annotations.core.data.AnnotationInfo;
import com.ibm.etools.annotations.core.data.AnnotationInfoPG;
import com.ibm.etools.annotations.core.data.JavaElementInfo;
import com.ibm.etools.annotations.core.data.JavaElementInfoPG;
import com.ibm.etools.annotations.core.internal.jobs.AnnotationModelUpdateJob;
import com.ibm.etools.annotations.core.internal.jobs.AnnotationModelUpdateJobManager;
import com.ibm.etools.annotations.core.internal.utils.InternalUtils;
import com.ibm.etools.annotations.core.model.IAnnotationAttributeProperty;
import com.ibm.etools.annotations.core.properties.ArrayArgumentProperty;
import com.ibm.etools.annotations.core.properties.SingleValueArgumentProperty;
import com.ibm.etools.annotations.core.utils.AnnotationUtils;
import com.ibm.propertygroup.IPropertyDescriptor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class AnnotatedClassInfo
extends JavaElementInfo {
    private IJavaElement cu;
    private List impliedOnlyAnnotationInfos;
    private boolean isUpdating_ = false;
    protected AnnotationModelUpdateJobManager updateManager_ = new AnnotationModelUpdateJobManager();

    public AnnotatedClassInfo(IJavaElement cu) throws CoreException {
        super(cu, null);
        this.cu = cu;
        this.impliedOnlyAnnotationInfos = new ArrayList();
    }

    public IJavaElement getJavaElementForThisClass() {
        return this.cu;
    }

    private ArrayList resolveImpliedAnnotations(IJavaProject project, JavaElementInfo prop, ArrayList impliedList) {
        ArrayList<AnnotationInfo> newImpliedList = new ArrayList<AnnotationInfo>();
        List<AnnotationInfo> existingList = AnnotationUtils.getAnnotationInfosFromJavaElementInfo(prop);
        int l = 0;
        while (l < impliedList.size()) {
            boolean found = false;
            int k = 0;
            while (k < existingList.size()) {
                if (existingList.get(k) instanceof AnnotationInfo) {
                    AnnotationInfo existingAnno = existingList.get(k);
                    String longName = AnnotationUtils.getFullyQaulifiedAnnotationName(existingAnno);
                    if (impliedList.get(l).equals(longName)) {
                        if (existingAnno.getDeclaredAttributes() != null) {
                            existingAnno.setIsImpliedAnnotation(false);
                        } else {
                            existingAnno.setIsImpliedAnnotation(true);
                        }
                        found = true;
                    }
                }
                ++k;
            }
            if (!found) {
                String annoName = AnnotationUtils.getAnnoNameFromLongName((String)impliedList.get(l));
                String pkName = AnnotationUtils.getAnnoPackageNameFromLongName((String)impliedList.get(l));
                IJavaElement je = prop.getJavaElement();
                try {
                    List<IAnnotationAttributeProperty> attrs;
                    AnnotationInfo newImplied = AnnotationUtils.getResolvedImpliedAnnotations(project, annoName, pkName, je);
                    if (newImplied == null) {
                        newImplied = new AnnotationInfo(annoName, -1, null);
                        newImplied.setIsImpliedAnnotation(true);
                        newImplied.setCategorizationKey(pkName);
                        newImplied.setPackageName(pkName);
                        if (prop != null) {
                            newImplied.setParent(prop.getParent());
                            newImplied.setJavaElement(je);
                            newImplied.setJavaElementInfo(prop);
                        }
                    } else {
                        newImplied.setIsImpliedAnnotation(true);
                        if (prop != null) {
                            newImplied.setParent(prop.getParent());
                            newImplied.setJavaElement(je);
                            newImplied.setJavaElementInfo(prop);
                        }
                    }
                    if ((attrs = newImplied.getAllAttributes()) != null) {
                        int i = 0;
                        while (i < attrs.size()) {
                            ArrayArgumentProperty ap;
                            if (attrs.get(i) instanceof SingleValueArgumentProperty) {
                                SingleValueArgumentProperty sp = (SingleValueArgumentProperty)attrs.get(i);
                                if (sp.getImpliedValue() == null) {
                                    sp.setImpliedValue(sp.getImpliedValueFromExtension());
                                }
                            } else if (attrs.get(i) instanceof ArrayArgumentProperty && (ap = (ArrayArgumentProperty)attrs.get(i)).getImpliedValue() == null) {
                                ap.setImpliedValue(ap.getImpliedValueFromExtension());
                            }
                            ++i;
                        }
                    }
                    newImpliedList.add(newImplied);
                    this.impliedOnlyAnnotationInfos.add(newImplied);
                    prop.getAnnotationInfoPG().addProperty((IPropertyDescriptor)newImplied);
                    InternalUtils.applyExternalCustomization(newImplied);
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
            ++l;
        }
        return newImpliedList;
    }

    private List<AnnotationInfo> getImpliedAnnotationsFromExtension(IJavaProject project, JavaElementInfo prop) {
        ArrayList newAnnoImpliedList = new ArrayList();
        ArrayList newAnnoImpliedList2 = new ArrayList();
        List<AnnotationInfo> existingList = AnnotationUtils.getAnnotationInfosFromJavaElementInfo(prop);
        int v = 0;
        while (v < existingList.size()) {
            AnnotationInfo anno = existingList.get(v);
            String tagName = anno.getName();
            String pkName = null;
            if (anno.getCategorizationKey() != null) {
                pkName = anno.getCategorizationKey();
            } else if (anno.getPackageName() != null) {
                pkName = anno.getPackageName();
            }
            String packageName = pkName;
            StringBuffer tag = new StringBuffer();
            if (packageName != null) {
                tag.append(packageName);
                tag.append(".");
            }
            tag.append(tagName);
            ArrayList impliedList = null;
            impliedList = AnnotationUtils.getImpliedAnnotationsFromExtensionPoint(tag.toString(), prop.getJavaElement());
            if (impliedList != null) {
                newAnnoImpliedList = this.resolveImpliedAnnotations(project, prop, impliedList);
            }
            IPropertyDescriptor[] childs = prop.getJavaElementInfoPG().getProperties();
            int m = 0;
            while (m < childs.length) {
                JavaElementInfo jelm;
                IPropertyDescriptor prop1 = childs[m];
                if (prop1 instanceof JavaElementInfo && (jelm = (JavaElementInfo)prop1).getJavaElement().getElementType() != 7) {
                    ArrayList impliedList2 = AnnotationUtils.getImpliedAnnotationsFromExtensionPoint(tag.toString(), jelm.getJavaElement());
                    newAnnoImpliedList2 = this.resolveImpliedAnnotations(project, jelm, impliedList2);
                }
                ++m;
            }
            ++v;
        }
        newAnnoImpliedList.addAll(newAnnoImpliedList2);
        return newAnnoImpliedList;
    }

    protected void dumpDetails(String comment, AnnotationInfo an) {
        System.out.println("dumping ..." + comment);
        if (an != null) {
            System.out.println("name=" + an.getName());
            System.out.println("pkkey=" + an.getCategorizationKey());
            System.out.println("anno object=" + an.getAnnotation());
            System.out.println("anno offset=" + an.getOffset());
            System.out.println("JEINfo=" + (Object)((Object)an.getParentJavaElementInfo()));
            List<IAnnotationAttributeProperty> attrs = an.getAllAttributes();
            if (attrs != null) {
                int i = 0;
                while (i < attrs.size()) {
                    System.out.println("name=" + attrs.get(i).getName());
                    System.out.println("default value" + attrs.get(i).getDefaultValue(true));
                    System.out.println("implied value=" + attrs.get(i).getImpliedValue());
                    ++i;
                }
            }
            if (an.getAllAttributes() != null) {
                System.out.println("attr size=" + an.getAllAttributes().size());
            } else {
                System.out.println("no attributes");
            }
            if (an.getJavaElem() != null) {
                System.out.println("Java Name=" + an.getJavaElem().getElementName());
                System.out.println("Java Type=" + an.getJavaElem().getElementType());
            } else {
                System.out.println(" no javaElement");
            }
            if (an.getScopes() != null) {
                System.out.println(an.getScopes().size());
                System.out.println(an.getScopes().toString());
            }
        }
    }

    public void calculateAllImpliedAnnotations(IJavaProject project) {
        ArrayList<AnnotationInfo> newAnnoImpliedList = new ArrayList<AnnotationInfo>();
        IPropertyDescriptor[] descrs = this.getAnnotationInfoPG().getProperties();
        int v = 0;
        while (v < descrs.length) {
            if (descrs[v] instanceof AnnotationInfo) {
                AnnotationInfo anno = (AnnotationInfo)descrs[v];
                String tagName = anno.getName();
                String packageName = anno.getCategorizationKey();
                int offset = anno.getOffset();
                StringBuffer tag = new StringBuffer(packageName);
                tag.append(".");
                tag.append(tagName);
                ArrayList impliedList = AnnotationUtils.getImpliedAnnotationsFromExtensionPoint(tag.toString(), anno.getJavaElem());
                if (impliedList != null) {
                    int l = 0;
                    while (l < impliedList.size()) {
                        boolean found = false;
                        int k = 0;
                        while (k < descrs.length) {
                            if (descrs[k] instanceof AnnotationInfo) {
                                AnnotationInfo implied1 = (AnnotationInfo)descrs[k];
                                String longName = AnnotationUtils.getFullyQaulifiedAnnotationName(implied1);
                                if (impliedList.get(l).equals(longName)) {
                                    implied1.setIsImpliedAnnotation(true);
                                    found = true;
                                }
                            }
                            ++k;
                        }
                        if (!found) {
                            String annoName = AnnotationUtils.getAnnoNameFromLongName((String)impliedList.get(l));
                            String pkName = AnnotationUtils.getAnnoPackageNameFromLongName((String)impliedList.get(l));
                            AnnotationInfo newImplied = null;
                            IJavaElement je = this.getJavaElement();
                            newImplied = AnnotationUtils.getResolvedImpliedAnnotations(project, annoName, pkName, je);
                            try {
                                if (newImplied == null) {
                                    newImplied = new AnnotationInfo(annoName, -1, null);
                                    newImplied.setCategorizationKey(pkName);
                                    newImplied.setPackageName(pkName);
                                    if (je != null) {
                                        newImplied.setJavaElement(je);
                                    }
                                    newImplied.setIsImpliedAnnotation(true);
                                    newImplied.setParent((IPropertyDescriptor)this);
                                    newImplied.setOffset(offset);
                                } else {
                                    if (je != null) {
                                        newImplied.setJavaElement(je);
                                    }
                                    newImplied.setIsImpliedAnnotation(true);
                                    newImplied.setParent((IPropertyDescriptor)this);
                                    newImplied.setOffset(offset);
                                }
                                newAnnoImpliedList.add(newImplied);
                                this.impliedOnlyAnnotationInfos.add(newImplied);
                                this.getAnnotationInfoPG().addProperty((IPropertyDescriptor)newImplied);
                                InternalUtils.applyExternalCustomization(newImplied);
                            }
                            catch (Exception exc) {
                                exc.printStackTrace();
                            }
                        }
                        ++l;
                    }
                }
            }
            ++v;
        }
        IPropertyDescriptor[] childs = this.getJavaElementInfoPG().getProperties();
        int m = 0;
        while (m < childs.length) {
            List<AnnotationInfo> newImpliedAnnoLists;
            IPropertyDescriptor prop = childs[m];
            if (prop instanceof JavaElementInfo && (newImpliedAnnoLists = this.getImpliedAnnotationsFromExtension(project, (JavaElementInfo)prop)) != null) {
                int k = 0;
                while (k < newImpliedAnnoLists.size()) {
                    ((JavaElementInfo)prop).getAnnotationInfoPG().addProperty((IPropertyDescriptor)newImpliedAnnoLists.get(k));
                    ++k;
                }
            }
            ++m;
        }
    }

    public List getImpliedOnlyAnnotations() {
        return this.impliedOnlyAnnotationInfos;
    }

    public void elementChanged(ElementChangedEvent event) {
        IJavaElementDelta delta = event.getDelta();
        switch (event.getType()) {
            case 1: {
                IJavaElementDelta cDelta = this.getChangedDelta(delta);
                if (cDelta == null || !this.cu.exists()) break;
                this.updateManager_.performModelUpdate(new AnnotatedClassInfoUpdateJob((IPropertyDescriptor)this));
                break;
            }
            default: {
                CompilationUnit astUnit = delta.getCompilationUnitAST();
                if (astUnit == null || astUnit.getTypeRoot() == null || !astUnit.getTypeRoot().equals(this.cu)) break;
                this.cu = astUnit.getTypeRoot();
                if (!this.cu.exists()) break;
                this.updateManager_.performModelUpdate(new AnnotatedClassInfoUpdateJob((IPropertyDescriptor)this));
            }
        }
    }

    public void makeSourceListener(boolean set) {
    }

    public void makeSourceListener() {
    }

    protected IJavaElementDelta getChangedDelta(IJavaElementDelta delta) {
        int kind = delta.getKind();
        if (kind == 4) {
            int i;
            int flags = delta.getFlags();
            IJavaElement element = delta.getElement();
            if (element instanceof IJavaModel) {
                if ((flags & 8) == 0) {
                    return null;
                }
            } else if (element instanceof IJavaProject) {
                if (element.equals(this.cu.getJavaProject())) {
                    if (this.evaluateLeafChildreb(delta)) {
                        return delta;
                    }
                    if ((flags & 0x20000) != 0) {
                        return delta;
                    }
                    IResourceDelta[] deltas = delta.getResourceDeltas();
                    if (deltas != null) {
                        i = 0;
                        while (i < deltas.length) {
                            if (deltas[i].getProjectRelativePath().toString().equals(".classpath")) {
                                return delta;
                            }
                            ++i;
                        }
                    }
                }
            } else if (element instanceof ICompilationUnit) {
                ICompilationUnit icu = (ICompilationUnit)element;
                if (icu.equals(this.cu)) {
                    return delta;
                }
                return null;
            }
            IJavaElementDelta[] children = delta.getChangedChildren();
            i = 0;
            while (i < children.length) {
                IJavaElementDelta cDelta = this.getChangedDelta(children[i]);
                if (cDelta != null) {
                    return cDelta;
                }
                ++i;
            }
        }
        return null;
    }

    protected boolean evaluateLeafChildreb(IJavaElementDelta delta) {
        boolean movedTo = false;
        boolean movedFrom = false;
        boolean content = false;
        List<IJavaElementDelta> dds = InternalUtils.getLeafDeltas(delta);
        int c = 0;
        while (c < dds.size()) {
            ICompilationUnit cuNew;
            IJavaElement astUnit;
            IJavaElementDelta del = dds.get(c);
            int flags = del.getFlags();
            if ((flags & 0x20) != 0) {
                movedTo = true;
            }
            if ((flags & 0x10) != 0) {
                movedFrom = true;
            }
            if ((flags & 1) != 0 && (astUnit = del.getElement()) instanceof ICompilationUnit && (cuNew = (ICompilationUnit)astUnit) != null && this.cu.getElementName().equals(cuNew.getElementName())) {
                content = true;
            }
            ++c;
        }
        return movedTo && movedFrom && content;
    }

    public void waitForModelUpdating() {
        int loopCounter = 25;
        while (this.isUpdating_ && loopCounter > 0) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
            --loopCounter;
        }
    }

    @Override
    public AnnotationInfoPG getAnnotationInfoPG() {
        if (this.isUpdating_) {
            this.waitForModelUpdating();
        }
        return super.getAnnotationInfoPG();
    }

    @Override
    public JavaElementInfoPG getJavaElementInfoPG() {
        if (this.isUpdating_) {
            this.waitForModelUpdating();
        }
        return super.getJavaElementInfoPG();
    }

    public List<AnnotationInfo> getAnnotationInfos(boolean includeChildrenOnly) {
        AnnotationInfoPG pg;
        ArrayList<AnnotationInfo> res = new ArrayList<AnnotationInfo>();
        if (!includeChildrenOnly && (pg = this.getAnnotationInfoPG()) != null) {
            IPropertyDescriptor[] descrs = pg.getProperties();
            int v = 0;
            while (v < descrs.length) {
                res.add((AnnotationInfo)descrs[v]);
                ++v;
            }
        }
        if (this.getJavaElementInfoPG() != null) {
            IPropertyDescriptor[] childs = this.getJavaElementInfoPG().getProperties();
            int m = 0;
            while (m < childs.length) {
                IPropertyDescriptor prop = childs[m];
                if (prop instanceof JavaElementInfo) {
                    res.addAll(AnnotationUtils.getAnnotationInfosFromJavaElementInfo((JavaElementInfo)prop));
                }
                ++m;
            }
        }
        return res;
    }

    protected void changeParent() {
        IPropertyDescriptor[] contents = this.javaElementInfoPG.getProperties();
        int i = 0;
        while (i < contents.length) {
            ((JavaElementInfo)contents[i]).setParentJavaElementInfo(this);
            ++i;
        }
        contents = this.annotationInfoPG.getProperties();
        i = 0;
        while (i < contents.length) {
            ((AnnotationInfo)contents[i]).setParentElementInfo((Object)this);
            ++i;
        }
    }

    @Override
    public String toString() {
        return new StringBuffer(super.toString()).append(", AnnotationInfos: ").append(this.getAnnotationInfos(false).size()).toString();
    }

    protected class AnnotatedClassInfoUpdateJob
    extends AnnotationModelUpdateJob {
        public AnnotatedClassInfoUpdateJob(IPropertyDescriptor model) {
            super(model);
        }

        protected IStatus run(IProgressMonitor monitor) {
            switch (this.updateType_) {
                case 1: {
                    break;
                }
                default: {
                    AnnotatedClassInfo info = AnnotationUtils.getAnnotatedClassInfo(AnnotatedClassInfo.this.cu);
                    AnnotatedClassInfo.this.isUpdating_ = true;
                    if (info == null) {
                        AnnotatedClassInfo.this.annotationInfoPG.removeAll();
                        AnnotatedClassInfo.this.javaElementInfoPG.removeAll();
                    } else {
                        AnnotatedClassInfo.this.javaElementInfoPG.replaceAll((IPropertyDescriptor[])info.getJavaElementInfoObjects());
                        AnnotatedClassInfo.this.annotationInfoPG.replaceAll((IPropertyDescriptor[])info.getAnnotationInfoObjects());
                        AnnotatedClassInfo.this.changeParent();
                    }
                    AnnotatedClassInfo.this.isUpdating_ = false;
                    this.firePropertyInValid();
                }
            }
            return Status.OK_STATUS;
        }

        public synchronized void firePropertyInValid() {
            AnnotatedClassInfo.this.propertyChanges.firePropertyInValid();
        }
    }
}

