/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.j2c.internal.codegen.util;

import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;

public class ParamType {
    public static int VOID = 0;
    public static int INT = 1;
    public static int CHAR = 2;
    public static int BYTE = 3;
    public static int SHORT = 4;
    public static int LONG = 5;
    public static int FLOAT = 6;
    public static int DOUBLE = 7;
    public static int BOOLEAN = 8;
    private static final String[] PRIMITIVES = new String[]{"void", "int", "char", "byte", "short", "long", "float", "double", "boolean"};
    private boolean isArray = false;
    private int primitive = -1;
    private String name = null;

    public ParamType() {
        this(VOID);
    }

    public ParamType(int value) {
        this.primitive = value;
    }

    public ParamType(String value) {
        int i = 0;
        while (i < PRIMITIVES.length) {
            if (PRIMITIVES[i].equalsIgnoreCase(value)) {
                this.primitive = i;
                break;
            }
            ++i;
        }
        this.name = value;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public void setArray(boolean array) {
        this.isArray = array;
    }

    public boolean isPrimitive() {
        return this.primitive != -1;
    }

    public int getPrimitiveType() {
        return this.primitive;
    }

    public String getName() {
        return this.name;
    }

    public Type createType(AST ast) {
        Type type = null;
        if (this.isPrimitive()) {
            if (this.primitive == VOID) {
                type = ast.newPrimitiveType(PrimitiveType.VOID);
            }
            if (this.primitive == INT) {
                type = ast.newPrimitiveType(PrimitiveType.INT);
            }
            if (this.primitive == CHAR) {
                type = ast.newPrimitiveType(PrimitiveType.CHAR);
            }
            if (this.primitive == BYTE) {
                type = ast.newPrimitiveType(PrimitiveType.BYTE);
            }
            if (this.primitive == SHORT) {
                type = ast.newPrimitiveType(PrimitiveType.SHORT);
            }
            if (this.primitive == LONG) {
                type = ast.newPrimitiveType(PrimitiveType.LONG);
            }
            if (this.primitive == FLOAT) {
                type = ast.newPrimitiveType(PrimitiveType.FLOAT);
            }
            if (this.primitive == DOUBLE) {
                type = ast.newPrimitiveType(PrimitiveType.DOUBLE);
            }
            if (this.primitive == BOOLEAN) {
                type = ast.newPrimitiveType(PrimitiveType.BOOLEAN);
            }
        } else {
            type = this.deriveASTType(ast, this.getName());
        }
        if (this.isArray()) {
            type = ast.newArrayType(type);
        }
        return type;
    }

    private Type deriveASTType(AST ast, String value) {
        SimpleType type = ast.newSimpleType(ast.newName(value));
        return type;
    }
}

