/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.j2c.internal.codegen.inbound.validation;

import com.ibm.adapter.j2c.internal.MessageResource;
import com.ibm.etools.annotations.core.api.TriggerAnnotationListener;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.osgi.util.NLS;

public class InboundAdapterValidator
extends TriggerAnnotationListener {
    public static final String VALIDATION_TARGET = "target";
    public static final String VALIDATION_OWNER = "owner";
    public static final String VALIDATION_OWNER_ID = "j2c.adapter.inbound";
    public static final String VALIDATION_TRIGGER = "trigger";
    public static final String VALIDATION_TRIGGER_ANNOTATION_CHANGED = "changed";
    public static final String VALIDATION_TRIGGER_ANNOTATION_ADDED = "added";
    public static final String VALIDATION_TRIGGER_ANNOTATION_REMOVED = "removed";
    public static final String VALIDATION_MARKER_TYPE = "com.ibm.adapter.j2c.codegen.J2CInboundBeanAnnotationMarker";

    @Override
    public void annotationChanged(IAnnotation annotation) {
        if (!this.isValidContext(annotation)) {
            return;
        }
        IJavaElement parent = annotation.getParent();
        if ("Local".equals(annotation.getElementName())) {
            if (!this.alreadyMarked(parent, VALIDATION_TRIGGER_ANNOTATION_CHANGED, "Local")) {
                this.createAnnotationMarker(VALIDATION_TRIGGER_ANNOTATION_CHANGED, parent, "Local", NLS.bind((String)MessageResource.LOCAL_ANNOTATION_CHANGE_VALIDATION_MSG, (Object)"@Local"));
            } else {
                IType declaringType = (IType)parent;
                String localInterfaceName = null;
                try {
                    String interfaceName;
                    String[] superInterfaceNames = declaringType.getSuperInterfaceNames();
                    if (superInterfaceNames != null && superInterfaceNames.length > 0) {
                        localInterfaceName = superInterfaceNames[0];
                    }
                    if ((interfaceName = (String)annotation.getMemberValuePairs()[0].getValue()).equals(localInterfaceName)) {
                        this.cleanupDeadMarkers(annotation);
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
        }
    }

    @Override
    public void annotationAdded(IAnnotation annotation) {
        if (!this.isValidContext(annotation)) {
            return;
        }
        this.cleanupDeadMarkers(annotation);
    }

    @Override
    public void annotationRemoved(IAnnotation annotation) {
        if (!this.isValidContext(annotation)) {
            return;
        }
        IJavaElement parent = annotation.getParent();
        if ("Local".equals(annotation.getElementName())) {
            if (!this.isDuplicate(annotation) && !this.alreadyMarked(parent, VALIDATION_TRIGGER_ANNOTATION_REMOVED, "Local")) {
                IType declaringType = (IType)parent;
                String localInterfaceName = null;
                try {
                    String[] superInterfaceNames = declaringType.getSuperInterfaceNames();
                    if (superInterfaceNames != null && superInterfaceNames.length > 0) {
                        localInterfaceName = superInterfaceNames[0];
                    }
                }
                catch (JavaModelException javaModelException) {}
                this.createAnnotationMarker(VALIDATION_TRIGGER_ANNOTATION_REMOVED, parent, "Local", NLS.bind((String)MessageResource.LOCAL_ANNOTATION_REMOVE_VALIDATION_MSG, (Object)"@Local", localInterfaceName));
            }
        } else if ("Stateless".equals(annotation.getElementName())) {
            if (!this.isDuplicate(annotation) && !this.alreadyMarked(parent, VALIDATION_TRIGGER_ANNOTATION_REMOVED, "Stateless")) {
                this.createAnnotationMarker(VALIDATION_TRIGGER_ANNOTATION_REMOVED, parent, "Stateless", NLS.bind((String)MessageResource.TYPE_ANNOTATION_REMOVE_VALIDATION_MSG, (Object)"@Stateless"));
            }
        } else if ("MessageDriven".equals(annotation.getElementName())) {
            if (!this.isDuplicate(annotation) && !this.alreadyMarked(parent, VALIDATION_TRIGGER_ANNOTATION_REMOVED, "MessageDriven")) {
                this.createAnnotationMarker(VALIDATION_TRIGGER_ANNOTATION_REMOVED, parent, "MessageDriven", NLS.bind((String)MessageResource.TYPE_ANNOTATION_REMOVE_VALIDATION_MSG, (Object)"@MessageDriven"));
            }
        } else if ("EJB".equals(annotation.getElementName()) && parent instanceof IField) {
            if (!this.isDuplicate(annotation) && !this.alreadyMarked(parent, VALIDATION_TRIGGER_ANNOTATION_REMOVED, "EJB")) {
                try {
                    IField declaringField = (IField)parent;
                    String fieldType = Signature.toString((String)declaringField.getTypeSignature());
                    String fieldName = declaringField.getElementName();
                    String fieldDeclaration = "private " + fieldType + " " + fieldName;
                    this.createAnnotationMarker(VALIDATION_TRIGGER_ANNOTATION_REMOVED, parent, "EJB", NLS.bind((String)MessageResource.EJB_ANNOTATION_REMOVE_VALIDATION_MSG, (Object)fieldDeclaration, (Object)"@EJB"));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (JavaModelException javaModelException) {}
            }
        } else if ("PostConstruct".equals(annotation.getElementName())) {
            if (!this.isDuplicate(annotation) && !this.alreadyMarked(parent, VALIDATION_TRIGGER_ANNOTATION_REMOVED, "PostConstruct")) {
                IMethod declaringMethod = (IMethod)parent;
                this.createAnnotationMarker(VALIDATION_TRIGGER_ANNOTATION_REMOVED, parent, "PostConstruct", NLS.bind((String)MessageResource.POST_CONSTRUCT_ANNOTATION_REMOVE_VALIDATION_MSG, (Object[])new String[]{declaringMethod.getElementName(), "@PostConstruct", "@PostConstruct"}));
            }
        } else if ("PreDestroy".equals(annotation.getElementName()) && !this.isDuplicate(annotation) && !this.alreadyMarked(parent, VALIDATION_TRIGGER_ANNOTATION_REMOVED, "PreDestroy")) {
            IMethod declaringMethod = (IMethod)parent;
            this.createAnnotationMarker(VALIDATION_TRIGGER_ANNOTATION_REMOVED, parent, "PreDestroy", NLS.bind((String)MessageResource.PRE_DESTROY_ANNOTATION_REMOVE_VALIDATION_MSG, (Object)declaringMethod.getElementName(), (Object)"@PreDestroy"));
        }
    }

    @Override
    public void affectedElement(IJavaElement affectedElement, IJavaElementDelta delta, String annotationName) {
    }

    private int computeLineNumber(IType type, IField field, IMethod method) {
        int lineNumber = 0;
        try {
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setSource(type.getCompilationUnit());
            parser.setResolveBindings(true);
            CompilationUnit astCU = (CompilationUnit)parser.createAST(null);
            TypeVisitor typeVisitor = new TypeVisitor(astCU, type, field, method);
            astCU.accept((ASTVisitor)typeVisitor);
            lineNumber = typeVisitor.getNodeLineNumber();
        }
        catch (IllegalStateException illegalStateException) {}
        return lineNumber;
    }

    private boolean isValidContext(IAnnotation annotation) {
        IJavaElement parent = annotation.getParent();
        String[] typeAnnotationNames = null;
        String methodAnnotationName = null;
        String fieldAnnotationName = null;
        if ("Local".equals(annotation.getElementName())) {
            typeAnnotationNames = new String[]{"Stateless"};
            methodAnnotationName = "InboundMethodBinding";
        } else if ("Stateless".equals(annotation.getElementName())) {
            typeAnnotationNames = new String[]{"Local"};
            methodAnnotationName = "InboundMethodBinding";
        } else if ("MessageDriven".equals(annotation.getElementName())) {
            typeAnnotationNames = new String[]{"InboundAdapter"};
        } else if ("EJB".equals(annotation.getElementName()) && parent instanceof IField || "PostConstruct".equals(annotation.getElementName()) || "PreDestroy".equals(annotation.getElementName())) {
            typeAnnotationNames = new String[]{"MessageDriven", "InboundAdapter"};
        }
        if (typeAnnotationNames == null) {
            return false;
        }
        IType declaringType = null;
        IField declaringField = null;
        IMethod declaringMethod = null;
        if (parent instanceof IType) {
            declaringType = (IType)parent;
            if (typeAnnotationNames != null) {
                String[] stringArray = typeAnnotationNames;
                int n = typeAnnotationNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String typeAnnotationName = stringArray[n2];
                    IAnnotation typeAnnotation = declaringType.getAnnotation(typeAnnotationName);
                    if (!typeAnnotation.exists()) {
                        return false;
                    }
                    ++n2;
                }
                if (methodAnnotationName != null) {
                    try {
                        IMethod[] methods = declaringType.getMethods();
                        boolean validContext = false;
                        IMethod[] iMethodArray = methods;
                        int typeAnnotation = methods.length;
                        int n3 = 0;
                        while (n3 < typeAnnotation) {
                            IMethod method = iMethodArray[n3];
                            IAnnotation methodAnnotation = method.getAnnotation(methodAnnotationName);
                            if (methodAnnotation.exists()) {
                                validContext = true;
                                break;
                            }
                            ++n3;
                        }
                        if (!validContext) {
                            return false;
                        }
                    }
                    catch (JavaModelException javaModelException) {
                        return false;
                    }
                }
            }
        } else if (parent instanceof IField) {
            IAnnotation fieldAnnotation;
            declaringField = (IField)parent;
            declaringType = declaringField.getDeclaringType();
            if (typeAnnotationNames != null) {
                String[] stringArray = typeAnnotationNames;
                int n = typeAnnotationNames.length;
                int n4 = 0;
                while (n4 < n) {
                    String typeAnnotationName = stringArray[n4];
                    IAnnotation typeAnnotation = declaringType.getAnnotation(typeAnnotationName);
                    if (!typeAnnotation.exists()) {
                        return false;
                    }
                    ++n4;
                }
            }
            if (fieldAnnotationName != null && !(fieldAnnotation = declaringField.getAnnotation(fieldAnnotationName)).exists()) {
                return false;
            }
        } else if (parent instanceof IMethod) {
            IAnnotation methodAnnotation;
            declaringMethod = (IMethod)parent;
            declaringType = declaringMethod.getDeclaringType();
            if (typeAnnotationNames != null) {
                String[] stringArray = typeAnnotationNames;
                int n = typeAnnotationNames.length;
                int n5 = 0;
                while (n5 < n) {
                    String typeAnnotationName = stringArray[n5];
                    IAnnotation typeAnnotation = declaringType.getAnnotation(typeAnnotationName);
                    if (!typeAnnotation.exists()) {
                        return false;
                    }
                    ++n5;
                }
            }
            if (methodAnnotationName != null && !(methodAnnotation = declaringMethod.getAnnotation(methodAnnotationName)).exists()) {
                return false;
            }
        }
        return true;
    }

    private void createAnnotationMarker(String validationTrigger, IJavaElement parent, String problemAnnotationName, String errorMessage) {
        IType declaringType = null;
        IField declaringField = null;
        IMethod declaringMethod = null;
        try {
            if (parent instanceof IType) {
                declaringType = (IType)parent;
            } else if (parent instanceof IField) {
                declaringField = (IField)parent;
                declaringType = declaringField.getDeclaringType();
            } else if (parent instanceof IMethod) {
                declaringMethod = (IMethod)parent;
                declaringType = declaringMethod.getDeclaringType();
            }
            IMarker marker = declaringType.getResource().createMarker(VALIDATION_MARKER_TYPE);
            HashMap<String, Object> attribuets = new HashMap<String, Object>();
            int lineNumber = this.computeLineNumber(declaringType, declaringField, declaringMethod);
            attribuets.put(VALIDATION_OWNER, VALIDATION_OWNER_ID);
            attribuets.put(VALIDATION_TARGET, problemAnnotationName);
            if (VALIDATION_TRIGGER_ANNOTATION_CHANGED.equals(validationTrigger)) {
                attribuets.put(VALIDATION_TRIGGER, VALIDATION_TRIGGER_ANNOTATION_CHANGED);
                attribuets.put("lineNumber", new Integer(lineNumber - 1));
            } else if (VALIDATION_TRIGGER_ANNOTATION_ADDED.equals(validationTrigger)) {
                attribuets.put(VALIDATION_TRIGGER, VALIDATION_TRIGGER_ANNOTATION_ADDED);
            } else if (VALIDATION_TRIGGER_ANNOTATION_REMOVED.equals(validationTrigger)) {
                attribuets.put(VALIDATION_TRIGGER, VALIDATION_TRIGGER_ANNOTATION_REMOVED);
                attribuets.put("lineNumber", new Integer(lineNumber));
            }
            attribuets.put("severity", new Integer(2));
            if (declaringField != null) {
                String ejbFieldType = Signature.toString((String)declaringField.getTypeSignature());
                attribuets.put("message", errorMessage);
                attribuets.put("sourceId", ejbFieldType);
            } else if (declaringMethod != null) {
                attribuets.put("message", errorMessage);
                attribuets.put("sourceId", declaringMethod.getElementName());
            } else {
                attribuets.put("message", errorMessage);
            }
            marker.setAttributes(attribuets);
        }
        catch (CoreException coreException) {}
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean alreadyMarked(IJavaElement javaElement, String validationTrigger, String problemAnnotationName) {
        IType declaringType = null;
        if (javaElement instanceof IType) {
            declaringType = (IType)javaElement;
        } else if (javaElement instanceof IField) {
            declaringType = ((IField)javaElement).getDeclaringType();
        } else if (javaElement instanceof IMethod) {
            declaringType = ((IMethod)javaElement).getDeclaringType();
        }
        try {
            IMarker[] markers = declaringType.getResource().findMarkers(VALIDATION_MARKER_TYPE, false, 2);
            if (markers == null) return false;
            IMarker[] iMarkerArray = markers;
            int n = markers.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IMarker marker = iMarkerArray[n2];
                Object trigger = marker.getAttribute(VALIDATION_TRIGGER);
                Object target = marker.getAttribute(VALIDATION_TARGET);
                if (validationTrigger.equals(trigger) && problemAnnotationName.equals(target)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    private void cleanupDeadMarkers(IAnnotation annotation) {
        IJavaElement parent = annotation.getParent();
        IType declaringType = null;
        if (parent instanceof IType) {
            declaringType = (IType)parent;
        } else if (parent instanceof IField) {
            declaringType = ((IField)parent).getDeclaringType();
        } else if (parent instanceof IMethod) {
            declaringType = ((IMethod)parent).getDeclaringType();
        }
        try {
            IMarker[] markers = declaringType.getResource().findMarkers(VALIDATION_MARKER_TYPE, false, 2);
            if (markers != null) {
                IMarker markerForDelete = null;
                IMarker[] iMarkerArray = markers;
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker marker = iMarkerArray[n2];
                    Object target = marker.getAttribute(VALIDATION_TARGET);
                    if (annotation.getElementName().equals(target)) {
                        markerForDelete = marker;
                        break;
                    }
                    ++n2;
                }
                if (markerForDelete != null) {
                    markerForDelete.delete();
                }
            }
        }
        catch (CoreException coreException) {}
    }

    private boolean isDuplicate(IAnnotation annotation) {
        IJavaElement parent = annotation.getParent();
        String annotationName = annotation.getElementName();
        int annotationCount = 0;
        try {
            IAnnotation[] annotations = null;
            if (parent instanceof IType) {
                annotations = ((IType)parent).getAnnotations();
            } else if (parent instanceof IField) {
                annotations = ((IField)parent).getAnnotations();
            } else if (parent instanceof IMethod) {
                annotations = ((IMethod)parent).getAnnotations();
            }
            IAnnotation[] iAnnotationArray = annotations;
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                IAnnotation ann = iAnnotationArray[n2];
                if (ann.exists() && annotationName.equals(ann.getElementName())) {
                    ++annotationCount;
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {}
        return annotationCount > 0;
    }

    class TypeVisitor
    extends ASTVisitor {
        int nodeLineNumber;
        CompilationUnit astCU;
        IType type;
        IField field;
        IMethod method;

        public TypeVisitor(CompilationUnit astCU, IType type, IField field, IMethod method) {
            this.astCU = astCU;
            this.type = type;
            this.field = field;
            this.method = method;
        }

        public boolean visit(TypeDeclaration node) {
            super.visit(node);
            if (node.getName().getIdentifier().equals(this.type.getElementName())) {
                if (this.field != null) {
                    FieldDeclaration[] fields = node.getFields();
                    if (fields != null) {
                        try {
                            String fieldType = Signature.toString((String)this.field.getTypeSignature());
                            FieldDeclaration[] fieldDeclarationArray = fields;
                            int n = fields.length;
                            int n2 = 0;
                            while (n2 < n) {
                                FieldDeclaration fieldDec = fieldDeclarationArray[n2];
                                if (fieldDec.getType().resolveBinding().getName().equals(fieldType)) {
                                    int startPosition = fieldDec.getStartPosition();
                                    this.nodeLineNumber = this.astCU.getLineNumber(startPosition);
                                    break;
                                }
                                ++n2;
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                        }
                        catch (JavaModelException javaModelException) {}
                    }
                } else if (this.method != null) {
                    MethodDeclaration[] methods = node.getMethods();
                    if (methods != null) {
                        try {
                            MethodDeclaration[] methodDeclarationArray = methods;
                            int n = methods.length;
                            int fieldDec = 0;
                            while (fieldDec < n) {
                                MethodDeclaration methodDec = methodDeclarationArray[fieldDec];
                                if (methodDec.getName().getFullyQualifiedName().equals(this.method.getElementName())) {
                                    int startPosition = methodDec.getStartPosition();
                                    this.nodeLineNumber = this.astCU.getLineNumber(startPosition);
                                    break;
                                }
                                ++fieldDec;
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                    }
                } else {
                    int startPosition = node.getStartPosition();
                    int lineNumber = this.astCU.getLineNumber(startPosition);
                    List modifiers = node.modifiers();
                    this.nodeLineNumber = modifiers.isEmpty() ? lineNumber : lineNumber + modifiers.size();
                }
            }
            return false;
        }

        public int getNodeLineNumber() {
            return this.nodeLineNumber;
        }
    }
}

