/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.j2c.internal.J2CDoclet.util;

import com.ibm.adapter.j2c.internal.CodegenPlugin;
import com.ibm.adapter.j2c.internal.J2CDoclet.BoundedProperty;
import com.ibm.adapter.j2c.internal.J2CDoclet.ClassType;
import com.ibm.adapter.j2c.internal.J2CDoclet.CommandType;
import com.ibm.adapter.j2c.internal.J2CDoclet.ConnectionFactoryType;
import com.ibm.adapter.j2c.internal.J2CDoclet.ConnectionSpecPropertyType;
import com.ibm.adapter.j2c.internal.J2CDoclet.ConnectionSpecPropertyType1;
import com.ibm.adapter.j2c.internal.J2CDoclet.ConnectionSpecType;
import com.ibm.adapter.j2c.internal.J2CDoclet.ConnectionSpecType1;
import com.ibm.adapter.j2c.internal.J2CDoclet.InteractionSpecPropertyType;
import com.ibm.adapter.j2c.internal.J2CDoclet.InteractionSpecReturnPropertyType;
import com.ibm.adapter.j2c.internal.J2CDoclet.InteractionSpecType;
import com.ibm.adapter.j2c.internal.J2CDoclet.InteractionSpecType1;
import com.ibm.adapter.j2c.internal.J2CDoclet.J2CDocletObject;
import com.ibm.adapter.j2c.internal.J2CDoclet.J2CDocletVisitor;
import com.ibm.adapter.j2c.internal.J2CDoclet.J2CMethodTags;
import com.ibm.adapter.j2c.internal.J2CDoclet.J2CTypeTags;
import com.ibm.adapter.j2c.internal.J2CDoclet.ManagedConnectionFactoryPropertyType;
import com.ibm.adapter.j2c.internal.J2CDoclet.ManagedConnectionFactoryType;
import com.ibm.adapter.j2c.internal.J2CDoclet.Property;
import com.ibm.adapter.j2c.internal.J2CDoclet.Wsadie5xStyleType;
import com.ibm.adapter.j2c.internal.J2CDoclet.util.J2CDocletCodeAssist;
import com.ibm.adapter.j2c.internal.J2CDoclet.util.J2CDocletUtil;
import com.ibm.adapter.j2c.internal.MessageResource;
import com.ibm.adapter.j2c.internal.codegen.util.BaseGenerator;
import com.ibm.adapter.j2ca.IResourceAdapterDescriptor;
import com.ibm.zcc.etools.wrd.extensions.util.AnnotationUtil;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.osgi.util.NLS;

public class J2CDocletValidator
implements J2CDocletVisitor {
    static final String NAME_ATTR = "name";
    static final String JNDI_NAME_ATTR = "jndi-name";
    static final String WSDL_ATTR = "wsdl";
    static final String VALUE_ATTR = "value";
    static final String CLASS_ATTR = "class";
    static final String ARG_BINDING_ATTR = "argumentBinding";
    static final String OUTPUT_BINDING_ATTR = "outputBinding";
    IJavaProject project = null;
    IResourceAdapterDescriptor firstDescriptor = null;

    public J2CDocletValidator(IJavaProject project) {
        this.project = project;
    }

    @Override
    public void visit(J2CDocletObject obj) {
    }

    @Override
    public void visit(ConnectionSpecPropertyType obj) {
        this.validateTypeProperty(obj, ((J2CTypeTags)obj.eContainer()).getConnectionSpec(), 1);
    }

    @Override
    public void visit(ConnectionSpecPropertyType1 obj) {
        J2CTypeTags typeTags;
        ClassType clsType = ((J2CMethodTags)obj.eContainer()).getConnectionSpec();
        if (clsType == null && (typeTags = this.navigateToTypeTags((J2CMethodTags)obj.eContainer())) != null) {
            clsType = typeTags.getConnectionSpec();
        }
        this.validateMethodProperty(obj, clsType, 1);
    }

    @Override
    public void visit(ConnectionSpecType obj) {
        this.validateClass(obj, 1);
    }

    @Override
    public void visit(ConnectionSpecType1 obj) {
        this.validateClass(obj, 1);
    }

    @Override
    public void visit(InteractionSpecPropertyType obj) {
        J2CTypeTags typeTags;
        ClassType clsType = ((J2CMethodTags)obj.eContainer()).getInteractionSpec();
        if (clsType == null && (typeTags = this.navigateToTypeTags((J2CMethodTags)obj.eContainer())) != null) {
            clsType = typeTags.getInteractionSpec();
        }
        this.validateMethodProperty(obj, clsType, 2);
    }

    @Override
    public void visit(InteractionSpecType obj) {
        this.validateClass(obj, 2);
    }

    @Override
    public void visit(InteractionSpecType1 obj) {
        this.validateClass(obj, 2);
    }

    @Override
    public void visit(ManagedConnectionFactoryPropertyType obj) {
        this.validateTypeProperty(obj, ((J2CTypeTags)obj.eContainer()).getManagedConnectionFactory(), 0);
    }

    @Override
    public void visit(ManagedConnectionFactoryType obj) {
        this.validateClass(obj, 0);
    }

    @Override
    public void visit(Wsadie5xStyleType object) {
        this.cleanUpMarker(object);
        if (object.getWsdl() == null || object.getWsdl().length() == 0) {
            this.flagValidationWarning(object, NLS.bind((String)MessageResource.DISP_PROPERTY_NOT_SPECIFIED, (Object)WSDL_ATTR));
        }
    }

    @Override
    public void visit(ConnectionFactoryType object) {
        this.cleanUpMarker(object);
        if (object.getJndiName() == null || object.getJndiName().length() == 0) {
            this.flagValidationWarning(object, NLS.bind((String)MessageResource.DISP_PROPERTY_NOT_SPECIFIED, (Object)JNDI_NAME_ATTR));
        }
    }

    @Override
    public void visit(CommandType object) {
        this.cleanUpMarker(object);
        if (object.getClass_() == null || object.getClass_().length() == 0) {
            this.flagValidationWarning(object, NLS.bind((String)MessageResource.DISP_PROPERTY_NOT_SPECIFIED, (Object)CLASS_ATTR));
        } else {
            IStatus status = JavaConventions.validateJavaTypeName((String)object.getClass_());
            if (!status.isOK()) {
                if (status.getCode() == 4) {
                    this.flagValidationError(object, status.getMessage());
                } else {
                    this.flagValidationWarning(object, status.getMessage());
                }
            }
        }
    }

    @Override
    public void visit(InteractionSpecReturnPropertyType obj) {
        this.cleanUpMarker(obj);
        if (obj.getName() == null || obj.getName().length() == 0) {
            this.flagValidationWarning(obj, NLS.bind((String)MessageResource.DISP_PROPERTY_NOT_SPECIFIED, (Object)NAME_ATTR));
        } else if (obj.getOutputBinding() == null || obj.getOutputBinding().length() == 0) {
            this.flagValidationWarning(obj, NLS.bind((String)MessageResource.DISP_PROPERTY_NOT_SPECIFIED, (Object)OUTPUT_BINDING_ATTR));
        } else {
            J2CTypeTags typeTags;
            ClassType clsType = ((J2CMethodTags)obj.eContainer()).getInteractionSpec();
            if (clsType == null && (typeTags = this.navigateToTypeTags((J2CMethodTags)obj.eContainer())) != null) {
                clsType = typeTags.getInteractionSpec();
            }
            if (clsType != null && clsType.getClass_() != null) {
                IResourceAdapterDescriptor desc = this.findDescriptorFor(clsType.getClass_());
                if (desc != null) {
                    if (!J2CDocletUtil.containsJ2CClass(desc, clsType.getClass_(), 2)) {
                        this.flagValidationError(obj, NLS.bind((String)MessageResource.DISP_CLASS_NOT_FOUND, (Object)clsType.getClass_(), (Object)desc.getConnectorProject().getName()));
                    } else {
                        if (J2CDocletUtil.getJavaBeanPropertyDescriptor(desc, clsType.getClass_(), 2, obj.getName()) == null) {
                            this.flagValidationError(obj, NLS.bind((String)MessageResource.DISP_INVALID_FIELD_ARG_SPECIFIED, (Object)obj.getName(), (Object)clsType.getClass_()));
                        }
                        this.validateArgumentOnReturnType(obj, obj.getOutputBinding());
                    }
                } else {
                    this.flagValidationError(obj, NLS.bind((String)MessageResource.DISP_CLASS_NOT_FOUND, (Object)clsType.getClass_(), (Object)this.project.getElementName()));
                }
            } else {
                this.flagValidationError(obj, MessageResource.DISP_PARENT_TAG_NOT_FOUND);
            }
        }
    }

    private void validateClass(ClassType obj, int type) {
        this.cleanUpMarker(obj);
        if (obj.getClass_() == null || obj.getClass_().length() == 0) {
            this.flagValidationWarning(obj, NLS.bind((String)MessageResource.DISP_PROPERTY_NOT_SPECIFIED, (Object)CLASS_ATTR));
        } else {
            IResourceAdapterDescriptor desc = this.findDescriptorFor(obj.getClass_());
            if (desc != null) {
                if (!J2CDocletUtil.containsJ2CClass(desc, obj.getClass_(), type)) {
                    this.flagValidationError(obj, NLS.bind((String)MessageResource.DISP_CLASS_NOT_FOUND, (Object)obj.getClass_(), (Object)desc.getConnectorProject().getName()));
                }
            } else {
                this.flagValidationError(obj, NLS.bind((String)MessageResource.DISP_CLASS_NOT_FOUND, (Object)obj.getClass_(), (Object)this.project.getElementName()));
            }
        }
    }

    private void validateTypeProperty(Property obj, ClassType clsType, int type) {
        this.cleanUpMarker(obj);
        if (obj.getName() == null || obj.getName().length() == 0) {
            this.flagValidationWarning(obj, NLS.bind((String)MessageResource.DISP_PROPERTY_NOT_SPECIFIED, (Object)NAME_ATTR));
        } else if (obj.getValue() == null || obj.getValue().length() == 0) {
            this.flagValidationWarning(obj, NLS.bind((String)MessageResource.DISP_PROPERTY_NOT_SPECIFIED, (Object)VALUE_ATTR));
        } else if (clsType != null && clsType.getClass_() != null) {
            IResourceAdapterDescriptor desc = this.findDescriptorFor(clsType.getClass_());
            if (desc != null) {
                if (!J2CDocletUtil.containsJ2CClass(desc, clsType.getClass_(), type)) {
                    this.flagValidationError(obj, NLS.bind((String)MessageResource.DISP_CLASS_NOT_FOUND, (Object)clsType.getClass_(), (Object)desc.getConnectorProject().getName()));
                } else if (J2CDocletUtil.getJavaBeanPropertyDescriptor(desc, clsType.getClass_(), type, obj.getName()) == null) {
                    this.flagValidationError(obj, NLS.bind((String)MessageResource.DISP_INVALID_FIELD_ARG_SPECIFIED, (Object)obj.getName(), (Object)clsType.getClass_()));
                }
            } else {
                this.flagValidationError(obj, NLS.bind((String)MessageResource.DISP_CLASS_NOT_FOUND, (Object)clsType.getClass_(), (Object)this.project.getElementName()));
            }
        } else {
            this.flagValidationError(obj, MessageResource.DISP_PARENT_TAG_NOT_FOUND);
        }
    }

    private void validateMethodProperty(BoundedProperty obj, ClassType clsType, int type) {
        this.cleanUpMarker(obj);
        if (obj.getName() == null || obj.getName().length() == 0) {
            this.flagValidationWarning(obj, NLS.bind((String)MessageResource.DISP_PROPERTY_NOT_SPECIFIED, (Object)NAME_ATTR));
        } else if (!(obj.getValue() != null && obj.getValue().length() != 0 || obj.getArgumentBinding() != null && obj.getArgumentBinding().length() != 0)) {
            if (obj.getValue() == null || obj.getValue().length() == 0) {
                this.flagValidationWarning(obj, NLS.bind((String)MessageResource.DISP_PROPERTY_NOT_SPECIFIED, (Object)VALUE_ATTR));
            } else {
                this.flagValidationWarning(obj, NLS.bind((String)MessageResource.DISP_PROPERTY_NOT_SPECIFIED, (Object)ARG_BINDING_ATTR));
            }
        } else if (obj.getValue() != null && obj.getArgumentBinding() != null) {
            this.flagValidationError(obj, NLS.bind((String)MessageResource.DISP_BOTH_PROPERTIES_SPECIFIED, (Object)VALUE_ATTR, (Object)ARG_BINDING_ATTR));
        } else if (clsType != null && clsType.getClass_() != null) {
            IResourceAdapterDescriptor desc = this.findDescriptorFor(clsType.getClass_());
            if (desc != null) {
                if (!J2CDocletUtil.containsJ2CClass(desc, clsType.getClass_(), type)) {
                    this.flagValidationError(obj, NLS.bind((String)MessageResource.DISP_CLASS_NOT_FOUND, (Object)clsType.getClass_(), (Object)desc.getConnectorProject().getName()));
                } else {
                    if (J2CDocletUtil.getJavaBeanPropertyDescriptor(desc, clsType.getClass_(), type, obj.getName()) == null) {
                        this.flagValidationError(obj, NLS.bind((String)MessageResource.DISP_INVALID_FIELD_ARG_SPECIFIED, (Object)obj.getName(), (Object)clsType.getClass_()));
                    }
                    this.validateArgumentBinding(obj, obj.getArgumentBinding());
                }
            } else {
                this.flagValidationError(obj, NLS.bind((String)MessageResource.DISP_CLASS_NOT_FOUND, (Object)clsType.getClass_(), (Object)this.project.getElementName()));
            }
        } else {
            this.flagValidationError(obj, MessageResource.DISP_PARENT_TAG_NOT_FOUND);
        }
    }

    private void flagValidationError(J2CDocletObject doclet, String errorMessage) {
        AnnotationUtil.INSTANCE.createDocletErrorMarker("com.ibm.adapter.j2c.codegen.J2CProblemMarker", errorMessage, (EObject)doclet);
    }

    private void flagValidationWarning(J2CDocletObject doclet, String message) {
        AnnotationUtil.INSTANCE.createDocletWarningMarker("com.ibm.adapter.j2c.codegen.J2CProblemMarker", message, (EObject)doclet);
    }

    private void cleanUpMarker(J2CDocletObject doclet) {
        AnnotationUtil.INSTANCE.deleteMarkers("com.ibm.adapter.j2c.codegen.J2CProblemMarker", (EObject)doclet);
    }

    private void validateArgumentBinding(J2CDocletObject obj, String argumentBinding) {
        if (argumentBinding != null) {
            EOperation operation = (EOperation)obj.eContainer().eContainer().eContainer();
            try {
                IMethod method;
                String[] parameters;
                IJavaElement element = AnnotationUtil.INSTANCE.getJavaElementFromDoclet((EObject)obj);
                if (element != null && element.getElementType() == 9 && (parameters = (method = (IMethod)element).getParameterNames()) != null) {
                    boolean found = false;
                    int i = 0;
                    while (!found && i < parameters.length) {
                        String parameter = parameters[i++];
                        found = parameter.equals(argumentBinding);
                    }
                    if (!found) {
                        this.flagValidationError(obj, NLS.bind((String)MessageResource.DISP_INVALID_MTH_ARG_SPECIFIED, (Object)argumentBinding, (Object)operation.getName()));
                    }
                }
            }
            catch (JavaModelException e) {
                CodegenPlugin.getDefault().getLog().log(e.getStatus());
            }
        }
    }

    private void validateArgumentOnReturnType(J2CDocletObject object, String argumentBinding) {
        EOperation operation = (EOperation)object.eContainer().eContainer().eContainer();
        String clsName = ((EClass)operation.eContainer()).getName();
        String methodName = operation.getName();
        try {
            IJavaElement element = AnnotationUtil.INSTANCE.getJavaElementFromDoclet((EObject)object);
            IMethod method = null;
            if (element != null && element.getElementType() == 9) {
                method = (IMethod)element;
            }
            IType type = this.project.findType(clsName);
            ASTParser parser = ASTParser.newParser((int)BaseGenerator.AST_PARSER_LEVEL);
            parser.setSource(type.getCompilationUnit());
            parser.setResolveBindings(true);
            CompilationUnit astTypeCUnit = (CompilationUnit)parser.createAST(null);
            Type returnType = null;
            Iterator types = astTypeCUnit.types().iterator();
            while (returnType == null && types.hasNext()) {
                AbstractTypeDeclaration typeDec = (AbstractTypeDeclaration)types.next();
                Iterator itr = typeDec.bodyDeclarations().iterator();
                while (returnType == null && itr.hasNext()) {
                    MethodDeclaration node;
                    BodyDeclaration bodyDec = (BodyDeclaration)itr.next();
                    if (bodyDec.getNodeType() != 31 || !(node = (MethodDeclaration)bodyDec).getName().getIdentifier().equals(methodName) || method == null || !J2CDocletCodeAssist.isSameParameterTypes(method.getParameterTypes(), node.parameters())) continue;
                    returnType = node.getReturnType2();
                }
            }
            if (returnType == null || returnType.isPrimitiveType() || returnType.isArrayType()) {
                this.flagValidationError(object, MessageResource.DISP_INVALID_RETURN_TYPE);
            } else {
                boolean found = false;
                ITypeBinding binding = returnType.resolveBinding();
                if (binding != null) {
                    IVariableBinding[] variableBindings = binding.getDeclaredFields();
                    int i = 0;
                    while (!found && i < variableBindings.length) {
                        IVariableBinding vBinding = variableBindings[i++];
                        found = vBinding.getName().equals(argumentBinding);
                    }
                }
                if (!found) {
                    this.flagValidationError(object, NLS.bind((String)MessageResource.DISP_INVALID_FIELD_ARG_SPECIFIED, (Object)argumentBinding, (Object)BaseGenerator.getTypeName(returnType)));
                }
            }
        }
        catch (JavaModelException e) {
            CodegenPlugin.getDefault().getLog().log(e.getStatus());
        }
    }

    private IResourceAdapterDescriptor findDescriptorFor(String name) {
        if (this.firstDescriptor == null) {
            this.firstDescriptor = J2CDocletUtil.getDescriptorFor(name, this.project);
        }
        return this.firstDescriptor;
    }

    private J2CTypeTags navigateToTypeTags(J2CMethodTags obj) {
        EAnnotation matchingAnnotation;
        List annotations;
        EModelElement classElement;
        EModelElement operationElement;
        EAnnotation annotation = (EAnnotation)obj.eContainer();
        if (annotation != null && (operationElement = (EModelElement)annotation.eContainer()) != null && (classElement = (EModelElement)operationElement.eContainer()) != null && (annotations = com.ibm.adapter.j2c.internal.taghandlers.AnnotationUtil.getEAnnotations(classElement, "com.ibm.adapter.j2c.codegen")) != null && !annotations.isEmpty() && !(matchingAnnotation = (EAnnotation)annotations.get(0)).eContents().isEmpty()) {
            return (J2CTypeTags)matchingAnnotation.getContents().get(0);
        }
        return null;
    }
}

