/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.j2c.codegen.writer.properties;

import com.ibm.adapter.emd.extension.description.spi.J2CServiceDescription;
import com.ibm.adapter.j2c.internal.MessageResource;
import com.ibm.propertygroup.IPropertyChangeListener;
import com.ibm.propertygroup.PropertyChangeEvent;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import com.ibm.propertygroup.spi.BaseSingleValuedProperty;
import com.ibm.propertygroup.spi.PropertyVetoException;
import commonj.connector.metadata.description.InboundServiceDescription;
import commonj.connector.metadata.discovery.connection.InboundConnectionConfiguration;
import org.eclipse.core.runtime.CoreException;

public class InboundConnectionPropertyGroup
extends BasePropertyGroup {
    private static final String copyright = "Licensed Material - Property of IBM  5724-I66 (C) Copyright IBM Corporation 2008 - All Rights Reserved. Note to U.S. Government Users Restricted Rights - Use, duplication or disclosure " + "restricted by GSA ADP Schedule Contract with IBM Corp.".intern();
    public static final String INBOUND_CONNECTION_GROUP_NAME = "INBOUND_CONNECTION_GROUP_NAME";
    public static final String ACTIVATION_SPEC_TYPE = "ACTIVATION_SPEC_TYPE";
    public static final String MESSAGE_LISTENER_TYPE = "MESSAGE_LISTENER_TYPE";
    public static final String ACTIVATION_SPEC_JNDI_NAME = "ACTIVATION_SPEC_JNDI_NAME";
    public static final String JAAS_AUTHENTICATION_ALIAS = "JAAS_AUTHENTICATION_ALIAS";
    private J2CServiceDescription serviceDescriptionWrapper;
    private InboundConnectionConfiguration connectionConfiguration;
    private BaseSingleValuedProperty messageListenerType;
    private BaseSingleValuedProperty activationSpecType;
    private BaseSingleValuedProperty jndiTarget;
    private BaseSingleValuedProperty authenticationAlias;

    public InboundConnectionPropertyGroup(InboundConnectionConfiguration connectionConfiguration, J2CServiceDescription serviceDescriptionWrapper) throws CoreException {
        super(INBOUND_CONNECTION_GROUP_NAME, MessageResource.INBOUND_CONNECTION_GROUP_DISPLAY_NAME, MessageResource.INBOUND_CONNECTION_GROUP_DESCRIPTION);
        this.serviceDescriptionWrapper = serviceDescriptionWrapper;
        this.connectionConfiguration = connectionConfiguration;
        this.initializePropertyGroup();
    }

    private void initializePropertyGroup() throws CoreException {
        this.activationSpecType = new BaseSingleValuedProperty(ACTIVATION_SPEC_TYPE, MessageResource.ACTIVATION_SPEC_TYPE_DISPLAY_NAME, MessageResource.ACTIVATION_SPEC_TYPE_DISPLAY_NAME, String.class, (BasePropertyGroup)this);
        this.activationSpecType.setValue((Object)this.connectionConfiguration.getInboundConnectionType().createInboundConnectionBeans().getActivationSpecJavaBean().getClass().getName());
        this.activationSpecType.setReadOnly(true);
        this.messageListenerType = new BaseSingleValuedProperty(MESSAGE_LISTENER_TYPE, MessageResource.MESSAGE_LISTENER_TYPE_DISPLAY_NAME, MessageResource.MESSAGE_LISTENER_TYPE_DESCRIPTION, String.class, (BasePropertyGroup)this);
        this.messageListenerType.setValue((Object)((InboundServiceDescription)this.serviceDescriptionWrapper.getServiceDescription()).getListenerClassName());
        this.messageListenerType.setReadOnly(true);
        this.jndiTarget = new BaseSingleValuedProperty(ACTIVATION_SPEC_JNDI_NAME, MessageResource.ACTIVATION_SPEC_JNDI_NAME_DISPLAY_NAME, MessageResource.ACTIVATION_SPEC_JNDI_NAME_DESCRIPTION, String.class, (BasePropertyGroup)this);
        this.jndiTarget.setRequired(true);
        this.jndiTarget.addPropertyChangeListener((IPropertyChangeListener)this);
        this.jndiTarget.assignID("com.ibm.j2c.property.mcf");
        this.authenticationAlias = new BaseSingleValuedProperty(JAAS_AUTHENTICATION_ALIAS, MessageResource.JAAS_AUTHENTICATION_ALIAS_DISPLAY_NAME, MessageResource.JAAS_AUTHENTICATION_ALIAS_DESCRIPTION, String.class, (BasePropertyGroup)this);
        this.authenticationAlias.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public Object clone() throws CloneNotSupportedException {
        BaseSingleValuedProperty activationSpecType;
        BaseSingleValuedProperty messageListenerType;
        InboundConnectionPropertyGroup clone = (InboundConnectionPropertyGroup)((Object)super.clone());
        clone.messageListenerType = messageListenerType = (BaseSingleValuedProperty)clone.getProperty(MESSAGE_LISTENER_TYPE);
        clone.activationSpecType = activationSpecType = (BaseSingleValuedProperty)clone.getProperty(ACTIVATION_SPEC_TYPE);
        BaseSingleValuedProperty jndiTarget = (BaseSingleValuedProperty)clone.getProperty(ACTIVATION_SPEC_JNDI_NAME);
        clone.jndiTarget = jndiTarget != null ? jndiTarget : (BaseSingleValuedProperty)this.jndiTarget.clone();
        BaseSingleValuedProperty authenticationAlias = (BaseSingleValuedProperty)clone.getProperty(JAAS_AUTHENTICATION_ALIAS);
        clone.authenticationAlias = authenticationAlias != null ? authenticationAlias : (BaseSingleValuedProperty)this.authenticationAlias.clone();
        clone.jndiTarget.addPropertyChangeListener((IPropertyChangeListener)clone);
        clone.authenticationAlias.addPropertyChangeListener((IPropertyChangeListener)clone);
        return clone;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyChangeType() == 0) {
            if (evt.getSource() == this.jndiTarget) {
                String jndi = this.getJndiTarget();
                this.serviceDescriptionWrapper.setJNDILookupName(jndi);
            }
            if (evt.getSource() == this.authenticationAlias) {
                String jaasAlias = this.getJAASAlias();
                this.serviceDescriptionWrapper.setJAASAlias(jaasAlias);
            }
        }
    }

    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
    }

    public String getJndiTarget() {
        return this.jndiTarget.getValueAsString();
    }

    public String getJAASAlias() {
        return this.authenticationAlias.getValueAsString();
    }

    public String getActivationSpecName() {
        return this.activationSpecType.getValueAsString();
    }

    public J2CServiceDescription getServiceDescriptionWrapper() {
        return this.serviceDescriptionWrapper;
    }
}

