/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.discovery.ui.wizards;

import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.IEnvironment;
import com.ibm.adapter.framework.IImportResult;
import com.ibm.adapter.framework.IPublishingSet;
import com.ibm.adapter.framework.IResourceWriter;
import com.ibm.ccl.discovery.ui.internal.messages.DiscUIMessageBundle;
import com.ibm.ccl.discovery.ui.internal.utilities.DiscUIHelper;
import com.ibm.ccl.discovery.ui.wizards.DiscWizard;
import com.ibm.ccl.discpub.ui.core.internal.data.ResourceWriterInfo;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.ui.internal.utilities.IPropertyUIWidgetFactory;
import com.ibm.propertygroup.ui.plugin.PropertyUIMessageBundle;
import com.ibm.propertygroup.ui.utilities.PropertyUIComposite;
import com.ibm.propertygroup.ui.widgets.PropertyUIScrollableComposite;
import com.ibm.propertygroup.ui.wizards.MessageBundleWizardDynamicPage_PropertyGroup;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.SharedScrolledComposite;

public class DiscWizard_ResourceWriterPage
extends MessageBundleWizardDynamicPage_PropertyGroup {
    protected IPropertyUIWidgetFactory factory_;
    protected ResourceWriterInfo writerInfo_;
    protected Combo wrwList_;
    protected SharedScrolledComposite propertiesArea_;
    protected Composite emptyComposite_;

    public DiscWizard_ResourceWriterPage(String name, DiscUIMessageBundle newBundle) {
        super(name, (PropertyUIMessageBundle)newBundle);
        this.initPageTitle();
    }

    protected void initPageTitle() {
        this.setTitle(this.messageBundle_.getMessage("DISC_UI_WIZARD_RESOURCEWRITER_PAGE_TITLE"));
        this.setDescription(this.messageBundle_.getMessage("DISC_UI_WIZARD_RESOURCEWRITER_PAGE_DESC"));
        this.setImageDescriptor(this.messageBundle_.getImageDescriptor(this.messageBundle_.getMessage("ICON_DISC_WIZARD_RESOURCEWRITER_PAGE")));
    }

    public Composite createContents(IPropertyUIWidgetFactory factory, Composite parent) {
        this.factory_ = factory;
        return super.createContents(factory, parent);
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    protected boolean canWizardFlipToNextPage() {
        return super.canFlipToNextPage();
    }

    public void initPage(IResourceWriter[] writers, IImportResult result) throws Exception {
        this.isModified(true);
        if (writers.length < 2) {
            this.writerInfo_ = new ResourceWriterInfo(writers[0], (IEnvironment)((DiscWizard)this.getWizard()).getImportEnvironment(), result, ((DiscWizard)this.getWizard()).getContext());
            this.displayPage(this.writerInfo_.getWriteProperties());
        } else {
            if (this.wrwList_ == null) {
                this.createWriterSelectionArea(result);
            } else {
                this.cleanWriterSelection();
            }
            this.initWriterSelection(writers);
        }
        this.afterInitPage();
    }

    protected void afterInitPage() {
    }

    protected void cleanCurrentPropertyUIComposite() {
        if (this.wrwList_ == null) {
            super.cleanCurrentPropertyUIComposite();
        }
    }

    protected void cleanWriterSelection() {
        Control control;
        if (this.wrwList_ != null) {
            String[] items = this.wrwList_.getItems();
            int i = 0;
            while (i < items.length) {
                LayoutInfo info = (LayoutInfo)this.wrwList_.getData(items[i]);
                if (info != null && info.uiComposite_ != null) {
                    info.uiComposite_.dispose();
                }
                ++i;
            }
            this.wrwList_.removeAll();
        }
        if (this.propertiesArea_ != null && !this.propertiesArea_.isDisposed() && (control = this.propertiesArea_.getContent()) != null && control.isDisposed()) {
            if (this.emptyComposite_ == null || this.emptyComposite_.isDisposed()) {
                this.emptyComposite_ = this.factory_.createComposite((Composite)this.propertiesArea_, 0);
            }
            this.propertiesArea_.setContent((Control)this.emptyComposite_);
        }
        this.writerInfo_ = null;
        this.uiComposite_ = null;
    }

    protected void createWriterSelectionArea(final IImportResult result) {
        Composite parent = (Composite)((SharedScrolledComposite)this.getControl()).getContent();
        GridLayout layout = (GridLayout)parent.getLayout();
        layout.numColumns = 2;
        this.factory_.createLabel(parent, this.messageBundle_.getMessage("DISC_UI_WIZARD_LABEL_WRW"), 0);
        this.wrwList_ = this.factory_.createNormalCombo(parent, this.factory_.getBorderStyle() | 8);
        this.wrwList_.setToolTipText(this.messageBundle_.getMessage("DISC_UI_WIZARD_LABEL_WRW"));
        GridData gd = new GridData(768);
        this.wrwList_.setLayoutData((Object)gd);
        Label sep = this.factory_.createSeparator(parent, 256);
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        sep.setLayoutData((Object)gd);
        this.propertiesArea_ = this.createPropertiesContainer(parent);
        this.wrwList_.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DiscWizard_ResourceWriterPage.this.performModifyText(e, result);
            }
        });
    }

    protected SharedScrolledComposite createPropertiesContainer(Composite parent) {
        PropertyUIScrollableComposite container = this.factory_.createPropertyUIScrollableComposite(parent, 768);
        container.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        container.setLayoutData((Object)gd);
        return container;
    }

    protected void initWriterSelection(IResourceWriter[] writers) {
        ArrayList<String> list = new ArrayList<String>(writers.length);
        int i = 0;
        while (i < writers.length) {
            String item;
            if (writers[i] != null && list.indexOf(item = writers[i].getDisplayName()) == -1) {
                list.add(item);
                LayoutInfo info = new LayoutInfo();
                info.writerInfo_ = new ResourceWriterInfo(writers[i]);
                this.wrwList_.setData(item, (Object)info);
            }
            ++i;
        }
        if (!list.isEmpty()) {
            String[] items = new String[list.size()];
            list.toArray(items);
            this.wrwList_.setItems(items);
        }
        this.pageContainerReflow();
        if (this.wrwList_.getItemCount() > 0) {
            this.wrwList_.select(0);
        }
    }

    protected void performModifyText(ModifyEvent e, IImportResult result) {
        DiscWizard wizard = (DiscWizard)this.getWizard();
        this.firstOpens(false);
        this.isModified(true);
        String key = this.wrwList_.getText();
        LayoutInfo info = (LayoutInfo)this.wrwList_.getData(key);
        if (info != null && info.writerInfo_ != null && !info.writerInfo_.sameWriter(this.writerInfo_)) {
            if (this.uiComposite_ == null) {
                try {
                    this.writerInfo_.setImportResult((IEnvironment)wizard.getImportEnvironment(), result);
                    this.displayPage((Composite)this.propertiesArea_, this.writerInfo_.getWriteProperties());
                    info.uiComposite_ = this.uiComposite_;
                }
                catch (BaseException ie) {
                    DiscUIHelper.getDiscUIHelper().showExceptionMessage(ie, this.getShell(), this.messageBundle_.getMessage("WIZARD_WIN_ERRTITLE"), DiscUIHelper.getDiscUIHelper().getMessageFromCoreException((CoreException)ie));
                }
                catch (Exception ex) {
                    DiscUIHelper.getDiscUIHelper().showExceptionMessage(ex, this.getShell(), this.messageBundle_.getMessage("WIZARD_WIN_ERRTITLE"), ex.getMessage());
                }
            } else {
                this.uiComposite_ = info.uiComposite_;
                this.setPageComplete(this.determinePageCompletion());
            }
            this.writerInfo_ = info.writerInfo_;
            Composite content = null;
            if (info.uiComposite_ != null) {
                content = info.uiComposite_.getComposite();
            } else {
                if (this.emptyComposite_ == null || this.emptyComposite_.isDisposed()) {
                    this.emptyComposite_ = this.factory_.createComposite((Composite)this.propertiesArea_, 0);
                }
                content = this.emptyComposite_;
            }
            this.propertiesArea_.setContent((Control)content);
            this.propertiesArea_.reflow(true);
            this.pageContainerReflow();
        }
    }

    public boolean determinePageCompletion() {
        boolean isComplete = super.determinePageCompletion();
        IWizard wizard = this.getWizard();
        if (wizard instanceof DiscWizard) {
            ((DiscWizard)wizard).setCanFinish(isComplete);
        }
        return isComplete;
    }

    public IResourceWriter getResourceWriter() {
        return this.writerInfo_.getResourceWriter();
    }

    public IPropertyGroup getWriteProperties() {
        return this.getPropertyGroup();
    }

    public IPublishingSet getPublishingSet() {
        return this.writerInfo_.getPublishingSet();
    }

    public ResourceWriterInfo getResourceWriterInfo() {
        return this.writerInfo_;
    }

    public void dispose() {
        super.dispose();
        this.cleanWriterSelection();
    }

    protected class LayoutInfo {
        ResourceWriterInfo writerInfo_;
        PropertyUIComposite uiComposite_;

        protected LayoutInfo() {
        }

        IResourceWriter getResourceWriter() {
            return this.writerInfo_ == null ? null : this.writerInfo_.getResourceWriter();
        }
    }
}

