/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.discovery.ui.wizards;

import com.ibm.adapter.framework.IDiscoveryAgent;
import com.ibm.adapter.framework.registry.IConfiguration;
import com.ibm.ccl.discovery.ui.api.IDiscoveryAgentUIWizardElement;
import com.ibm.ccl.discovery.ui.internal.data.DiscoveryConnection;
import com.ibm.ccl.discovery.ui.internal.messages.DiscUIMessageBundle;
import com.ibm.ccl.discovery.ui.internal.providers.ConfigurationContentProvider;
import com.ibm.ccl.discovery.ui.internal.providers.ConfigurationLabelProvider;
import com.ibm.propertygroup.ui.internal.utilities.IPropertyUIWidgetFactory;
import com.ibm.propertygroup.ui.plugin.PropertyUIMessageBundle;
import com.ibm.propertygroup.ui.widgets.ToolBarViewer;
import com.ibm.propertygroup.ui.wizards.MessageBundleWizard;
import com.ibm.propertygroup.ui.wizards.MessageBundleWizardPage;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;

public class DiscWizard_CategoryPage
extends MessageBundleWizardPage {
    protected TreeViewer treeViewer_ = null;
    protected Label topologyIcon_ = null;
    protected IContributionItem[] toolBarItems_ = null;
    protected IDiscoveryAgent agent_ = null;
    protected IConfiguration configuration_ = null;
    protected ArrayList input_ = null;
    protected boolean showTopology_ = true;
    protected Hashtable allocatedImages_ = new Hashtable();
    protected Object selectedObject_;
    protected String J2C_CONFIGURABLE_PROJECT = "J2C_Configurable_Project";

    public DiscWizard_CategoryPage(String name, DiscUIMessageBundle newBundle) {
        super(name, (PropertyUIMessageBundle)newBundle);
        this.initPageTitle();
    }

    protected void initPageTitle() {
        this.setTitle(this.messageBundle_.getMessage("DISC_UI_WIZARD_CATEGORY_PAGE_TITLE"));
        this.setDescription(this.messageBundle_.getMessage("DISC_UI_WIZARD_CATEGORY_PAGE_DESC"));
        this.setImageDescriptor(this.messageBundle_.getImageDescriptor(this.messageBundle_.getMessage("ICON_DISC_WIZARD_CATEGORY_PAGE")));
    }

    public Composite createContents(IPropertyUIWidgetFactory factory, Composite parent) {
        Composite main = factory.createComposite(parent, 0);
        main.setLayout((Layout)new GridLayout());
        main.setLayoutData((Object)new GridData(1808));
        this.createTreeViewerTitle(factory, main);
        SashForm sashForm = new SashForm(main, 256);
        this.treeViewer_ = this.createTreeViewer(factory, sashForm);
        this.topologyIcon_ = this.createTopologyIcon(factory, sashForm);
        this.initSashForm(sashForm);
        this.initTreeViewer(this.treeViewer_);
        this.initPageContents();
        this.loadDefaultValues();
        this.setPageComplete(this.validatePage());
        return main;
    }

    protected Label createTreeViewerTitle(IPropertyUIWidgetFactory factory, Composite parent) {
        return null;
    }

    protected TreeViewer createTreeViewer(IPropertyUIWidgetFactory factory, SashForm parent) {
        TreeViewer viewer;
        if (this.toolBarItems_ == null || this.toolBarItems_.length < 1) {
            Tree tree = factory.createTree((Composite)parent, 4 | factory.getBorderStyle());
            viewer = factory.createTreeViewer(tree);
            tree.setLayoutData((Object)new GridData(1808));
        } else {
            ToolBarViewer composite = new ToolBarViewer((Composite)parent, factory.getBorderStyle());
            Tree tree = factory.createTree((Composite)composite, 4);
            viewer = factory.createTreeViewer(tree);
            composite.setViewer((StructuredViewer)viewer);
            tree.setLayoutData((Object)new GridData(1808));
            composite.addContributionItems(this.toolBarItems_);
        }
        ViewerComparator sorter = this.getViewerComparator();
        if (sorter != null) {
            viewer.setComparator(sorter);
        }
        return viewer;
    }

    protected ViewerComparator getViewerComparator() {
        return new ViewerComparator();
    }

    protected Label createTopologyIcon(IPropertyUIWidgetFactory factory, SashForm parent) {
        ScrolledComposite iconComp = factory.createScrolledComposite((Composite)parent, 768);
        iconComp.setLayout((Layout)new GridLayout());
        Label icon = factory.createLabel((Composite)iconComp, factory.getBorderStyle());
        icon.setBackground(Display.getCurrent().getSystemColor(1));
        iconComp.setContent((Control)icon);
        return icon;
    }

    protected void initTreeViewer(TreeViewer treeViewer) {
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DiscWizard_CategoryPage.this.handleTreeSelectionChanged(event);
            }
        });
        treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                DiscWizard_CategoryPage.this.handleTreeDoubleClick(event);
            }
        });
        treeViewer.setLabelProvider((IBaseLabelProvider)new ConfigurationLabelProvider((DiscUIMessageBundle)this.messageBundle_));
        IWizard wizard = this.getWizard();
        AbstractUIPlugin plugin = null;
        if (wizard instanceof MessageBundleWizard) {
            plugin = ((MessageBundleWizard)wizard).getDataPersistPlugin();
        }
        treeViewer.setContentProvider((IContentProvider)new ConfigurationContentProvider(plugin));
    }

    protected void initSashForm(SashForm sashForm) {
        if (this.showTopology_) {
            sashForm.setWeights(new int[]{43, 57});
        } else {
            Tree tree = this.treeViewer_.getTree();
            if (tree.getParent() instanceof ToolBarViewer) {
                sashForm.setMaximizedControl((Control)tree.getParent());
            } else {
                sashForm.setMaximizedControl((Control)tree);
            }
        }
        GridData gridData = new GridData(1808);
        gridData.heightHint = 306;
        gridData.widthHint = 550;
        sashForm.setLayoutData((Object)gridData);
    }

    protected void initPageContents() {
        this.input_ = this.initTreeInput();
        if (this.input_ != null && !this.input_.isEmpty()) {
            this.treeViewer_.setInput((Object)this.input_);
        }
    }

    protected void loadDefaultValues() {
    }

    protected void handleTreeSelectionChanged(SelectionChangedEvent e) {
        if (this.firstOpens()) {
            this.firstOpens(false);
        }
        Object selection = ((StructuredSelection)this.treeViewer_.getSelection()).getFirstElement();
        this.updateSelectedObject(selection);
        if (this.showTopology_) {
            if (selection != null && selection instanceof IDiscoveryAgentUIWizardElement) {
                this.selectService((IDiscoveryAgentUIWizardElement)selection);
            } else {
                this.topologyIcon_.setImage(null);
            }
        }
        this.processSelectedObject();
        this.setPageComplete(this.validatePage());
    }

    protected void updateSelectedObject(Object selection) {
        if (selection != null) {
            if (!selection.equals(this.selectedObject_)) {
                this.isModified(true);
                this.selectedObject_ = selection;
            }
        } else if (this.selectedObject_ != null && !this.selectedObject_.equals(selection)) {
            this.isModified(true);
            this.selectedObject_ = selection;
        }
    }

    protected void selectService(IDiscoveryAgentUIWizardElement info) {
        if (info != null) {
            String topologyIconPath = info.getTopologyIconPath();
            if (topologyIconPath != null) {
                Image im = (Image)this.allocatedImages_.get(topologyIconPath);
                if (im != null) {
                    this.topologyIcon_.setImage(im);
                } else {
                    try {
                        int index = topologyIconPath.indexOf("/");
                        String id = topologyIconPath.substring(0, index);
                        String path = topologyIconPath.substring(index + 1, topologyIconPath.length());
                        Bundle bundle = Platform.getBundle((String)id);
                        URL iconURL = FileLocator.find((Bundle)bundle, (IPath)new Path(path), null);
                        im = ImageDescriptor.createFromURL((URL)iconURL).createImage();
                        this.allocatedImages_.put(topologyIconPath, im);
                        this.topologyIcon_.setImage(im);
                    }
                    catch (Exception exception) {
                        this.topologyIcon_.setImage(null);
                    }
                }
            } else {
                this.topologyIcon_.setImage(null);
            }
        } else {
            this.topologyIcon_.setImage(null);
        }
    }

    protected void processSelectedObject() {
        if (this.isModified() && this.selectedObject_ != null) {
            if (this.selectedObject_ instanceof IConfiguration) {
                this.configuration_ = (IConfiguration)this.selectedObject_;
            } else if (this.selectedObject_ instanceof DiscoveryConnection) {
                this.configuration_ = ((DiscoveryConnection)this.selectedObject_).getConfiguration();
            }
            this.treeViewer_.expandToLevel(this.selectedObject_, 1);
        }
    }

    protected void handleTreeDoubleClick(DoubleClickEvent e) {
        IWizardPage page;
        if (this.isPageComplete() && (page = this.getNextPage()) != null) {
            this.getContainer().showPage(page);
        }
    }

    protected ArrayList initTreeInput() {
        return this.input_;
    }

    public void dispose() {
        super.dispose();
        Enumeration ims = this.allocatedImages_.elements();
        while (ims.hasMoreElements()) {
            Image i = (Image)ims.nextElement();
            if (i.isDisposed()) continue;
            i.dispose();
        }
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public boolean validatePage() {
        String errMsg = null;
        if (this.configuration_ == null) {
            errMsg = this.messageBundle_.getMessage("ERROR_WIZARD_SELECT_DA");
        }
        if (errMsg != null) {
            this.setErrorMessage(errMsg);
            return false;
        }
        if (this.getErrorMessage() != null) {
            this.cleanMessage();
        }
        return true;
    }

    public IConfiguration getConfiguration() {
        return this.configuration_;
    }

    public IDiscoveryAgent getDiscoveryAgent() {
        if (this.agent_ == null && this.configuration_ != null) {
            this.agent_ = this.configuration_.createDiscoveryAgent();
        }
        return this.agent_;
    }

    public ArrayList getTreeViewerInput() {
        return this.input_;
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer_;
    }

    public void showTopology(boolean show) {
        this.showTopology_ = show;
    }

    public void setTreeViewInput(ArrayList newList) {
        this.input_ = newList;
    }

    public Object getSelectedObject() {
        return this.selectedObject_;
    }

    public IProject hasConfigurableProject() {
        IProject value = null;
        Tree tree = this.treeViewer_.getTree();
        if (tree.getSelectionCount() > 0) {
            value = (IProject)tree.getSelection()[0].getData(this.J2C_CONFIGURABLE_PROJECT);
        }
        return value;
    }

    public void setConfigurableProject(IProject project) {
        Tree tree = this.treeViewer_.getTree();
        if (tree.getSelectionCount() > 0) {
            tree.getSelection()[0].setData(this.J2C_CONFIGURABLE_PROJECT, (Object)project);
        }
    }

    public IWizardPage getNextPage() {
        return super.getNextPage();
    }
}

