/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.discovery.ui.internal.listeners;

import com.ibm.adapter.framework.IResultNode;
import com.ibm.ccl.discovery.ui.internal.messages.MessageResource;
import com.ibm.ccl.discovery.ui.internal.utilities.DiscUIHelper;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.ui.internal.utilities.IPropertyUIWidgetFactory;
import com.ibm.propertygroup.ui.utilities.PropertyUIFactory;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;

public class TreeViewerHoverHelpListener
implements Listener {
    public static final String PF2_TEXT = MessageResource.DISC_UI_WIZARD_DETAILS_TEXT;
    private Shell tip_ = null;
    private Label label_ = null;
    private Label separator_ = null;
    private Label pf2Text_ = null;
    private TreeViewer viewer_ = null;
    private Shell parentShell_ = null;
    private TreeItem currentItem_ = null;
    private IPropertyGroup displayProperties_ = null;
    private boolean showDetails_ = false;

    public TreeViewerHoverHelpListener(TreeViewer viewer, Shell parentShell, boolean showDetails) {
        this.viewer_ = viewer;
        this.parentShell_ = parentShell;
        this.showDetails_ = showDetails;
        this.viewer_.getTree().setToolTipText("");
    }

    public void handleEvent(Event event) {
        switch (event.type) {
            case 5: 
            case 8: 
            case 12: {
                this.dispose();
                if (this.tip_ == null) break;
                this.tip_ = null;
                this.label_ = null;
                this.currentItem_ = null;
                this.displayProperties_ = null;
                this.separator_ = null;
                this.pf2Text_ = null;
                break;
            }
            case 32: {
                boolean hasDisplayProperties;
                TreeItem item = this.viewer_.getTree().getItem(new Point(event.x, event.y));
                if (item == null || item == this.currentItem_) {
                    return;
                }
                this.currentItem_ = item;
                if (!(item.getData() instanceof IResultNode)) break;
                String text = null;
                IResultNode resultNode = (IResultNode)item.getData();
                text = DiscUIHelper.getDiscUIHelper().getHoverHelpTextForNode(resultNode, false);
                boolean hasDescription = text != null && !"".equals(text);
                this.displayProperties_ = resultNode.getDisplayProperties();
                boolean bl = hasDisplayProperties = this.displayProperties_ != null;
                if (!this.showDetails_) {
                    hasDisplayProperties = false;
                }
                if (!hasDescription && !hasDisplayProperties) {
                    return;
                }
                this.dispose();
                this.tip_ = new Shell(this.parentShell_, 16384);
                GridLayout layout = new GridLayout();
                layout.numColumns = 1;
                this.tip_.setLayout((Layout)layout);
                Color fg = this.parentShell_.getDisplay().getSystemColor(28);
                Color bg = this.parentShell_.getDisplay().getSystemColor(29);
                this.tip_.setForeground(fg);
                this.tip_.setBackground(bg);
                GridData gd = null;
                IPropertyUIWidgetFactory factory = PropertyUIFactory.instance().getUIFactory();
                Composite comp = factory.createComposite((Composite)this.tip_, 0);
                layout = new GridLayout();
                layout.numColumns = 1;
                comp.setLayout((Layout)layout);
                comp.setForeground(fg);
                comp.setBackground(bg);
                if (hasDescription) {
                    this.label_ = factory.createLabel(comp, 0);
                    this.label_.setForeground(fg);
                    this.label_.setBackground(bg);
                    this.label_.setText(text);
                    gd = new GridData();
                    gd.horizontalAlignment = 4;
                    gd.grabExcessHorizontalSpace = true;
                    this.label_.setLayoutData((Object)gd);
                }
                if (hasDisplayProperties) {
                    if (hasDescription) {
                        this.separator_ = factory.createSeparator(comp, 256);
                        this.separator_.setForeground(fg);
                        this.separator_.setBackground(bg);
                        gd = new GridData();
                        gd.horizontalAlignment = 4;
                        gd.grabExcessHorizontalSpace = true;
                        this.separator_.setLayoutData((Object)gd);
                    }
                    this.pf2Text_ = factory.createLabel(comp, 0);
                    Font font = this.pf2Text_.getFont();
                    FontData[] fontDatas = font.getFontData();
                    int i = 0;
                    while (i < fontDatas.length) {
                        fontDatas[i].setHeight(fontDatas[i].getHeight() * 9 / 10);
                        ++i;
                    }
                    Font newFont = new Font((Device)this.pf2Text_.getDisplay(), fontDatas);
                    this.pf2Text_.setFont(newFont);
                    this.pf2Text_.addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent event) {
                            Label label = (Label)event.getSource();
                            Font font = label.getFont();
                            if (font != null && !font.isDisposed()) {
                                font.dispose();
                            }
                        }
                    });
                    this.pf2Text_.setForeground(this.pf2Text_.getDisplay().getSystemColor(17));
                    this.pf2Text_.setBackground(this.pf2Text_.getDisplay().getSystemColor(29));
                    this.pf2Text_.setText(PF2_TEXT);
                    gd = new GridData();
                    gd.horizontalAlignment = 3;
                    gd.grabExcessHorizontalSpace = true;
                    this.pf2Text_.setLayoutData((Object)gd);
                }
                comp.layout(true);
                Rectangle rect = item.getBounds();
                Point pt = this.viewer_.getTree().toDisplay(rect.x, rect.y);
                this.tip_.pack();
                Rectangle displayBounds = this.tip_.getDisplay().getBounds();
                Rectangle shellBounds = this.tip_.getBounds();
                shellBounds.x = pt.x + rect.width;
                shellBounds.y = Math.max(Math.min(pt.y + 16, displayBounds.height - shellBounds.height), 0);
                this.tip_.setBounds(shellBounds);
                this.tip_.setVisible(true);
            }
        }
    }

    public void dispose() {
        if (this.tip_ != null && !this.tip_.isDisposed()) {
            this.tip_.close();
            this.tip_.dispose();
        }
    }
}

