/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.emd.properties.wrapper;

import com.ibm.adapter.emd.internal.LogFacility;
import com.ibm.adapter.emd.internal.MessageResource;
import com.ibm.adapter.emd.internal.discovery.EMDDescriptor;
import com.ibm.adapter.emd.properties.wrapper.BaseParent;
import com.ibm.adapter.emd.properties.wrapper.ColumnDescriptorWrapper;
import com.ibm.adapter.emd.properties.wrapper.ITableCellPropertyWrapper;
import com.ibm.adapter.emd.properties.wrapper.TableCellBindingTypePropertyWrapper;
import com.ibm.adapter.emd.properties.wrapper.TableCellFilePropertyWrapper;
import com.ibm.adapter.emd.properties.wrapper.TableCellFolderPropertyWrapper;
import com.ibm.adapter.emd.properties.wrapper.TableCellJavaTypePropertyWrapper;
import com.ibm.adapter.emd.properties.wrapper.TableCellPropertyWrapper;
import com.ibm.adapter.emd.properties.wrapper.TableCellSchemaTypePropertyWrapper;
import com.ibm.propertygroup.IPropertyChangeListener;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.ITableCellProperty;
import com.ibm.propertygroup.ITableProperty;
import com.ibm.propertygroup.PropertyChangeEvent;
import com.ibm.propertygroup.spi.PropertyChangeSupport;
import commonj.connector.metadata.MetadataException;
import commonj.connector.metadata.discovery.properties.PropertyChangeListener;
import commonj.connector.metadata.discovery.properties.PropertyEvent;
import commonj.connector.metadata.discovery.properties.SingleValuedProperty;
import commonj.connector.metadata.discovery.properties.TableProperty;
import commonj.connector.metadata.discovery.properties.extensions.BindingTypeProperty;
import commonj.connector.metadata.discovery.properties.extensions.FileProperty;
import commonj.connector.metadata.discovery.properties.extensions.FolderProperty;
import commonj.connector.metadata.discovery.properties.extensions.JavaTypeProperty;
import commonj.connector.metadata.discovery.properties.extensions.SchemaTypeProperty;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class TablePropertyWrapper
extends BaseParent
implements ITableProperty,
PropertyChangeListener {
    protected TableProperty emdProperty;
    protected HashMap<SingleValuedProperty, ITableCellPropertyWrapper> wrapperMap_ = new HashMap();

    public TablePropertyWrapper(TableProperty tableProperty, String emdVersion) {
        this.emdProperty = tableProperty;
        this.propertyChanges = new PropertyChangeSupport((IPropertyDescriptor)this);
        this.emdProperty.addPropertyChangeListener((PropertyChangeListener)this);
        this.emdVersion = emdVersion;
        int i = 0;
        while (i < tableProperty.rowCount()) {
            SingleValuedProperty[] svps = tableProperty.getRowProperties(i);
            int j = 0;
            while (j < svps.length) {
                SingleValuedProperty emdProp = svps[j];
                try {
                    ITableCellPropertyWrapper prop = this.createTableCellPropertyWrapper(emdProp, emdVersion);
                    prop.setRow(i);
                    prop.setColumn(j);
                    prop.setParent((IPropertyDescriptor)this);
                    this.wrapperMap_.put(emdProp, prop);
                }
                catch (CoreException coreException) {}
                emdProp.addPropertyChangeListener((PropertyChangeListener)this);
                ++j;
            }
            ++i;
        }
    }

    public String getDescription() {
        return this.emdProperty.getDescription();
    }

    public String getName() {
        return this.emdProperty.getName();
    }

    public String getDisplayName() {
        return this.emdProperty.getDisplayName();
    }

    public boolean isEnabled() {
        return this.emdProperty.isEnabled();
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            TablePropertyWrapper clone = (TablePropertyWrapper)super.clone();
            clone.emdProperty = (TableProperty)this.emdProperty.clone();
            clone.propertyChanges = new PropertyChangeSupport((IPropertyDescriptor)clone);
            clone.emdProperty.addPropertyChangeListener((PropertyChangeListener)clone);
            int i = 0;
            while (i < clone.emdProperty.rowCount()) {
                SingleValuedProperty[] svps = clone.emdProperty.getRowProperties(i);
                int j = 0;
                while (j < svps.length) {
                    svps[j].addPropertyChangeListener((PropertyChangeListener)clone);
                    ++j;
                }
                ++i;
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            throw new CloneNotSupportedException(e.getLocalizedMessage());
        }
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyChanges.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyChanges.addPropertyChangeListener(listener);
    }

    public void assignID(String id) throws CoreException {
        if (!"DEFAULT_PROPERTY_IDENTIFIER".equals(this.getID())) {
            Status status = new Status(4, "com.ibm.adapter.emd", 4, MessageResource.ERR_ID_SET, null);
            LogFacility.logErrorMessage((IStatus)status);
            throw new CoreException((IStatus)status);
        }
        this.propertyID = id;
    }

    public String getID() {
        if (EMDDescriptor.isEMDSpecVersion11OrLater(this.emdVersion)) {
            return this.emdProperty.getID();
        }
        return this.propertyID;
    }

    public int getPropertyFlag() {
        return 258;
    }

    public ITableCellProperty[] createNewRow() throws CoreException {
        SingleValuedProperty[] array = null;
        ITableCellProperty[] cellArray = null;
        try {
            array = this.emdProperty.createNewRow();
        }
        catch (MetadataException me) {
            String message = me.getLocalizedMessage();
            message = message == null ? "" : message;
            Status status = new Status(4, "com.ibm.adapter.emd", 4, message, (Throwable)me);
            LogFacility.logErrorMessage((IStatus)status);
            throw new CoreException((IStatus)status);
        }
        if (array != null) {
            cellArray = new ITableCellPropertyWrapper[array.length];
            int i = 0;
            while (i < array.length) {
                SingleValuedProperty emdProp = array[i];
                ITableCellPropertyWrapper prop = this.createTableCellPropertyWrapper(emdProp, this.emdVersion);
                prop.setRow(this.emdProperty.rowCount() - 1);
                prop.setColumn(i);
                cellArray[i] = prop;
                prop.setParent((IPropertyDescriptor)this);
                emdProp.addPropertyChangeListener((PropertyChangeListener)this);
                this.wrapperMap_.put(emdProp, prop);
                ++i;
            }
            this.propertyChanges.fireTableRowAdd(cellArray);
        }
        return cellArray;
    }

    public ITableCellProperty[] createNewRow(int index) throws CoreException {
        SingleValuedProperty[] array = null;
        ITableCellProperty[] cellArray = null;
        try {
            array = this.emdProperty.createNewRow(index + 1);
        }
        catch (MetadataException me) {
            String message = me.getLocalizedMessage();
            message = message == null ? "" : message;
            Status status = new Status(4, "com.ibm.adapter.emd", 4, message, (Throwable)me);
            LogFacility.logErrorMessage((IStatus)status);
            throw new CoreException((IStatus)status);
        }
        if (array != null) {
            cellArray = new ITableCellPropertyWrapper[array.length];
            int i = 0;
            while (i < array.length) {
                SingleValuedProperty emdProp = array[i];
                ITableCellPropertyWrapper prop = this.createTableCellPropertyWrapper(emdProp, this.emdVersion);
                prop.setRow(index + 1);
                prop.setColumn(i);
                cellArray[i] = prop;
                prop.setParent((IPropertyDescriptor)this);
                emdProp.addPropertyChangeListener((PropertyChangeListener)this);
                this.wrapperMap_.put(emdProp, prop);
                ++i;
            }
            this.resetWrapperMapRows();
            this.propertyChanges.fireTableRowAdd(cellArray);
        }
        return cellArray;
    }

    public void deleteRow(int index) throws CoreException {
        SingleValuedProperty[] array = this.emdProperty.getRowProperties(index);
        ITableCellProperty[] cellArray = null;
        if (array != null) {
            cellArray = new ITableCellPropertyWrapper[array.length];
            int i = 0;
            while (i < array.length) {
                SingleValuedProperty emdProp = array[i];
                ITableCellPropertyWrapper prop = this.wrapperMap_.remove(emdProp);
                if (prop == null) {
                    prop = this.createTableCellPropertyWrapper(emdProp, this.emdVersion);
                    prop.setRow(index);
                    prop.setColumn(i);
                    prop.setParent((IPropertyDescriptor)this);
                }
                cellArray[i] = prop;
                emdProp.removePropertyChangeListener((PropertyChangeListener)this);
                ++i;
            }
        }
        this.emdProperty.deleteRow(index);
        this.resetWrapperMapRows();
        this.propertyChanges.fireTableRowRemove(cellArray);
    }

    public ITableCellProperty getCellProperty(int row, int column) throws CoreException {
        SingleValuedProperty emdProp = this.emdProperty.getCellProperty(row, column);
        ITableCellPropertyWrapper prop = null;
        if (emdProp != null && (prop = this.wrapperMap_.get(emdProp)) == null) {
            prop = this.createTableCellPropertyWrapper(emdProp, this.emdVersion);
            prop.setRow(row);
            prop.setColumn(column);
            prop.setParent((IPropertyDescriptor)this);
        }
        return prop;
    }

    public ITableProperty.ColumnDescriptor[] getColumns() throws CoreException {
        TableProperty.ColumnDescriptor[] array = this.emdProperty.getColumns();
        ColumnDescriptorWrapper[] cellArray = null;
        if (array != null) {
            cellArray = new ColumnDescriptorWrapper[array.length];
            int i = 0;
            while (i < array.length) {
                ColumnDescriptorWrapper prop;
                TableProperty.ColumnDescriptor emdProp = array[i];
                cellArray[i] = prop = new ColumnDescriptorWrapper(emdProp, this.emdVersion);
                prop.setParent((IPropertyDescriptor)this);
                ++i;
            }
        }
        return cellArray;
    }

    public ITableCellProperty[] getRowProperties(int index) throws CoreException {
        SingleValuedProperty[] array = this.emdProperty.getRowProperties(index);
        ITableCellPropertyWrapper[] cellArray = null;
        if (array != null) {
            cellArray = new ITableCellPropertyWrapper[array.length];
            int i = 0;
            while (i < array.length) {
                SingleValuedProperty emdProp = array[i];
                ITableCellPropertyWrapper prop = this.wrapperMap_.get(emdProp);
                if (prop == null) {
                    prop = this.createTableCellPropertyWrapper(emdProp, this.emdVersion);
                    prop.setRow(index);
                    prop.setColumn(i);
                    prop.setParent((IPropertyDescriptor)this);
                }
                cellArray[i] = prop;
                ++i;
            }
        }
        return cellArray;
    }

    public int rowCount() {
        return this.emdProperty.rowCount();
    }

    public String getValidationMessage() {
        return this.emdProperty.getValidationMessage();
    }

    public boolean isSet() {
        return this.emdProperty.isSet();
    }

    public boolean isValid() {
        return this.emdProperty.isValid();
    }

    public void unSet() {
        this.emdProperty.unSet();
    }

    public void moveRow(int to, int from) throws CoreException {
        if (from == to) {
            return;
        }
        SingleValuedProperty[] oldProperties = this.emdProperty.getRowProperties(from);
        this.emdProperty.deleteRow(from);
        Object array = null;
        try {
            this.emdProperty.createNewRow(to - 1);
        }
        catch (MetadataException me) {
            String message = me.getLocalizedMessage();
            message = message == null ? "" : message;
            Status status = new Status(4, "com.ibm.adapter.emd", 4, message, (Throwable)me);
            LogFacility.logErrorMessage((IStatus)status);
            throw new CoreException((IStatus)status);
        }
        if (oldProperties != null && array != null && oldProperties.length == (array).length) {
            int i = 0;
            while (i < oldProperties.length) {
                try {
                    array[i].setValue(oldProperties[i].getValue());
                }
                catch (MetadataException e) {
                    LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                    Status status = new Status(4, "com.ibm.adapter.emd", 4, e.getMessage() == null ? "" : e.getMessage(), (Throwable)e);
                    throw new CoreException((IStatus)status);
                }
                ++i;
            }
        } else {
            Status status = new Status(4, "com.ibm.adapter.emd", 4, MessageResource.MSG_ERROR_CANNOT_MOVE_ROW, null);
            throw new CoreException((IStatus)status);
        }
        this.propertyChanges.fireTableRowMove(to, from);
        this.resetWrapperMapRows();
    }

    public void propertyChange(PropertyEvent evt) {
        if (evt.getSource() == this.emdProperty) {
            int propertyChangeType = evt.getPropertyChangeType();
            if (propertyChangeType == 2) {
                this.propertyChanges.firePropertyEnabledChange(false);
            } else if (propertyChangeType == 1) {
                this.propertyChanges.firePropertyEnabledChange(true);
            } else if (propertyChangeType == 3) {
                this.propertyChanges.firePropertyValidValuesChanged();
            } else if (propertyChangeType == 0) {
                this.propertyChanges.firePropertyValueChange(evt.getOldValue(), evt.getNewValue());
            } else if (propertyChangeType == 4) {
                this.propertyChanges.firePropertyValid();
            } else if (propertyChangeType == 5) {
                this.propertyChanges.firePropertyInValid();
            } else if (propertyChangeType == 12) {
                this.propertyChanges.fireTableRowAdd((ITableCellProperty[])evt.getNewValue());
            } else if (propertyChangeType == 13) {
                this.propertyChanges.fireTableRowRemove((ITableCellProperty[])evt.getOldValue());
            } else if (propertyChangeType == 14) {
                this.propertyChanges.fireTableRowMove(((Integer)evt.getNewValue()).intValue(), ((Integer)evt.getOldValue()).intValue());
            }
        } else if (evt.getSource() instanceof SingleValuedProperty) {
            try {
                ITableCellPropertyWrapper wrapper = this.wrapperMap_.get((SingleValuedProperty)evt.getSource());
                if (wrapper == null) {
                    wrapper = this.createTableCellPropertyWrapper((SingleValuedProperty)evt.getSource(), this.emdVersion);
                    wrapper.setParent((IPropertyDescriptor)this);
                }
                if (evt.getPropertyChangeType() == 0) {
                    this.propertyChanges.firePropertyChange(new PropertyChangeEvent((IPropertyDescriptor)wrapper, evt.getOldValue(), evt.getNewValue(), 0));
                } else if (evt.getPropertyChangeType() == 1) {
                    this.propertyChanges.firePropertyChange(new PropertyChangeEvent((IPropertyDescriptor)wrapper, evt.getOldValue(), evt.getNewValue(), 1));
                } else if (evt.getPropertyChangeType() == 2) {
                    this.propertyChanges.firePropertyChange(new PropertyChangeEvent((IPropertyDescriptor)wrapper, evt.getOldValue(), evt.getNewValue(), 2));
                }
            }
            catch (CoreException coreException) {}
        }
    }

    void setHidden(boolean value) {
        try {
            ITableProperty.ColumnDescriptor[] columns = this.getColumns();
            int i = 0;
            while (i < columns.length) {
                ((ColumnDescriptorWrapper)columns[i]).setHidden(value);
                ++i;
            }
        }
        catch (CoreException coreException) {}
    }

    public ITableCellPropertyWrapper createTableCellPropertyWrapper(SingleValuedProperty emdProperty, String emdVersion) throws CoreException {
        PropertyChangeListener wrapper = null;
        wrapper = emdProperty instanceof BindingTypeProperty ? new TableCellBindingTypePropertyWrapper((BindingTypeProperty)emdProperty, emdVersion) : (emdProperty instanceof SchemaTypeProperty ? new TableCellSchemaTypePropertyWrapper((SchemaTypeProperty)emdProperty, emdVersion) : (emdProperty instanceof FileProperty ? new TableCellFilePropertyWrapper((FileProperty)emdProperty, emdVersion) : (emdProperty instanceof FolderProperty ? new TableCellFolderPropertyWrapper((FolderProperty)emdProperty, emdVersion) : (emdProperty instanceof JavaTypeProperty ? new TableCellJavaTypePropertyWrapper((JavaTypeProperty)emdProperty, emdVersion) : new TableCellPropertyWrapper(emdProperty, emdVersion)))));
        return wrapper;
    }

    protected void resetWrapperMapRows() {
        int i = 0;
        while (i < this.emdProperty.rowCount()) {
            SingleValuedProperty[] svps = this.emdProperty.getRowProperties(i);
            int j = 0;
            while (j < svps.length) {
                SingleValuedProperty emdProp = svps[j];
                ITableCellPropertyWrapper tableCellPropertyWrapper = this.wrapperMap_.get(emdProp);
                if (tableCellPropertyWrapper != null) {
                    tableCellPropertyWrapper.setRow(i);
                }
                ++j;
            }
            ++i;
        }
    }

    public TableProperty getWrappedProperty() {
        return this.emdProperty;
    }

    public boolean isExpert() {
        if (EMDDescriptor.isEMDSpecVersion13OrLater(this.emdVersion)) {
            return this.emdProperty.isExpert();
        }
        return false;
    }
}

