/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.emd.properties.wrapper;

import com.ibm.adapter.emd.internal.LogFacility;
import com.ibm.adapter.emd.internal.MessageResource;
import com.ibm.adapter.emd.internal.discovery.EMDDescriptor;
import com.ibm.adapter.emd.properties.wrapper.BaseParent;
import com.ibm.adapter.emd.properties.wrapper.PropertyTypeWrapper;
import com.ibm.propertygroup.IPropertyChangeListener;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.IPropertyType;
import com.ibm.propertygroup.ISingleValuedProperty;
import com.ibm.propertygroup.spi.IVetoableChangeListener;
import com.ibm.propertygroup.spi.PropertyChangeSupport;
import com.ibm.propertygroup.spi.PropertyVetoException;
import commonj.connector.metadata.MetadataException;
import commonj.connector.metadata.discovery.properties.PropertyChangeListener;
import commonj.connector.metadata.discovery.properties.PropertyEvent;
import commonj.connector.metadata.discovery.properties.SingleValuedProperty;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class SingleValuedPropertyWrapper
extends BaseParent
implements ISingleValuedProperty,
PropertyChangeListener {
    protected SingleValuedProperty emdProperty;
    protected PropertyTypeWrapper propertyType;

    public SingleValuedPropertyWrapper(SingleValuedProperty property, String emdVersion) throws CoreException {
        this.emdProperty = property;
        this.propertyChanges = new PropertyChangeSupport((IPropertyDescriptor)this);
        this.propertyType = new PropertyTypeWrapper(property.getPropertyType());
        this.emdProperty.addPropertyChangeListener((PropertyChangeListener)this);
        this.emdVersion = emdVersion;
    }

    public SingleValuedProperty getWrappedProperty() {
        return this.emdProperty;
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyChanges.addPropertyChangeListener(listener);
    }

    public void assignID(String id) throws CoreException {
        if (!"DEFAULT_PROPERTY_IDENTIFIER".equals(this.getID())) {
            Status status = new Status(4, "com.ibm.adapter.emd", 4, MessageResource.ERR_ID_SET, null);
            LogFacility.logErrorMessage((IStatus)status);
            throw new CoreException((IStatus)status);
        }
        this.propertyID = id;
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            SingleValuedPropertyWrapper clone = (SingleValuedPropertyWrapper)super.clone();
            clone.emdProperty = (SingleValuedProperty)this.emdProperty.clone();
            clone.emdProperty.addPropertyChangeListener((PropertyChangeListener)clone);
            clone.propertyChanges = new PropertyChangeSupport((IPropertyDescriptor)clone);
            clone.propertyType = new PropertyTypeWrapper(clone.emdProperty.getPropertyType());
            return clone;
        }
        catch (CloneNotSupportedException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            throw new CloneNotSupportedException(e.getLocalizedMessage());
        }
    }

    public String getDescription() {
        return this.emdProperty.getDescription();
    }

    public String getDisplayName() {
        return this.emdProperty.getDisplayName();
    }

    public String getID() {
        if (EMDDescriptor.isEMDSpecVersion11OrLater(this.emdVersion)) {
            return this.emdProperty.getID();
        }
        return this.propertyID;
    }

    public String getName() {
        return this.emdProperty.getName();
    }

    public int getPropertyFlag() {
        return 4353;
    }

    public IPropertyType getPropertyType() {
        return this.propertyType;
    }

    public String getValidationMessage() {
        return this.emdProperty.getValidationMessage();
    }

    public Object getValue() {
        return this.emdProperty.getValue();
    }

    public String getValueAsString() {
        return this.emdProperty.getValueAsString();
    }

    public boolean isEnabled() {
        return this.emdProperty.isEnabled();
    }

    public boolean isSet() {
        return this.emdProperty.isSet();
    }

    public boolean isValid() {
        return this.emdProperty.isValid();
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyChanges.removePropertyChangeListener(listener);
    }

    public void setValue(Object newValue) throws CoreException {
        if (!this.isEnabled()) {
            Status status = new Status(4, "com.ibm.adapter.emd", 4, MessageResource.ERR_PROPERTY_IS_DISABLED, null);
            LogFacility.logErrorMessage((IStatus)status);
            throw new CoreException((IStatus)status);
        }
        try {
            block6: {
                try {
                    this.propertyChanges.fireVetoableChange(this.emdProperty.getValue(), newValue);
                }
                catch (PropertyVetoException ex) {
                    if (ex.getErrorCode() == 0) {
                        Status status = new Status(4, "com.ibm.adapter.emd", 4, ex.getLocalizedMessage() != null ? ex.getLocalizedMessage() : "", (Throwable)ex);
                        throw new CoreException((IStatus)status);
                    }
                    if (ex.getErrorCode() != 1) break block6;
                    Status status = new Status(2, "com.ibm.adapter.emd", 2, ex.getLocalizedMessage() != null ? ex.getLocalizedMessage() : "", (Throwable)ex);
                    this.emdProperty.setValue(newValue);
                    throw new CoreException((IStatus)status);
                }
            }
            this.emdProperty.setValue(newValue);
        }
        catch (MetadataException e) {
            Status status = new Status(4, "com.ibm.adapter.emd", 4, e.getLocalizedMessage(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    public void setValueAsString(String newValue) throws CoreException {
        if (!this.isEnabled()) {
            Status status = new Status(4, "com.ibm.adapter.emd", 4, MessageResource.ERR_PROPERTY_IS_DISABLED, null);
            LogFacility.logErrorMessage((IStatus)status);
            throw new CoreException((IStatus)status);
        }
        try {
            block6: {
                try {
                    this.propertyChanges.fireVetoableChange(this.emdProperty.getValue(), (Object)newValue);
                }
                catch (PropertyVetoException ex) {
                    if (ex.getErrorCode() == 0) {
                        Status status = new Status(4, "com.ibm.adapter.emd", 4, ex.getLocalizedMessage() != null ? ex.getLocalizedMessage() : "", (Throwable)ex);
                        throw new CoreException((IStatus)status);
                    }
                    if (ex.getErrorCode() != 1) break block6;
                    Status status = new Status(2, "com.ibm.adapter.emd", 2, ex.getLocalizedMessage() != null ? ex.getLocalizedMessage() : "", (Throwable)ex);
                    this.emdProperty.setValueAsString(newValue);
                    throw new CoreException((IStatus)status);
                }
            }
            this.emdProperty.setValueAsString(newValue);
        }
        catch (MetadataException e) {
            Status status = new Status(4, "com.ibm.adapter.emd", 4, e.getLocalizedMessage(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    public void unSet() {
        this.emdProperty.unSet();
    }

    public void propertyChange(PropertyEvent evt) {
        if (evt.getSource() == this.emdProperty) {
            int propertyChangeType = evt.getPropertyChangeType();
            if (propertyChangeType == 2) {
                this.propertyChanges.firePropertyEnabledChange(false);
            } else if (propertyChangeType == 1) {
                this.propertyChanges.firePropertyEnabledChange(true);
            } else if (propertyChangeType == 3) {
                this.propertyChanges.firePropertyValidValuesChanged();
            } else if (propertyChangeType == 0) {
                this.propertyChanges.firePropertyValueChange(evt.getOldValue(), evt.getNewValue());
            } else if (propertyChangeType == 4) {
                this.propertyChanges.firePropertyValid();
            } else if (propertyChangeType == 5) {
                this.propertyChanges.firePropertyInValid();
            }
        }
    }

    public void addVetoablePropertyChangeListener(IVetoableChangeListener listener) {
        this.propertyChanges.addVetoableChangeListener(listener);
    }

    public void removeVetoablePropertyChangeListener(IVetoableChangeListener listener) {
        this.propertyChanges.removeVetoableChangeListener(listener);
    }

    public void setHidden(boolean value) {
        ((PropertyTypeWrapper)this.getPropertyType()).setHidden(value);
    }
}

