/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.emd.properties.wrapper;

import com.ibm.adapter.emd.internal.LogFacility;
import com.ibm.adapter.emd.internal.MessageResource;
import com.ibm.adapter.emd.internal.discovery.EMDDescriptor;
import com.ibm.adapter.emd.properties.wrapper.BaseParent;
import com.ibm.adapter.emd.properties.wrapper.PropertyGroupWrapper;
import com.ibm.propertygroup.INodeProperty;
import com.ibm.propertygroup.IPropertyChangeListener;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.spi.PropertyChangeSupport;
import commonj.connector.metadata.discovery.properties.NodeProperty;
import commonj.connector.metadata.discovery.properties.PropertyChangeListener;
import commonj.connector.metadata.discovery.properties.PropertyEvent;
import commonj.connector.metadata.discovery.properties.PropertyGroup;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class NodePropertyWrapper
extends BaseParent
implements INodeProperty,
PropertyChangeListener {
    protected NodeProperty emdProperty;
    protected PropertyGroupWrapper currrentConfigurationParameters = null;
    protected NodeProperty[] emdChildren_ = null;
    protected NodePropertyWrapper[] wrappedChildren_ = null;

    public NodePropertyWrapper(NodeProperty emdProperty, String emdVersion) {
        this.emdProperty = emdProperty;
        this.propertyChanges = new PropertyChangeSupport((IPropertyDescriptor)this);
        emdProperty.addPropertyChangeListener((PropertyChangeListener)this);
        this.emdVersion = emdVersion;
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyChanges.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyChanges.addPropertyChangeListener(listener);
    }

    public void assignID(String id) throws CoreException {
        if (!"DEFAULT_PROPERTY_IDENTIFIER".equals(this.getID())) {
            Status status = new Status(4, "com.ibm.adapter.emd", 4, MessageResource.ERR_ID_SET, null);
            LogFacility.logErrorMessage((IStatus)status);
            throw new CoreException((IStatus)status);
        }
        this.propertyID = id;
    }

    public String getID() {
        if (EMDDescriptor.isEMDSpecVersion11OrLater(this.emdVersion)) {
            return this.emdProperty.getID();
        }
        return this.propertyID;
    }

    public int getPropertyFlag() {
        return 272;
    }

    public void applyConfigurationProperties(IPropertyGroup properties) {
        try {
            if (properties != null && properties instanceof PropertyGroupWrapper) {
                PropertyGroup pg = ((PropertyGroupWrapper)properties).getWrappedPropertyGroup();
                this.emdProperty.applyConfigurationProperties(pg);
                properties.setParent((IPropertyDescriptor)this);
                this.currrentConfigurationParameters = (PropertyGroupWrapper)properties;
            } else {
                LogFacility.logErrorMessage((String)MessageResource.MSG_ERROR_INVALID_NODE_PROPS, null);
            }
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public IPropertyGroup createConfigurationProperties() {
        try {
            PropertyGroup group = this.emdProperty.createConfigurationProperties();
            if (group != null) {
                PropertyGroupWrapper wrapper = new PropertyGroupWrapper(group.getName(), group.getDisplayName(), group.getDescription(), this.emdVersion);
                wrapper.addPropertiesToPropertyGroup(group);
                wrapper.setParent((IPropertyDescriptor)this);
                return wrapper;
            }
            return null;
        }
        catch (CoreException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
        return null;
    }

    public INodeProperty[] getChildren() {
        NodeProperty[] children = this.emdProperty.getChildren();
        if (children != null && children.length > 0) {
            if (this.emdChildren_ == null || this.emdChildren_.length != children.length) {
                this.emdChildren_ = children;
                this.wrappedChildren_ = new NodePropertyWrapper[children.length];
                int i = children.length;
                while (--i >= 0) {
                    this.wrappedChildren_[i] = new NodePropertyWrapper(children[i], this.emdVersion);
                    this.wrappedChildren_[i].setParent((IPropertyDescriptor)this);
                }
            }
            return this.wrappedChildren_;
        }
        return new NodePropertyWrapper[0];
    }

    public boolean isSelected() {
        return this.emdProperty.isSelected();
    }

    public void setSelected(boolean selected) {
        this.emdProperty.setSelected(selected);
    }

    public void propertyChange(PropertyEvent evt) {
        if (evt.getSource() == this.emdProperty) {
            int propertyChangeType = evt.getPropertyChangeType();
            if (propertyChangeType == 10) {
                this.propertyChanges.fireTreePropertySelected();
            } else if (propertyChangeType == 11) {
                this.propertyChanges.fireTreePropertyDeselected();
            } else if (propertyChangeType == 17) {
                this.propertyChanges.fireTreeNodeHighlighted();
            } else if (propertyChangeType == 18) {
                this.propertyChanges.fireTreeNodeDehighlighted();
            }
        }
    }

    public String getValidationMessage() {
        return this.emdProperty.getValidationMessage();
    }

    public boolean isSet() {
        return this.emdProperty.isSet();
    }

    public boolean isValid() {
        return this.emdProperty.isValid();
    }

    public void unSet() {
        this.emdProperty.unSet();
    }

    public String getDescription() {
        return this.emdProperty.getDescription();
    }

    public String getDisplayName() {
        return this.emdProperty.getDisplayName();
    }

    public String getName() {
        return this.emdProperty.getName();
    }

    public boolean isEnabled() {
        return this.emdProperty.isEnabled();
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            NodePropertyWrapper clone = (NodePropertyWrapper)super.clone();
            clone.emdProperty = (NodeProperty)this.emdProperty.clone();
            clone.emdProperty.addPropertyChangeListener((PropertyChangeListener)clone);
            clone.propertyChanges = new PropertyChangeSupport((IPropertyDescriptor)clone);
            clone.emdChildren_ = clone.emdProperty.getChildren();
            if (clone.emdChildren_ != null) {
                clone.wrappedChildren_ = new NodePropertyWrapper[clone.emdChildren_.length];
                int i = clone.emdChildren_.length;
                while (--i >= 0) {
                    clone.wrappedChildren_[i] = new NodePropertyWrapper(clone.emdChildren_[i], this.emdVersion);
                    clone.wrappedChildren_[i].setParent((IPropertyDescriptor)clone);
                }
            } else {
                clone.wrappedChildren_ = null;
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            throw new CloneNotSupportedException(e.getLocalizedMessage());
        }
    }

    public void setHighLighted() {
        if (EMDDescriptor.isEMDSpecVersion12OrLater(this.emdVersion)) {
            this.emdProperty.setHighLighted(true);
        } else if (EMDDescriptor.isEMDSpecVersion11OrLater(this.emdVersion)) {
            this.emdProperty.setHighLighted();
        }
    }

    public IPropertyGroup getActiveConfigurationProperties() {
        return this.currrentConfigurationParameters;
    }

    public boolean isHighLighted() {
        if (EMDDescriptor.isEMDSpecVersion12OrLater(this.emdVersion)) {
            return this.emdProperty.isHighLighted();
        }
        return false;
    }

    public void setHighLighted(boolean highlighted) {
        if (EMDDescriptor.isEMDSpecVersion12OrLater(this.emdVersion)) {
            this.emdProperty.setHighLighted(highlighted);
        } else if (highlighted && EMDDescriptor.isEMDSpecVersion11OrLater(this.emdVersion)) {
            this.emdProperty.setHighLighted();
        }
    }

    public NodeProperty getWrappedProperty() {
        return this.emdProperty;
    }
}

