/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.emd.internal.properties.j2c;

import com.ibm.adapter.emd.extension.properties.JavaBeanPropertyGroup;
import com.ibm.adapter.emd.internal.LogFacility;
import com.ibm.adapter.emd.properties.j2c.spi.ResourceAdapterDescriptorProperties;
import com.ibm.adapter.emd.properties.j2c.spi.ResourceAdapterDescriptorPropertiesConstants;
import com.ibm.adapter.emd.properties.j2c.spi.ResourceAdapterDescriptorPropertiesCustomization;
import com.ibm.adapter.emd.util.EMDUtil;
import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.registry.Configuration;
import com.ibm.adapter.framework.registry.IRegistry;
import com.ibm.adapter.framework.registry.RegistryFactory;
import com.ibm.adapter.framework.util.QNameHelper;
import com.ibm.adapter.j2ca.Connector;
import com.ibm.adapter.j2ca.IResourceAdapterDescriptor;
import commonj.connector.metadata.MetadataException;
import commonj.connector.metadata.discovery.properties.PropertyDescriptor;
import commonj.connector.metadata.discovery.properties.PropertyGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.jca.AdminObject;
import org.eclipse.jst.j2ee.jca.OutboundResourceAdapter;
import org.eclipse.jst.j2ee.jca.RequiredConfigPropertyType;
import org.eclipse.jst.javaee.jca.ConnectionDefinition;
import org.eclipse.jst.javaee.jca.RequiredConfigProperty;

public class ResourceAdapterDescriptorPropertiesImpl
implements ResourceAdapterDescriptorProperties,
ResourceAdapterDescriptorPropertiesConstants {
    private IResourceAdapterDescriptor resourceAdapterDescriptor;
    private Map adminObjectDescriptorProperties = Collections.synchronizedMap(new HashMap());
    private Map connectionSpecProperties = Collections.synchronizedMap(new HashMap());
    private Map interactionSpecProperties = Collections.synchronizedMap(new HashMap());
    private Map<String, PropertyGroup> managedConnectionFactoryProperties = Collections.synchronizedMap(new HashMap());
    private Map messageListnerDescriptorProperties = Collections.synchronizedMap(new HashMap());
    private PropertyGroup resourceAdapterBeanProperties;
    private boolean isAdminObjectPropertiesInitialized;
    private boolean isConnectionSpecPropertiesInitialized;
    private boolean isInteractionSpecPropertiesInitialized;
    private boolean isMCFPropertiesInitialized;
    private boolean isMessageListenerPropertiesInitialized;
    private boolean isRABeanPropertiesInitialized;
    private boolean isCustomized;

    @Override
    public IResourceAdapterDescriptor getResourceAdapterDescriptor() {
        return this.resourceAdapterDescriptor;
    }

    @Override
    public void setResourceAdapterDescriptor(IResourceAdapterDescriptor resourceAdapterDescriptor) {
        this.resourceAdapterDescriptor = resourceAdapterDescriptor;
    }

    @Override
    public void addAdminObjectProperties(IResourceAdapterDescriptor.IAdminObjectDescriptor adminObjectDescriptor, PropertyGroup adminObjectPropertyGroup) {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        this.initializeAdminObjectProperties();
        this.adminObjectDescriptorProperties.put(adminObjectDescriptor, adminObjectPropertyGroup);
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
    }

    @Override
    public void addMessageListnerProperties(IResourceAdapterDescriptor.IMessageListenerDescriptor messageListenerDescriptor, PropertyGroup messageListenerPropertyGroup) {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            this.initializeMessageListenerProperties();
        }
        catch (BaseException e) {
            LogFacility.logErrorMessage((IStatus)e.getStatus());
            return;
        }
        this.messageListnerDescriptorProperties.put(messageListenerDescriptor, messageListenerPropertyGroup);
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
    }

    @Override
    public void addConnectionSpecProperties(String connectionSpecName, PropertyGroup connectionSpecPropertyGroup) {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            this.initializeConnectionSpecProperties();
        }
        catch (BaseException e) {
            LogFacility.logErrorMessage((IStatus)e.getStatus());
            return;
        }
        this.connectionSpecProperties.put(connectionSpecName, connectionSpecPropertyGroup);
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
    }

    public void addInteractionSpecProperties(String interactionSpecName, PropertyGroup interactionSpecPropertyGroup) {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            this.initializeInteractionSpecProperties();
        }
        catch (BaseException e) {
            LogFacility.logErrorMessage((IStatus)e.getStatus());
            return;
        }
        this.interactionSpecProperties.put(interactionSpecName, interactionSpecPropertyGroup);
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
    }

    @Override
    public void addManagedConnectionFactory(String managedConnectionFactoryName, PropertyGroup managedConnectionFactoryPropertyGroup) {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        this.initializeManagedConnectionFactoryProperties();
        this.managedConnectionFactoryProperties.put(managedConnectionFactoryName, managedConnectionFactoryPropertyGroup);
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
    }

    @Override
    public PropertyGroup getAdminObjectDescriptorProperties(IResourceAdapterDescriptor.IAdminObjectDescriptor adminObjectDescriptor) {
        block8: {
            if (LogFacility.trace) {
                LogFacility.TrcEntry();
            }
            this.initializeAdminObjectProperties();
            try {
                Object pg;
                ResourceAdapterDescriptorPropertiesCustomization customization = ResourceAdapterDescriptorPropertiesCustomization.getInstance();
                customization.customizeResourceAdapterDescriptorProperties(this);
                PropertyGroup propertyGroup = (PropertyGroup)this.adminObjectDescriptorProperties.get(adminObjectDescriptor);
                if (propertyGroup == null) break block8;
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
                if ((pg = propertyGroup.clone()) != null) {
                    return (PropertyGroup)pg;
                }
                return null;
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
                return null;
            }
        }
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
        return null;
    }

    @Override
    public PropertyGroup getMessageListenerProperties(IResourceAdapterDescriptor.IMessageListenerDescriptor messageListenerDescriptor) {
        block13: {
            if (LogFacility.trace) {
                LogFacility.TrcEntry();
            }
            try {
                this.initializeMessageListenerProperties();
            }
            catch (BaseException e1) {
                LogFacility.logErrorMessage((IStatus)e1.getStatus());
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
                return null;
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
                return null;
            }
            try {
                Object pg;
                ResourceAdapterDescriptorPropertiesCustomization customization = ResourceAdapterDescriptorPropertiesCustomization.getInstance();
                customization.customizeResourceAdapterDescriptorProperties(this);
                PropertyGroup propertyGroup = (PropertyGroup)this.messageListnerDescriptorProperties.get(messageListenerDescriptor);
                if (propertyGroup == null) break block13;
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
                if ((pg = propertyGroup.clone()) != null) {
                    return (PropertyGroup)pg;
                }
                return null;
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
                return null;
            }
        }
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
        return null;
    }

    @Override
    public PropertyGroup getConnectionSpecProperties(String connectionSpecName) {
        block13: {
            if (LogFacility.trace) {
                LogFacility.TrcEntry();
            }
            try {
                this.initializeConnectionSpecProperties();
            }
            catch (BaseException e1) {
                LogFacility.logErrorMessage((IStatus)e1.getStatus());
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
                return null;
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
                return null;
            }
            try {
                Object pg;
                ResourceAdapterDescriptorPropertiesCustomization customization = ResourceAdapterDescriptorPropertiesCustomization.getInstance();
                customization.customizeResourceAdapterDescriptorProperties(this);
                PropertyGroup propertyGroup = (PropertyGroup)this.connectionSpecProperties.get(connectionSpecName);
                if (propertyGroup == null) break block13;
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
                if ((pg = propertyGroup.clone()) != null) {
                    return (PropertyGroup)pg;
                }
                return null;
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
                return null;
            }
        }
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
        return null;
    }

    @Override
    public PropertyGroup getInteractionSpecProperties(String interactionSpecName) {
        block11: {
            if (LogFacility.trace) {
                LogFacility.TrcEntry();
            }
            try {
                try {
                    this.initializeInteractionSpecProperties();
                }
                catch (BaseException e1) {
                    LogFacility.logErrorMessage((IStatus)e1.getStatus());
                    if (LogFacility.trace) {
                        LogFacility.TrcExit();
                    }
                    return null;
                }
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
                return null;
            }
            ResourceAdapterDescriptorPropertiesCustomization customization = ResourceAdapterDescriptorPropertiesCustomization.getInstance();
            customization.customizeResourceAdapterDescriptorProperties(this);
            PropertyGroup propertyGroup = (PropertyGroup)this.interactionSpecProperties.get(interactionSpecName);
            if (propertyGroup == null) break block11;
            Object clone = propertyGroup.clone();
            if (clone != null) {
                return (PropertyGroup)clone;
            }
            return null;
        }
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
        return null;
    }

    @Override
    public PropertyGroup getManagedConnectionFactoryProperties(String managedConnectionFactoryName) {
        block7: {
            if (LogFacility.trace) {
                LogFacility.TrcEntry();
            }
            try {
                this.initializeManagedConnectionFactoryProperties();
                ResourceAdapterDescriptorPropertiesCustomization customization = ResourceAdapterDescriptorPropertiesCustomization.getInstance();
                customization.customizeResourceAdapterDescriptorProperties(this);
                PropertyGroup propertyGroup = this.managedConnectionFactoryProperties.get(managedConnectionFactoryName);
                if (propertyGroup == null) break block7;
                Object clone = propertyGroup.clone();
                if (clone != null) {
                    return (PropertyGroup)clone;
                }
                return null;
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
                return null;
            }
        }
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
        return null;
    }

    @Override
    public PropertyGroup getResourceAdapterBeanProperties() {
        block11: {
            if (LogFacility.trace) {
                LogFacility.TrcEntry();
            }
            this.initializeResourceAdapterBeanProperties();
            if (this.resourceAdapterBeanProperties == null) break block11;
            ResourceAdapterDescriptorPropertiesCustomization customization = ResourceAdapterDescriptorPropertiesCustomization.getInstance();
            customization.customizeResourceAdapterDescriptorProperties(this);
            PropertyGroup beanProperties = (PropertyGroup)this.resourceAdapterBeanProperties.clone();
            if (beanProperties != null) {
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
                return (PropertyGroup)beanProperties.clone();
            }
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            return null;
        }
        try {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            return null;
        }
        catch (BaseException e) {
            LogFacility.logErrorMessage((IStatus)e.getStatus());
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            return null;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            return null;
        }
    }

    public void refreshProperties() {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        if (this.isMCFPropertiesInitialized) {
            this.isMCFPropertiesInitialized = false;
        }
        if (this.isRABeanPropertiesInitialized) {
            this.isRABeanPropertiesInitialized = false;
        }
        if (this.isAdminObjectPropertiesInitialized) {
            this.isAdminObjectPropertiesInitialized = false;
        }
        if (this.isMessageListenerPropertiesInitialized) {
            this.isMessageListenerPropertiesInitialized = false;
        }
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
    }

    public void setResourceAdapterBeanProperties(PropertyGroup resourceAdapterBeanProperties) {
        this.resourceAdapterBeanProperties = resourceAdapterBeanProperties;
    }

    private void initializeAdminObjectProperties() {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        if (!this.isAdminObjectPropertiesInitialized) {
            IResourceAdapterDescriptor.IAdminObjectDescriptor[] adminObjectDescriptors = this.resourceAdapterDescriptor.getAdminObjects();
            if (adminObjectDescriptors != null) {
                int i = 0;
                while (i < adminObjectDescriptors.length) {
                    String adminObjectClass;
                    AdminObject adminObject;
                    IResourceAdapterDescriptor.IAdminObjectDescriptor adminObjectDescriptor = adminObjectDescriptors[i];
                    PropertyGroup adminObjectProperties = null;
                    if ("1.5".equals(this.resourceAdapterDescriptor.getSpecVersion())) {
                        adminObject = adminObjectDescriptor.getAdminObject();
                        adminObjectClass = adminObject.getAdminObjectClass();
                        adminObjectProperties = EMDUtil.createPropertyGroupFromConfigElements(adminObjectClass, (List)adminObject.getConfigProperties(), this.resourceAdapterDescriptor.getClassLoader());
                    } else if ("1.6".equals(this.resourceAdapterDescriptor.getSpecVersion())) {
                        adminObject = adminObjectDescriptor.getJca16AdminObject();
                        adminObjectClass = adminObject.getAdminobjectClass();
                        adminObjectProperties = EMDUtil.createPropertyGroupFromJca16ConfigElements(adminObjectClass, adminObject.getConfigProperty(), this.resourceAdapterDescriptor.getClassLoader());
                    }
                    this.adminObjectDescriptorProperties.put(adminObjectDescriptor, adminObjectProperties);
                    ++i;
                }
            }
            this.isAdminObjectPropertiesInitialized = true;
        }
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
    }

    private void initializeConnectionSpecProperties() throws BaseException {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            try {
                if (!this.isConnectionSpecPropertiesInitialized) {
                    String[] connectionSpecNames = this.resourceAdapterDescriptor.getConnectionSpecNames();
                    if (connectionSpecNames != null) {
                        int i = 0;
                        while (i < connectionSpecNames.length) {
                            String connectionSpecName = connectionSpecNames[i];
                            JavaBeanPropertyGroup connectionSpecPropertyGroup = new JavaBeanPropertyGroup(this.resourceAdapterDescriptor.getConnectionSpecClass(connectionSpecName), connectionSpecName);
                            this.connectionSpecProperties.put(connectionSpecName, connectionSpecPropertyGroup);
                            ++i;
                        }
                    }
                    this.isConnectionSpecPropertiesInitialized = true;
                }
            }
            catch (CoreException e) {
                throw new BaseException(e.getStatus());
            }
            catch (MetadataException e) {
                Status status = new Status(4, "com.ibm.adapter.emd", 4, e.getMessage() == null ? "" : e.getMessage(), (Throwable)e);
                throw new BaseException((IStatus)status);
            }
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    private void initializeInteractionSpecProperties() throws BaseException {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            try {
                if (!this.isInteractionSpecPropertiesInitialized) {
                    String[] interactionSpecNames = this.resourceAdapterDescriptor.getInteractionSpecNames();
                    if (interactionSpecNames != null) {
                        int i = 0;
                        while (i < interactionSpecNames.length) {
                            String interactionSpecName = interactionSpecNames[i];
                            JavaBeanPropertyGroup interactionSpecPropertyGroup = new JavaBeanPropertyGroup(this.resourceAdapterDescriptor.getInteractionSpecClass(interactionSpecName), interactionSpecName);
                            this.interactionSpecProperties.put(interactionSpecName, interactionSpecPropertyGroup);
                            ++i;
                        }
                    }
                    this.isInteractionSpecPropertiesInitialized = true;
                }
            }
            catch (CoreException e) {
                throw new BaseException(e.getStatus());
            }
            catch (MetadataException e) {
                Status status = new Status(4, "com.ibm.adapter.emd", 4, e.getMessage() == null ? "" : e.getMessage(), (Throwable)e);
                throw new BaseException((IStatus)status);
            }
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    private void initializeManagedConnectionFactoryProperties() {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        if (!this.isMCFPropertiesInitialized) {
            List connectionDefinitions;
            org.eclipse.jst.javaee.jca.OutboundResourceAdapter outboundAdapter;
            Connector connector = this.resourceAdapterDescriptor.getConnector();
            if ("1.0".equals(this.resourceAdapterDescriptor.getSpecVersion())) {
                String mcf = connector.getJca15Connector().getResourceAdapter().getManagedConnectionFactoryClass();
                PropertyGroup mcfProperties = EMDUtil.createPropertyGroupFromConfigElements(mcf, (List)connector.getJca15Connector().getResourceAdapter().getConfigProperties(), this.resourceAdapterDescriptor.getClassLoader());
                this.managedConnectionFactoryProperties.put(mcf, mcfProperties);
            } else if ("1.5".equals(this.resourceAdapterDescriptor.getSpecVersion())) {
                EList connectionDefinitions2;
                OutboundResourceAdapter outboundAdapter2 = connector.getJca15Connector().getResourceAdapter().getOutboundResourceAdapter();
                if (outboundAdapter2 != null && (connectionDefinitions2 = outboundAdapter2.getConnectionDefinitions()) != null) {
                    for (org.eclipse.jst.j2ee.jca.ConnectionDefinition def : connectionDefinitions2) {
                        String mcf = def.getManagedConnectionFactoryClass();
                        PropertyGroup mcfProperties = EMDUtil.createPropertyGroupFromConfigElements(mcf, (List)def.getConfigProperties(), this.resourceAdapterDescriptor.getClassLoader());
                        this.managedConnectionFactoryProperties.put(mcf, mcfProperties);
                    }
                }
            } else if ("1.6".equals(this.resourceAdapterDescriptor.getSpecVersion()) && (outboundAdapter = connector.getJca16Connector().getResourceadapter().getOutboundResourceadapter()) != null && (connectionDefinitions = outboundAdapter.getConnectionDefinition()) != null) {
                for (ConnectionDefinition def : connectionDefinitions) {
                    String mcf = def.getManagedconnectionfactoryClass();
                    PropertyGroup mcfProperties = EMDUtil.createPropertyGroupFromJca16ConfigElements(mcf, def.getConfigProperty(), this.resourceAdapterDescriptor.getClassLoader());
                    this.managedConnectionFactoryProperties.put(mcf, mcfProperties);
                }
            }
            this.isMCFPropertiesInitialized = true;
        }
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
    }

    private void initializeMessageListenerProperties() throws BaseException {
        block15: {
            if (LogFacility.trace) {
                LogFacility.TrcEntry();
            }
            try {
                try {
                    if (this.isMessageListenerPropertiesInitialized) break block15;
                    IResourceAdapterDescriptor.IMessageListenerDescriptor[] messageListenerDescriptors = this.resourceAdapterDescriptor.getMessageListeners();
                    if (messageListenerDescriptors != null) {
                        int i = 0;
                        while (i < messageListenerDescriptors.length) {
                            PropertyDescriptor property;
                            RequiredConfigPropertyType requiredProperty;
                            Iterator rpIter;
                            Object requiredProperties;
                            IResourceAdapterDescriptor.IMessageListenerDescriptor messageListenerDescriptor = messageListenerDescriptors[i];
                            JavaBeanPropertyGroup activationSpecProperties = new JavaBeanPropertyGroup(messageListenerDescriptor.getActivationSpecClass(), messageListenerDescriptor.getActivationSpecName());
                            if ("1.5".equals(this.resourceAdapterDescriptor.getSpecVersion())) {
                                requiredProperties = messageListenerDescriptor.getActivationSpec().getRequiredConfigProperties();
                                rpIter = requiredProperties.iterator();
                                while (rpIter.hasNext()) {
                                    requiredProperty = (RequiredConfigPropertyType)rpIter.next();
                                    property = activationSpecProperties.getProperty(requiredProperty.getName());
                                    if (property == null || !(property instanceof JavaBeanPropertyGroup.JavaBeanPropertyDescriptor)) continue;
                                    ((JavaBeanPropertyGroup.JavaBeanPropertyDescriptor)property).setRequired(true);
                                }
                            } else if ("1.6".equals(this.resourceAdapterDescriptor.getSpecVersion())) {
                                requiredProperties = messageListenerDescriptor.getJca16ActivationSpec().getRequiredConfigProperty();
                                rpIter = requiredProperties.iterator();
                                while (rpIter.hasNext()) {
                                    requiredProperty = (RequiredConfigProperty)rpIter.next();
                                    property = activationSpecProperties.getProperty(requiredProperty.getConfigPropertyName());
                                    if (property == null || !(property instanceof JavaBeanPropertyGroup.JavaBeanPropertyDescriptor)) continue;
                                    ((JavaBeanPropertyGroup.JavaBeanPropertyDescriptor)property).setRequired(true);
                                }
                            }
                            this.messageListnerDescriptorProperties.put(messageListenerDescriptor, activationSpecProperties);
                            ++i;
                        }
                    }
                    this.isMessageListenerPropertiesInitialized = true;
                }
                catch (CoreException e) {
                    throw new BaseException(e.getStatus());
                }
                catch (MetadataException e) {
                    Status status = new Status(4, "com.ibm.adapter.emd", 4, e.getMessage() == null ? "" : e.getMessage(), (Throwable)e);
                    throw new BaseException((IStatus)status);
                }
            }
            finally {
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
            }
        }
    }

    private void initializeResourceAdapterBeanProperties() throws BaseException {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            try {
                if (!this.isRABeanPropertiesInitialized) {
                    if ("1.5".equals(this.resourceAdapterDescriptor.getSpecVersion())) {
                        String resourceAdapterBeanName = this.resourceAdapterDescriptor.getResouceAdapterBeanName();
                        PropertyGroup raBeanProperties = EMDUtil.createPropertyGroupFromConfigElements(resourceAdapterBeanName, (List)this.resourceAdapterDescriptor.getConnector().getJca15Connector().getResourceAdapter().getConfigProperties(), this.resourceAdapterDescriptor.getClassLoader());
                        this.setResourceAdapterBeanProperties(raBeanProperties);
                        this.isRABeanPropertiesInitialized = true;
                    } else if ("1.6".equals(this.resourceAdapterDescriptor.getSpecVersion())) {
                        String resourceAdapterBeanName = this.resourceAdapterDescriptor.getResouceAdapterBeanName();
                        PropertyGroup raBeanProperties = EMDUtil.createPropertyGroupFromJca16ConfigElements(resourceAdapterBeanName, this.resourceAdapterDescriptor.getConnector().getJca16Connector().getResourceadapter().getConfigProperty(), this.resourceAdapterDescriptor.getClassLoader());
                        this.setResourceAdapterBeanProperties(raBeanProperties);
                        this.isRABeanPropertiesInitialized = true;
                    }
                }
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                throw BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    public boolean equals(Object obj) {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ResourceAdapterDescriptorProperties)) {
                return false;
            }
            ResourceAdapterDescriptorPropertiesImpl descriptor = (ResourceAdapterDescriptorPropertiesImpl)obj;
            if (this.resourceAdapterDescriptor.getConnectorProject() != null) {
                return this.resourceAdapterDescriptor.getConnectorProject().equals((Object)descriptor.getResourceAdapterDescriptor().getConnectorProject());
                {
                }
            }
            return this.resourceAdapterDescriptor.getConnectorProject() == null;
            {
            }
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    public int hashCode() {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            if (this.resourceAdapterDescriptor.getConnectorProject() != null) {
                int ret;
                int n = ret = this.resourceAdapterDescriptor.getConnectorProject().hashCode();
                return n;
            }
            return -1;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            return -1;
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    @Override
    public boolean isCustomized() {
        return this.isCustomized;
    }

    @Override
    public void setCustomized(boolean isCustomized) {
        this.isCustomized = isCustomized;
    }

    @Override
    public Configuration[] getSupportedDataConfigurations() {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            ResourceAdapterDescriptorPropertiesCustomization customization = ResourceAdapterDescriptorPropertiesCustomization.getInstance();
            customization.customizeResourceAdapterDescriptorProperties(this);
            List resourceAdapterDescriptors = customization.getResourceAdapterCustomization(this);
            ArrayList<Configuration> list = new ArrayList<Configuration>();
            Configuration[] allDataImportConfigurations = null;
            IRegistry importRegistry = RegistryFactory.getFactory().getRegistry();
            importRegistry.waitForRegistryProcessing();
            ArrayList<String> duplicatesFilter = new ArrayList<String>();
            Iterator it = resourceAdapterDescriptors.iterator();
            while (it.hasNext()) {
                try {
                    IConfigurationElement resourceAdapterDescriptor = (IConfigurationElement)it.next();
                    IConfigurationElement[] importConfigurationElements = resourceAdapterDescriptor.getChildren("ImportConfiguration");
                    int i = 0;
                    while (i < importConfigurationElements.length) {
                        block16: {
                            try {
                                IConfigurationElement importConfiguration = importConfigurationElements[i];
                                String QName2 = importConfiguration.getAttribute("QName").trim();
                                QName configQName = QNameHelper.createQName((String)QName2);
                                if (duplicatesFilter.contains(QName2)) break block16;
                                duplicatesFilter.add(QName2);
                                try {
                                    Configuration dataImportConfiguration = importRegistry.getConfiguration(configQName);
                                    if (dataImportConfiguration != null) {
                                        list.add(dataImportConfiguration);
                                    }
                                }
                                catch (BaseException ie) {
                                    LogFacility.logErrorMessage((IStatus)ie.getStatus());
                                }
                            }
                            catch (RuntimeException e) {
                                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                            }
                        }
                        ++i;
                    }
                }
                catch (RuntimeException e) {
                    LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            if (list.size() > 0) {
                allDataImportConfigurations = new Configuration[list.size()];
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
                return list.toArray(allDataImportConfigurations);
            }
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            return null;
        }
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
        return null;
    }
}

