/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.emd.internal.properties;

import com.ibm.adapter.emd.internal.LogFacility;
import com.ibm.adapter.emd.internal.discovery.EMDDescriptor;
import com.ibm.adapter.emd.internal.discovery.MessageUtil;
import com.ibm.adapter.emd.properties.wrapper.PropertyGroupWrapper;
import com.ibm.propertygroup.IPropertyChangeListener;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.PropertyChangeEvent;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import com.ibm.propertygroup.spi.BaseSingleValuedProperty;
import com.ibm.propertygroup.spi.IVetoableChangeListener;
import com.ibm.propertygroup.spi.PropertyVetoException;
import com.ibm.propertygroup.spi.common.FileProperty;
import commonj.connector.metadata.MetadataException;
import commonj.connector.metadata.discovery.AdapterType;
import commonj.connector.metadata.discovery.AdapterTypeSummary;
import commonj.connector.metadata.discovery.MetadataDiscovery;
import commonj.connector.metadata.discovery.connection.ConnectionType;
import commonj.connector.metadata.discovery.connection.OutboundConnectionConfiguration;
import commonj.connector.metadata.discovery.connection.OutboundConnectionType;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.osgi.util.NLS;

public class ConnectionPropertyGroup
extends BasePropertyGroup {
    private static final String ADAPTER_TYPE = "adapterType";
    private static final String ADAPTER_TYPE_PG = "adapterTypePG";
    private static final String CONNECTION_TYPE = "connectionType";
    private static final String CONNECTION_PROPS = "connectionProperties";
    private static final String LOGGING_OPTIONS = "loggingOptions";
    private static final String LOG_FILE_LOCATION = "logFileLocation";
    private static final String LOG_FILE_EXTENSION = "log";
    private static final String LOG_LEVEL = "loggingLevel";
    private HashMap adapterTypes = new HashMap();
    private HashMap connectionTypes = new HashMap();
    private OutboundConnectionConfiguration currentConnectionConfiguration;
    private MetadataDiscovery emdMetadataDiscovery;
    private BasePropertyGroup adapterTypePropertyGroup;
    private BaseSingleValuedProperty adapterTypeProperty;
    private BaseSingleValuedProperty connectionTypeProperty;
    private PropertyGroupWrapper connectionConfigurationProperties;
    private BasePropertyGroup loggingPropertyGroup;
    private FileProperty logFile;
    private BaseSingleValuedProperty loggingLevel;
    private String emdVersion;
    private MessageUtil messageUtil;

    public ConnectionPropertyGroup(String groupName, String displayName, String groupDescription, EMDDescriptor emdDescriptor, final MessageUtil messageUtil) throws CoreException {
        super(groupName, displayName, groupDescription);
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        this.messageUtil = messageUtil;
        this.emdMetadataDiscovery = emdDescriptor.getDiscoveryService();
        this.emdVersion = emdDescriptor.getSpecVersion();
        try {
            try {
                this.adapterTypePropertyGroup = new BasePropertyGroup(ADAPTER_TYPE_PG, messageUtil.getMessage("ADAPTER_CONNECTION_TYPE_DISPLAYNAME"), "");
                AdapterTypeSummary[] adapterTypeSummaries = this.emdMetadataDiscovery.getAdapterTypeSummaries();
                StringBuffer adapterDescription = new StringBuffer(messageUtil.getMessage("ADAPTER_TYPE_PROP_DESCRIPTION"));
                adapterDescription.append("<OL>");
                int i = 0;
                while (i < adapterTypeSummaries.length) {
                    this.adapterTypes.put(adapterTypeSummaries[i].getDisplayName(), adapterTypeSummaries[i]);
                    adapterDescription.append("<LI><B>").append(adapterTypeSummaries[i].getDisplayName()).append("</B>:  ").append(adapterTypeSummaries[i].getDescription()).append("</LI><BR>");
                    ++i;
                }
                adapterDescription.append("</OL>");
                this.adapterTypeProperty = new BaseSingleValuedProperty(ADAPTER_TYPE, messageUtil.getMessage("ADAPTER_TYPE_PROP_DISPLAY_NAME"), adapterDescription.toString(), String.class, this.adapterTypePropertyGroup);
                this.adapterTypeProperty.setDefaultValue((Object)adapterTypeSummaries[0].getDisplayName());
                this.adapterTypeProperty.setRequired(true);
                this.adapterTypeProperty.setEnabled(true);
                this.adapterTypeProperty.setValidValues((Object[])this.adapterTypes.keySet().toArray(new String[0]));
                this.adapterTypeProperty.setValidValuesEditable(false);
                this.adapterTypeProperty.addVetoablePropertyChangeListener((IVetoableChangeListener)this);
                if (adapterTypeSummaries.length == 1) {
                    this.adapterTypeProperty.setHidden(true);
                } else {
                    this.addProperty((IPropertyDescriptor)this.adapterTypePropertyGroup);
                }
                this.connectionConfigurationProperties = new PropertyGroupWrapper(CONNECTION_PROPS, messageUtil.getMessage("CONNECTION_PROPS_DISPLAY_NAME"), messageUtil.getMessage("CONNECTION_PROPS_DESCRIPTION"), this.emdVersion);
                this.connectionConfigurationProperties.setEnabled(false);
                this.addProperty((IPropertyDescriptor)this.connectionConfigurationProperties);
                try {
                    this.loggingPropertyGroup = new BasePropertyGroup(LOGGING_OPTIONS, messageUtil.getMessage("LOGGING_OPTS_DISPLAY_NAME"), messageUtil.getMessage("LOGGING_OPTS_DESCRIPTION"));
                    this.logFile = new FileProperty(LOG_FILE_LOCATION, messageUtil.getMessage("LOG_FILE_DISPLAY_NAME"), messageUtil.getMessage("LOG_FILE_DESCRIPTION"), this.loggingPropertyGroup, new String[]{LOG_FILE_EXTENSION}, false);
                    this.logFile.addVetoablePropertyChangeListener(new IVetoableChangeListener(){

                        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                            if (evt.getNewValue() != null) {
                                URI uri = (URI)evt.getNewValue();
                                File f = new File(uri.toFileString());
                                boolean created = false;
                                try {
                                    created = f.createNewFile();
                                }
                                catch (IOException iOException) {
                                    throw new PropertyVetoException(messageUtil.getMessage("MSG_ERROR_CANNOT_WRITE_LOG_FILE"), (java.beans.PropertyChangeEvent)evt);
                                }
                                boolean canWrite = f.canWrite();
                                if (created) {
                                    f.delete();
                                }
                                if (!canWrite) {
                                    throw new PropertyVetoException(messageUtil.getMessage("MSG_ERROR_CANNOT_WRITE_LOG_FILE"), (java.beans.PropertyChangeEvent)evt);
                                }
                            }
                        }
                    });
                    String className = this.emdMetadataDiscovery.getClass().getName();
                    int index = className.lastIndexOf(46);
                    if (index > 0) {
                        className = className.substring(index + 1);
                    }
                    String defaultLogFileLocation = Platform.getLogFileLocation().removeLastSegments(1).append(String.valueOf(className) + ".log").toOSString();
                    this.logFile.setDefaultValue((Object)URI.createFileURI((String)defaultLogFileLocation));
                    this.logFile.setValue(this.logFile.getPropertyType().getDefaultValue());
                    this.logFile.setExpert(true);
                    this.logFile.setEnabled(true);
                    this.logFile.setRequired(true);
                    this.loggingLevel = new BaseSingleValuedProperty(LOG_LEVEL, messageUtil.getMessage("LOG_LEVEL_DISPLAY_NAME"), messageUtil.getMessage("LOG_LEVEL_DESCRIPTION"), String.class, this.loggingPropertyGroup);
                    this.loggingLevel.setExpert(true);
                    this.loggingLevel.setEnabled(true);
                    this.loggingLevel.setRequired(true);
                    this.loggingLevel.setDefaultValue((Object)Level.SEVERE.getLocalizedName());
                    this.loggingLevel.setValue((Object)Level.SEVERE.getLocalizedName());
                    this.loggingLevel.setValidValues((Object[])new String[]{Level.ALL.getLocalizedName(), Level.OFF.getLocalizedName(), Level.FINE.getLocalizedName(), Level.FINER.getLocalizedName(), Level.FINEST.getLocalizedName(), Level.CONFIG.getLocalizedName(), Level.INFO.getLocalizedName(), Level.SEVERE.getLocalizedName(), Level.WARNING.getLocalizedName()});
                    this.addProperty((IPropertyDescriptor)this.loggingPropertyGroup);
                    this.adapterTypeProperty.setValue(this.adapterTypeProperty.getPropertyType().getDefaultValue());
                }
                catch (Throwable e) {
                    LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            catch (MetadataException e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                throw new CoreException((IStatus)new Status(4, "com.ibm.adapter.emd", 4, NLS.bind((String)messageUtil.getMessage("MSG_ERROR_ANNONYMOUS_EMD_ERROR"), (Object)e.getLocalizedMessage()), (Throwable)e));
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                throw new CoreException((IStatus)new Status(4, "com.ibm.adapter.emd", 4, e.getLocalizedMessage() != null ? e.getLocalizedMessage() : "", (Throwable)e));
            }
            catch (Throwable e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                throw new CoreException((IStatus)new Status(4, "com.ibm.adapter.emd", 4, e.getLocalizedMessage() != null ? e.getLocalizedMessage() : "", e));
            }
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            ConnectionPropertyGroup clone = (ConnectionPropertyGroup)((Object)super.clone());
            clone.adapterTypePropertyGroup = (BasePropertyGroup)clone.getProperty(ADAPTER_TYPE_PG);
            clone.adapterTypeProperty = (BaseSingleValuedProperty)this.adapterTypePropertyGroup.getProperty(ADAPTER_TYPE);
            clone.adapterTypeProperty.addVetoablePropertyChangeListener((IVetoableChangeListener)clone);
            clone.connectionTypeProperty = (BaseSingleValuedProperty)this.adapterTypePropertyGroup.getProperty(CONNECTION_TYPE);
            if (this.connectionTypeProperty != null) {
                clone.connectionTypeProperty.addPropertyChangeListener((IPropertyChangeListener)clone);
                clone.connectionConfigurationProperties = (PropertyGroupWrapper)clone.getProperty(CONNECTION_PROPS);
            }
            clone.loggingPropertyGroup = (BasePropertyGroup)clone.getProperty(LOGGING_OPTIONS);
            if (clone.loggingPropertyGroup != null) {
                clone.logFile = (FileProperty)clone.loggingPropertyGroup.getProperty(LOG_FILE_LOCATION);
                clone.loggingLevel = (BaseSingleValuedProperty)clone.loggingPropertyGroup.getProperty(LOG_LEVEL);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            throw new CloneNotSupportedException(e.getLocalizedMessage());
        }
    }

    public OutboundConnectionConfiguration getConnectionConfiguration() {
        try {
            this.currentConnectionConfiguration.applyUnifiedProperties(this.connectionConfigurationProperties.getWrappedPropertyGroup());
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
        return this.currentConnectionConfiguration;
    }

    public ConnectionType getConnectionType() {
        return (ConnectionType)this.connectionTypes.get(this.connectionTypeProperty.getValue());
    }

    public String getLogFileLocation() {
        return this.logFile.getFileLocation();
    }

    public Level getLoggingLevel() {
        String levelName = this.loggingLevel.getValueAsString();
        Level level = Level.parse(levelName);
        return level;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        try {
            OutboundConnectionType connectionType;
            if (evt.getSource() == this.connectionTypeProperty && evt.getPropertyChangeType() == 0 && (connectionType = (OutboundConnectionType)this.connectionTypes.get(evt.getNewValue())) != null) {
                this.connectionConfigurationProperties.setEnabled(true);
                this.currentConnectionConfiguration = connectionType.createOutboundConnectionConfiguration();
                this.connectionConfigurationProperties.addPropertiesToPropertyGroup(this.currentConnectionConfiguration.createUnifiedProperties());
            }
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        block18: {
            if (evt.getSource() == this.adapterTypeProperty && evt.getPropertyChangeType() == 0) {
                String adapterTypeName = (String)evt.getNewValue();
                AdapterTypeSummary summary = (AdapterTypeSummary)this.adapterTypes.get(adapterTypeName);
                if (summary == null) {
                    throw new PropertyVetoException(this.messageUtil.getMessage("MSG_ERROR_ADAPTERTYPE_NULL"), (java.beans.PropertyChangeEvent)evt, 0);
                }
                AdapterType adapterType = null;
                try {
                    adapterType = this.emdMetadataDiscovery.getAdapterType(summary.getId());
                    if (adapterType == null) {
                        throw new PropertyVetoException(NLS.bind((String)this.messageUtil.getMessage("MSG_ERROR_ADAPTERTYPE_NOT_RESOLVED"), (Object)summary.getDisplayName()), (java.beans.PropertyChangeEvent)evt, 0);
                    }
                }
                catch (Throwable e) {
                    LogFacility.logErrorMessage((String)NLS.bind((String)this.messageUtil.getMessage("MSG_ERROR_ADAPTERTYPE_NOT_RESOLVED"), (Object)summary.getDisplayName()), (Throwable)e);
                    throw new PropertyVetoException(NLS.bind((String)this.messageUtil.getMessage("MSG_ERROR_ADAPTERTYPE_NOT_RESOLVED"), (Object)summary.getDisplayName()), (java.beans.PropertyChangeEvent)evt, 0);
                }
                try {
                    String defaultValue = null;
                    OutboundConnectionType[] outboundConnectionTypes = adapterType.getOutboundConnectionTypes();
                    StringBuffer connectionTypeDescriptions = new StringBuffer();
                    int i = outboundConnectionTypes.length;
                    while (--i >= 0) {
                        OutboundConnectionType connectionType = outboundConnectionTypes[i];
                        if (!connectionType.isSupportedInMetadataService()) continue;
                        if (connectionType.getDisplayName() == null) {
                            LogFacility.logErrorMessage((String)NLS.bind((String)this.messageUtil.getMessage("MSG_ERROR_CONNTYPE_NULL_DISPLAY"), (Object)Integer.toString(i), (Object)summary.getDisplayName()), null);
                            continue;
                        }
                        if (connectionType.getDescription() == null) {
                            LogFacility.logErrorMessage((String)NLS.bind((String)this.messageUtil.getMessage("MSG_ERROR_CONNTYPE_NULL_DESCRIPTION"), (Object)Integer.toString(i), (Object)summary.getDisplayName()), null);
                            continue;
                        }
                        if (connectionType.getId() == null) {
                            LogFacility.logErrorMessage((String)NLS.bind((String)this.messageUtil.getMessage("MSG_ERROR_CONNTYPE_NULL_ID"), (Object)Integer.toString(i), (Object)summary.getDisplayName()), null);
                            continue;
                        }
                        this.connectionTypes.put(connectionType.getDisplayName(), connectionType);
                        connectionTypeDescriptions.append("<LI><B>").append(connectionType.getDisplayName()).append("</B>:  ").append(connectionType.getDescription()).append("</LI>");
                        if (defaultValue != null) continue;
                        defaultValue = connectionType.getDisplayName();
                    }
                    if (defaultValue != null) {
                        if (this.connectionTypeProperty != null) {
                            this.adapterTypePropertyGroup.remove((IPropertyDescriptor)this.connectionTypeProperty);
                        }
                        StringBuffer connectorTypeDescription = new StringBuffer(this.messageUtil.getMessage("CONNECTION_TYPE_PROP_DESCRIPTION"));
                        connectorTypeDescription.append("<OL>").append(connectionTypeDescriptions.toString()).append("</OL>");
                        this.connectionTypeProperty = new BaseSingleValuedProperty(CONNECTION_TYPE, this.messageUtil.getMessage("CONNECTION_TYPE_PROP_DISPLAY_NAME"), connectorTypeDescription.toString(), String.class, this.adapterTypePropertyGroup);
                        if (this.connectionTypes.size() == 1) {
                            this.connectionTypeProperty.setHidden(true);
                        } else if (this.getProperty(this.adapterTypePropertyGroup.getName()) == null) {
                            this.replaceAll(new IPropertyDescriptor[]{this.adapterTypePropertyGroup, this.connectionConfigurationProperties, this.loggingPropertyGroup});
                        }
                        this.connectionTypeProperty.setRequired(true);
                        this.connectionTypeProperty.addPropertyChangeListener((IPropertyChangeListener)this);
                        this.connectionTypeProperty.setValidValuesEditable(false);
                        this.connectionTypeProperty.setEnabled(true);
                        Object[] values = this.connectionTypes.keySet().toArray();
                        Object[] validValues = new String[values.length];
                        int i2 = values.length;
                        while (--i2 >= 0) {
                            validValues[i2] = (String)values[i2];
                        }
                        this.connectionTypeProperty.setValidValues(validValues);
                        this.connectionTypeProperty.setDefaultValue((Object)defaultValue);
                        this.connectionTypeProperty.setValue((Object)defaultValue);
                        break block18;
                    }
                    if (this.connectionTypeProperty != null) {
                        this.adapterTypePropertyGroup.remove((IPropertyDescriptor)this.connectionTypeProperty);
                    }
                    throw new PropertyVetoException(NLS.bind((String)this.messageUtil.getMessage("MSG_ERROR_CONNTYPE_NOT_LOADED"), (Object)summary.getDisplayName()), (java.beans.PropertyChangeEvent)evt);
                }
                catch (Throwable e) {
                    LogFacility.logErrorMessage((String)NLS.bind((String)this.messageUtil.getMessage("MSG_ERROR_CONNTYPE_NOT_LOADED"), (Object)summary.getDisplayName()), (Throwable)e);
                    throw new PropertyVetoException(NLS.bind((String)this.messageUtil.getMessage("MSG_ERROR_CONNTYPE_NOT_LOADED"), (Object)summary.getDisplayName()), (java.beans.PropertyChangeEvent)evt, 0);
                }
            }
        }
    }
}

