/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.emd.internal.properties;

import com.ibm.adapter.emd.properties.wrapper.SingleValuedPropertyWrapper;
import com.ibm.propertygroup.IPropertyChangeListener;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.PropertyChangeEvent;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import com.ibm.propertygroup.spi.BaseSingleValuedProperty;
import commonj.connector.metadata.discovery.properties.SingleValuedProperty;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.CoreException;

public class BooleanPropertyGroup
extends BasePropertyGroup
implements IPropertyChangeListener {
    protected BaseSingleValuedProperty booleanProperty_;
    protected String booleanPropertyName_;
    protected boolean selected_ = false;

    public BooleanPropertyGroup(String groupName, String displayName, String groupDescription, boolean selected, boolean expert, boolean createBooleanProperty) throws CoreException {
        super(groupName, displayName, groupDescription);
        this.assignID("com.ibm.j2c.ui.racustomization.radiobutton_property_group");
        this.selected_ = selected;
        if (createBooleanProperty) {
            this.initializePropertyGroup(groupName, displayName, groupDescription, selected, expert);
        }
    }

    protected void initializePropertyGroup(String name, String dName, String desc, boolean selected, boolean expert) throws CoreException {
        this.booleanProperty_ = new BaseSingleValuedProperty(name, dName, desc, Boolean.class, (BasePropertyGroup)this);
        this.booleanProperty_.setEnabled(true);
        this.booleanProperty_.setValue((Object)new Boolean(selected));
        this.booleanProperty_.addPropertyChangeListener((IPropertyChangeListener)this);
        this.booleanProperty_.setExpert(expert);
        this.booleanPropertyName_ = name;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyChangeType() == 0 && evt.getSource() == this.booleanProperty_) {
            this.enableProperties((IPropertyGroup)this, (Boolean)this.booleanProperty_.getValue(), false);
        }
    }

    protected void enableProperties(IPropertyGroup group, boolean enabled, boolean isChildren) {
        if (group == null || group.getProperties() == null) {
            return;
        }
        IPropertyDescriptor[] properties = group.getProperties();
        int i = 1;
        while (i < properties.length) {
            IPropertyDescriptor ipd = properties[i];
            if (ipd instanceof IPropertyGroup) {
                boolean status = enabled;
                if (ipd instanceof BooleanPropertyGroup) {
                    BooleanPropertyGroup subGroup = (BooleanPropertyGroup)ipd;
                    BaseSingleValuedProperty booleanProperty = subGroup.getBooleanProperty();
                    boolean subStatus = (Boolean)booleanProperty.getValue();
                    booleanProperty.setEnabled(status);
                    status = status && subStatus;
                }
                this.enableProperties((IPropertyGroup)ipd, status, true);
            } else {
                String name = ipd.getName();
                IPropertyDescriptor property = group.getProperty(name);
                if (property != null) {
                    if (property instanceof BaseSingleValuedProperty) {
                        ((BaseSingleValuedProperty)property).setEnabled(enabled);
                    } else if (property instanceof SingleValuedPropertyWrapper) {
                        SingleValuedPropertyWrapper wrapper = (SingleValuedPropertyWrapper)property;
                        SingleValuedProperty emdProperty = wrapper.getWrappedProperty();
                        this.setEMDPropertyEnabled(emdProperty, enabled);
                    }
                }
            }
            ++i;
        }
    }

    protected void setEMDPropertyEnabled(SingleValuedProperty emdProperty, boolean enabled) {
        try {
            Method method = emdProperty.getClass().getMethod("setEnabled", Boolean.TYPE);
            method.invoke((Object)emdProperty, enabled);
        }
        catch (Exception exception) {}
    }

    public BaseSingleValuedProperty getBooleanProperty() {
        return this.booleanProperty_;
    }

    public void setBooleanProperty(BaseSingleValuedProperty newValue) {
        this.booleanProperty_ = newValue;
        this.booleanPropertyName_ = this.booleanProperty_.getName();
    }

    public Object clone() throws CloneNotSupportedException {
        BooleanPropertyGroup clone = (BooleanPropertyGroup)((Object)super.clone());
        BaseSingleValuedProperty property = (BaseSingleValuedProperty)clone.getProperty(this.booleanPropertyName_);
        if (property != null) {
            clone.booleanProperty_ = property;
            clone.booleanProperty_.setEnabled(property.isEnabled());
            property.addPropertyChangeListener((IPropertyChangeListener)clone);
        }
        return clone;
    }

    public void addProperty(IPropertyDescriptor property) {
        super.addProperty(property);
        if (property instanceof BaseSingleValuedProperty) {
            ((BaseSingleValuedProperty)property).setEnabled(this.selected_);
        } else if (property instanceof SingleValuedPropertyWrapper) {
            SingleValuedPropertyWrapper wrapper = (SingleValuedPropertyWrapper)property;
            SingleValuedProperty emdProperty = wrapper.getWrappedProperty();
            this.setEMDPropertyEnabled(emdProperty, this.selected_);
        }
    }
}

