/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.emd.internal.extension.discovery.connection;

import com.ibm.adapter.emd.extension.discovery.connection.spi.OutboundConnectionType;
import com.ibm.adapter.emd.extension.discovery.spi.AdapterType;
import com.ibm.adapter.emd.internal.LogFacility;
import com.ibm.adapter.emd.internal.MessageResource;
import com.ibm.adapter.emd.internal.extension.discovery.connection.OutboundConnectionConfigurationImpl;
import com.ibm.adapter.emd.util.EMDUtil;
import com.ibm.adapter.j2ca.IResourceAdapterDescriptor;
import commonj.connector.metadata.MetadataException;
import commonj.connector.metadata.discovery.connection.ConnectionConfiguration;
import commonj.connector.metadata.discovery.connection.ConnectionPersistence;
import commonj.connector.metadata.discovery.connection.MetadataConnection;
import commonj.connector.metadata.discovery.connection.OutboundConnectionConfiguration;
import commonj.connector.metadata.discovery.connection.OutboundConnectionType;
import commonj.connector.metadata.discovery.properties.PropertyDescriptor;
import commonj.connector.metadata.discovery.properties.PropertyGroup;
import commonj.connector.metadata.discovery.properties.SingleValuedProperty;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;

public class OutboundConnectionTypeImpl
implements OutboundConnectionType {
    private String managedConnectionFactoryName;
    private AdapterType adapterType;
    private String description;
    private String displayName;
    private String id;
    private boolean isSupportedInMetadataService;
    private boolean isSupportedAtRuntime = true;
    private ConnectionPersistence connectionPersistence;

    public OutboundConnectionType.OutboundConnectionBeans createOutboundConnectionBeans() {
        OutboundConnectionBeansImpl newOutboundConnectionBeans = null;
        try {
            newOutboundConnectionBeans = new OutboundConnectionBeansImpl();
            IResourceAdapterDescriptor resourceAdapterDescriptor = this.adapterType.getResourceAdapterDescriptor();
            Class mcfBean = resourceAdapterDescriptor.getManagedConnectionFactoryClass(this.managedConnectionFactoryName);
            ManagedConnectionFactory mcf = (ManagedConnectionFactory)mcfBean.newInstance();
            newOutboundConnectionBeans.setManagedConnectionFactoryJavaBean(mcf);
            if ("1.5".equals(resourceAdapterDescriptor.getSpecVersion()) || "1.6".equals(resourceAdapterDescriptor.getSpecVersion())) {
                Class raBean = resourceAdapterDescriptor.getResouceAdapterBeanClass();
                ResourceAdapter ra = (ResourceAdapter)raBean.newInstance();
                newOutboundConnectionBeans.setResourceAdapterJavaBean(ra);
            }
        }
        catch (Exception e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
        return newOutboundConnectionBeans;
    }

    public OutboundConnectionConfiguration createOutboundConnectionConfiguration() {
        OutboundConnectionConfigurationImpl outboundConnectionConfiguration = new OutboundConnectionConfigurationImpl();
        StringBuffer ocfName = new StringBuffer().append(this.adapterType.getDisplayName()).append(" ").append(this.adapterType.getVendor()).append(" ").append(this.adapterType.getVersion()).append(" ").append(MessageResource.ADAPTER_OUTBOUND_CONNECTION_CONFIGURATION);
        outboundConnectionConfiguration.setName(ocfName.toString());
        outboundConnectionConfiguration.setDescription(ocfName.toString());
        outboundConnectionConfiguration.setOutboundConnectionType(this);
        return outboundConnectionConfiguration;
    }

    public boolean isSupportedAtRuntime() {
        return this.isSupportedAtRuntime;
    }

    public boolean isSupportedInMetadataService() {
        return this.isSupportedInMetadataService;
    }

    public MetadataConnection openMetadataConnection(OutboundConnectionConfiguration outboundConnectionConfiguration) throws MetadataException {
        return null;
    }

    public void synchronizeFromManagedConnectionFactoryToPropertyGroup(ManagedConnectionFactory managedConnectionFactory, PropertyGroup propertyGroup) throws MetadataException {
        EMDUtil.synchronizeFromBeanToPropertyGroup(managedConnectionFactory, propertyGroup);
    }

    public void synchronizeFromOutboundBeansToUnifiedPropertyGroup(OutboundConnectionType.OutboundConnectionBeans outboundConnectionBeans, PropertyGroup propertyGroup) throws MetadataException {
        EMDUtil.synchronizeFromBeanToPropertyGroup(outboundConnectionBeans.getManagedConnectionFactoryJavaBean(), propertyGroup);
        EMDUtil.synchronizeFromBeanToPropertyGroup(outboundConnectionBeans.getResourceAdapterJavaBean(), propertyGroup);
    }

    public void synchronizeFromPropertyGroupToManagedConnectionFactory(PropertyGroup propertyGroup, ManagedConnectionFactory managedConnectionFactory) throws MetadataException {
        EMDUtil.getBean(managedConnectionFactory, propertyGroup);
    }

    public void synchronizeFromUnifiedPropertyGroupToBeans(PropertyGroup propertyGroup, OutboundConnectionType.OutboundConnectionBeans outboundConnectionBeans) throws MetadataException {
        EMDUtil.getBean(outboundConnectionBeans.getManagedConnectionFactoryJavaBean(), propertyGroup);
        EMDUtil.getBean(outboundConnectionBeans.getResourceAdapterJavaBean(), propertyGroup);
    }

    public commonj.connector.metadata.discovery.AdapterType getAdapterType() {
        return this.adapterType;
    }

    public ConnectionPersistence getConnectionPersistence() throws MetadataException {
        return this.connectionPersistence;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getId() {
        return this.id;
    }

    public boolean isConnectionConfigurationComplete(ConnectionConfiguration connectionConfiguration) {
        OutboundConnectionConfigurationImpl outboundConnectionConfiguration = (OutboundConnectionConfigurationImpl)connectionConfiguration;
        PropertyDescriptor[] descriptors = outboundConnectionConfiguration.createUnifiedProperties().getProperties();
        boolean isConnConfComplete = true;
        int i = 0;
        while (i < descriptors.length) {
            PropertyDescriptor descriptor = descriptors[i];
            if (descriptor instanceof PropertyGroup) {
                if (!this.checkRequiredProperties((PropertyGroup)descriptor)) {
                    isConnConfComplete = false;
                    break;
                }
            } else {
                SingleValuedProperty property = (SingleValuedProperty)descriptor;
                Object value = property.getValue();
                if (value == null) {
                    isConnConfComplete = false;
                    break;
                }
            }
            ++i;
        }
        return isConnConfComplete;
    }

    public void synchronizeFromPropertyGroupToResourceAdapter(PropertyGroup propertyGroup, ResourceAdapter resourceAdapter) throws MetadataException {
        EMDUtil.getBean(resourceAdapter, propertyGroup);
    }

    public void synchronizeFromResourceAdapterToPropertyGroup(ResourceAdapter resourceAdapter, PropertyGroup propertyGroup) throws MetadataException {
        EMDUtil.synchronizeFromBeanToPropertyGroup(resourceAdapter, propertyGroup);
    }

    @Override
    public String getManagedConnectionFactoryName() {
        return this.managedConnectionFactoryName;
    }

    @Override
    public void setManagedConnectionFactoryName(String managedConnectionFactoryName) {
        this.managedConnectionFactoryName = managedConnectionFactoryName;
    }

    @Override
    public void setAdapterType(AdapterType adapterType) {
        this.adapterType = adapterType;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public void setId(String connectionTypeId) {
        this.id = connectionTypeId;
    }

    @Override
    public void setIsSupportedAtRuntime(boolean isSupportedAtRuntime) {
        this.isSupportedAtRuntime = isSupportedAtRuntime;
    }

    @Override
    public void setIsSupportedInMetadataService(boolean isSupportedInMetadataService) {
        this.isSupportedInMetadataService = isSupportedInMetadataService;
    }

    @Override
    public void setConnectionPersistence(ConnectionPersistence connectionPersistence) {
        this.connectionPersistence = connectionPersistence;
    }

    private boolean checkRequiredProperties(PropertyGroup propertyGroup) {
        PropertyDescriptor[] descriptors = propertyGroup.getProperties();
        boolean isConnConfComplete = true;
        int i = 0;
        while (i < descriptors.length) {
            PropertyDescriptor descriptor = descriptors[i];
            if (descriptor instanceof PropertyGroup) {
                if (!this.checkRequiredProperties((PropertyGroup)descriptor)) {
                    isConnConfComplete = false;
                    break;
                }
            } else {
                SingleValuedProperty property = (SingleValuedProperty)descriptor;
                Object value = property.getValue();
                if (value == null) {
                    isConnConfComplete = false;
                    break;
                }
            }
            ++i;
        }
        return isConnConfComplete;
    }

    public class OutboundConnectionBeansImpl
    implements OutboundConnectionType.OutboundConnectionBeans {
        private ManagedConnectionFactory mcf;
        private ResourceAdapter ra;

        public ManagedConnectionFactory getManagedConnectionFactoryJavaBean() {
            return this.mcf;
        }

        public void setManagedConnectionFactoryJavaBean(ManagedConnectionFactory mcf) {
            this.mcf = mcf;
        }

        public ResourceAdapter getResourceAdapterJavaBean() {
            return this.ra;
        }

        public void setResourceAdapterJavaBean(ResourceAdapter ra) {
            this.ra = ra;
        }
    }
}

