/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.emd.internal.extension.discovery.connection;

import com.ibm.adapter.emd.extension.discovery.connection.spi.InboundConnectionType;
import com.ibm.adapter.emd.extension.discovery.spi.AdapterType;
import com.ibm.adapter.emd.internal.LogFacility;
import com.ibm.adapter.emd.internal.MessageResource;
import com.ibm.adapter.emd.internal.extension.discovery.connection.InboundConnectionConfigurationImpl;
import com.ibm.adapter.emd.util.EMDUtil;
import com.ibm.adapter.j2ca.IResourceAdapterDescriptor;
import commonj.connector.metadata.MetadataException;
import commonj.connector.metadata.discovery.connection.ConnectionConfiguration;
import commonj.connector.metadata.discovery.connection.ConnectionPersistence;
import commonj.connector.metadata.discovery.connection.InboundConnectionConfiguration;
import commonj.connector.metadata.discovery.connection.InboundConnectionType;
import commonj.connector.metadata.discovery.properties.PropertyDescriptor;
import commonj.connector.metadata.discovery.properties.PropertyGroup;
import commonj.connector.metadata.discovery.properties.SingleValuedProperty;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.ResourceAdapter;

public class InboundConnectionTypeImpl
implements InboundConnectionType {
    private String activationSpecName;
    private AdapterType adapterType;
    private String description;
    private String displayName;
    private String id;
    private ConnectionPersistence connectionPersistence;

    public InboundConnectionType.InboundConnectionBeans createInboundConnectionBeans() {
        InboundConnectionBeansImpl newInboundConnectionBeans = null;
        try {
            newInboundConnectionBeans = new InboundConnectionBeansImpl();
            IResourceAdapterDescriptor resourceAdapterDescriptor = this.adapterType.getResourceAdapterDescriptor();
            IResourceAdapterDescriptor.IMessageListenerDescriptor[] listeners = resourceAdapterDescriptor.getMessageListeners();
            if (listeners != null && listeners.length != 0) {
                Class asBean = null;
                int i = 0;
                while (i < listeners.length) {
                    Class aClass = listeners[0].getActivationSpecClass();
                    if (aClass.getName().equals(this.activationSpecName)) {
                        asBean = aClass;
                        break;
                    }
                    ++i;
                }
                if (asBean != null) {
                    ActivationSpec as = (ActivationSpec)asBean.newInstance();
                    newInboundConnectionBeans.setActivationSpecJavaBean(as);
                    if ("1.5".equals(resourceAdapterDescriptor.getSpecVersion()) || "1.6".equals(resourceAdapterDescriptor.getSpecVersion())) {
                        Class raBean = resourceAdapterDescriptor.getResouceAdapterBeanClass();
                        ResourceAdapter ra = (ResourceAdapter)raBean.newInstance();
                        newInboundConnectionBeans.setResourceAdapterJavaBean(ra);
                    }
                }
            }
        }
        catch (Exception exc) {
            LogFacility.logErrorMessage((String)exc.getLocalizedMessage(), (Throwable)exc);
        }
        return newInboundConnectionBeans;
    }

    public InboundConnectionConfiguration createInboundConnectionConfiguration() {
        InboundConnectionConfigurationImpl inboundConnectionConfiguration = new InboundConnectionConfigurationImpl();
        StringBuffer ocfName = new StringBuffer().append(this.adapterType.getDisplayName()).append(" ").append(this.adapterType.getVendor()).append(" ").append(this.adapterType.getVersion()).append(" ").append(MessageResource.ADAPTER_INBOUND_CONNECTION_CONFIGURATION);
        inboundConnectionConfiguration.setName(ocfName.toString());
        inboundConnectionConfiguration.setDescription(ocfName.toString());
        inboundConnectionConfiguration.setInboundConnectionType(this);
        return inboundConnectionConfiguration;
    }

    public void synchronizeFromActivationSpecToPropertyGroup(ActivationSpec activationSpec, PropertyGroup propertyGroup) throws MetadataException {
        EMDUtil.synchronizeFromBeanToPropertyGroup(activationSpec, propertyGroup);
    }

    public void synchronizeFromInboundBeansToUnifiedPropertyGroup(InboundConnectionType.InboundConnectionBeans inboundConnectionBeans, PropertyGroup propertyGroup) throws MetadataException {
        EMDUtil.synchronizeFromBeanToPropertyGroup(inboundConnectionBeans.getActivationSpecJavaBean(), propertyGroup);
        EMDUtil.synchronizeFromBeanToPropertyGroup(inboundConnectionBeans.getResourceAdapterJavaBean(), propertyGroup);
    }

    public void synchronizeFromPropertyGroupToActivationSpec(PropertyGroup propertyGroup, ActivationSpec activationSpec) throws MetadataException {
        EMDUtil.getBean(activationSpec, propertyGroup);
    }

    public void synchronizeFromUnifiedPropertyGroupToBeans(PropertyGroup propertyGroup, InboundConnectionType.InboundConnectionBeans inboundConnectionBeans) throws MetadataException {
        EMDUtil.getBean(inboundConnectionBeans.getActivationSpecJavaBean(), propertyGroup);
        EMDUtil.getBean(inboundConnectionBeans.getResourceAdapterJavaBean(), propertyGroup);
    }

    public commonj.connector.metadata.discovery.AdapterType getAdapterType() {
        return this.adapterType;
    }

    public ConnectionPersistence getConnectionPersistence() throws MetadataException {
        return this.connectionPersistence;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getId() {
        return this.id;
    }

    public boolean isConnectionConfigurationComplete(ConnectionConfiguration connectionConfiguration) {
        InboundConnectionConfigurationImpl inboundConnectionConfiguration = (InboundConnectionConfigurationImpl)connectionConfiguration;
        PropertyDescriptor[] descriptors = inboundConnectionConfiguration.createUnifiedProperties().getProperties();
        boolean isConnConfComplete = true;
        int i = 0;
        while (i < descriptors.length) {
            PropertyDescriptor descriptor = descriptors[i];
            if (descriptor instanceof PropertyGroup) {
                if (!this.checkRequiredProperties((PropertyGroup)descriptor)) {
                    isConnConfComplete = false;
                    break;
                }
            } else {
                SingleValuedProperty property = (SingleValuedProperty)descriptor;
                Object value = property.getValue();
                if (value == null) {
                    isConnConfComplete = false;
                    break;
                }
            }
            ++i;
        }
        return isConnConfComplete;
    }

    public void synchronizeFromPropertyGroupToResourceAdapter(PropertyGroup propertyGroup, ResourceAdapter resourceAdapter) throws MetadataException {
        EMDUtil.getBean(resourceAdapter, propertyGroup);
    }

    public void synchronizeFromResourceAdapterToPropertyGroup(ResourceAdapter resourceAdapter, PropertyGroup propertyGroup) throws MetadataException {
        EMDUtil.synchronizeFromBeanToPropertyGroup(resourceAdapter, propertyGroup);
    }

    @Override
    public void setConnectionPersistence(ConnectionPersistence connectionPersistence) {
        this.connectionPersistence = connectionPersistence;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public void setId(String connectionTypeId) {
        this.id = connectionTypeId;
    }

    @Override
    public String getActivationSpecName() {
        return this.activationSpecName;
    }

    @Override
    public void setActivationSpecName(String activationSpecName) {
        this.activationSpecName = activationSpecName;
    }

    @Override
    public void setAdapterType(AdapterType adapterType) {
        this.adapterType = adapterType;
    }

    private boolean checkRequiredProperties(PropertyGroup propertyGroup) {
        PropertyDescriptor[] descriptors = propertyGroup.getProperties();
        boolean isConnConfComplete = true;
        int i = 0;
        while (i < descriptors.length) {
            PropertyDescriptor descriptor = descriptors[i];
            if (descriptor instanceof PropertyGroup) {
                if (!this.checkRequiredProperties((PropertyGroup)descriptor)) {
                    isConnConfComplete = false;
                    break;
                }
            } else {
                SingleValuedProperty property = (SingleValuedProperty)descriptor;
                Object value = property.getValue();
                if (value == null) {
                    isConnConfComplete = false;
                    break;
                }
            }
            ++i;
        }
        return isConnConfComplete;
    }

    public class InboundConnectionBeansImpl
    implements InboundConnectionType.InboundConnectionBeans {
        private ActivationSpec as;
        private ResourceAdapter ra;

        public ActivationSpec getActivationSpecJavaBean() {
            return this.as;
        }

        public ResourceAdapter getResourceAdapterJavaBean() {
            return this.ra;
        }

        public void setActivationSpecJavaBean(ActivationSpec as) {
            this.as = as;
        }

        public void setResourceAdapterJavaBean(ResourceAdapter ra) {
            this.ra = ra;
        }
    }
}

