/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.emd.internal.discovery;

import com.ibm.adapter.asi.registry.ApplicationSpecificSchemaProperties;
import com.ibm.adapter.asi.registry.ApplicationSpecificSchemaRegistryFactory;
import com.ibm.adapter.asi.registry.IApplicationSpecificSchemaRegistry;
import com.ibm.adapter.asi.registry.IApplicationSpecificSchemaRegistrySPI;
import com.ibm.adapter.binding.registry.BindingRegistryFactory;
import com.ibm.adapter.binding.registry.IBinding;
import com.ibm.adapter.binding.registry.IBindingRegistry;
import com.ibm.adapter.binding.registry.IBindingRegistrySPI;
import com.ibm.adapter.binding.registry.ServiceTypes;
import com.ibm.adapter.emd.internal.LogFacility;
import com.ibm.adapter.emd.internal.MessageResource;
import com.ibm.adapter.emd.internal.build.EMDBuildAgent;
import com.ibm.adapter.emd.internal.discovery.EMDDescriptor;
import com.ibm.adapter.emd.internal.discovery.EMDDiscoveryAgent;
import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.IDiscoveryAgent;
import com.ibm.adapter.framework.internal.build.IBuildAgent;
import com.ibm.adapter.framework.internal.registry.Registry;
import com.ibm.adapter.j2ca.IResourceAdapterDescriptor;
import com.ibm.adapter.j2ca.RegistryFactory;
import com.ibm.adapter.j2ca.spi.util.InMemoryClassLoader;
import com.ibm.propertygroup.ui.api.IPropertyGroupUIExtension;
import com.ibm.propertygroup.ui.api.IPropertyUIExtension;
import com.ibm.propertygroup.ui.internal.utilities.PropertyUIExtensionRegistry;
import commonj.connector.metadata.BindingConfigurationEdit;
import commonj.connector.metadata.MetadataException;
import commonj.connector.metadata.build.Binding;
import commonj.connector.metadata.build.BindingProvider;
import commonj.connector.metadata.build.MetadataBuild;
import commonj.connector.metadata.discovery.AdapterTypeSummary;
import commonj.connector.metadata.discovery.MetadataDiscovery;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EMDHelper {
    public static final String DESCRIPTION_ELEMENT = "description";
    public static final String DISCOVERY_CLASS_ELEMENT = "discoveryService-class";
    public static final String DISCOVERY_SERVICE_XML = "discovery-service.xml";
    public static final String DISPLAY_NAME_ELEMENT = "display-name";
    public static final String DS_ELEMENT = "discoveryService";
    public static final String EMD_NAMESPACE = "commonj.connector";
    public static final String J2EE_NAMESPACE = "http://java.sun.com/xml/ns/j2ee";
    public static final String METADATA_EDIT_CLASS = "metadataEdit-class";
    public static final String METADATA_BUILD_CLASS = "metadataBuild-class";
    public static final String METADATA_TYPE_CLASS = "metadataType-class";
    public static final String ADAPTER_CONFIGURATION_CLASS = "adapterConfiguration-class";
    public static final String BINDING_PROVIDER_CLASS = "bindingProvider-class";
    public static final String SPEC_VERSION_ELEMENT = "spec-version";
    public static final String VENDOR_NAME_ELEMENT = "vendor-name";
    public static final String VERSION_ELEMENT = "version";
    public static final String ASI_ELEMENT = "application-specific-schema";
    public static final String ASI_LOCATION_ELEMENT = "asiSchemaLocation";
    public static final String ASI_URI_ELEMENT = "asiNSURI";
    public static final String UI_OVERRIDE = "uiOverride";
    public static final String UI_OVERRIDE_CLASS = "uiOverride-class";
    public static final String UI_OVERRIDE_ATTR_PROPERTY_ID = "propertyID";
    public static final String UI_OVERRIDE_ATTR_TYPE = "type";
    public static final String UI_OVERRIDE_TYPE_GROUP = "group";
    public static final String UI_OVERRIDE_TYPE_PROPERTY = "property";
    public static final String CLASSIFICATION = "JCA";
    static final String ATTRIBUTE_NAME__LANG_LOCALE = "xml:lang";
    static final String ATTRIBUTE__LANG_LOCALE__LANGUAGE_DEFAULT_VALUE = "en";
    static final String ATTRIBUTE__LANG_LOCALE__COUNTRY_DEFAULT_VALUE = "US";
    static final String EMD_RESOURCE_WRITER = "com/ibm/adapter/emdwriter:EISImportExportWriter";

    public static final IFile getDescoveryServiceXML(IProject connectorProject) {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        IFile discoveryFile = EMDHelper.findDescoveryServiceXML((IContainer)connectorProject);
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
        return discoveryFile;
    }

    public static final EMDDescriptor parseDiscoveryServiceXML(IFile discoveryFile) throws BaseException {
        EMDDescriptor emdDescriptor;
        block37: {
            if (LogFacility.trace) {
                LogFacility.TrcEntry();
            }
            emdDescriptor = new EMDDescriptor();
            emdDescriptor.setConnectorProject(discoveryFile.getProject());
            try {
                try {
                    Element[] ui;
                    Element[] asi;
                    Element[] bindingProvider;
                    Element[] adapterConfig;
                    Element[] metadataType;
                    Element[] metadataEdit;
                    InputStream xmlDescriptor = discoveryFile.getContents();
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    factory.setNamespaceAware(true);
                    factory.setValidating(false);
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    InputSource iSource = new InputSource(xmlDescriptor);
                    Document doc = builder.parse(iSource);
                    xmlDescriptor.close();
                    Element[] rootElement = EMDHelper.findElements(EMD_NAMESPACE, DS_ELEMENT, doc);
                    if (rootElement == null || rootElement.length != 1) {
                        BaseException e = BaseException.createException((String)NLS.bind((String)MessageResource.MSG_ERROR_NO_DESCOVERY_ELEMENT, (Object)discoveryFile.getFullPath().toString()), null);
                        LogFacility.logErrorMessage((IStatus)e.getStatus());
                        throw e;
                    }
                    Element discoveryService = rootElement[0];
                    Element[] displayName = EMDHelper.findElements(J2EE_NAMESPACE, DISPLAY_NAME_ELEMENT, discoveryService);
                    String displayNameString = EMDHelper.findCorrectLocale(displayName);
                    if (displayNameString == null) {
                        BaseException e = BaseException.createException((String)NLS.bind((String)MessageResource.MSG_ERROR_NO_DISPLAY_ELEMENT, (Object)discoveryFile.getFullPath().toString()), null);
                        LogFacility.logErrorMessage((IStatus)e.getStatus());
                        throw e;
                    }
                    emdDescriptor.setDisplayName(displayNameString);
                    Element[] description = EMDHelper.findElements(J2EE_NAMESPACE, DESCRIPTION_ELEMENT, discoveryService);
                    String descriptionString = EMDHelper.findCorrectLocale(description);
                    if (descriptionString == null) {
                        BaseException e = BaseException.createException((String)NLS.bind((String)MessageResource.MSG_ERROR_NO_DESCRIPTION_ELEMENT, (Object)discoveryFile.getFullPath().toString()), null);
                        LogFacility.logErrorMessage((IStatus)e.getStatus());
                        throw e;
                    }
                    emdDescriptor.setDescription(descriptionString);
                    Element[] vendor = EMDHelper.findElements(EMD_NAMESPACE, VENDOR_NAME_ELEMENT, discoveryService);
                    if (vendor == null || vendor.length != 1 || vendor[0].getFirstChild() == null || vendor[0].getFirstChild().getNodeValue() == null || vendor[0].getFirstChild().getNodeValue().equals("")) {
                        BaseException e = BaseException.createException((String)NLS.bind((String)MessageResource.MSG_ERROR_NO_VENDOR_ELEMENT, (Object)discoveryFile.getFullPath().toString()), null);
                        LogFacility.logErrorMessage((IStatus)e.getStatus());
                        throw e;
                    }
                    emdDescriptor.setVendorName(vendor[0].getFirstChild().getNodeValue().trim());
                    Element[] version = EMDHelper.findElements(EMD_NAMESPACE, VERSION_ELEMENT, discoveryService);
                    if (version == null || version.length != 1 || version[0].getFirstChild() == null || version[0].getFirstChild().getNodeValue() == null || version[0].getFirstChild().getNodeValue().equals("")) {
                        BaseException e = BaseException.createException((String)NLS.bind((String)MessageResource.MSG_ERROR_NO_VERSION_ELEMENT, (Object)discoveryFile.getFullPath().toString()), null);
                        LogFacility.logErrorMessage((IStatus)e.getStatus());
                        throw e;
                    }
                    emdDescriptor.setVersion(version[0].getFirstChild().getNodeValue().trim());
                    Element[] specVersion = EMDHelper.findElements(EMD_NAMESPACE, SPEC_VERSION_ELEMENT, discoveryService);
                    if (specVersion == null || specVersion.length != 1 || specVersion[0].getFirstChild() == null || specVersion[0].getFirstChild().getNodeValue() == null || specVersion[0].getFirstChild().getNodeValue().equals("")) {
                        BaseException e = BaseException.createException((String)NLS.bind((String)MessageResource.MSG_ERROR_NO_SPEC_VERSION_ELEMENT, (Object)discoveryFile.getFullPath().toString()), null);
                        LogFacility.logErrorMessage((IStatus)e.getStatus());
                        throw e;
                    }
                    emdDescriptor.setSpecVersion(specVersion[0].getFirstChild().getNodeValue().trim());
                    Element[] discoveryClass = EMDHelper.findElements(EMD_NAMESPACE, DISCOVERY_CLASS_ELEMENT, discoveryService);
                    if (discoveryClass != null) {
                        if (discoveryClass.length != 1 || discoveryClass[0].getFirstChild() == null || discoveryClass[0].getFirstChild().getNodeValue() == null || discoveryClass[0].getFirstChild().getNodeValue().equals("")) {
                            BaseException e = BaseException.createException((String)NLS.bind((String)MessageResource.MSG_ERROR_NO_DESCOVERY_CLASS_ELEMENT, (Object)discoveryFile.getFullPath().toString()), null);
                            LogFacility.logErrorMessage((IStatus)e.getStatus());
                            throw e;
                        }
                        emdDescriptor.setDiscoveryServiceClass(discoveryClass[0].getFirstChild().getNodeValue().trim());
                    }
                    if ((metadataEdit = EMDHelper.findElements(EMD_NAMESPACE, METADATA_EDIT_CLASS, discoveryService)) == null || metadataEdit.length != 1 || metadataEdit[0].getFirstChild() == null || metadataEdit[0].getFirstChild().getNodeValue() == null || metadataEdit[0].getFirstChild().getNodeValue().equals("")) {
                        BaseException e = BaseException.createException((String)NLS.bind((String)MessageResource.MSG_ERROR_NO_EDIT_ELEMENT, (Object)discoveryFile.getFullPath().toString()), null);
                        LogFacility.logErrorMessage((IStatus)e.getStatus());
                        throw e;
                    }
                    emdDescriptor.setMetadataEditClass(metadataEdit[0].getFirstChild().getNodeValue().trim());
                    Element[] metadataBuild = EMDHelper.findElements(EMD_NAMESPACE, METADATA_BUILD_CLASS, discoveryService);
                    if (metadataBuild != null && metadataBuild.length >= 1 && metadataBuild[0].getFirstChild() != null && metadataBuild[0].getFirstChild().getNodeValue() != null && !metadataBuild[0].getFirstChild().getNodeValue().equals("")) {
                        emdDescriptor.setMetadataBuildClass(metadataBuild[0].getFirstChild().getNodeValue().trim());
                    }
                    if ((metadataType = EMDHelper.findElements(EMD_NAMESPACE, METADATA_TYPE_CLASS, discoveryService)) != null && metadataType.length >= 1 && metadataType[0].getFirstChild() != null && metadataType[0].getFirstChild().getNodeValue() != null && !metadataType[0].getFirstChild().getNodeValue().equals("")) {
                        emdDescriptor.setMetadataTypeClass(metadataType[0].getFirstChild().getNodeValue().trim());
                    }
                    if ((adapterConfig = EMDHelper.findElements(EMD_NAMESPACE, ADAPTER_CONFIGURATION_CLASS, discoveryService)) != null && adapterConfig.length >= 1 && adapterConfig[0].getFirstChild() != null && adapterConfig[0].getFirstChild().getNodeValue() != null && !adapterConfig[0].getFirstChild().getNodeValue().equals("")) {
                        emdDescriptor.setAdapterConfigurationClass(adapterConfig[0].getFirstChild().getNodeValue().trim());
                    }
                    if ((bindingProvider = EMDHelper.findElements(EMD_NAMESPACE, BINDING_PROVIDER_CLASS, discoveryService)) != null && bindingProvider.length >= 1 && bindingProvider[0].getFirstChild() != null && bindingProvider[0].getFirstChild().getNodeValue() != null && !bindingProvider[0].getFirstChild().getNodeValue().equals("")) {
                        emdDescriptor.setBindingProviderClass(bindingProvider[0].getFirstChild().getNodeValue().trim());
                    }
                    if ((asi = EMDHelper.findElements(EMD_NAMESPACE, ASI_ELEMENT, discoveryService)) != null && asi.length > 0) {
                        int i = asi.length;
                        while (--i >= 0) {
                            EMDDescriptor.ASI asiEntry = emdDescriptor.new EMDDescriptor.ASI();
                            Element[] asiDisplayName = EMDHelper.findElements(J2EE_NAMESPACE, DISPLAY_NAME_ELEMENT, asi[i]);
                            if (asiDisplayName == null || asiDisplayName.length != 1 || asiDisplayName[0].getFirstChild() == null || asiDisplayName[0].getFirstChild().getNodeValue() == null || asiDisplayName[0].getFirstChild().getNodeValue().equals("")) {
                                LogFacility.logErrorMessage((String)NLS.bind((String)MessageResource.MSG_ERROR_NO_DISPLAYANAME_ASI, (Object)Integer.toString(i), (Object)discoveryFile.getFullPath().toString()), null);
                                continue;
                            }
                            asiEntry.setDisplayName(asiDisplayName[0].getFirstChild().getNodeValue().trim());
                            Element[] asiDescription = EMDHelper.findElements(J2EE_NAMESPACE, DESCRIPTION_ELEMENT, asi[i]);
                            if (asiDescription == null || asiDescription.length != 1 || asiDescription[0].getFirstChild() == null || asiDescription[0].getFirstChild().getNodeValue() == null || asiDescription[0].getFirstChild().getNodeValue().equals("")) {
                                LogFacility.logErrorMessage((String)NLS.bind((String)MessageResource.MSG_ERROR_NO_DESCRIPTION_ASI, (Object)Integer.toString(i), (Object)discoveryFile.getFullPath().toString()), null);
                                continue;
                            }
                            asiEntry.setDescription(asiDescription[0].getFirstChild().getNodeValue().trim());
                            Element[] asiLocation = EMDHelper.findElements(EMD_NAMESPACE, ASI_LOCATION_ELEMENT, asi[i]);
                            if (asiLocation == null || asiLocation.length != 1 || asiLocation[0].getFirstChild() == null || asiLocation[0].getFirstChild().getNodeValue() == null || asiLocation[0].getFirstChild().getNodeValue().equals("")) {
                                LogFacility.logErrorMessage((String)NLS.bind((String)MessageResource.MSG_ERROR_NO_SCHEMA_ASI, (Object)Integer.toString(i), (Object)discoveryFile.getFullPath().toString()), null);
                                continue;
                            }
                            asiEntry.setSchemaLocation(asiLocation[0].getFirstChild().getNodeValue().trim());
                            Element[] asiNSURI = EMDHelper.findElements(EMD_NAMESPACE, ASI_URI_ELEMENT, asi[i]);
                            if (asiNSURI == null || asiNSURI.length != 1 || asiNSURI[0].getFirstChild() == null || asiNSURI[0].getFirstChild().getNodeValue() == null || asiNSURI[0].getFirstChild().getNodeValue().equals("")) {
                                LogFacility.logErrorMessage((String)NLS.bind((String)MessageResource.MSG_ERROR_NO_NS_ASI, (Object)Integer.toString(i), (Object)discoveryFile.getFullPath().toString()), null);
                                continue;
                            }
                            asiEntry.setNamespaceURI(asiNSURI[0].getFirstChild().getNodeValue().trim());
                            emdDescriptor.addASI(asiEntry);
                        }
                    }
                    if ((ui = EMDHelper.findElements(EMD_NAMESPACE, UI_OVERRIDE, discoveryService)) == null || ui.length <= 0) break block37;
                    int i = 0;
                    while (i < ui.length) {
                        block38: {
                            int propertyType;
                            String propertyID;
                            String className;
                            block40: {
                                String type;
                                block39: {
                                    Element[] uiOverrideClass = EMDHelper.findElements(EMD_NAMESPACE, UI_OVERRIDE_CLASS, ui[i]);
                                    if (uiOverrideClass == null || uiOverrideClass.length != 1 || uiOverrideClass[0].getFirstChild() == null || uiOverrideClass[0].getFirstChild().getNodeValue() == null || uiOverrideClass[0].getFirstChild().getNodeValue().equals("") || (className = uiOverrideClass[0].getFirstChild().getNodeValue().trim()).isEmpty()) break block38;
                                    propertyID = ui[i].getAttribute(UI_OVERRIDE_ATTR_PROPERTY_ID);
                                    type = ui[i].getAttribute(UI_OVERRIDE_ATTR_TYPE);
                                    if (propertyID == null || propertyID.isEmpty() || type == null || type.isEmpty()) break block38;
                                    if (!UI_OVERRIDE_TYPE_GROUP.equals(type)) break block39;
                                    propertyType = 1;
                                    break block40;
                                }
                                if (!UI_OVERRIDE_TYPE_PROPERTY.equals(type)) break block38;
                                propertyType = 2;
                            }
                            EMDDescriptor.UIOverride override = new EMDDescriptor.UIOverride(propertyID, propertyType, className, emdDescriptor.getConnectorProject());
                            emdDescriptor.addUIOverride(override);
                        }
                        ++i;
                    }
                }
                catch (BaseException e) {
                    throw e;
                }
                catch (CoreException e) {
                    LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                    throw BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
                }
                catch (FactoryConfigurationError e) {
                    LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                    throw BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
                }
                catch (ParserConfigurationException e) {
                    LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                    throw BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
                }
                catch (SAXException e) {
                    LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                    throw BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
                }
                catch (IOException e) {
                    LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                    throw BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
                }
                catch (RuntimeException e) {
                    LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                    throw BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
                }
                catch (Throwable e) {
                    LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                    throw BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            finally {
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
            }
        }
        return emdDescriptor;
    }

    private static String findCorrectLocale(Element[] elements) {
        Locale locale = Locale.getDefault();
        String currentLanguage = locale.getLanguage();
        String currentCountry = locale.getCountry();
        String enUSTokensDoc = null;
        String enTokenDoc = null;
        String languageTokenDoc = null;
        String emptyTokenDoc = null;
        if (elements == null) {
            return null;
        }
        int i = 0;
        while (i < elements.length) {
            String languageToken;
            Element element = elements[i];
            String langAttr = element.getAttribute(ATTRIBUTE_NAME__LANG_LOCALE);
            if (langAttr != null && langAttr.length() == 5) {
                languageToken = langAttr.substring(0, 2);
                String countryToken = langAttr.substring(3, 5);
                if (currentLanguage.equals(languageToken) && currentCountry.equals(countryToken)) {
                    return element.getFirstChild().getNodeValue().trim();
                }
                if (enUSTokensDoc == null && ATTRIBUTE__LANG_LOCALE__LANGUAGE_DEFAULT_VALUE.equals(languageToken) && ATTRIBUTE__LANG_LOCALE__COUNTRY_DEFAULT_VALUE.equals(countryToken)) {
                    enUSTokensDoc = element.getFirstChild().getNodeValue().trim();
                }
            } else if (langAttr != null && langAttr.length() == 2) {
                languageToken = langAttr.substring(0, 2);
                if (languageTokenDoc == null && currentLanguage.equals(languageToken)) {
                    languageTokenDoc = element.getFirstChild().getNodeValue().trim();
                } else if (enTokenDoc == null && ATTRIBUTE__LANG_LOCALE__LANGUAGE_DEFAULT_VALUE.equals(languageToken)) {
                    enTokenDoc = element.getFirstChild().getNodeValue().trim();
                }
            } else if ((langAttr == null || langAttr.length() == 0) && emptyTokenDoc == null) {
                emptyTokenDoc = element.getFirstChild().getNodeValue().trim();
            }
            ++i;
        }
        if (languageTokenDoc != null) {
            return languageTokenDoc;
        }
        if (enUSTokensDoc != null) {
            return enUSTokensDoc;
        }
        if (enTokenDoc != null) {
            return enTokenDoc;
        }
        return emptyTokenDoc;
    }

    private static final IFile findDescoveryServiceXML(IContainer container) {
        IFile result;
        block9: {
            result = null;
            try {
                try {
                    IResource[] contents = container.members();
                    int i = contents.length;
                    while (--i >= 0) {
                        if (contents[i].getType() != 1 || !DISCOVERY_SERVICE_XML.equals(contents[i].getName())) continue;
                        result = (IFile)contents[i];
                        break;
                    }
                    if (result != null) break block9;
                    i = contents.length;
                    while (--i >= 0) {
                        if (contents[i].getType() != 2 || (result = EMDHelper.findDescoveryServiceXML((IContainer)((IFolder)contents[i]))) == null) {
                            continue;
                        }
                        break;
                    }
                }
                catch (CoreException e) {
                    LogFacility.logErrorMessage((IStatus)e.getStatus());
                }
                catch (RuntimeException e) {
                    LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                }
                catch (Throwable e) {
                    LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            catch (Throwable throwable) {}
        }
        return result;
    }

    private static final IFile findApplicationSpecificSchema(IContainer connectorProject, String asiFileName) {
        IFile result;
        block9: {
            result = null;
            try {
                try {
                    IResource[] contents = connectorProject.members();
                    int i = contents.length;
                    while (--i >= 0) {
                        if (contents[i].getType() != 1 || !asiFileName.equals(contents[i].getName())) continue;
                        result = (IFile)contents[i];
                        break;
                    }
                    if (result != null) break block9;
                    i = contents.length;
                    while (--i >= 0) {
                        if (contents[i].getType() != 2 || (result = EMDHelper.findApplicationSpecificSchema((IContainer)((IFolder)contents[i]), asiFileName)) == null) {
                            continue;
                        }
                        break;
                    }
                }
                catch (CoreException e) {
                    LogFacility.logErrorMessage((IStatus)e.getStatus());
                }
                catch (RuntimeException e) {
                    LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                }
                catch (Throwable e) {
                    LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            catch (Throwable throwable) {}
        }
        return result;
    }

    private static final Element[] findElements(String namespace, String localName, Node parentNode) {
        if (namespace == null || localName == null || parentNode == null) {
            // empty if block
        }
        ArrayList<Element> elements = new ArrayList<Element>();
        NodeList rootNodeList = parentNode.getChildNodes();
        int i = rootNodeList.getLength();
        while (--i >= 0) {
            Element element;
            Node node = rootNodeList.item(i);
            if (node.getNodeType() != 1 || !localName.equals((element = (Element)node).getLocalName()) || !namespace.equals(element.getNamespaceURI())) continue;
            elements.add(element);
        }
        if (elements.size() == 0) {
            return null;
        }
        return elements.toArray(new Element[0]);
    }

    public static final void registerSchemas(EMDDescriptor emdDetails) {
        block9: {
            try {
                EMDDescriptor.ASI[] schemas = emdDetails.getSchemas();
                if (schemas == null) break block9;
                IApplicationSpecificSchemaRegistrySPI registry = ApplicationSpecificSchemaRegistryFactory.getFactory().getApplicationSpecificSchemaRegistrySPI();
                int i = schemas.length;
                while (--i >= 0) {
                    try {
                        ApplicationSpecificSchemaProperties properties = registry.createEntry();
                        properties.setDescription(schemas[i].getDescription());
                        properties.setDisplayName(schemas[i].getDisplayName());
                        properties.setNamespaceURI(schemas[i].getNamespaceURI());
                        URL schemaURL = emdDetails.getClassLoader().getResource(schemas[i].getSchemaLocation());
                        if (schemaURL == null) {
                            try {
                                schemaURL = new URL(schemas[i].getSchemaLocation());
                            }
                            catch (MalformedURLException e) {
                                LogFacility.logErrorMessage((String)NLS.bind((String)MessageResource.MSG_ERROR_ASI_NOT_FOUND, (Object)schemas[i].getSchemaLocation()), (Throwable)e);
                                continue;
                            }
                        }
                        properties.setXSDFileURL(schemaURL);
                        properties.setLinkage(1);
                        registry.addEntry(properties);
                    }
                    catch (RuntimeException e) {
                        LogFacility.logErrorMessage((String)NLS.bind((String)MessageResource.MSG_ERROR_ASI_NOT_FOUND, (Object)schemas[i].getSchemaLocation()), (Throwable)e);
                    }
                    catch (Throwable e) {
                        LogFacility.logErrorMessage((String)NLS.bind((String)MessageResource.MSG_ERROR_ASI_NOT_FOUND, (Object)schemas[i].getSchemaLocation()), (Throwable)e);
                    }
                }
            }
            catch (Throwable e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    public static final void removeSchemas(EMDDescriptor emdDetails) {
        try {
            EMDDescriptor.ASI[] schemas = emdDetails.getSchemas();
            if (schemas != null) {
                IApplicationSpecificSchemaRegistrySPI registry = ApplicationSpecificSchemaRegistryFactory.getFactory().getApplicationSpecificSchemaRegistrySPI();
                IApplicationSpecificSchemaRegistry apiRegistry = ApplicationSpecificSchemaRegistryFactory.getFactory().getApplicationSpecificSchemaRegistry();
                String projectLocation = String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocationURI().toURL().getFile()) + emdDetails.getConnectorProject().getFullPath().addTrailingSeparator().toString();
                int i = schemas.length;
                while (--i >= 0) {
                    try {
                        ApplicationSpecificSchemaProperties[] asiProperties = apiRegistry.getApplicationSpecificSchemaProperties(schemas[i].getNamespaceURI());
                        int j = asiProperties.length;
                        while (--j >= 0) {
                            String asiSchemaLocationURI = asiProperties[j].getXSDFileURL().getPath();
                            if (!asiSchemaLocationURI.startsWith(projectLocation)) continue;
                            registry.removeEntry(asiProperties[j]);
                        }
                    }
                    catch (RuntimeException e) {
                        LogFacility.logErrorMessage((String)NLS.bind((String)MessageResource.MSG_ERROR_ASI_NOT_FOUND, (Object)schemas[i].getSchemaLocation()), (Throwable)e);
                    }
                    catch (Throwable e) {
                        LogFacility.logErrorMessage((String)NLS.bind((String)MessageResource.MSG_ERROR_ASI_NOT_FOUND, (Object)schemas[i].getSchemaLocation()), (Throwable)e);
                    }
                }
            }
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public static final void registerBindings(EMDDescriptor emdDetails, IResourceAdapterDescriptor resourceAdapter) {
        BindingProvider bindingProvider = emdDetails.getBindingProvider();
        IProject project = emdDetails.getConnectorProject();
        if (bindingProvider != null && project != null) {
            IBindingRegistrySPI bindingRegistry = BindingRegistryFactory.getFactory().getBindingRegistrySPI();
            ClassLoader classLoader = emdDetails.getClassLoader();
            Binding[] bindings = bindingProvider.getBinding();
            IBinding[] registryEntries = new IBinding[bindings.length];
            int i = 0;
            while (i < bindings.length) {
                String[] tags;
                QName serviceTypeQName;
                String serviceTag;
                String[] asiNS;
                int type;
                IBinding registryEntry;
                Binding binding;
                block37: {
                    binding = bindings[i];
                    registryEntry = bindingRegistry.createEntry();
                    registryEntry.setProviderDescription(resourceAdapter.getConnectorProject().getName());
                    registryEntry.setDisplayName(binding.getDisplayName());
                    registryEntry.setDescription(binding.getDescription());
                    try {
                        String bindingClassName = binding.getClassName();
                        if (bindingClassName != null) {
                            registryEntry.setClassName(bindingClassName);
                            Class<?> bindingClass = null;
                            try {
                                bindingClass = classLoader.loadClass(bindingClassName);
                            }
                            catch (Throwable e) {
                                LogFacility.logErrorMessage((String)NLS.bind((String)MessageResource.MSG_ERROR_UNABLE_TO_LOAD_BINDING_CLASS, (Object[])new String[]{emdDetails.getConnectorProject().getName(), bindingClassName, emdDetails.getBindingProviderClass()}), (Throwable)e);
                            }
                            if (bindingClass == null) {
                                throw BaseException.createException((String)NLS.bind((String)MessageResource.MSG_ERROR_NO_BINDING_IMPL, (Object[])new String[]{emdDetails.getConnectorProject().getName(), bindingClassName, emdDetails.getBindingProviderClass()}), null);
                            }
                            try {
                                Object instance = bindingClass.newInstance();
                                registryEntry.setInstance(instance);
                            }
                            catch (Throwable e) {
                                LogFacility.logErrorMessage((String)NLS.bind((String)MessageResource.MSG_ERROR_UNABLE_TO_LOAD_BINDING_CLASS, (Object[])new String[]{emdDetails.getConnectorProject().getName(), bindingClassName, emdDetails.getBindingProviderClass()}), (Throwable)e);
                            }
                        } else {
                            LogFacility.logErrorMessage((String)NLS.bind((String)MessageResource.MSG_ERROR_NULL_BINDING_CLASS, (Object)emdDetails.getConnectorProject().getName(), (Object)emdDetails.getBindingProviderClass()), null);
                        }
                        String configurationClassName = String.valueOf(bindingClassName) + "Configuration";
                        Class<?> configurationClass = null;
                        try {
                            configurationClass = classLoader.loadClass(configurationClassName);
                        }
                        catch (Throwable throwable) {}
                        if (configurationClass == null) break block37;
                        try {
                            BindingConfigurationEdit bindingConfiguration = (BindingConfigurationEdit)configurationClass.newInstance();
                            registryEntry.setConfiguration(bindingConfiguration);
                            registryEntry.setConfigurationClassName(configurationClassName);
                            if (!bindingConfiguration.isOptional()) {
                                registryEntry.setRequireConfiguration(true);
                            }
                            String propertiesJavaBeanClassName = String.valueOf(bindingClassName) + "Properties";
                            Class<?> propertiesJavaBeanClass = null;
                            try {
                                propertiesJavaBeanClass = classLoader.loadClass(propertiesJavaBeanClassName);
                            }
                            catch (Throwable e) {
                                LogFacility.logErrorMessage((String)NLS.bind((String)MessageResource.MSG_ERROR_UNABLE_TO_LOAD_BINDING__PROPERTIES_JAVA_BEAN_CLASS, (Object[])new String[]{emdDetails.getConnectorProject().getName(), propertiesJavaBeanClassName}), (Throwable)e);
                            }
                            if (propertiesJavaBeanClass == null) {
                                throw BaseException.createException((String)NLS.bind((String)MessageResource.MSG_ERROR_NO_BINDING_PROPERTIES_JAVA_BEAN_IMPL, (Object[])new String[]{emdDetails.getConnectorProject().getName(), propertiesJavaBeanClassName}), null);
                            }
                            try {
                                Object propertiesJavaBean = propertiesJavaBeanClass.newInstance();
                                registryEntry.setPropertiesJavaBean(propertiesJavaBean);
                                registryEntry.setPropertiesJavaBeanClassName(propertiesJavaBeanClassName);
                            }
                            catch (Throwable e) {
                                LogFacility.logErrorMessage((String)NLS.bind((String)MessageResource.MSG_ERROR_UNABLE_TO_LOAD_BINDING__PROPERTIES_JAVA_BEAN_CLASS, (Object[])new String[]{emdDetails.getConnectorProject().getName(), propertiesJavaBeanClassName}), (Throwable)e);
                            }
                        }
                        catch (Throwable e) {
                            LogFacility.logErrorMessage((String)NLS.bind((String)MessageResource.MSG_ERROR_UNABLE_TO_LOAD_BINDING__CONFIGURATION_CLASS, (Object[])new String[]{emdDetails.getConnectorProject().getName(), configurationClassName}), (Throwable)e);
                        }
                    }
                    catch (BaseException e) {
                        LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                if ((type = binding.getType()) == 0) {
                    registryEntry.setType("DataBinding");
                } else if (3 == type) {
                    registryEntry.setType("DataHandler");
                } else if (1 == type) {
                    registryEntry.setType("FunctionSelector");
                } else if (2 == type) {
                    registryEntry.setType("DataBindingGenerator");
                    int generatedType = binding.getGeneratedType();
                    if (generatedType == 0) {
                        registryEntry.setGeneratedType("DataBinding");
                    } else if (1 == generatedType) {
                        registryEntry.setGeneratedType("Record");
                    }
                }
                String[] supportedTypes = binding.getSupportedType();
                if (supportedTypes != null && supportedTypes.length > 0) {
                    registryEntry.setSupportedTypes(Arrays.asList(supportedTypes));
                }
                if ((asiNS = binding.getASINamespaceURI()) != null && asiNS.length > 0) {
                    registryEntry.setAsiNamespaces(Arrays.asList(asiNS));
                }
                if ((serviceTag = (String)ServiceTypes.serviceQName2ServiceTagMap.get(serviceTypeQName = new QName("http://www.ibm.com/xmlns/prod/websphere/scdl/eis/6.0.0", resourceAdapter.getConnector().getEisType()))) != null) {
                    registryEntry.addSupportedServiceType(serviceTag);
                }
                if ((tags = binding.getTags()) != null && tags.length > 0) {
                    registryEntry.setTags(Arrays.asList(tags));
                }
                registryEntry.setLinkage(1);
                try {
                    String projectLocation = String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocationURI().toURL().getFile()) + emdDetails.getConnectorProject().getFullPath().toString();
                    registryEntry.setProjectPath(projectLocation);
                }
                catch (Throwable e) {
                    LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                }
                registryEntry.setProject(project);
                registryEntries[i] = registryEntry;
                ++i;
            }
            bindingRegistry.addEntries(registryEntries);
        }
    }

    public static final void removeBindings(EMDDescriptor emdDetails) {
        BindingProvider bindingProvider = emdDetails.getBindingProvider();
        if (bindingProvider != null) {
            IBindingRegistrySPI bindingRegistrySPI = BindingRegistryFactory.getFactory().getBindingRegistrySPI();
            IBindingRegistry bindingRegistryAPI = BindingRegistryFactory.getFactory().getBindingRegistry();
            Binding[] bindings = bindingProvider.getBinding();
            IBinding[] registryEntries = new IBinding[bindings.length];
            int i = 0;
            while (i < bindings.length) {
                int j;
                Binding binding = bindings[i];
                String className = binding.getClassName();
                String projectLocation = null;
                try {
                    projectLocation = String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocationURI().toURL().getFile()) + emdDetails.getConnectorProject().getFullPath().toString();
                }
                catch (Throwable e) {
                    LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                }
                IBinding[] entries = bindingRegistryAPI.getDataBindings(className);
                if (entries != null) {
                    j = 0;
                    while (j < entries.length) {
                        if (projectLocation.equals(entries[j].getProjectPath())) {
                            registryEntries[i] = entries[j];
                            break;
                        }
                        ++j;
                    }
                } else {
                    entries = bindingRegistryAPI.getDataHandlers(className);
                    if (entries != null) {
                        j = 0;
                        while (j < entries.length) {
                            if (projectLocation.equals(entries[j].getProjectPath())) {
                                registryEntries[i] = entries[j];
                                break;
                            }
                            ++j;
                        }
                    } else {
                        entries = bindingRegistryAPI.getDataBindingGenerators(className);
                        if (entries != null) {
                            j = 0;
                            while (j < entries.length) {
                                if (projectLocation.equals(entries[j].getProjectPath())) {
                                    registryEntries[i] = entries[j];
                                    break;
                                }
                                ++j;
                            }
                        } else {
                            entries = bindingRegistryAPI.getFunctionSelectors(className);
                            if (entries != null) {
                                j = 0;
                                while (j < entries.length) {
                                    if (projectLocation.equals(entries[j].getProjectPath())) {
                                        registryEntries[i] = entries[j];
                                        break;
                                    }
                                    ++j;
                                }
                            } else {
                                return;
                            }
                        }
                    }
                }
                ++i;
            }
            bindingRegistrySPI.removeEntries(registryEntries);
        }
    }

    public static final void registerDescriptor(EMDDescriptor descriptor, IResourceAdapterDescriptor resourceAdapter) {
        try {
            MetadataBuild build;
            EMDHelper.registerSchemas(descriptor);
            EMDHelper.registerBindings(descriptor, resourceAdapter);
            EMDHelper.registerUIOverrides(descriptor, resourceAdapter);
            MetadataDiscovery discovery = descriptor.getDiscoveryService();
            if (discovery != null && EMDHelper.hasMetaDataConnections(discovery.getAdapterTypeSummaries())) {
                EMDDiscoveryAgent discoveryAgent = new EMDDiscoveryAgent(descriptor, resourceAdapter);
                com.ibm.adapter.framework.registry.RegistryFactory.getFactory().getSPIRegistry().removeDiscoveryAgent(discoveryAgent.getMetaData().getAgentName());
                String eisType = resourceAdapter.getConnector().getEisType();
                com.ibm.adapter.framework.registry.RegistryFactory.getFactory().getSPIRegistry().registerDiscoveryAgent((IDiscoveryAgent)discoveryAgent, (IPath[])new Path[]{eisType != null ? new Path("JCA/" + eisType) : new Path(CLASSIFICATION)});
                RegistryFactory.getFactory().getSPIResourceAdapterRegistry().updateResourceAdapterDiscoveryAgent(resourceAdapter, (IDiscoveryAgent)discoveryAgent, true);
            }
            if ((build = descriptor.getMetadataBuild()) != null && EMDHelper.hasMetaDataConnections(build.getAdapterTypeSummaries())) {
                EMDBuildAgent buildAgent = new EMDBuildAgent(descriptor, resourceAdapter);
                ((Registry)com.ibm.adapter.framework.registry.RegistryFactory.getFactory().getSPIRegistry()).removeBuildAgent(buildAgent.getName());
                String eisType = resourceAdapter.getConnector().getEisType();
                ((Registry)com.ibm.adapter.framework.registry.RegistryFactory.getFactory().getSPIRegistry()).registerBuildAgent((IBuildAgent)buildAgent, (IPath[])new Path[]{eisType != null ? new Path("JCA/" + eisType) : new Path(CLASSIFICATION)});
                RegistryFactory.getFactory().getSPIResourceAdapterRegistry().updateResourceAdapterBuildAgent(resourceAdapter, (IBuildAgent)buildAgent, true);
            }
            EMDDescriptor.getDescriptors().put(descriptor.getConnectorProject().getName(), descriptor);
            resourceAdapter.getExtendedData().put("EMD_DESCRIPTOR", descriptor);
            if (descriptor.getClassLoader() instanceof InMemoryClassLoader) {
                ((InMemoryClassLoader)descriptor.getClassLoader()).closeOpenJars();
            }
        }
        catch (BaseException e) {
            LogFacility.logErrorMessage((IStatus)e.getStatus());
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public static final void removeDescriptor(EMDDescriptor descriptor) {
        try {
            EMDBuildAgent buildAgent;
            EMDDiscoveryAgent agent = descriptor.getDiscoveryAgent();
            if (agent != null) {
                com.ibm.adapter.framework.registry.RegistryFactory.getFactory().getSPIRegistry().removeDiscoveryAgent(agent.getMetaData().getAgentName());
            }
            if ((buildAgent = descriptor.getBuildAgent()) != null) {
                ((Registry)com.ibm.adapter.framework.registry.RegistryFactory.getFactory().getSPIRegistry()).removeBuildAgent(buildAgent.getName());
            }
            EMDHelper.removeSchemas(descriptor);
            EMDHelper.removeBindings(descriptor);
            EMDHelper.removeUIOverrides(descriptor);
            EMDDescriptor.getDescriptors().remove(descriptor.getConnectorProject().getName());
        }
        catch (BaseException e) {
            LogFacility.logErrorMessage((IStatus)e.getStatus());
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private static boolean hasMetaDataConnections(AdapterTypeSummary[] adapterSummaries) throws MetadataException {
        boolean hasMetadataConnections = false;
        int i = 0;
        while (i < adapterSummaries.length) {
            if (adapterSummaries[i].hasMetadataConnectionTypes()) {
                hasMetadataConnections = true;
                break;
            }
            ++i;
        }
        return hasMetadataConnections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void registerUIOverrides(EMDDescriptor emdDetails, IResourceAdapterDescriptor resourceAdapter) {
        Map<String, List<EMDDescriptor.UIOverride>> allUIOverrides;
        List<EMDDescriptor.UIOverride> uiOverrides = emdDetails.getUIOverrides();
        if (uiOverrides.isEmpty()) {
            return;
        }
        ClassLoader loader = resourceAdapter.getClassLoader();
        Map<String, List<EMDDescriptor.UIOverride>> map = allUIOverrides = EMDDescriptor.getAllUIOverrides();
        synchronized (map) {
            for (EMDDescriptor.UIOverride uiOverride : uiOverrides) {
                String className = uiOverride.getClassName();
                try {
                    Class<?> aClass = loader.loadClass(className);
                    Object classInstance = aClass.newInstance();
                    if (uiOverride.getPropertyType() == 1 && !(classInstance instanceof IPropertyGroupUIExtension) || uiOverride.getPropertyType() == 2 && !(classInstance instanceof IPropertyUIExtension)) continue;
                    uiOverride.setInstanceObject(classInstance);
                    String propertyID = uiOverride.getPropertyID();
                    List<EMDDescriptor.UIOverride> currentList = allUIOverrides.get(propertyID);
                    if (currentList == null) {
                        currentList = new ArrayList<EMDDescriptor.UIOverride>();
                        allUIOverrides.put(propertyID, currentList);
                    }
                    currentList.add(uiOverride);
                    switch (uiOverride.getPropertyType()) {
                        case 1: {
                            PropertyUIExtensionRegistry.instance().addPropertyGroupUIExtension(uiOverride.getPropertyID(), (IPropertyGroupUIExtension)classInstance);
                            break;
                        }
                        case 2: {
                            PropertyUIExtensionRegistry.instance().addPropertyUIExtension(uiOverride.getPropertyID(), (IPropertyUIExtension)classInstance);
                            break;
                        }
                    }
                }
                catch (Throwable e) {
                    LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void removeUIOverrides(EMDDescriptor emdDetails) {
        Map<String, List<EMDDescriptor.UIOverride>> allUIOverrides;
        List<EMDDescriptor.UIOverride> uiOverrides = emdDetails.getUIOverrides();
        if (uiOverrides.isEmpty()) {
            return;
        }
        Map<String, List<EMDDescriptor.UIOverride>> map = allUIOverrides = EMDDescriptor.getAllUIOverrides();
        synchronized (map) {
            for (EMDDescriptor.UIOverride uiOverride : uiOverrides) {
                String propertyID = uiOverride.getPropertyID();
                List<EMDDescriptor.UIOverride> currentList = allUIOverrides.get(propertyID);
                if (currentList == null) continue;
                EMDDescriptor.UIOverride elementToRemove = null;
                for (EMDDescriptor.UIOverride anOverride : currentList) {
                    if (!anOverride.getResourceAdapterDescriptor().getConnectorProject().equals((Object)emdDetails.getConnectorProject())) continue;
                    elementToRemove = anOverride;
                    break;
                }
                if (elementToRemove == null) continue;
                currentList.remove(elementToRemove);
                switch (uiOverride.getPropertyType()) {
                    case 1: {
                        PropertyUIExtensionRegistry.instance().removePropertyGroupUIExtension(uiOverride.getPropertyID(), (IPropertyGroupUIExtension)uiOverride.getInstanceObject());
                        break;
                    }
                    case 2: {
                        PropertyUIExtensionRegistry.instance().removePropertyUIExtension(uiOverride.getPropertyID(), (IPropertyUIExtension)uiOverride.getInstanceObject());
                        break;
                    }
                }
                if (!currentList.isEmpty()) continue;
                allUIOverrides.remove(propertyID);
            }
        }
    }
}

