/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.emd.internal.build;

import com.ibm.adapter.emd.extension.description.J2CServiceDescription;
import com.ibm.adapter.emd.extension.description.spi.DataDescription;
import com.ibm.adapter.emd.extension.description.spi.SchemaDefinition;
import com.ibm.adapter.emd.extension.description.spi.ServiceDescription;
import com.ibm.adapter.emd.extension.description.spi.ServiceDescriptionFactory;
import com.ibm.adapter.emd.internal.build.EMDBuildContext;
import com.ibm.adapter.emd.internal.build.EMDOperation;
import com.ibm.adapter.emd.internal.build.EMDOperationContainer;
import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.IEnvironment;
import com.ibm.adapter.framework.IImportResult;
import com.ibm.adapter.framework.internal.build.IOperation;
import com.ibm.adapter.framework.internal.build.IOperationContainer;
import com.ibm.adapter.framework.internal.build.IServiceBuilder;
import commonj.connector.metadata.build.MetadataBuild;
import commonj.connector.metadata.description.FunctionDescription;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.core.runtime.IProgressMonitor;

public class EMDServiceBuilder
implements IServiceBuilder {
    private static final String COMMON_SCHEMA_FOLDER = "CommonSchemas/";
    private EMDBuildContext emdBuildContext;
    EMDOperationContainer operationContainer = null;

    EMDServiceBuilder(EMDBuildContext context) {
        this.emdBuildContext = context;
    }

    public IOperationContainer createOperationContainer() {
        if (this.operationContainer == null) {
            this.operationContainer = new EMDOperationContainer(this.emdBuildContext);
        }
        return this.operationContainer;
    }

    public IImportResult completeBuildProcess(IEnvironment environment) throws BaseException {
        IProgressMonitor monitor = null;
        if (environment != null) {
            monitor = environment.getProgressMonitor();
        }
        if (monitor != null) {
            monitor.beginTask(this.emdBuildContext.getMessageUtil().getMessage("MSG_COMPLETING_BUILD_PROCESS"), 1);
        }
        this.processCommonSchemas();
        IOperation[] operations = this.operationContainer.getOperations();
        if (operations != null) {
            int i = 0;
            while (i < operations.length) {
                EMDOperation op = (EMDOperation)operations[i];
                op.finalizeOperation();
                ++i;
            }
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        return this.emdBuildContext.getImportResult();
    }

    private ServiceDescription getServiceDescriptionModel() {
        Object data = this.emdBuildContext.getImportResult().getImportData();
        return (ServiceDescription)((J2CServiceDescription)data).getServiceDescription();
    }

    private void processCommonSchemas() throws BaseException {
        MetadataBuild emdBuildAgent = this.emdBuildContext.getEMDDescriptor().getMetadataBuild();
        List<QName> commonSchemaNames = Arrays.asList(emdBuildAgent.getCommonSchemaTypes());
        ServiceDescription description = this.getServiceDescriptionModel();
        commonj.connector.metadata.description.SchemaDefinition[] commonSchemaCopies = null;
        SchemaDefinition commonSchemaCopy = null;
        FunctionDescription[] functionDescriptions = description.getFunctionDescriptions();
        if (functionDescriptions != null) {
            int i = 0;
            while (i < functionDescriptions.length) {
                String newPath;
                String path;
                int j;
                commonj.connector.metadata.description.SchemaDefinition[] commonSchemas;
                QName type;
                DataDescription dataDescription = (DataDescription)functionDescriptions[i].getInputDataDescription();
                if (dataDescription != null && commonSchemaNames.contains(type = dataDescription.getName())) {
                    commonSchemas = emdBuildAgent.getCommonSchemas(type);
                    commonSchemaCopies = new SchemaDefinition[commonSchemas.length];
                    j = 0;
                    while (j < commonSchemas.length) {
                        commonSchemaCopy = ServiceDescriptionFactory.getFactory().createSchemaDefinition();
                        commonSchemaCopy.setContent(commonSchemas[j].getContent());
                        commonSchemaCopy.setIsEditable(commonSchemas[j].isEditable());
                        commonSchemaCopy.setNamespace(commonSchemas[j].getNamespace());
                        path = commonSchemas[j].getLocation().getPath();
                        newPath = COMMON_SCHEMA_FOLDER;
                        newPath = "./".regionMatches(0, path, 0, 2) ? String.valueOf(newPath) + path.substring(2) : COMMON_SCHEMA_FOLDER + path;
                        try {
                            commonSchemaCopy.setLocation(new URI(newPath));
                        }
                        catch (URISyntaxException e) {
                            throw BaseException.createException((String)e.getMessage(), (Throwable)e);
                        }
                        commonSchemaCopies[j] = commonSchemaCopy;
                        ++j;
                    }
                    dataDescription.setSchemaDefinitions(commonSchemaCopies);
                }
                if ((dataDescription = (DataDescription)functionDescriptions[i].getOutputDataDescription()) != null && commonSchemaNames.contains(type = dataDescription.getName())) {
                    commonSchemas = emdBuildAgent.getCommonSchemas(type);
                    commonSchemaCopies = new SchemaDefinition[commonSchemas.length];
                    j = 0;
                    while (j < commonSchemas.length) {
                        commonSchemaCopy = ServiceDescriptionFactory.getFactory().createSchemaDefinition();
                        commonSchemaCopy.setContent(commonSchemas[j].getContent());
                        commonSchemaCopy.setIsEditable(commonSchemas[j].isEditable());
                        commonSchemaCopy.setNamespace(commonSchemas[j].getNamespace());
                        path = commonSchemas[j].getLocation().getPath();
                        newPath = COMMON_SCHEMA_FOLDER;
                        newPath = "./".regionMatches(0, path, 0, 2) ? String.valueOf(newPath) + path.substring(2) : COMMON_SCHEMA_FOLDER + path;
                        try {
                            commonSchemaCopy.setLocation(new URI(newPath));
                        }
                        catch (URISyntaxException e) {
                            throw BaseException.createException((String)e.getMessage(), (Throwable)e);
                        }
                        commonSchemaCopies[j] = commonSchemaCopy;
                        ++j;
                    }
                    dataDescription.setSchemaDefinitions(commonSchemaCopies);
                }
                ++i;
            }
        }
    }
}

