/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.emd.internal.build;

import com.ibm.adapter.emd.extension.description.spi.J2CServiceDescription;
import com.ibm.adapter.emd.extension.description.spi.ServiceDescription;
import com.ibm.adapter.emd.extension.description.spi.ServiceDescriptionFactory;
import com.ibm.adapter.emd.internal.LogFacility;
import com.ibm.adapter.emd.internal.build.EMDBuildContext;
import com.ibm.adapter.emd.internal.build.EMDServiceBuilder;
import com.ibm.adapter.emd.internal.discovery.EMDDescriptor;
import com.ibm.adapter.emd.internal.discovery.EMDDiscoveryAgent;
import com.ibm.adapter.emd.internal.discovery.EMDToolContext;
import com.ibm.adapter.emd.internal.discovery.MessageUtil;
import com.ibm.adapter.emd.internal.properties.BuildConnectionPropertyGroup;
import com.ibm.adapter.emd.internal.properties.BuildServiceLevelPropertyGroup;
import com.ibm.adapter.emd.internal.properties.JNDITargetProperty;
import com.ibm.adapter.emd.internal.properties.SecurityPropertyGroup;
import com.ibm.adapter.emd.properties.wrapper.PropertyGroupWrapper;
import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.IEnvironment;
import com.ibm.adapter.framework.IImportResult;
import com.ibm.adapter.framework.internal.build.IBuildAgent;
import com.ibm.adapter.framework.internal.build.IServiceBuilder;
import com.ibm.adapter.framework.internal.build.spi.BaseBuildAgent;
import com.ibm.adapter.framework.spi.ImportResult;
import com.ibm.adapter.framework.util.QNameHelper;
import com.ibm.adapter.j2ca.IResourceAdapterDescriptor;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.ISingleValuedProperty;
import commonj.connector.metadata.MetadataConfigurationType;
import commonj.connector.metadata.MetadataException;
import commonj.connector.metadata.build.MetadataBuild;
import commonj.connector.metadata.discovery.AdapterType;
import commonj.connector.metadata.discovery.AdapterTypeSummary;
import commonj.connector.metadata.discovery.connection.InboundConnectionConfiguration;
import commonj.connector.metadata.discovery.connection.InboundConnectionType;
import commonj.connector.metadata.discovery.connection.OutboundConnectionConfiguration;
import commonj.connector.metadata.discovery.connection.OutboundConnectionType;
import commonj.connector.metadata.discovery.properties.PropertyGroup;
import commonj.connector.tool.ToolContext;
import java.util.logging.Level;
import javax.resource.cci.ConnectionSpec;
import javax.xml.namespace.QName;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class EMDBuildAgent
extends BaseBuildAgent {
    private static final String copyright = "Licensed Material - Property of IBM  5724-I66 (C) Copyright IBM Corporation 2005 - All Rights Reserved. Note to U.S. Government Users Restricted Rights - Use, duplication or disclosure " + "restricted by GSA ADP Schedule Contract with IBM Corp.".intern();
    private EMDDescriptor emdDescriptor;
    private IResourceAdapterDescriptor resourceAdapterDescriptor;
    private boolean derivedCapabilities = false;
    private boolean isOutboundFlow = true;
    private EMDToolContext activeContext;
    private boolean configSet = false;
    private MessageUtil messageUtil;
    static final String FLAT_FILE_EIS_TYPE = "Local File System";
    static final String FTP_EIS_TYPE = "Remote File System";
    static final String FTP_GENERATOR_NAME = "com.ibm.wbit.adapter.db.generator.ftp.FTPDataBindingGenerator";
    static final String FLAT_FILE_GENERATOR_NAME = "com.ibm.wbit.adapter.db.generator.flatfile.FFDataBindingGenerator";

    public EMDBuildAgent(EMDDescriptor emdDescriptor, IResourceAdapterDescriptor resourceAdapterDescriptor) throws BaseException {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            try {
                if (emdDescriptor == null) {
                    throw BaseException.createException((String)this.getMessageUtil().getMessage("MSG_ERROR_EMD_NULL"), null);
                }
                if (resourceAdapterDescriptor == null) {
                    throw BaseException.createException((String)this.getMessageUtil().getMessage("MSG_ERROR_RAR_NULL"), null);
                }
                this.emdDescriptor = emdDescriptor;
                this.resourceAdapterDescriptor = resourceAdapterDescriptor;
                this.activeContext = EMDDescriptor.defaultContext;
                String name = NLS.bind((String)this.getMessageUtil().getMessage("DA_DISPLAY_NAME"), (Object[])new String[]{emdDescriptor.getDisplayName(), emdDescriptor.getVersion(), emdDescriptor.getConnectorProject().getName()});
                String projectName = emdDescriptor.getConnectorProject().getName().replace(' ', '_');
                String fixedName = emdDescriptor.getDisplayName().replace(' ', '_');
                String version = emdDescriptor.getVersion().replace(' ', '_');
                String vendor = emdDescriptor.getVendorName().replace(' ', '_');
                String adapterNamespace = new StringBuffer().append(projectName).append('/').append(fixedName).append('/').append(version).append('/').append(vendor).toString();
                QName adapterQName = QNameHelper.createQName((String)adapterNamespace, (String)name);
                this.setName(adapterQName);
                this.emdDescriptor.setBuildAgent(this);
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                throw BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (Throwable e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                throw BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    private EMDBuildAgent() {
    }

    public IServiceBuilder getServiceBuilder(IImportResult result) throws BaseException {
        EMDBuildContext context = new EMDBuildContext();
        context.setEMDDescriptor(this.emdDescriptor);
        context.setImportResult(result);
        context.setOutboundFlow(this.isOutboundFlow);
        context.setMessageUtil(this.getMessageUtil());
        return new EMDServiceBuilder(context);
    }

    public IImportResult initialize(IEnvironment environment, IPropertyGroup initializeProperties) throws BaseException {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        if (initializeProperties == null) {
            throw BaseException.createException((String)this.getMessageUtil().getMessage("MSG_ERROR_FAILED_TO_INITIATE"), null);
        }
        try {
            ISingleValuedProperty connChoiceProp;
            ServiceDescription serviceDescription;
            IProgressMonitor monitor = null;
            if (environment != null) {
                monitor = environment.getProgressMonitor();
            }
            if (monitor != null) {
                monitor.beginTask(this.getMessageUtil().getMessage("MSG_INITIALIZING_BUILD_AGENT"), 1);
            }
            BuildConnectionPropertyGroup pg = (BuildConnectionPropertyGroup)initializeProperties;
            BuildServiceLevelPropertyGroup buildServiceLevelPG = (BuildServiceLevelPropertyGroup)pg.getProperty("ServiceLevelPG");
            ServiceDescription description = null;
            if (this.isOutboundFlow) {
                serviceDescription = ServiceDescriptionFactory.getFactory().createOutboundServiceDescription();
                serviceDescription.setConnectionSpec((ConnectionSpec)this.resourceAdapterDescriptor.getConnectionSpecClass(this.emdDescriptor.getMetadataBuild().getConnectionSpecClassName()[0]).newInstance());
                serviceDescription.setOutboundConnectionAdvancedConfiguration((OutboundConnectionConfiguration)pg.getConnectionConfiguration());
                description = serviceDescription;
            } else {
                serviceDescription = ServiceDescriptionFactory.getFactory().createInboundServiceDescription();
                serviceDescription.setFunctionSelectorClassName(this.emdDescriptor.getMetadataBuild().getDefaultFunctionSelector());
                serviceDescription.setFunctionSelectorConfigurationName(null);
                if (buildServiceLevelPG != null && (buildServiceLevelPG.isFunctionSelectorRequiresConfiguration() || this.getMessageUtil().getMessage("SERVICE_LEVEL_USE_CONFIGURED_FUNCTION_SELECTOR").equals(((ISingleValuedProperty)buildServiceLevelPG.getProperty("ServiceLevelFunctionSelector")).getValueAsString()))) {
                    ISingleValuedProperty functionSelectorConfigurationName = (ISingleValuedProperty)buildServiceLevelPG.getProperty("FunctionSelectorConfigurationProperty");
                    serviceDescription.setFunctionSelectorConfigurationName((QName)functionSelectorConfigurationName.getValue());
                    ISingleValuedProperty functionSelectorClassName = (ISingleValuedProperty)buildServiceLevelPG.getProperty("FunctionSelectorProperty");
                    serviceDescription.setFunctionSelectorClassName(functionSelectorClassName.getValueAsString());
                }
                serviceDescription.setListenerClassName(pg.getMessageListener());
                serviceDescription.setInboundConnectionAdvancedConfiguration((InboundConnectionConfiguration)pg.getConnectionConfiguration());
                description = serviceDescription;
            }
            String logFile = pg.getLogFileLocation();
            Level level = pg.getLoggingLevel();
            this.activeContext = new EMDToolContext(logFile, this.emdDescriptor.getMetadataBuildClass(), level);
            this.activeContext.setImportEnvironment(environment);
            this.emdDescriptor.getMetadataBuild().setToolContext((ToolContext)this.activeContext);
            J2CServiceDescription importData = ServiceDescriptionFactory.getFactory().createJ2CServiceDescription();
            importData.setResourceAdapterDescriptor(this.resourceAdapterDescriptor);
            importData.setServiceDescription(description);
            importData.setBuild(true);
            ISingleValuedProperty isDeployWithModule = (ISingleValuedProperty)pg.getProperty("DeployConnectorProject");
            if (isDeployWithModule != null) {
                importData.setDeployWithModule(isDeployWithModule.getPropertyType().getValidValuesAsStrings()[0].equals(isDeployWithModule.getValueAsString()));
            }
            importData.setBindingConfigurationName(null);
            importData.setBindingClassName(null);
            if (buildServiceLevelPG != null) {
                ISingleValuedProperty specifyBindingProperty = (ISingleValuedProperty)buildServiceLevelPG.getProperty("ServiceLevelBindingLevel");
                if (this.getMessageUtil().getMessage("SERVICE_LEVEL_USE_CONFIGURED_DATA_BINDING").equals(specifyBindingProperty.getValueAsString())) {
                    ISingleValuedProperty dataBindingConfigurationName = (ISingleValuedProperty)buildServiceLevelPG.getProperty("DataBindingProperty");
                    importData.setBindingConfigurationName(dataBindingConfigurationName.getValueAsString());
                } else if (!this.getMessageUtil().getMessage("SERVICE_LEVEL_SPECIFY_DATA_BINDING_OPERATION").equals(specifyBindingProperty.getValueAsString())) {
                    if (this.getMessageUtil().getMessage("LANGUAGE_DATA_BINDING").equals(specifyBindingProperty.getValueAsString())) {
                        if (FTP_EIS_TYPE.equals(this.resourceAdapterDescriptor.getConnector().getEisType())) {
                            importData.setBindingGeneratorClassName(FTP_GENERATOR_NAME);
                        } else if (FLAT_FILE_EIS_TYPE.equals(this.resourceAdapterDescriptor.getConnector().getEisType())) {
                            importData.setBindingGeneratorClassName(FLAT_FILE_GENERATOR_NAME);
                        }
                    } else {
                        importData.setBindingClassName(this.emdDescriptor.getMetadataBuild().getDefaultDataBinding());
                    }
                }
                SecurityPropertyGroup secPG = buildServiceLevelPG.getSecurityPropertyGroup();
                if (secPG != null && secPG.isJAASSelected()) {
                    importData.setJAASAlias(secPG.getJaasProperty().getValueAsString());
                }
            }
            if ((connChoiceProp = (ISingleValuedProperty)pg.getProperty("ConnectionChoice")) != null && this.getMessageUtil().getMessage("CONNECTION_CHOICE_USE_PREDEFINED_CONNECTION").equals(connChoiceProp.getValueAsString())) {
                ISingleValuedProperty jndiProperty = (ISingleValuedProperty)pg.getProperty(JNDITargetProperty.JNDI_TARGET_PROPERTY_NAME);
                if (jndiProperty != null) {
                    importData.setJNDILookupName(jndiProperty.getValueAsString());
                }
            } else {
                SecurityPropertyGroup secPG;
                PropertyGroup emdPG = ((PropertyGroupWrapper)pg.getProperty("connectionProperties")).getWrappedPropertyGroup();
                if (EMDDescriptor.isEMDSpecVersion12OrLater(this.emdDescriptor.getSpecVersion()) && buildServiceLevelPG != null && (secPG = buildServiceLevelPG.getSecurityPropertyGroup()) != null && secPG.isSecurityPropsSelected()) {
                    pg.getConnectionConfiguration().applySecurityPropertiesToUnifiedProperties(secPG.getSecurityProps(), emdPG);
                }
                pg.getConnectionConfiguration().applyUnifiedProperties(emdPG);
            }
            ImportResult result = new ImportResult();
            result.setImportData((Object)importData);
            if (monitor != null) {
                monitor.worked(1);
            }
            ImportResult importResult = result;
            return importResult;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            throw BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            throw BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    public IBuildAgent newInstance() throws BaseException {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            EMDBuildAgent agent = new EMDBuildAgent();
            agent.emdDescriptor = this.emdDescriptor;
            agent.resourceAdapterDescriptor = this.resourceAdapterDescriptor;
            agent.initializeProperties = this.initializeProperties;
            agent.setName(this.getName());
            agent.setDisplayName(this.getDisplayName());
            agent.setDescription(this.getDescription());
            EMDBuildAgent eMDBuildAgent = agent;
            return eMDBuildAgent;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
        return null;
    }

    public String[] getConfiguration() {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        String[] configuration = null;
        try {
            MetadataBuild build = this.emdDescriptor.getMetadataBuild();
            MetadataConfigurationType[] configurationTypes = build.getConfiguration();
            if (this.derivedCapabilities) {
                configurationTypes = this.isOutboundFlow ? new MetadataConfigurationType[]{MetadataConfigurationType.OUTBOUND_SERVICE} : new MetadataConfigurationType[]{MetadataConfigurationType.INBOUND_SERVICE};
            }
            configuration = EMDDiscoveryAgent.serializeFromMetaDataConfiguration(configurationTypes);
        }
        catch (Throwable throwable) {}
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
        return configuration;
    }

    public String[] getSupportedConfiguration() {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        String[] supportedConfiguration = null;
        MetadataBuild build = this.emdDescriptor.getMetadataBuild();
        MetadataConfigurationType[] configurationTypes = build.getSupportedConfiguration();
        try {
            if (configurationTypes == null || configurationTypes.length == 0) {
                boolean supportsOutbound = false;
                boolean supportsInbound = false;
                AdapterTypeSummary[] summaries = build.getAdapterTypeSummaries();
                if (summaries != null) {
                    int i = 0;
                    while (i < summaries.length) {
                        AdapterType adapterType = build.getAdapterType(summaries[i].getId());
                        OutboundConnectionType[] outboundTypes = adapterType.getOutboundConnectionTypes();
                        InboundConnectionType[] inboundTypes = adapterType.getInboundConnectionTypes();
                        if (outboundTypes != null && outboundTypes.length > 0) {
                            supportsOutbound = true;
                        }
                        if (inboundTypes != null && inboundTypes.length > 0) {
                            supportsInbound = true;
                        }
                        ++i;
                    }
                }
                if (supportsOutbound && supportsInbound) {
                    configurationTypes = new MetadataConfigurationType[]{MetadataConfigurationType.OUTBOUND_SERVICE, MetadataConfigurationType.INBOUND_SERVICE};
                    this.derivedCapabilities = true;
                } else if (supportsOutbound) {
                    this.isOutboundFlow = true;
                } else if (supportsInbound) {
                    this.isOutboundFlow = false;
                }
            }
        }
        catch (MetadataException metadataException) {}
        supportedConfiguration = EMDDiscoveryAgent.serializeFromMetaDataConfiguration(configurationTypes);
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
        return supportedConfiguration;
    }

    public void setConfiguration(String[] capabilities) throws BaseException {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        MetadataBuild build = this.emdDescriptor.getMetadataBuild();
        MetadataConfigurationType[] configurationTypes = EMDDiscoveryAgent.serializeToMetaDataConfiguration(capabilities, build.getSupportedConfiguration());
        try {
            try {
                if (this.derivedCapabilities) {
                    this.isOutboundFlow = MetadataConfigurationType.OUTBOUND_SERVICE == configurationTypes[0];
                    this.initializeProperties = null;
                } else if (configurationTypes != null) {
                    build.setConfiguration(configurationTypes);
                    this.isOutboundFlow = EMDBuildAgent.hasOutboundType(configurationTypes);
                    this.initializeProperties = null;
                }
            }
            catch (MetadataException e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                throw BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    public IPropertyGroup getInitializeProperties() throws BaseException {
        if (this.initializeProperties == null || this.configSet) {
            try {
                BuildConnectionPropertyGroup buildConnectionPG = new BuildConnectionPropertyGroup("Configuration Properties", this.getMessageUtil().getMessage("CONFIGURATION_PROPERTIES_DISPLAY_NAME"), this.getMessageUtil().getMessage("CONFIGURATION_PROPERTIES_DESCRIPTION"), this.emdDescriptor, this.isOutboundFlow, this.getMessageUtil());
                this.setInitializeProperties((IPropertyGroup)buildConnectionPG);
                this.configSet = false;
            }
            catch (CoreException e) {
                throw BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return this.initializeProperties;
    }

    public void close() throws BaseException {
        if (this.activeContext != null) {
            this.activeContext.close();
        }
        this.messageUtil = null;
    }

    public static boolean hasOutboundType(MetadataConfigurationType[] configurationTypes) {
        if (configurationTypes != null) {
            int i = 0;
            while (i < configurationTypes.length) {
                if (MetadataConfigurationType.OUTBOUND_SERVICE.toString().equals(configurationTypes[i].toString())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void initializeContext(Object[] context) throws BaseException {
        this.initMessageUtil(context);
    }

    private void initMessageUtil(Object[] context) {
        this.messageUtil = null;
        if (context != null) {
            int i = 0;
            while (i < context.length) {
                if (context[i] instanceof MessageUtil) {
                    this.messageUtil = (MessageUtil)context[i];
                    break;
                }
                ++i;
            }
        }
    }

    private MessageUtil getMessageUtil() {
        if (this.messageUtil == null) {
            this.messageUtil = new MessageUtil(null);
        }
        return this.messageUtil;
    }

    public EMDDescriptor getEmdDescriptor() {
        return this.emdDescriptor;
    }
}

