/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.emd.extension.properties;

import com.ibm.adapter.emd.extension.properties.PropertyChangeEvent;
import com.ibm.adapter.emd.extension.properties.PropertyImpl;
import com.ibm.adapter.emd.extension.properties.PropertyVetoException;
import com.ibm.adapter.emd.extension.properties.SingleValuedPropertyImpl;
import com.ibm.adapter.emd.internal.LogFacility;
import com.ibm.adapter.emd.internal.MessageResource;
import commonj.connector.metadata.MetadataException;
import commonj.connector.metadata.discovery.properties.PropertyEvent;
import commonj.connector.metadata.discovery.properties.SingleValuedProperty;
import commonj.connector.metadata.discovery.properties.TableProperty;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class TablePropertyImpl
extends PropertyImpl
implements TableProperty {
    private static final String copyright = "Licensed Material - Property of IBM  5724-I66 (C) Copyright IBM Corporation 2005 - All Rights Reserved. Note to U.S. Government Users Restricted Rights - Use, duplication or disclosure " + "restricted by GSA ADP Schedule Contract with IBM Corp.".intern();
    protected ArrayList<SingleValuedProperty[]> rows = new ArrayList();
    protected ArrayList<TableProperty.ColumnDescriptor> columnDescriptors = new ArrayList();
    protected boolean rowCreated = false;
    protected boolean expert = false;

    public TablePropertyImpl(String propertyName) throws MetadataException {
        super(propertyName);
    }

    public void addColumn(TableProperty.ColumnDescriptor column) throws CoreException {
        if (this.rowCreated) {
            Status status = new Status(4, "com.ibm.adapter.emd", 4, MessageResource.ERR_CAN_NOT_ADD_COLUMN, null);
            throw new CoreException((IStatus)status);
        }
        this.columnDescriptors.add(column);
    }

    public void removeColumn(int index) throws CoreException {
        if (this.rowCreated) {
            Status status = new Status(4, "com.ibm.adapter.emd", 4, MessageResource.ERR_CAN_NOT_REMOVE_COLUMN, null);
            throw new CoreException((IStatus)status);
        }
        this.columnDescriptors.remove(index);
    }

    public TableProperty.ColumnDescriptor[] getColumns() {
        try {
            return this.columnDescriptors.toArray(new TableProperty.ColumnDescriptor[this.columnDescriptors.size()]);
        }
        catch (RuntimeException e) {
            Status status = new Status(4, "com.ibm.adapter.emd", 4, e.getLocalizedMessage() != null ? e.getLocalizedMessage() : "", (Throwable)e);
            LogFacility.logErrorMessage((IStatus)status);
            return null;
        }
    }

    public SingleValuedProperty[] getRowProperties(int index) {
        try {
            SingleValuedProperty[] row = this.rows.get(index);
            return row;
        }
        catch (RuntimeException e) {
            Status status = new Status(4, "com.ibm.adapter.emd", 4, e.getLocalizedMessage() != null ? e.getLocalizedMessage() : "", (Throwable)e);
            LogFacility.logErrorMessage((IStatus)status);
            return null;
        }
    }

    public SingleValuedProperty getCellProperty(int row, int column) {
        try {
            return this.getRowProperties(row)[column];
        }
        catch (RuntimeException e) {
            Status status = new Status(4, "com.ibm.adapter.emd", 4, e.getLocalizedMessage() != null ? e.getLocalizedMessage() : "", (Throwable)e);
            LogFacility.logErrorMessage((IStatus)status);
            return null;
        }
    }

    public void deleteRow(int index) {
        try {
            SingleValuedProperty[] deletedRow = this.rows.remove(index);
            this.propertyChanges.fireTableRowRemove(deletedRow);
        }
        catch (RuntimeException e) {
            Status status = new Status(4, "com.ibm.adapter.emd", 4, e.getLocalizedMessage() != null ? e.getLocalizedMessage() : "", (Throwable)e);
            LogFacility.logErrorMessage((IStatus)status);
        }
    }

    public SingleValuedProperty[] createNewRow() {
        return this.createNewRow(this.rows.size());
    }

    public SingleValuedProperty[] createNewRow(int index) {
        SingleValuedProperty[] newRow = new SingleValuedProperty[this.columnDescriptors.size()];
        try {
            int i = this.columnDescriptors.size();
            while (--i >= 0) {
                TableProperty.ColumnDescriptor column = this.columnDescriptors.get(i);
                SingleValuedPropertyImpl property = new SingleValuedPropertyImpl(column.getName(), column.getType().getType());
                property.setDisplayName(column.getDisplayName());
                property.setDescription(column.getDescription());
                property.setDefaultValue(column.getType().getDefaultValue());
                property.setValidValues(column.getType().getValidValues());
                property.setExpert(column.getType().isExpert());
                property.setReadOnly(column.getType().isReadOnly());
                property.setRequired(column.getType().isRequired());
                property.setHidden(column.getType().isHidden());
                property.setSensitive(column.getType().isSensitive());
                property.setValidValuesEditable(column.getType().isValidValuesEditable());
                property.setEnabled(true);
                newRow[i] = property;
            }
            this.rows.add(index, newRow);
            this.propertyChanges.fireTableRowAdd(newRow);
        }
        catch (RuntimeException e) {
            Status status = new Status(4, "com.ibm.adapter.emd", 4, e.getLocalizedMessage() != null ? e.getLocalizedMessage() : "", (Throwable)e);
            LogFacility.logErrorMessage((IStatus)status);
            return null;
        }
        catch (MetadataException e) {
            Status status = new Status(4, "com.ibm.adapter.emd", 4, e.getLocalizedMessage() != null ? e.getLocalizedMessage() : "", (Throwable)e);
            LogFacility.logErrorMessage((IStatus)status);
            return null;
        }
        if (!this.rowCreated) {
            this.rowCreated = true;
        }
        return newRow;
    }

    public int rowCount() {
        return this.rows.size();
    }

    public void unSet() {
        this.rows.clear();
        this.rowCreated = false;
        this.propertyChanges.fireTableCleared();
    }

    @Override
    public void vetoableChange(PropertyEvent evt) throws PropertyVetoException {
    }

    @Override
    public boolean isSet() {
        return this.rowCreated;
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    public void moveRow(int to, int from) throws CoreException {
        try {
            SingleValuedProperty[] oldRow = this.rows.remove(from);
            this.rows.add(to, oldRow);
            this.propertyChanges.fireTableRowMove(to, from);
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            Status status = new Status(4, "com.ibm.adapter.emd", 4, e.getLocalizedMessage() != null ? e.getLocalizedMessage() : "", (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    @Override
    public void propertyChange(PropertyEvent arg0) {
    }

    public boolean isExpert() {
        return this.expert;
    }

    public void setExpert(boolean expert) {
        this.expert = expert;
    }
}

