/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.emd.extension.properties;

import com.ibm.adapter.emd.extension.properties.SingleValuedPropertyImpl;
import com.ibm.adapter.emd.internal.LogFacility;
import commonj.connector.metadata.MetadataException;
import commonj.connector.metadata.discovery.properties.NodeProperty;
import commonj.connector.metadata.discovery.properties.PropertyGroup;
import java.util.ArrayList;
import java.util.Arrays;

public class NodePropertyImpl
extends SingleValuedPropertyImpl
implements NodeProperty {
    private static final String copyright = "Licensed Material - Property of IBM  5724-I66 (C) Copyright IBM Corporation 2005 - All Rights Reserved. Note to U.S. Government Users Restricted Rights - Use, duplication or disclosure " + "restricted by GSA ADP Schedule Contract with IBM Corp.".intern();
    protected boolean selected = false;
    protected boolean highlighted = false;
    protected PropertyGroup configurationParameters;
    protected PropertyGroup currrentConfigurationParameters;
    protected ArrayList<NodeProperty> children = new ArrayList();

    public NodePropertyImpl(String propertyName, Class<?> propertyType) throws MetadataException {
        super(propertyName, propertyType);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean arg0) {
        this.selected = arg0;
        if (this.selected) {
            this.propertyChanges.fireTreePropertySelected();
        } else {
            this.propertyChanges.fireTreePropertyDeselected();
        }
    }

    public NodeProperty[] getChildren() {
        NodeProperty[] childNodes = this.children.toArray(new NodeProperty[0]);
        return childNodes;
    }

    public PropertyGroup createConfigurationProperties() {
        try {
            if (this.currrentConfigurationParameters != null) {
                return (PropertyGroup)this.currrentConfigurationParameters.clone();
            }
            if (this.configurationParameters != null) {
                return (PropertyGroup)this.configurationParameters.clone();
            }
            return null;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public void applyConfigurationProperties(PropertyGroup properties) {
        this.currrentConfigurationParameters = properties;
    }

    public PropertyGroup getActiveConfigurationProperties() {
        return this.currrentConfigurationParameters;
    }

    @Override
    public void unSet() {
        this.setSelected(false);
    }

    public void setConfigurationParameters(PropertyGroup configurationParameters) {
        this.configurationParameters = configurationParameters;
    }

    public void addChild(NodeProperty child) {
        this.children.add(child);
    }

    public void removeChild(NodeProperty child) {
        this.children.remove(child);
    }

    public void removeAllChildren() {
        this.children.clear();
    }

    public void addChildren(NodeProperty[] childNodes) {
        this.children.addAll(Arrays.asList(childNodes));
    }

    @Override
    public Object clone() {
        NodePropertyImpl newType = (NodePropertyImpl)super.clone();
        if (this.currrentConfigurationParameters != null) {
            newType.currrentConfigurationParameters = (PropertyGroup)this.currrentConfigurationParameters.clone();
        }
        newType.children = new ArrayList();
        for (NodeProperty element : this.children) {
            newType.children.add((NodeProperty)element.clone());
        }
        return newType;
    }

    public void setHighLighted() {
        this.propertyChanges.fireTreeNodeHighLighted();
    }

    public boolean isHighLighted() {
        return this.highlighted;
    }

    public void setHighLighted(boolean highlighted) {
        this.highlighted = highlighted;
        if (highlighted) {
            this.propertyChanges.fireTreeNodeHighLighted();
        } else {
            this.propertyChanges.fireTreeNodeDehighLighted();
        }
    }
}

