/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.connections.utils;

import com.ibm.cics.core.comm.ConnectionConfiguration;
import com.ibm.cics.core.comm.IConnection;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.IConnectionManager;
import com.ibm.cics.core.connections.IConnectionService;
import com.ibm.cics.core.connections.IConnectionState;
import com.ibm.cics.core.connections.internal.ConnectedState;
import com.ibm.cics.core.connections.internal.DisconnectedState;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.connections.categories.IZCeeAdminApiConnection;
import java.util.ArrayList;
import java.util.List;

public class ZCeeAdminApiUtils {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static IConnectionManager connectionManager = ConnectionsPlugin.getDefault().getConnectionManager();
    private static IConnectionService connectionService = ConnectionsPlugin.getDefault().getConnectionService();

    public static List<IZCeeAdminApiConnection> getConnections(boolean connect) {
        ArrayList<IZCeeAdminApiConnection> retVal = new ArrayList<IZCeeAdminApiConnection>();
        List connectionProfiles = connectionManager.getConnectionProfiles("com.ibm.zosconnect.ui.connections.type.adminapi");
        for (ConnectionProfile profile : connectionProfiles) {
            IZCeeAdminApiConnection connection = ZCeeAdminApiUtils.getConnection(profile, connect);
            if (connection == null) continue;
            retVal.add(connection);
        }
        return retVal;
    }

    public static List<IZCeeAdminApiConnection> getConnections() {
        return ZCeeAdminApiUtils.getConnections(false);
    }

    public static IZCeeAdminApiConnection getConnection(ConnectionProfile profile, boolean connect) {
        IConnection connection;
        IZCeeAdminApiConnection retVal = null;
        IConnectionState connectionState = connectionService.getConnectionState(profile);
        if (connectionState instanceof DisconnectedState && connect) {
            connectionService.connect(profile.getId());
            connectionState = connectionService.getConnectionState(profile);
        }
        if (connectionState instanceof ConnectedState && (connection = ((ConnectedState)connectionState).getConnection()) instanceof IZCeeAdminApiConnection) {
            retVal = (IZCeeAdminApiConnection)connection;
        }
        return retVal;
    }

    public static List<ConnectionProfile> getConnectionProfiles() {
        return connectionManager.getConnectionProfiles("com.ibm.zosconnect.ui.connections.type.adminapi");
    }

    public static String getServerNameWithHostAndPort(ConnectionProfile profile) {
        if (profile == null || profile.getConnectionConfiguration() == null) {
            return "";
        }
        ConnectionConfiguration config = profile.getConnectionConfiguration();
        return ZCeeAdminApiUtils.getServerNameWithHostAndPort(config);
    }

    public static String getServerNameWithHostAndPort(ConnectionConfiguration config) {
        if (config == null) {
            return "";
        }
        StringBuilder serverName = new StringBuilder();
        serverName.append("\"");
        serverName.append(config.getName());
        serverName.append("\" (");
        serverName.append(config.getHost());
        serverName.append(Xlat.colon());
        serverName.append(config.getPort());
        serverName.append(")");
        return serverName.toString();
    }
}

