/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.connections.types;

import com.ibm.cics.core.comm.AbstractConnection;
import com.ibm.cics.core.comm.AuthenticationException;
import com.ibm.cics.core.comm.CertificateDetails;
import com.ibm.cics.core.comm.ConnectionConfiguration;
import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.cics.core.comm.CredentialsConfiguration;
import com.ibm.cics.core.comm.ExplorerSecurityHelper;
import com.ibm.cics.core.comm.IConnection;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.ICredentialsManager;
import com.ibm.zosconnect.ui.common.connections.ZCeeHostnameVerifier;
import com.ibm.zosconnect.ui.common.exceptions.ZosConnectUIException;
import com.ibm.zosconnect.ui.common.logger.ZCeeErrorDialog;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.ListUtilz;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.common.util.http.HttpStatusCodes;
import com.ibm.zosconnect.ui.common.util.swagger.OpenApi2xUtil;
import com.ibm.zosconnect.ui.connections.categories.IZCeeAdminApiConnection;
import com.ibm.zosconnect.ui.connections.models.adminapi.ZCeeAdminApiModelConverter;
import com.ibm.zosconnect.ui.connections.models.adminapi.ZosConnectApi;
import com.ibm.zosconnect.ui.connections.models.adminapi.ZosConnectApiDetail;
import com.ibm.zosconnect.ui.connections.models.adminapi.ZosConnectApiStatus;
import com.ibm.zosconnect.ui.connections.models.adminapi.ZosConnectDeleteApi;
import com.ibm.zosconnect.ui.connections.models.adminapi.ZosConnectDeleteService;
import com.ibm.zosconnect.ui.connections.models.adminapi.ZosConnectService;
import com.ibm.zosconnect.ui.connections.models.adminapi.ZosConnectServiceDetail;
import com.ibm.zosconnect.ui.connections.models.adminapi.ZosConnectServiceStatus;
import com.ibm.zosconnect.ui.swagger.clients.adminapi.api.ZosConnectAdminApi;
import com.ibm.zosconnect.ui.swagger.clients.adminapi.invoker.ApiClient;
import io.swagger.models.Swagger;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.osgi.framework.Version;

public class ZCeeAdminApiConnection
extends AbstractConnection
implements IZCeeAdminApiConnection {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String TAG = ZCeeAdminApiConnection.class.getName();
    public static final String CONNECT_TIMEOUT_KEY = "CONNECT_TIMEOUT";
    public static final String READ_TIMEOUT_KEY = "READ_TIMEOUT";
    private static final Integer CONNECT_TIMEOUT_DEFAULT = 30000;
    private static final Integer READ_TIMEOUT_DEFAULT = 30000;
    private static final String HTTP_URI_PFX = "http://";
    private static final String HTTPS_URI_PFX = "https://";
    private boolean connected = false;
    private SSLContext sslContext;
    private SSLSocketFactory sslSocketFactory;
    private Swagger adminApiSwagger;
    private List<String> adminApiOperIDs;
    private Version adminApiVersion;
    private ICredentialsManager credentialsManager = ConnectionsPlugin.getDefault().getCredentialsManager();

    @Override
    public List<ZosConnectApi> getApis() throws ZosConnectUIException {
        ZCeeUILogger.entering((String)this.getClass().getName(), (String)"getApis()", (Object[])new Object[0]);
        this.checkSupportedOperationID("getApis");
        ZosConnectAdminApi adminApi = new ZosConnectAdminApi(new ApiClient());
        this.configureApiClient(adminApi.getApiClient());
        List<ZosConnectApi> apis = ZCeeAdminApiModelConverter.convert(adminApi.getApis(), adminApi.getApiClient());
        ZCeeUILogger.exiting((String)this.getClass().getName(), (String)"getApis()", (Object[])new Object[0]);
        return apis;
    }

    @Override
    public List<Pair<ZosConnectApi, ZosConnectApiDetail>> getApisWithDetails() throws ZosConnectUIException {
        ZCeeUILogger.entering((String)this.getClass().getName(), (String)"getApisWithDetails()", (Object[])new Object[0]);
        this.checkSupportedOperationID("getApis");
        ZosConnectAdminApi adminApi = new ZosConnectAdminApi(new ApiClient());
        this.configureApiClient(adminApi.getApiClient());
        List<ZosConnectApi> apis = ZCeeAdminApiModelConverter.convert(adminApi.getApis(), adminApi.getApiClient());
        ArrayList<Pair<ZosConnectApi, ZosConnectApiDetail>> apiPairs = new ArrayList<Pair<ZosConnectApi, ZosConnectApiDetail>>(Math.max(10, apis.size()));
        for (ZosConnectApi api : apis) {
            ZosConnectApiDetail apiDetail = null;
            try {
                apiDetail = this.getApi(api, adminApi);
            }
            catch (ZosConnectUIException exception) {
                if (!exception.isCausedByConnectivityException() && !exception.isCausedByCertificateException() && !exception.isCausedBySecurityException() && HttpStatusCodes.Forbidden.equals(exception.getHttpStatusCode())) {
                    ZCeeUILogger.info((String)"User \"{0}\" not authorized to get the details of API \"{1}\" on connection \"{2}\"", (Throwable)exception, (Object[])new Object[]{this.getConfiguration().getUserID(), api.getName(), this.getConfiguration().getName()});
                    apiDetail = new ZosConnectApiDetail();
                    apiDetail.setStatus(ZosConnectApiStatus.NOT_AUTHORIZED);
                }
                throw exception;
            }
            apiPairs.add((Pair<ZosConnectApi, ZosConnectApiDetail>)Pair.of((Object)api, (Object)apiDetail));
        }
        ZCeeUILogger.exiting((String)this.getClass().getName(), (String)"getApisWithDetails()", (Object[])new Object[0]);
        return apiPairs;
    }

    @Override
    public ZosConnectApiDetail createApi(byte[] apiPackage, ZosConnectApiStatus status) throws ZosConnectUIException {
        ZosConnectApiDetail apiDetail;
        ZCeeUILogger.entering((String)this.getClass().getName(), (String)"createApi(apiPackage={0},status={1})", (Object[])new Object[]{apiPackage, status});
        this.checkSupportedOperationID("createApi");
        ZosConnectAdminApi adminApi = new ZosConnectAdminApi(new ApiClient());
        this.configureApiClient(adminApi.getApiClient());
        try {
            apiDetail = ZCeeAdminApiModelConverter.convert(adminApi.createApi(apiPackage, status.toString()), adminApi.getApiClient());
        }
        catch (URISyntaxException e) {
            throw new ZosConnectUIException((Throwable)e);
        }
        ZCeeUILogger.exiting((String)this.getClass().getName(), (String)"createApi(byte[],ZosConnectApiStatus)", (Object[])new Object[0]);
        return apiDetail;
    }

    @Override
    public ZosConnectApiDetail getApi(ZosConnectApi api) throws ZosConnectUIException {
        ZosConnectApiDetail apiDetail;
        ZCeeUILogger.entering((String)this.getClass().getName(), (String)"getApi(api={0})", (Object[])new Object[]{api});
        this.checkSupportedOperationID("getApi");
        ZosConnectAdminApi adminApi = new ZosConnectAdminApi(new ApiClient());
        this.configureApiClient(adminApi.getApiClient());
        try {
            apiDetail = ZCeeAdminApiModelConverter.convert(adminApi.getApi(api.getName()), adminApi.getApiClient());
        }
        catch (URISyntaxException e) {
            throw new ZosConnectUIException((Throwable)e);
        }
        ZCeeUILogger.exiting((String)this.getClass().getName(), (String)"getApi(ZosConnectApi)", (Object[])new Object[0]);
        return apiDetail;
    }

    private ZosConnectApiDetail getApi(ZosConnectApi api, ZosConnectAdminApi adminApi) throws ZosConnectUIException {
        ZosConnectApiDetail apiDetail;
        ZCeeUILogger.entering((String)this.getClass().getName(), (String)"getApi(api={0},adminApi={1})", (Object[])new Object[]{api, adminApi});
        try {
            apiDetail = ZCeeAdminApiModelConverter.convert(adminApi.getApi(api.getName()), adminApi.getApiClient());
        }
        catch (URISyntaxException e) {
            throw new ZosConnectUIException((Throwable)e);
        }
        ZCeeUILogger.exiting((String)this.getClass().getName(), (String)"getApi(ZosConnectApi,ZosConnectAdminApi)", (Object[])new Object[0]);
        return apiDetail;
    }

    @Override
    public ZosConnectApiDetail updateApi(String apiName, byte[] apiPackage, ZosConnectApiStatus status) throws ZosConnectUIException {
        ZosConnectApiDetail apiDetail;
        ZCeeUILogger.entering((String)this.getClass().getName(), (String)"updateApi(apiName={0},apiPackage={1},status={2})", (Object[])new Object[]{apiName, apiPackage, status});
        this.checkSupportedOperationID("updateApi");
        ZosConnectAdminApi adminApi = new ZosConnectAdminApi(new ApiClient());
        this.configureApiClient(adminApi.getApiClient());
        try {
            apiDetail = ZCeeAdminApiModelConverter.convert(adminApi.updateApi(apiName, status.toString(), apiPackage), adminApi.getApiClient());
        }
        catch (URISyntaxException e) {
            throw new ZosConnectUIException((Throwable)e);
        }
        ZCeeUILogger.exiting((String)this.getClass().getName(), (String)"updateApi(String,byte[],ZosConnectApiStatus)", (Object[])new Object[0]);
        return apiDetail;
    }

    @Override
    public ZosConnectApiDetail startApi(String apiName) throws ZosConnectUIException {
        ZosConnectApiDetail apiDetail;
        ZCeeUILogger.entering((String)this.getClass().getName(), (String)"startApi(apiName={0})", (Object[])new Object[]{apiName});
        this.checkSupportedOperationID("updateApi");
        ZosConnectAdminApi adminApi = new ZosConnectAdminApi(new ApiClient());
        this.configureApiClient(adminApi.getApiClient());
        try {
            apiDetail = ZCeeAdminApiModelConverter.convert(adminApi.updateApi(apiName, ZosConnectApiStatus.STARTED.toString(), null), adminApi.getApiClient());
        }
        catch (URISyntaxException e) {
            throw new ZosConnectUIException((Throwable)e);
        }
        ZCeeUILogger.exiting((String)this.getClass().getName(), (String)"startApi(String)", (Object[])new Object[0]);
        return apiDetail;
    }

    @Override
    public ZosConnectApiDetail stopApi(String apiName) throws ZosConnectUIException {
        ZosConnectApiDetail apiDetail;
        ZCeeUILogger.entering((String)this.getClass().getName(), (String)"stopApi(apiName={0})", (Object[])new Object[]{apiName});
        this.checkSupportedOperationID("updateApi");
        ZosConnectAdminApi adminApi = new ZosConnectAdminApi(new ApiClient());
        this.configureApiClient(adminApi.getApiClient());
        try {
            apiDetail = ZCeeAdminApiModelConverter.convert(adminApi.updateApi(apiName, ZosConnectApiStatus.STOPPED.toString(), null), adminApi.getApiClient());
        }
        catch (URISyntaxException e) {
            throw new ZosConnectUIException((Throwable)e);
        }
        ZCeeUILogger.exiting((String)this.getClass().getName(), (String)"stopApi(String)", (Object[])new Object[0]);
        return apiDetail;
    }

    @Override
    public ZosConnectServiceDetail startService(String serviceName) throws ZosConnectUIException {
        ZosConnectServiceDetail serviceDetail;
        ZCeeUILogger.entering((String)this.getClass().getName(), (String)"startService(serviceName={0})", (Object[])new Object[]{serviceName});
        this.checkSupportedOperationID("updateService");
        ZosConnectAdminApi adminApi = new ZosConnectAdminApi(new ApiClient());
        this.configureApiClient(adminApi.getApiClient());
        try {
            serviceDetail = ZCeeAdminApiModelConverter.convert(adminApi.updateService(serviceName, ZosConnectServiceStatus.STARTED.toString(), null), adminApi.getApiClient());
        }
        catch (URISyntaxException e) {
            throw new ZosConnectUIException((Throwable)e);
        }
        ZCeeUILogger.exiting((String)this.getClass().getName(), (String)"startService(String)", (Object[])new Object[0]);
        return serviceDetail;
    }

    @Override
    public ZosConnectServiceDetail stopService(String serviceName) throws ZosConnectUIException {
        ZosConnectServiceDetail serviceDetail;
        ZCeeUILogger.entering((String)this.getClass().getName(), (String)"stopService(serviceName={0})", (Object[])new Object[]{serviceName});
        this.checkSupportedOperationID("updateService");
        ZosConnectAdminApi adminApi = new ZosConnectAdminApi(new ApiClient());
        this.configureApiClient(adminApi.getApiClient());
        try {
            serviceDetail = ZCeeAdminApiModelConverter.convert(adminApi.updateService(serviceName, ZosConnectServiceStatus.STOPPED.toString(), null), adminApi.getApiClient());
        }
        catch (URISyntaxException e) {
            throw new ZosConnectUIException((Throwable)e);
        }
        ZCeeUILogger.exiting((String)this.getClass().getName(), (String)"stopService(String)", (Object[])new Object[0]);
        return serviceDetail;
    }

    @Override
    public ZosConnectDeleteApi deleteApi(String apiName) throws ZosConnectUIException {
        ZCeeUILogger.entering((String)this.getClass().getName(), (String)"deleteApi(apiName={0})", (Object[])new Object[]{apiName});
        this.checkSupportedOperationID("deleteApi");
        ZosConnectAdminApi adminApi = new ZosConnectAdminApi(new ApiClient());
        this.configureApiClient(adminApi.getApiClient());
        ZosConnectDeleteApi deleteApi = ZCeeAdminApiModelConverter.convert(adminApi.deleteApi(apiName), adminApi.getApiClient());
        ZCeeUILogger.exiting((String)this.getClass().getName(), (String)"deleteApi(String)", (Object[])new Object[0]);
        return deleteApi;
    }

    @Override
    public String getApiDocs(ZosConnectApiDetail apiDetail) throws ZosConnectUIException {
        ZCeeUILogger.entering((String)this.getClass().getName(), (String)"getApiDocs(apiDetail={0})", (Object[])new Object[]{apiDetail});
        ZosConnectAdminApi adminApi = new ZosConnectAdminApi(new ApiClient());
        this.configureApiClient(adminApi.getApiClient());
        String clientBasePath = adminApi.getApiClient().getBasePath();
        clientBasePath = StringUtils.removeEnd((String)clientBasePath, (String)"zosConnect");
        adminApi.getApiClient().setBasePath(clientBasePath);
        URI uri = null;
        try {
            uri = new URI(apiDetail.getApiUrl());
        }
        catch (URISyntaxException e) {
            throw new ZosConnectUIException((Throwable)e);
        }
        String apiDocs = adminApi.getApiDocs(uri.getPath());
        ZCeeUILogger.exiting((String)this.getClass().getName(), (String)"getApiDocs(ZosConnectApiDetail)", (Object[])new Object[0]);
        return apiDocs;
    }

    @Override
    public boolean isApiDiscoveryFeatureEnabled() throws ZosConnectUIException {
        ZCeeUILogger.entering((String)this.getClass().getName(), (String)"isApiDiscoveryFeatureEnabled()", (Object[])new Object[0]);
        ZosConnectAdminApi adminApi = new ZosConnectAdminApi(new ApiClient());
        this.configureApiClient(adminApi.getApiClient(), "");
        boolean retVal = adminApi.isApiDiscoveryFeatureEnabled();
        ZCeeUILogger.exiting((String)this.getClass().getName(), (String)("isApiDiscoveryFeatureEnabled(): " + retVal), (Object[])new Object[0]);
        return retVal;
    }

    @Override
    public List<ZosConnectService> getServices() throws ZosConnectUIException {
        ZCeeUILogger.entering((String)this.getClass().getName(), (String)"getServices()", (Object[])new Object[0]);
        ZosConnectAdminApi adminApi = new ZosConnectAdminApi(new ApiClient());
        this.configureApiClient(adminApi.getApiClient());
        List<ZosConnectService> services = ZCeeAdminApiModelConverter.convert(adminApi.getServices(), adminApi.getApiClient());
        ZCeeUILogger.exiting((String)this.getClass().getName(), (String)"getServices()", (Object[])new Object[0]);
        return services;
    }

    @Override
    public List<Pair<ZosConnectService, ZosConnectServiceDetail>> getServicesWithDetails() throws ZosConnectUIException {
        ZCeeUILogger.entering((String)this.getClass().getName(), (String)"getServicesWithDetails()", (Object[])new Object[0]);
        ZosConnectAdminApi adminApi = new ZosConnectAdminApi(new ApiClient());
        this.configureApiClient(adminApi.getApiClient());
        List<ZosConnectService> services = ZCeeAdminApiModelConverter.convert(adminApi.getServices(), adminApi.getApiClient());
        ArrayList<Pair<ZosConnectService, ZosConnectServiceDetail>> servicePairs = new ArrayList<Pair<ZosConnectService, ZosConnectServiceDetail>>(Math.max(10, services.size()));
        for (ZosConnectService service : services) {
            ZosConnectServiceDetail serviceDetail = null;
            try {
                serviceDetail = this.getService(service.getServiceName(), adminApi);
            }
            catch (ZosConnectUIException exception) {
                if (!exception.isCausedByConnectivityException() && !exception.isCausedByCertificateException() && !exception.isCausedBySecurityException() && HttpStatusCodes.Forbidden.equals(exception.getHttpStatusCode())) {
                    ZCeeUILogger.info((String)"User \"{0}\" not authorized to get the details of service \"{1}\" on connection \"{2}\"", (Throwable)exception, (Object[])new Object[]{this.getConfiguration().getUserID(), service.getServiceName(), this.getConfiguration().getName()});
                    serviceDetail = new ZosConnectServiceDetail();
                    serviceDetail.setServiceStatus(ZosConnectServiceStatus.NOT_AUTHORIZED);
                }
                throw exception;
            }
            servicePairs.add((Pair<ZosConnectService, ZosConnectServiceDetail>)Pair.of((Object)service, (Object)serviceDetail));
        }
        ZCeeUILogger.exiting((String)this.getClass().getName(), (String)"getServicesWithDetails()", (Object[])new Object[0]);
        return servicePairs;
    }

    @Override
    public ZosConnectServiceDetail getService(String serviceName) throws ZosConnectUIException {
        ZCeeUILogger.entering((String)this.getClass().getName(), (String)"getService(serviceName={0})", (Object[])new Object[]{serviceName});
        ZosConnectAdminApi adminApi = new ZosConnectAdminApi(new ApiClient());
        this.configureApiClient(adminApi.getApiClient());
        ZosConnectServiceDetail serviceDetail = null;
        try {
            serviceDetail = ZCeeAdminApiModelConverter.convert(adminApi.getService(serviceName), adminApi.getApiClient());
        }
        catch (URISyntaxException e) {
            throw new ZosConnectUIException((Throwable)e);
        }
        ZCeeUILogger.exiting((String)this.getClass().getName(), (String)"getService(String)", (Object[])new Object[0]);
        return serviceDetail;
    }

    private ZosConnectServiceDetail getService(String serviceName, ZosConnectAdminApi adminApi) throws ZosConnectUIException {
        ZCeeUILogger.entering((String)this.getClass().getName(), (String)"getService(serviceName={0},adminApi={1})", (Object[])new Object[]{serviceName, adminApi});
        ZosConnectServiceDetail serviceDetail = null;
        try {
            serviceDetail = ZCeeAdminApiModelConverter.convert(adminApi.getService(serviceName), adminApi.getApiClient());
        }
        catch (URISyntaxException e) {
            throw new ZosConnectUIException((Throwable)e);
        }
        ZCeeUILogger.exiting((String)this.getClass().getName(), (String)"getService(String,ZosConnectAdminApi)", (Object[])new Object[0]);
        return serviceDetail;
    }

    @Override
    public String getServiceRequestSchema(String serviceName) throws ZosConnectUIException {
        ZCeeUILogger.entering((String)this.getClass().getName(), (String)"getServiceRequestSchema(serviceName={0})", (Object[])new Object[]{serviceName});
        this.checkSupportedOperationID("getRequestSchema");
        ZosConnectAdminApi adminApi = new ZosConnectAdminApi(new ApiClient());
        this.configureApiClient(adminApi.getApiClient());
        String requestSchema = adminApi.getServiceSchema(serviceName, "request");
        ZCeeUILogger.exiting((String)this.getClass().getName(), (String)"getServiceRequestSchema(String)", (Object[])new Object[0]);
        return requestSchema;
    }

    @Override
    public String getServiceResponseSchema(String serviceName) throws ZosConnectUIException {
        ZCeeUILogger.entering((String)this.getClass().getName(), (String)"getServiceResponseSchema(serviceName={0})", (Object[])new Object[]{serviceName});
        this.checkSupportedOperationID("getResponseSchema");
        ZosConnectAdminApi adminApi = new ZosConnectAdminApi(new ApiClient());
        this.configureApiClient(adminApi.getApiClient());
        String responseSchema = adminApi.getServiceSchema(serviceName, "response");
        ZCeeUILogger.exiting((String)this.getClass().getName(), (String)"getServiceResponseSchema(String)", (Object[])new Object[0]);
        return responseSchema;
    }

    @Override
    public ZosConnectServiceDetail createService(byte[] serviceArchive, ZosConnectServiceStatus status) throws ZosConnectUIException {
        ZosConnectServiceDetail serviceDetail;
        ZCeeUILogger.entering((String)this.getClass().getName(), (String)"createService(serviceArchive={0},status={1})", (Object[])new Object[]{serviceArchive, status});
        this.checkSupportedOperationID("createService");
        ZosConnectAdminApi adminApi = new ZosConnectAdminApi(new ApiClient());
        this.configureApiClient(adminApi.getApiClient());
        try {
            serviceDetail = ZCeeAdminApiModelConverter.convert(adminApi.createService(serviceArchive, status.toString()), adminApi.getApiClient());
        }
        catch (URISyntaxException e) {
            throw new ZosConnectUIException((Throwable)e);
        }
        ZCeeUILogger.exiting((String)this.getClass().getName(), (String)"createService(byte[],ZosConnectServiceStatus)", (Object[])new Object[0]);
        return serviceDetail;
    }

    @Override
    public ZosConnectServiceDetail updateService(String serviceName, byte[] serviceArchive, ZosConnectServiceStatus status) throws ZosConnectUIException {
        ZosConnectServiceDetail serviceDetail;
        ZCeeUILogger.entering((String)this.getClass().getName(), (String)"updateService(serviceName={0},serviceArchive={1},status={2})", (Object[])new Object[]{serviceName, serviceArchive, status});
        this.checkSupportedOperationID("updateService");
        ZosConnectAdminApi adminApi = new ZosConnectAdminApi(new ApiClient());
        this.configureApiClient(adminApi.getApiClient());
        try {
            serviceDetail = ZCeeAdminApiModelConverter.convert(adminApi.updateService(serviceName, status.toString(), serviceArchive), adminApi.getApiClient());
        }
        catch (URISyntaxException e) {
            throw new ZosConnectUIException((Throwable)e);
        }
        ZCeeUILogger.exiting((String)this.getClass().getName(), (String)"updateService(String,byte[])", (Object[])new Object[0]);
        return serviceDetail;
    }

    @Override
    public ZosConnectDeleteService deleteService(String serviceName) throws ZosConnectUIException {
        ZCeeUILogger.entering((String)this.getClass().getName(), (String)"deleteService(serviceName={0})", (Object[])new Object[]{serviceName});
        this.checkSupportedOperationID("deleteService");
        ZosConnectAdminApi adminApi = new ZosConnectAdminApi(new ApiClient());
        this.configureApiClient(adminApi.getApiClient());
        ZosConnectDeleteService deleteService = ZCeeAdminApiModelConverter.convert(adminApi.deleteService(serviceName), adminApi.getApiClient());
        ZCeeUILogger.exiting((String)this.getClass().getName(), (String)"deleteService(String)", (Object[])new Object[0]);
        return deleteService;
    }

    private Swagger getAdminApiSwagger() throws ZosConnectUIException {
        ZCeeUILogger.entering((String)this.getClass().getName(), (String)"getAdminApiSwagger()", (Object[])new Object[0]);
        if (this.adminApiSwagger == null) {
            ZosConnectAdminApi adminApi = new ZosConnectAdminApi(new ApiClient());
            this.configureApiClient(adminApi.getApiClient());
            String adminApiDocs = adminApi.getApiDocs("/");
            ZCeeUILogger.info((String)"Admin API Swagger={0}", (Object[])new Object[]{adminApiDocs});
            try {
                this.adminApiSwagger = OpenApi2xUtil.unmarshallSwagger((String)adminApiDocs);
                this.adminApiVersion = OpenApi2xUtil.getVersion((Swagger)this.adminApiSwagger);
                this.adminApiOperIDs = OpenApi2xUtil.getOperationIDs((Swagger)this.adminApiSwagger);
                ZCeeUILogger.info((String)"Admin API operation IDs={0}", (Object[])new Object[]{this.adminApiOperIDs});
            }
            catch (IOException e) {
                throw new ZosConnectUIException((Throwable)e);
            }
        }
        ZCeeUILogger.exiting((String)this.getClass().getName(), (String)"getAdminApiSwagger()", (Object[])new Object[0]);
        return this.adminApiSwagger;
    }

    public void connect() throws ConnectionException {
        ZCeeUILogger.entering((String)this.getClass().getName(), (String)"connect()", (Object[])new Object[0]);
        try {
            this.connected = false;
            this.initSSLConfiguration();
            this.adminApiSwagger = this.getAdminApiSwagger();
            this.connected = true;
        }
        catch (ZosConnectUIException e) {
            ZCeeUILogger.error((Throwable)e);
            if (e.isCausedByCertificateException()) {
                throw new ConnectionException((Exception)((Object)e));
            }
            if (HttpStatusCodes.Unauthorized.equals(e.getHttpStatusCode())) {
                ZCeeErrorDialog.openError((Exception)((Object)e));
                throw new AuthenticationException(e.getExternalMessage());
            }
            ZCeeErrorDialog.openError((Exception)((Object)e));
            throw new ConnectionException(e.getExternalMessage(), (Throwable)e);
        }
        catch (Exception e) {
            ZCeeUILogger.error((Throwable)e);
            ZCeeErrorDialog.openError((Exception)e);
            throw new ConnectionException(e);
        }
        ZCeeUILogger.exiting((String)this.getClass().getName(), (String)"connect()", (Object[])new Object[0]);
    }

    public void disconnect() throws ConnectionException {
        ZCeeUILogger.entering((String)this.getClass().getName(), (String)"disconnect()", (Object[])new Object[0]);
        this.connected = false;
        ZCeeUILogger.exiting((String)this.getClass().getName(), (String)"disconnect()", (Object[])new Object[0]);
    }

    public boolean isConnected() {
        ZCeeUILogger.entering((String)this.getClass().getName(), (String)"isConnected()", (Object[])new Object[0]);
        ZCeeUILogger.exiting((String)this.getClass().getName(), (String)"isConnected()", (Object[])new Object[0]);
        return this.connected;
    }

    public void configureApiClient(ApiClient apiClient) throws ZosConnectUIException {
        this.configureApiClient(apiClient, "/zosConnect");
    }

    public void configureApiClient(ApiClient apiClient, String pathAfterPort) throws ZosConnectUIException {
        try {
            ConnectionConfiguration configuration = this.getConfiguration();
            apiClient.setConnection((IConnection)this);
            apiClient.setBasePath(this.getAdminApiBasePath(pathAfterPort));
            Integer connectTimeout = NumberUtils.toInt((String)configuration.getExtendedAttribute(CONNECT_TIMEOUT_KEY), (int)CONNECT_TIMEOUT_DEFAULT);
            apiClient.setConnectTimeout(connectTimeout.intValue());
            Integer readTimeout = NumberUtils.toInt((String)configuration.getExtendedAttribute(READ_TIMEOUT_KEY), (int)READ_TIMEOUT_DEFAULT);
            apiClient.setReadTimeout(readTimeout.intValue());
            if (configuration.getSecureHint()) {
                apiClient.setSSLContext(this.sslContext);
                apiClient.setSSLSocketFactory(this.sslSocketFactory);
                apiClient.setHostnameVerifier((HostnameVerifier)new ZCeeHostnameVerifier());
            }
            apiClient.setIsClientCert(this.isClientCert());
            if (!this.isClientCert() && !StringUtils.isBlank((CharSequence)configuration.getCredentialsID())) {
                CredentialsConfiguration credentials = this.credentialsManager.findCredentialsConfigurationByID(configuration.getCredentialsID());
                if (credentials != null) {
                    apiClient.setUsername(credentials.getUserID());
                    apiClient.setPassword(credentials.getPassword());
                } else {
                    apiClient.setUsername(null);
                    apiClient.setPassword(null);
                }
            }
        }
        catch (Exception e) {
            throw new ZosConnectUIException((Throwable)e);
        }
    }

    private String getAdminApiBasePath(String pathAfterPort) {
        StringBuilder basePath = new StringBuilder();
        ConnectionConfiguration configuration = this.getConfiguration();
        if (configuration.getSecureHint()) {
            basePath.append(HTTPS_URI_PFX);
        } else {
            basePath.append(HTTP_URI_PFX);
        }
        basePath.append(configuration.getHost());
        basePath.append(":");
        basePath.append(configuration.getPort());
        basePath.append(pathAfterPort);
        return basePath.toString();
    }

    public void initSSLConfiguration() throws IOException {
        ZCeeUILogger.entering((String)TAG, (String)"initSSLConfiguration()", (Object[])new Object[0]);
        boolean enableExtraTLSProtocols = false;
        if (this.isClientCert()) {
            Object[] helper = ExplorerSecurityHelper.getSSLContext((String)this.getConfiguration().getName(), (String)this.getConfiguration().getHost(), (CertificateDetails)this.getConfiguration().getCertificateDetails());
            this.sslContext = (SSLContext)helper[0];
            enableExtraTLSProtocols = (Boolean)helper[1];
            this.sslSocketFactory = ExplorerSecurityHelper.getSSLSocketFactory((String)this.getConfiguration().getName(), (String)this.getConfiguration().getHost(), (CertificateDetails)this.getConfiguration().getCertificateDetails());
        } else {
            Object[] helper = ExplorerSecurityHelper.getSSLContext((String)this.getConfiguration().getName(), (String)this.getConfiguration().getHost());
            this.sslContext = (SSLContext)helper[0];
            enableExtraTLSProtocols = (Boolean)helper[1];
            this.sslSocketFactory = ExplorerSecurityHelper.getSSLSocketFactory((String)this.getConfiguration().getName(), (String)this.getConfiguration().getHost());
        }
        ZCeeUILogger.info((String)"protocol={0},enableExtraTLSProtocols={1}", (Object[])new Object[]{this.sslContext.getProtocol(), enableExtraTLSProtocols});
        ZCeeUILogger.exiting((String)TAG, (String)"initSSLConfiguration()", (Object[])new Object[0]);
    }

    public boolean isClientCert() {
        return this.getConfiguration().getCertificateDetails() != null;
    }

    @Override
    public String getName() {
        return this.getConfiguration().getName();
    }

    private boolean checkSupportedOperationID(String operID) throws ZosConnectUIException {
        boolean supported = false;
        if (!ListUtilz.contains(this.adminApiOperIDs, (Object)operID)) {
            String message = Xlat.error((String)"OPERATION_NOT_AVAILABLE_WITH_VERSION", (String[])new String[]{"\"" + operID + "\"", this.getName(), this.adminApiVersion.toString()});
            throw new ZosConnectUIException(message);
        }
        supported = true;
        return supported;
    }
}

