/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.connections.models.adminapi;

import com.ibm.cics.core.comm.ConnectionConfiguration;
import com.ibm.zosconnect.ui.common.util.ListUtilz;
import com.ibm.zosconnect.ui.common.util.URIUtilz;
import com.ibm.zosconnect.ui.connections.models.adminapi.ZosConnectApi;
import com.ibm.zosconnect.ui.connections.models.adminapi.ZosConnectApiDetail;
import com.ibm.zosconnect.ui.connections.models.adminapi.ZosConnectApiDocumentation;
import com.ibm.zosconnect.ui.connections.models.adminapi.ZosConnectApiStatus;
import com.ibm.zosconnect.ui.connections.models.adminapi.ZosConnectDeleteApi;
import com.ibm.zosconnect.ui.connections.models.adminapi.ZosConnectDeleteService;
import com.ibm.zosconnect.ui.connections.models.adminapi.ZosConnectService;
import com.ibm.zosconnect.ui.connections.models.adminapi.ZosConnectServiceDetail;
import com.ibm.zosconnect.ui.connections.models.adminapi.ZosConnectServiceStatus;
import com.ibm.zosconnect.ui.swagger.clients.adminapi.invoker.ApiClient;
import com.ibm.zosconnect.ui.swagger.clients.adminapi.model.ApiDetail;
import com.ibm.zosconnect.ui.swagger.clients.adminapi.model.ApiDetailDocumentation;
import com.ibm.zosconnect.ui.swagger.clients.adminapi.model.Apis;
import com.ibm.zosconnect.ui.swagger.clients.adminapi.model.ApisApis;
import com.ibm.zosconnect.ui.swagger.clients.adminapi.model.DeleteApi;
import com.ibm.zosconnect.ui.swagger.clients.adminapi.model.DeleteService;
import com.ibm.zosconnect.ui.swagger.clients.adminapi.model.ServiceDetail;
import com.ibm.zosconnect.ui.swagger.clients.adminapi.model.ServiceDetailZosConnect;
import com.ibm.zosconnect.ui.swagger.clients.adminapi.model.Services;
import com.ibm.zosconnect.ui.swagger.clients.adminapi.model.ServicesZosConnectServices;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;

public class ZCeeAdminApiModelConverter {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static ZosConnectApi convert(ApisApis source, ApiClient client) {
        ZosConnectApi target = new ZosConnectApi();
        target.setName(source.getName());
        target.setVersion(source.getVersion());
        target.setDescription(source.getDescription());
        target.setAdminUrl(source.getAdminUrl());
        target.setStatusCode(client.getStatusCode());
        return target;
    }

    public static List<ZosConnectApi> convert(List<ApisApis> sources, ApiClient client) {
        if (ListUtilz.isEmpty(sources)) {
            return new ArrayList<ZosConnectApi>();
        }
        ArrayList<ZosConnectApi> targets = new ArrayList<ZosConnectApi>(Math.max(10, sources.size()));
        for (ApisApis target : sources) {
            targets.add(ZCeeAdminApiModelConverter.convert(target, client));
        }
        return targets;
    }

    public static List<ZosConnectApi> convert(Apis source, ApiClient client) {
        if (source == null || ListUtilz.isEmpty((List)source.getApis())) {
            return new ArrayList<ZosConnectApi>();
        }
        List apisApis = source.getApis();
        ArrayList<ZosConnectApi> targets = new ArrayList<ZosConnectApi>(Math.max(10, apisApis.size()));
        for (ApisApis target : apisApis) {
            targets.add(ZCeeAdminApiModelConverter.convert(target, client));
        }
        return targets;
    }

    public static ZosConnectApiStatus convert(ApiDetail.StatusEnum source) {
        ZosConnectApiStatus target = ZosConnectApiStatus.UNKNOWN;
        if (source == null) {
            return target;
        }
        switch (source) {
            case STARTED: {
                target = ZosConnectApiStatus.STARTED;
                break;
            }
            case STOPPED: {
                target = ZosConnectApiStatus.STOPPED;
                break;
            }
            default: {
                target = ZosConnectApiStatus.UNKNOWN;
            }
        }
        return target;
    }

    public static ZosConnectApiDetail convert(ApiDetail source, ApiClient client) throws URISyntaxException {
        ZosConnectApiDetail target = new ZosConnectApiDetail();
        if (source == null) {
            return target;
        }
        ConnectionConfiguration configuration = client.getConnection().getConfiguration();
        target.setName(source.getName());
        target.setVersion(source.getVersion());
        target.setDescription(source.getDescription());
        target.setStatus(ZCeeAdminApiModelConverter.convert(source.getStatus()));
        target.setApiUrl(URIUtilz.updateURI((String)source.getApiUrl(), (String)configuration.getHost(), (int)configuration.getPort()));
        target.setDocumentation(ZCeeAdminApiModelConverter.convert(source.getDocumentation(), client));
        target.setStatusCode(client.getStatusCode());
        return target;
    }

    public static ZosConnectApiDocumentation convert(ApiDetailDocumentation source, ApiClient client) throws URISyntaxException {
        ZosConnectApiDocumentation target = new ZosConnectApiDocumentation();
        if (source == null) {
            return target;
        }
        ConnectionConfiguration configuration = client.getConnection().getConfiguration();
        target.setSwagger(URIUtilz.updateURI((String)source.getSwagger(), (String)configuration.getHost(), (int)configuration.getPort()));
        return target;
    }

    public static ZosConnectDeleteApi convert(DeleteApi source, ApiClient client) {
        ZosConnectDeleteApi target = new ZosConnectDeleteApi();
        target.setName(source.getName());
        target.setStatusCode(client.getStatusCode());
        return target;
    }

    public static List<ZosConnectService> convert(Services sources, ApiClient client) {
        if (sources == null || ListUtilz.isEmpty((List)sources.getZosConnectServices())) {
            return new ArrayList<ZosConnectService>();
        }
        List services = sources.getZosConnectServices();
        ArrayList<ZosConnectService> targets = new ArrayList<ZosConnectService>(Math.max(10, services.size()));
        for (ServicesZosConnectServices target : services) {
            targets.add(ZCeeAdminApiModelConverter.convert(target, client));
        }
        return targets;
    }

    public static ZosConnectServiceDetail convert(ServiceDetail source, ApiClient client) throws URISyntaxException {
        ZosConnectServiceDetail target = new ZosConnectServiceDetail();
        if (source == null) {
            return target;
        }
        ConnectionConfiguration configuration = client.getConnection().getConfiguration();
        target.setServiceName(source.getZosConnect().getServiceName());
        target.setServiceDescription(source.getZosConnect().getServiceDescription());
        target.setServiceProvider(source.getZosConnect().getServiceProvider());
        target.setServiceInvokeURL(URIUtilz.updateURI((String)source.getZosConnect().getServiceInvokeURL(), (String)configuration.getHost(), (int)configuration.getPort()));
        target.setDataXformProvider(source.getZosConnect().getDataXformProvider());
        target.setServiceStatus(ZCeeAdminApiModelConverter.convert(source.getZosConnect().getServiceStatus()));
        target.setStatusCode(client.getStatusCode());
        return target;
    }

    public static ZosConnectService convert(ServicesZosConnectServices source, ApiClient client) {
        ZosConnectService target = new ZosConnectService();
        target.setServiceName(source.getServiceName());
        target.setServiceDescription(source.getServiceDescription());
        target.setServiceProvider(source.getServiceProvider());
        target.setServiceURL(source.getServiceURL());
        target.setStatusCode(client.getStatusCode());
        return target;
    }

    public static ZosConnectDeleteService convert(DeleteService source, ApiClient client) {
        ZosConnectDeleteService target = new ZosConnectDeleteService();
        target.setName(source.getName());
        target.setStatusCode(client.getStatusCode());
        return target;
    }

    public static ZosConnectServiceStatus convert(ServiceDetailZosConnect.ServiceStatusEnum source) {
        ZosConnectServiceStatus target = ZosConnectServiceStatus.UNKNOWN;
        if (source == null) {
            return target;
        }
        switch (source) {
            case STARTED: {
                target = ZosConnectServiceStatus.STARTED;
                break;
            }
            case STOPPED: {
                target = ZosConnectServiceStatus.STOPPED;
                break;
            }
            default: {
                target = ZosConnectServiceStatus.UNKNOWN;
            }
        }
        return target;
    }
}

